/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.novell.gw.engine.Filter;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelector;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.dialogs.rules.AbstractConditionField;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;

class DateConditionField
extends AbstractConditionField {
    private JPanel pnlCondition;
    private JPanel pnlContent = new OrientablePanel(new BorderLayout(5, 0));
    private JComboBox cbDate = new OrientableComboBox();
    private JSpinner spDate = new OrientableSpinner();
    private DateSelector dateSelector = new DateSelector();

    public DateConditionField(Filter.FilterData filterData, Filter filter) {
        super(filterData, filter);
        ((JSpinner.DefaultEditor)this.spDate.getEditor()).getTextField().setColumns(3);
        this.dateSelector.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
    }

    public Container getConditionPane() {
        if (this.pnlCondition == null) {
            this.pnlCondition = new OrientablePanel(new BorderLayout(5, 0));
            this.buildUI();
            if (this.rowInfo != null) {
                this.updateRowInfo();
            }
        }
        return this.pnlContent;
    }

    protected void updateRowInfo() {
        super.updateRowInfo();
        if (this.getValidValueType().getType() == 3) {
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
            gregorianCalendar.setTime(this.rowInfo.getValue().getValue().getDate());
            this.dateSelector.setDate(gregorianCalendar);
        } else {
            this.spDate.setValue(new Integer(this.rowInfo.getValue().getValue().getDateOffset()));
            this.cbDate.setSelectedItem(this.getSelectedValue());
        }
    }

    private void buildUI() {
        this.buildPopup();
        this.rebuildContent(this.getValidValueType().getType());
        this.pnlContent.add((Component)this.btnCondition, "Before");
    }

    protected void operatorChanged(Filter.FilterData filterData) {
        this.rebuildContent(this.getValidValueType().getType());
    }

    private void rebuildContent(int n) {
        this.pnlContent.remove(this.pnlCondition);
        this.pnlCondition.removeAll();
        this.cbDate.removeAllItems();
        this.dateSelector.setDate(GWCalendarUtils.getToday());
        switch (n) {
            case 4: {
                this.spDate.setValue(new Integer(1));
                this.pnlCondition.add((Component)this.spDate, "Before");
                this.cbDate.setModel(new DefaultComboBoxModel<AbstractConditionField.ValidValueWrapper>(this.getValidValues()));
                this.pnlCondition.add((Component)this.cbDate, "Center");
                break;
            }
            case 5: {
                this.spDate.setValue(new Integer(0));
                this.pnlCondition.add((Component)this.spDate, "Before");
                this.cbDate.setModel(new DefaultComboBoxModel<AbstractConditionField.ValidValueWrapper>(this.getValidValues()));
                this.pnlCondition.add((Component)this.cbDate, "Center");
                break;
            }
            case 3: {
                this.pnlCondition.add((Component)this.dateSelector, "Center");
            }
        }
        this.pnlContent.add((Component)this.pnlCondition, "Center");
        this.pnlContent.updateUI();
    }

    public RowPaneInfo getRowInfo() {
        RowPaneInfo rowPaneInfo = super.getRowInfo();
        int n = this.getValidValueType().getType();
        rowPaneInfo.setValueType(n);
        Filter.FilterValue filterValue = new Filter.FilterValue(this.filter);
        if (n == 3) {
            filterValue.setDate(this.dateSelector.getDate().getTime());
        } else {
            AbstractConditionField.ValidValueWrapper validValueWrapper = (AbstractConditionField.ValidValueWrapper)this.cbDate.getSelectedItem();
            Integer n2 = (Integer)this.spDate.getValue();
            filterValue.setDateOffset(n2.intValue());
            filterValue.setStringValue(validValueWrapper.toString());
            filterValue.setId(validValueWrapper.getValueId());
        }
        rowPaneInfo.setValue(filterValue);
        return rowPaneInfo;
    }
}

