/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.rules;

import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBoxMenuItem;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.rules.OperatorButton;
import com.novell.gw.jclient.application.dialogs.rules.RowPane;
import com.novell.gw.jclient.application.dialogs.rules.RowPaneInfo;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class GroupPane
extends OrientablePanel {
    private boolean isFirstGroup;
    private JPanel pnlRows = new OrientablePanel(new GridLayout(0, 1, 0, 10));
    private JPopupMenu popupAddGroup = new JPopupMenu();
    private OperatorButton btnAddGroup = new OperatorButton();

    private GroupPane(boolean bl) {
        super(new BorderLayout(0, 5));
        this.pnlRows.setBorder(BorderFactory.createEtchedBorder());
        this.isFirstGroup = bl;
        this.buildUI();
    }

    public GroupPane(boolean bl, List list) {
        this(bl);
        for (int i = 0; i < list.size(); ++i) {
            this.pnlRows.add((RowPane)list.get(i));
        }
        this.pnlRows.updateUI();
    }

    public void setGroupOperator(int n) {
        this.btnAddGroup.setOperator(n);
    }

    public int getGroupOperator() {
        return this.btnAddGroup.getOperator();
    }

    private void buildUI() {
        if (!this.isFirstGroup) {
            OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(1));
            ButtonGroup buttonGroup = new ButtonGroup();
            OrientableCheckBoxMenuItem orientableCheckBoxMenuItem = new OrientableCheckBoxMenuItem(new AndOrAction(0));
            orientableCheckBoxMenuItem.setText(StringResources.AND);
            this.popupAddGroup.add(orientableCheckBoxMenuItem);
            buttonGroup.add(orientableCheckBoxMenuItem);
            orientableCheckBoxMenuItem.setSelected(true);
            orientableCheckBoxMenuItem = new OrientableCheckBoxMenuItem(new AndOrAction(1));
            orientableCheckBoxMenuItem.setText(StringResources.OR);
            this.popupAddGroup.add(orientableCheckBoxMenuItem);
            buttonGroup.add(orientableCheckBoxMenuItem);
            this.btnAddGroup.setAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    GroupPane.this.popupAddGroup.show((JComponent)actionEvent.getSource(), 0, 0);
                }
            });
            this.btnAddGroup.setHorizontalTextPosition(10);
            this.btnAddGroup.setOperator(0);
            this.btnAddGroup.setIcon(ImageResources.ADV_FILTER_UP_DOWN);
            orientablePanel.add(this.btnAddGroup);
            this.add((Component)orientablePanel, "North");
        }
        this.add((Component)this.pnlRows, "Center");
    }

    public boolean isFirstGroup() {
        return this.isFirstGroup;
    }

    public void deleteRow(RowPane rowPane) {
        if (this.pnlRows.getComponentCount() == 1) {
            this.removeAll();
        } else {
            this.pnlRows.remove(rowPane);
        }
        this.updateUI();
    }

    public void insertRow(RowPane rowPane, RowPane rowPane2) {
        this.pnlRows.add((Component)rowPane2, this.getRowIndex(rowPane) + 1);
        this.pnlRows.updateUI();
    }

    public int getRowIndex(RowPane rowPane) {
        int n = 0;
        int n2 = this.pnlRows.getComponentCount();
        for (int i = 0; i < n2; ++i) {
            if (!this.pnlRows.getComponent(i).equals(rowPane)) continue;
            n = i;
            break;
        }
        return n;
    }

    public RowPane getLastRowPane() {
        return (RowPane)this.pnlRows.getComponent(this.getRowCount() - 1);
    }

    public int getRowCount() {
        return this.pnlRows.getComponentCount();
    }

    public RowPaneInfo[] getRowPanesInfo() {
        ArrayList<RowPaneInfo> arrayList = new ArrayList<RowPaneInfo>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            RowPane rowPane = (RowPane)this.pnlRows.getComponent(i);
            RowPaneInfo rowPaneInfo = rowPane.getRowPaneInfo();
            if (rowPaneInfo == null) continue;
            arrayList.add(rowPaneInfo);
        }
        return arrayList.toArray(new RowPaneInfo[0]);
    }

    public RowPane[] removeRowsAfter(RowPane rowPane) {
        int n = this.getRowIndex(rowPane) + 1;
        int n2 = this.pnlRows.getComponentCount() - n;
        RowPane[] rowPaneArray = new RowPane[n2];
        for (int i = 0; i < rowPaneArray.length; ++i) {
            rowPaneArray[i] = (RowPane)this.pnlRows.getComponent(n);
            this.pnlRows.remove(rowPaneArray[i]);
        }
        this.updateUI();
        return rowPaneArray;
    }

    private class AndOrAction
    extends AbstractAction {
        int operator;

        public AndOrAction(int n) {
            this.operator = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupPane.this.btnAddGroup.setOperator(this.operator);
        }
    }
}

