/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.saveasdialog;

import com.appframework.ApplicationFrame;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.options.compose.FileChooserPanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.store.GWItemSerializer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SaveAsDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$saveasdialog$SaveAsDialog == null ? (class$com$novell$gw$jclient$application$dialogs$saveasdialog$SaveAsDialog = SaveAsDialog.class$("com.novell.gw.jclient.application.dialogs.saveasdialog.SaveAsDialog")) : class$com$novell$gw$jclient$application$dialogs$saveasdialog$SaveAsDialog));
    private JTextField tfSaveAs;
    private FileChooserPanel fileChooserPanel;
    private String currentDir = Utils.USER_HOME;
    private AbstractItem item;
    private JList itemsList;
    private JComboBox cmbMailExtension;
    private JCheckBox cbReportConflict;
    private boolean isDocument;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$saveasdialog$SaveAsDialog;

    private SaveAsDialog(ApplicationFrame applicationFrame) {
        super(applicationFrame);
        if (!UIUtils.isJDKMoreThan5()) {
            this.setModal(false);
            applicationFrame.setEnabled(false);
        }
        this.userGuid = applicationFrame.getUserGuid();
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.SAVE);
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.setBorder(BorderFactory.createEmptyBorder(16, 16, 16, 16));
        jComponent.add((Component)this.buildMainPanel(), "Center");
        jComponent.add((Component)this.buildButtonsPanel(), "After");
    }

    public static void showSaveAsDialog(AbstractItem abstractItem, ApplicationFrame applicationFrame, int[] nArray) {
        SaveAsDialog saveAsDialog = new SaveAsDialog(applicationFrame);
        saveAsDialog.setItem(abstractItem);
        if (nArray != null) {
            saveAsDialog.selectAttachments(nArray);
        }
        UIUtils.centerWindow((Window)saveAsDialog, applicationFrame);
        saveAsDialog.pack();
        saveAsDialog.setVisible(true);
    }

    private void selectAttachments(int[] nArray) {
        this.itemsList.setSelectedIndices(nArray);
    }

    private void setItem(AbstractItem abstractItem) {
        this.item = abstractItem;
        this.fileChooserPanel.setText(this.currentDir);
        this.setModelToList();
        this.setSaveAsText();
        this.setSaveAsExtension();
        this.itemsList.addListSelectionListener(new ItemsListSelectionListener());
    }

    private void setModelToList() {
        Vector<ListItem> vector = new Vector<ListItem>();
        this.isDocument = this.item instanceof DocumentItem;
        if (!this.isDocument) {
            vector.add(new ListItem(this.item));
        } else {
            this.cmbMailExtension.setEnabled(false);
        }
        for (int i = 0; i < this.item.getAttachments().size(); ++i) {
            GWAttachment gWAttachment = (GWAttachment)this.item.getAttachments().getIDObjectAt(i);
            vector.add(new ListItem(gWAttachment));
        }
        this.itemsList.setListData(vector);
        this.itemsList.setSelectedIndex(0);
    }

    private void setSaveAsText() {
        int n = this.itemsList.getSelectedValues().length;
        if (n <= 0) {
            return;
        }
        Object object = ((ListItem)this.itemsList.getSelectedValues()[n - 1]).getObject();
        if (object instanceof AbstractItem) {
            this.tfSaveAs.setText(this.getFileNameFromSubject(((AbstractItem)object).getSubject()));
        } else if (object instanceof GWAttachment) {
            this.tfSaveAs.setText(this.getFileNameFromSubject(((GWAttachment)object).getName()));
        }
        this.tfSaveAs.setEditable(n == 1 && !this.isDocument);
    }

    private String removeAttachmentExtension(String string, String string2) {
        int n;
        for (n = 0; n < GWItemSerializer.getPosibleFileExtensions().length; ++n) {
            if (!string.endsWith(GWItemSerializer.getPosibleFileExtensions()[n])) continue;
            int n2 = string.lastIndexOf(GWItemSerializer.getPosibleFileExtensions()[n]);
            string = string.substring(0, n2 - 1);
        }
        if (string2 != null && string.endsWith(string2)) {
            n = string.lastIndexOf(string2);
            string = string.substring(0, n - 1);
        }
        return string;
    }

    private void setSaveAsExtension() {
        String string = this.tfSaveAs.getText();
        if (this.itemsList.getSelectedIndices().length == 1 && this.itemsList.getSelectedIndex() == 0) {
            if (string.endsWith(this.cmbMailExtension.getSelectedItem().toString()) || this.isDocument) {
                return;
            }
            string = this.removeAttachmentExtension(string, null);
            this.tfSaveAs.setText(string + "." + this.cmbMailExtension.getSelectedItem());
        } else {
            GWAttachment gWAttachment;
            int n = this.itemsList.getSelectedValues().length;
            if (n <= 0) {
                return;
            }
            Object object = ((ListItem)this.itemsList.getSelectedValues()[n - 1]).getObject();
            if (object instanceof GWAttachment && (gWAttachment = (GWAttachment)object).isMessageAttachment()) {
                this.cmbMailExtension.setEnabled(true);
                string = this.removeAttachmentExtension(string, "doc");
                this.tfSaveAs.setText(string + "." + this.cmbMailExtension.getSelectedItem());
            }
        }
    }

    private JComponent buildButtonsPanel() {
        JButton jButton = new JButton(new BtnSaveAction());
        JButton jButton2 = new JButton(new BtnCloseAction());
        this.setDefaultButton(jButton);
        this.setCancelButton(jButton2);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        orientablePanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        orientablePanel.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)new JLabel(), gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildMainPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(0, 5));
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.ITEMS_TO_SAVE_C);
        orientablePanel.add((Component)orientableLabel, "North");
        this.itemsList = new OrientableList(){};
        this.itemsList.setCellRenderer(new ListRenderer());
        orientablePanel.add((Component)new OrientableScrollPane(this.itemsList), "Center");
        orientablePanel.add((Component)this.buildSaveAsPanel(), "South");
        return orientablePanel;
    }

    private JPanel buildSaveAsPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.cbReportConflict = new OrientableCheckBox(StringResources.REPORT_FILENAME_CONFLICTS);
        this.cbReportConflict.setSelected(true);
        Object[] objectArray = new String[]{StringResources.SAVE_TO_DISK};
        OrientableComboBox orientableComboBox = new OrientableComboBox(objectArray);
        this.cmbMailExtension = new OrientableComboBox(GWItemSerializer.getPosibleFileExtensions());
        this.cmbMailExtension.addActionListener(new CmbMailExtensionListenert());
        this.tfSaveAs = new OrientableTextField();
        this.fileChooserPanel = new FileChooserPanel(StringResources.CURRENT_DIRECTORY_C, "", 1);
        int n = 10;
        Insets insets = new Insets(n, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.cbReportConflict, gridBagConstraints);
        orientablePanel.add((Component)orientableComboBox, gridBagConstraints);
        gridBagConstraints.fill = 0;
        orientablePanel.add((Component)new JLabel(StringResources.SAVE_MAIL_AS_C), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets2;
        orientablePanel.add((Component)this.cmbMailExtension, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = insets;
        orientablePanel.add((Component)new JLabel(StringResources.SAVE_FILE_AS_C), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = insets2;
        orientablePanel.add((Component)this.tfSaveAs, gridBagConstraints);
        this.tfSaveAs.setPreferredSize(new Dimension(200, this.tfSaveAs.getPreferredSize().height));
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets;
        orientablePanel.add((Component)this.fileChooserPanel, gridBagConstraints);
        return orientablePanel;
    }

    private boolean isEmbeddedItem(Object object) {
        if (object instanceof GWAttachment) {
            GWAttachment gWAttachment = (GWAttachment)object;
            return gWAttachment.isMessageAttachment();
        }
        return false;
    }

    private void saveSelectedItems() {
        boolean bl = false;
        int n = this.itemsList.getSelectedValues().length;
        for (int i = 0; i < n; ++i) {
            ListItem listItem = (ListItem)this.itemsList.getSelectedValues()[i];
            Object object = listItem.getObject();
            boolean bl2 = this.isEmbeddedItem(object);
            if (object instanceof AbstractItem || bl2) {
                if (bl2) {
                    GWAttachment gWAttachment = (GWAttachment)object;
                    try {
                        listItem.setSaved(this.saveGWItem(GWCommandManager.getInstance(this.userGuid).getEnclosedItem(gWAttachment)));
                    }
                    catch (GWCommandException gWCommandException) {
                        logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                        ErrorDialog.processGWException(gWCommandException);
                    }
                } else {
                    listItem.setSaved(this.saveGWItem((AbstractItem)object));
                }
            } else if (object instanceof GWAttachment) {
                this.saveAttachment((GWAttachment)object);
                listItem.setSaved(true);
            }
            bl |= listItem.isSaved();
            bl2 = false;
        }
        if (bl) {
            this.setListSelection();
            this.itemsList.updateUI();
        }
    }

    private void setListSelection() {
        if (this.itemsList.getSelectedIndices().length == 0) {
            return;
        }
        int n = this.itemsList.getSelectedIndices()[this.itemsList.getSelectedValues().length - 1];
        this.itemsList.clearSelection();
        boolean bl = this.setSelectionToNextUnsaved(n + 1);
        if (!bl) {
            bl = this.setSelectionToNextUnsaved(0);
        }
        if (!bl) {
            this.itemsList.setSelectedIndex(n);
        }
    }

    private boolean setSelectionToNextUnsaved(int n) {
        boolean bl = false;
        for (int i = n; i < this.itemsList.getModel().getSize(); ++i) {
            ListItem listItem = (ListItem)this.itemsList.getModel().getElementAt(i);
            if (listItem.isSaved()) continue;
            this.itemsList.setSelectedIndex(i);
            this.itemsList.ensureIndexIsVisible(i);
            bl = true;
            break;
        }
        return bl;
    }

    private boolean saveGWItem(AbstractItem abstractItem) {
        String string = this.fileChooserPanel.getText() + Utils.FILE_SEPARATOR;
        string = this.tfSaveAs.isEditable() ? string + this.tfSaveAs.getText() : string + this.getFileNameFromSubject(abstractItem.getSubject()) + "." + this.cmbMailExtension.getSelectedItem();
        if (!this.canSaveToFile(string)) {
            return false;
        }
        try {
            GWItemSerializer.saveAs(string, this.cmbMailExtension.getSelectedItem().toString(), abstractItem, false, false);
        }
        catch (GWException gWException) {
            JOptionPane.showMessageDialog(this, StringResources.UNKNOWN_FILE_EXTENSION);
            return false;
        }
        return true;
    }

    private boolean saveAttachment(GWAttachment gWAttachment) {
        String string = this.fileChooserPanel.getText() + Utils.FILE_SEPARATOR;
        string = this.tfSaveAs.isEditable() ? string + this.tfSaveAs.getText() : string + this.getFileNameFromSubject(gWAttachment.getFileName());
        if (!this.canSaveToFile(string)) {
            return false;
        }
        MessageUtils.saveAttachment(gWAttachment, string);
        return true;
    }

    private boolean canSaveToFile(String string) {
        File file = new File(string);
        if (this.cbReportConflict.isSelected() && file.exists()) {
            int n = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.FILE_ALREADY_EXISTS_OVERWRITE_Q, new String[]{file.getPath()}), StringResources.SAVE + " " + file.getName(), 0, 2);
            return n != 1;
        }
        return true;
    }

    private String getFileNameFromSubject(String string) {
        String string2 = string;
        string2 = string2.replaceAll("/", "_");
        string2 = string2.replaceAll("\\\\", "_");
        string2 = string2.replaceAll("\\*", "_");
        return string2;
    }

    public void hide() {
        if (!UIUtils.isJDKMoreThan5()) {
            this.getParent().setEnabled(true);
        }
        super.hide();
    }

    public void dispose() {
        if (!UIUtils.isJDKMoreThan5()) {
            this.getParent().setEnabled(true);
        }
        super.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ListItem {
        private boolean isSaved = false;
        private Object object;

        public ListItem(Object object) {
            this.object = object;
        }

        public boolean isSaved() {
            return this.isSaved;
        }

        public void setSaved(boolean bl) {
            this.isSaved = bl;
        }

        public Object getObject() {
            return this.object;
        }
    }

    class CmbMailExtensionListenert
    extends AbstractAction {
        CmbMailExtensionListenert() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveAsDialog.this.setSaveAsExtension();
        }
    }

    class ItemsListSelectionListener
    implements ListSelectionListener {
        int lastSelectedIndex = 0;

        ItemsListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (SaveAsDialog.this.itemsList.getSelectedIndices().length == 0) {
                return;
            }
            if (SaveAsDialog.this.itemsList.getSelectedIndices()[0] == 0) {
                SaveAsDialog.this.cmbMailExtension.setEnabled(true);
            } else {
                SaveAsDialog.this.cmbMailExtension.setEnabled(false);
            }
            if (SaveAsDialog.this.itemsList.getSelectedIndices().length != 1 || SaveAsDialog.this.itemsList.getSelectedIndices()[0] != this.lastSelectedIndex) {
                SaveAsDialog.this.setSaveAsText();
                SaveAsDialog.this.setSaveAsExtension();
            }
            this.lastSelectedIndex = SaveAsDialog.this.itemsList.getSelectedIndices()[0];
        }
    }

    class BtnBrowseAction
    extends AbstractAction {
        public BtnBrowseAction() {
            super(StringResources.BROWSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OS.isMacOS()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(SaveAsDialog.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser(frame, StringResources.BROWSE_FOR_FOLDER, new File(SaveAsDialog.this.currentDir), 0);
                UIUtils.centerWindow((Window)gWMacFileChooser, SaveAsDialog.this);
                gWMacFileChooser.setVisible(true);
                String string = gWMacFileChooser.getFile();
                String string2 = gWMacFileChooser.getDirectory();
                if (string != null) {
                    SaveAsDialog.this.currentDir = string2 + string;
                    if (new File(SaveAsDialog.this.currentDir).exists()) {
                        SaveAsDialog.this.fileChooserPanel.setText(SaveAsDialog.this.currentDir);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser gWFileChooser = new GWFileChooser(SaveAsDialog.this, StringResources.BROWSE_FOR_FOLDER, new File(SaveAsDialog.this.currentDir), 1, 0, false);
                UIUtils.centerWindow((Window)gWFileChooser, SaveAsDialog.this);
                gWFileChooser.getChooser().setApproveButtonText(StringResources.OK);
                gWFileChooser.setVisible(true);
                String[] stringArray = gWFileChooser.getResult();
                if (stringArray != null && new File(stringArray[0]).exists()) {
                    SaveAsDialog.this.currentDir = stringArray[0];
                    SaveAsDialog.this.fileChooserPanel.setText(SaveAsDialog.this.currentDir);
                }
            }
        }
    }

    class BtnSaveAction
    extends AbstractAction {
        public BtnSaveAction() {
            super(StringResources.SAVE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveAsDialog.this.saveSelectedItems();
        }
    }

    class BtnCloseAction
    extends AbstractAction {
        public BtnCloseAction() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveAsDialog.this.dispose();
        }
    }

    private class ListRenderer
    extends OrientablePanel
    implements ListCellRenderer {
        private int attachmentMargin = 20;
        private JLabel label = new JLabel("", 10);

        public ListRenderer() {
            super(new FlowLayout(3, 0, 0));
            this.add(this.label);
            this.label.setPreferredSize(new Dimension(200, new JLabel((String)" ").getPreferredSize().height));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            String string = null;
            Object object2 = ((ListItem)object).getObject();
            if (object2 instanceof GWAttachment) {
                GWAttachment gWAttachment = (GWAttachment)object2;
                string = gWAttachment.getName();
                if (!SaveAsDialog.this.isDocument) {
                    string = this.getComponentOrientation().isLeftToRight() ? "+ " + string : string + " +";
                    ((FlowLayout)this.getLayout()).setHgap(this.attachmentMargin);
                }
            } else if (object2 instanceof AbstractItem) {
                string = ((AbstractItem)object2).getSubject();
                ((FlowLayout)this.getLayout()).setHgap(0);
            }
            if (((ListItem)object).isSaved()) {
                string = this.getComponentOrientation().isLeftToRight() ? string + " " + StringResources.D_SAVED : StringResources.D_SAVED + " " + string;
            }
            this.label.setText(string);
            this.label.setEnabled(jList.isEnabled());
            return this;
        }
    }
}

