/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.dialogs.timedifference;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.dialogs.timedifference.HourDocument;
import com.novell.gw.jclient.application.dialogs.timedifference.MinuteDocument;
import com.novell.gw.jclient.application.dialogs.timedifference.TimeDocument;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.log4j.Logger;

public class TimeDifference
extends BasicDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$dialogs$timedifference$TimeDifference == null ? (class$com$novell$gw$jclient$application$dialogs$timedifference$TimeDifference = TimeDifference.class$("com.novell.gw.jclient.application.dialogs.timedifference.TimeDifference")) : class$com$novell$gw$jclient$application$dialogs$timedifference$TimeDifference));
    private JComboBox[] cmbZone = new OrientableComboBox[2];
    private JTextField[] tfHours = new JTextField[2];
    private JTextField[] tfMins = new JTextField[2];
    private TimeZone[] tz = new TimeZone[2];
    GregorianCalendar[] gc = new GregorianCalendar[2];
    private JButton btnClose;
    private DateFormat hourFormat;
    private DateFormat ampmFormat;
    private DateFormat minFormat;
    private JComboBox[] cmbAMPM = new OrientableComboBox[2];
    private AMPMCmbAdapter[] ampmCmbAdapter = new AMPMCmbAdapter[2];
    private Vector AMPM = new Vector();
    static /* synthetic */ Class class$com$novell$gw$jclient$application$dialogs$timedifference$TimeDifference;

    public TimeDifference() {
        this((JFrame)null);
    }

    public TimeDifference(JFrame jFrame) {
        super(jFrame);
        this.init();
        this.buildUI();
        this.refreshUI();
        this.setDefaultButton(this.btnClose);
    }

    private void init() {
        this.gc[0] = GWCalendarUtils.getTodayUTC();
        this.gc[1] = GWCalendarUtils.getTodayUTC();
        this.minFormat = new SimpleDateFormat("mm");
        if (GWCalendarUtils.isAMPM()) {
            this.hourFormat = new SimpleDateFormat("hh");
            this.ampmFormat = new SimpleDateFormat("aa");
        } else {
            this.hourFormat = new SimpleDateFormat("HH");
        }
        this.AMPM.add("AM");
        this.AMPM.add("PM");
    }

    private void buildUI() {
        this.setTitle(StringResources.TIME_DIFFERENCE);
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setComponentOrientation(UIUtils.getComponentOrientation());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.buildInfoPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.buildZonePanel(0), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.getContentPane().add((Component)this.buildZonePanel(1), gridBagConstraints);
        this.btnClose = new JButton(StringResources.CLOSE);
        this.btnClose.addActionListener(new BtnClose());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        this.getContentPane().add((Component)this.btnClose, gridBagConstraints);
        this.pack();
    }

    private JPanel buildInfoPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n = gregorianCalendar.get(15) / 60000;
        int n2 = n / 60;
        int n3 = n % 60;
        gregorianCalendar.setTimeInMillis(GWCalendarUtils.getTodayUTC().getTimeInMillis());
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.HOST_TIME_ZONE_C);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        String string = n2 < 10 ? "0" + Integer.toString(n2) : Integer.toString(n2);
        String string2 = n3 < 10 ? "0" + Integer.toString(n3) : Integer.toString(n3);
        orientableLabel = new OrientableLabel("(GMT + " + string + ":" + string2 + "), " + gregorianCalendar.getTimeZone().getID());
        gridBagConstraints.gridx = 1;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        orientableLabel = new OrientableLabel(StringResources.HOST_TIME_C);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, EngineCommandManager.getLocale());
        orientableLabel = new OrientableLabel(dateFormat.format(gregorianCalendar.getTime()));
        gridBagConstraints.gridx = 1;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildZonePanel(int n) {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        String string = StringResources.TIME_ZONE;
        string = n == 0 ? string + " A" : string + " B";
        Border border = BorderFactory.createEtchedBorder(0);
        orientablePanel.setBorder(BorderFactory.createTitledBorder(border, string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        OrientableLabel orientableLabel = new OrientableLabel(StringResources.SELECT_TIME_ZONE_C + ' ');
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        Vector<TimeZone> vector = new Vector<TimeZone>();
        for (int i = 0; i < TimeZone.getAvailableIDs().length; ++i) {
            vector.add(TimeZone.getTimeZone(TimeZone.getAvailableIDs()[i]));
        }
        this.cmbZone[n] = new OrientableComboBox(TimeZone.getAvailableIDs());
        this.cmbZone[n].setSelectedItem(TimeZone.getDefault().getID());
        this.tz[n] = TimeZone.getTimeZone((String)this.cmbZone[n].getSelectedItem());
        this.cmbZone[n].addActionListener(new CbmTimeZoneAction(n));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 22;
        orientablePanel.add((Component)this.cmbZone[n], gridBagConstraints);
        OrientablePanel orientablePanel2 = new OrientablePanel();
        orientableLabel = new OrientableLabel(StringResources.TIME_C + ' ');
        orientablePanel2.add(orientableLabel);
        this.tfHours[n] = new OrientableTextField();
        this.tfHours[n].setDocument(new HourDocument());
        this.tfHours[n].setColumns(2);
        this.tfHours[n].addKeyListener(new TfHourKeyAdapter(n));
        orientablePanel2.add(this.tfHours[n]);
        if (GWCalendarUtils.isAMPM()) {
            this.ampmCmbAdapter[n] = new AMPMCmbAdapter(n);
            this.cmbAMPM[n] = new OrientableComboBox(this.AMPM);
            this.cmbAMPM[n].addActionListener(this.ampmCmbAdapter[n]);
            orientablePanel2.add(this.cmbAMPM[n]);
        }
        orientableLabel = new OrientableLabel(StringResources.HOUR_S + ' ');
        orientablePanel2.add(orientableLabel);
        this.tfMins[n] = new OrientableTextField();
        this.tfMins[n].setDocument(new MinuteDocument());
        this.tfMins[n].setColumns(2);
        this.tfMins[n].addKeyListener(new TfMinKeyAdapter(n));
        orientablePanel2.add(this.tfMins[n]);
        orientableLabel = new OrientableLabel(StringResources.MIN_S);
        orientablePanel2.add(orientableLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        orientablePanel.add((Component)orientablePanel2, gridBagConstraints);
        return orientablePanel;
    }

    private void refreshUI() {
        this.setTime(0);
        this.setTime(1);
    }

    private void setTime(int n) {
        this.hourFormat.setTimeZone(this.tz[n]);
        if (GWCalendarUtils.isAMPM()) {
            this.ampmFormat.setTimeZone(this.tz[n]);
            this.cmbAMPM[n].removeActionListener(this.ampmCmbAdapter[n]);
            if (this.ampmFormat.format(this.gc[n].getTime()).toUpperCase().equals("AM")) {
                this.cmbAMPM[n].setSelectedItem(this.AMPM.get(0));
            } else {
                this.cmbAMPM[n].setSelectedItem(this.AMPM.get(1));
            }
            this.cmbAMPM[n].addActionListener(this.ampmCmbAdapter[n]);
        }
        this.minFormat.setTimeZone(this.tz[n]);
        this.gc[n].setTimeZone(this.tz[n]);
        this.tfHours[n].setText(this.hourFormat.format(this.gc[n].getTime()));
        this.tfMins[n].setText(this.minFormat.format(this.gc[n].getTime()));
    }

    private void refreshTime(int n) {
        if (!TimeDocument.isDigit(this.tfMins[n].getText()) || !TimeDocument.isDigit(this.tfHours[n].getText())) {
            return;
        }
        if (GWCalendarUtils.isAMPM()) {
            this.gc[n].set(9, this.cmbAMPM[n].getSelectedIndex());
            this.gc[n].set(10, Integer.parseInt(this.tfHours[n].getText()));
        } else {
            this.gc[n].set(11, Integer.parseInt(this.tfHours[n].getText()));
        }
        this.gc[n].set(12, Integer.parseInt(this.tfMins[n].getText()));
        int n2 = n == 0 ? 1 : 0;
        long l = this.gc[n].getTimeInMillis();
        this.gc[n2].setTimeInMillis(l);
        this.setTime(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AMPMCmbAdapter
    extends AbstractAction {
        int index = 0;

        public AMPMCmbAdapter(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TimeDifference.this.refreshTime(this.index);
        }
    }

    class TfMinKeyAdapter
    extends KeyAdapter {
        int index = 0;

        public TfMinKeyAdapter(int n) {
            this.index = n;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (Character.isDigit(keyEvent.getKeyChar())) {
                TimeDifference.this.refreshTime(this.index);
            }
        }
    }

    class TfHourKeyAdapter
    extends KeyAdapter {
        int index = 0;

        public TfHourKeyAdapter(int n) {
            this.index = n;
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (Character.isDigit(keyEvent.getKeyChar())) {
                TimeDifference.this.refreshTime(this.index);
            }
        }
    }

    class BtnClose
    extends AbstractAction {
        BtnClose() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TimeDifference.this.setVisible(false);
        }
    }

    class CbmTimeZoneAction
    extends AbstractAction {
        int index = 0;

        public CbmTimeZoneAction(int n) {
            this.index = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((TimeDifference)TimeDifference.this).tz[this.index] = TimeZone.getTimeZone((String)TimeDifference.this.cmbZone[this.index].getSelectedItem());
            TimeDifference.this.refreshUI();
        }
    }
}

