/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.utils.UIUtils;
import com.novell.gw.account.Account;
import com.novell.gw.jclient.application.OrientableTable;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.AccountGeneralOptionsDialog;
import com.novell.gw.jclient.application.frames.options.AccountPropertiesDialog;
import com.novell.gw.jclient.application.frames.options.AccountUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class AccountOptionsFrame
extends JFrame {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$options$AccountOptionsFrame == null ? (class$com$novell$gw$jclient$application$frames$options$AccountOptionsFrame = AccountOptionsFrame.class$("com.novell.gw.jclient.application.frames.options.AccountOptionsFrame")) : class$com$novell$gw$jclient$application$frames$options$AccountOptionsFrame));
    private static AccountOptionsFrame instance;
    private JButton btnClose;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnProperties;
    private JButton btnDefault;
    private JButton btnOptions;
    private JButton btnFolders;
    private JTable mailTable;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$options$AccountOptionsFrame;

    private AccountOptionsFrame() {
        this.setTitle(StringResources.ACCOUNT_OPTIONS);
        this.setDefaultCloseOperation(1);
        this.build();
    }

    public static synchronized AccountOptionsFrame getInstance() {
        if (instance == null) {
            instance = new AccountOptionsFrame();
        }
        return instance;
    }

    public static synchronized void freeInstance() {
        instance = null;
    }

    private void build() {
        Container container = this.getContentPane();
        container.setComponentOrientation(UIUtils.getComponentOrientation());
        container.setLayout(new BorderLayout());
        container.add((Component)this.buildAccounts(), "Center");
        container.add((Component)this.buildControls(), "After");
        this.getRootPane().setDefaultButton(this.btnClose);
        this.btnClose.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AccountOptionsFrame.this.btnClose.getAction().actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.pack();
        UIUtils.centerWindowOnScreen(this);
    }

    private JComponent buildAccounts() {
        OrientableTabbedPane orientableTabbedPane = new OrientableTabbedPane(1);
        orientableTabbedPane.setBorder(new EmptyBorder(5, 10, 10, 5));
        orientableTabbedPane.addTab(StringResources.MAIL, this.buildMailPanel());
        return orientableTabbedPane;
    }

    private JPanel buildMailPanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout());
        orientablePanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        this.mailTable = new OrientableTable();
        MailTableModel mailTableModel = new MailTableModel();
        this.mailTable.setModel(mailTableModel);
        this.mailTable.getTableHeader().setBorder(BorderFactory.createEmptyBorder());
        this.mailTable.getTableHeader().setResizingAllowed(true);
        this.mailTable.setShowGrid(false);
        this.mailTable.setAutoResizeMode(3);
        this.mailTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.mailTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.mailTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.mailTable.getSelectionModel().addListSelectionListener(new MailTableSelectionListener());
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.mailTable);
        orientableScrollPane.setBackground(Color.WHITE);
        orientableScrollPane.setBorder(BorderFactory.createEmptyBorder());
        orientablePanel.add((Component)orientableScrollPane, "Center");
        return orientablePanel;
    }

    private JPanel buildControls() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        orientablePanel.setBorder(new LineBorder(Color.LIGHT_GRAY, 1));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.btnClose = new JButton(new ButtonCloseAction());
        orientablePanel.add((Component)this.btnClose, gridBagConstraints);
        this.btnAdd = new JButton(new ButtonAddAction());
        this.btnAdd.setEnabled(false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        orientablePanel.add((Component)this.btnAdd, gridBagConstraints);
        this.btnRemove = new JButton(new ButtonRemoveAction());
        this.btnRemove.setEnabled(false);
        gridBagConstraints.gridy = 2;
        orientablePanel.add((Component)this.btnRemove, gridBagConstraints);
        this.btnProperties = new JButton(new ButtonPropertiesAction());
        this.btnProperties.setEnabled(false);
        gridBagConstraints.gridy = 3;
        orientablePanel.add((Component)this.btnProperties, gridBagConstraints);
        this.btnDefault = new JButton(new ButtonDefaultAction());
        this.btnDefault.setEnabled(false);
        gridBagConstraints.gridy = 4;
        orientablePanel.add((Component)this.btnDefault, gridBagConstraints);
        this.btnOptions = new JButton(new ButtonGeneralOptionsAction());
        this.btnOptions.setEnabled(true);
        gridBagConstraints.gridy = 5;
        orientablePanel.add((Component)this.btnOptions, gridBagConstraints);
        this.btnFolders = new JButton(new ButtonFoldersAction());
        this.btnFolders.setEnabled(false);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        orientablePanel.add((Component)this.btnFolders, gridBagConstraints);
        return orientablePanel;
    }

    private void updateControls() {
        this.btnProperties.setEnabled(this.mailTable.getSelectedRow() != -1);
    }

    public static void main(String[] stringArray) {
        AccountOptionsFrame accountOptionsFrame = AccountOptionsFrame.getInstance();
        accountOptionsFrame.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MailTableSelectionListener
    implements ListSelectionListener {
        private MailTableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                AccountOptionsFrame.this.updateControls();
            }
        }
    }

    private class MailTableModel
    extends AbstractTableModel {
        Account[] accounts;

        private MailTableModel() {
        }

        public int getRowCount() {
            return this.getAccounts().length;
        }

        private Account[] getAccounts() {
            if (this.accounts == null) {
                this.accounts = EngineCommandManager.getAccounts();
            }
            return this.accounts;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return StringResources.MARKED_ACCOUNT;
                }
                case 1: {
                    return StringResources.ACCOUNT_TYPE;
                }
                case 2: {
                    return StringResources.INCOMING_SERVER;
                }
            }
            return "";
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            Account account = this.getAccount(n);
            switch (n2) {
                case 0: {
                    return account.getName();
                }
                case 1: {
                    return AccountUtils.getAccountTypeString(account);
                }
                case 2: {
                    return "";
                }
            }
            return "";
        }

        public Account getAccount(int n) {
            return this.getAccounts()[n];
        }
    }

    private class ButtonFoldersAction
    extends AbstractAction {
        public ButtonFoldersAction() {
            super(StringResources.FOLDERS);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"Folders");
        }
    }

    private class ButtonGeneralOptionsAction
    extends AbstractAction {
        public ButtonGeneralOptionsAction() {
            super(StringResources.GENERAL + " " + StringResources.OPTIONS);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"General Options");
            AccountOptionsFrame accountOptionsFrame = AccountOptionsFrame.this;
            AccountGeneralOptionsDialog accountGeneralOptionsDialog = new AccountGeneralOptionsDialog(accountOptionsFrame);
            UIUtils.centerWindow((Window)accountGeneralOptionsDialog, accountOptionsFrame);
            accountGeneralOptionsDialog.pack();
            accountGeneralOptionsDialog.setVisible(true);
        }
    }

    private class ButtonDefaultAction
    extends AbstractAction {
        public ButtonDefaultAction() {
            super(StringResources.SET_DEFAULT);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"Set Default");
        }
    }

    private class ButtonPropertiesAction
    extends AbstractAction {
        public ButtonPropertiesAction() {
            super(StringResources.PROPERTIES_C);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"Properties");
            AccountOptionsFrame accountOptionsFrame = AccountOptionsFrame.this;
            MailTableModel mailTableModel = (MailTableModel)accountOptionsFrame.mailTable.getModel();
            int n = accountOptionsFrame.mailTable.getSelectedRow();
            if (n == -1) {
                n = 0;
            }
            Account account = mailTableModel.getAccount(n);
            AccountPropertiesDialog accountPropertiesDialog = new AccountPropertiesDialog((JFrame)accountOptionsFrame, account);
            UIUtils.centerWindow((Window)accountPropertiesDialog, accountOptionsFrame);
            accountPropertiesDialog.pack();
            accountPropertiesDialog.setVisible(true);
        }
    }

    private class ButtonRemoveAction
    extends AbstractAction {
        public ButtonRemoveAction() {
            super(StringResources.REMOVE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"Remove");
        }
    }

    class ButtonAddAction
    extends AbstractAction {
        public ButtonAddAction() {
            super(StringResources.ADD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"Add");
        }
    }

    class ButtonCloseAction
    extends AbstractAction {
        public ButtonCloseAction() {
            super(StringResources.CLOSE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            logger.debug((Object)"Close");
            instance.hide();
        }
    }
}

