/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.frames.options.Options;
import com.novell.gw.jclient.application.frames.options.OptionsFrameActionList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class OptionsFrame
extends GWDialog {
    private Options optionsPane;
    private JButton btnApply = new JButton(new CommandAction(StringResources.APPLY, 140));
    private int top = 10;
    private int left = 10;
    private int bottom = 10;
    private int right = 10;
    private OptionsFrameModel model = new OptionsFrameModel(true);
    private String userGuid;

    public OptionsFrame(ApplicationFrame applicationFrame, MVCController mVCController) {
        super(applicationFrame, true);
        if (OS.isMacOS()) {
            this.setTitle(StringResources.PREFERENCES);
        } else {
            this.setTitle(StringResources.OPTIONS);
        }
        this.setName("Frame Options");
        this.setModal(true);
        this.setController(new OptionsFrameActionList(this, mVCController));
        this.userGuid = mVCController.getActionList().getOwnerComponent() instanceof ApplicationFrame ? ControlsUtils.getUserGuid(mVCController) : EngineCommandManager.getUserGuid();
        this.setDefaultCloseOperation(0);
        this.btnOK = new JButton(new CommandAction(StringResources.OK, 130));
        this.btnCancel = new JButton(new CommandAction(StringResources.CANCEL, 180));
        this.btnApply.setEnabled(false);
        this.buildUI();
    }

    private void buildUI() {
        this.removeWindowListeners();
        this.addWindowListener(new OptionWindowAdapter());
        this.optionsPane = new Options(this.getController(), this.userGuid);
        this.optionsPane.setPreferencesPage("General");
        this.appendEmptyBorder(this.optionsPane);
        this.getContentPane().add((Component)this.optionsPane, "Center");
        this.getContentPane().add((Component)this.createButtonsPanel(), "South");
        UIUtils.centerWindowOnScreen(this);
    }

    private void appendEmptyBorder(JPanel jPanel) {
        if (jPanel.getBorder() == null) {
            jPanel.setBorder(new EmptyBorder(this.top, this.left, this.bottom, this.right));
        } else {
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(this.top, this.left, this.bottom, this.right), jPanel.getBorder());
            jPanel.setBorder(compoundBorder);
        }
    }

    private JPanel createButtonsPanel() {
        this.setCancelButton(this.btnCancel);
        this.setDefaultButton(this.btnOK);
        OrientablePanel orientablePanel = new OrientablePanel(new FlowLayout(4));
        orientablePanel.setBorder(new EmptyBorder(0, this.left, this.bottom, this.right));
        OS.addButtons(orientablePanel, this.btnOK, this.btnCancel, this.btnApply);
        return orientablePanel;
    }

    private void removeWindowListeners() {
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
        }
    }

    public void setPreferencesPage(String string) {
        this.optionsPane.setPreferencesPage(string);
    }

    public void setMVCModel(Object object) {
        if (object instanceof OptionsFrameModel) {
            if (this.model.isOptinsApplied() == ((OptionsFrameModel)object).isOptinsApplied()) {
                return;
            }
            this.model = (OptionsFrameModel)object;
            if (this.model.isOptinsApplied()) {
                this.btnApply.setEnabled(false);
            } else {
                this.btnApply.setEnabled(true);
            }
        }
    }

    public void save() {
        this.optionsPane.getOptionsViewPane().saveOptions();
    }

    private class OptionWindowAdapter
    extends WindowAdapter {
        private OptionWindowAdapter() {
        }

        public void windowOpened(WindowEvent windowEvent) {
            OptionsFrame.this.btnOK.grabFocus();
        }

        public void windowClosing(WindowEvent windowEvent) {
            Command command = new Command(130);
            OptionsFrame.this.getController().processCommand(command);
        }
    }

    private class CommandAction
    extends AbstractAction {
        private int commandID;

        public CommandAction(String string, int n) {
            super(string);
            this.commandID = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Command command = new Command(this.commandID);
            OptionsFrame.this.getController().processCommand(command);
        }
    }

    public static class OptionsFrameModel {
        private boolean optinsApplied;

        public OptionsFrameModel(boolean bl) {
            this.optinsApplied = bl;
        }

        public boolean isOptinsApplied() {
            return this.optinsApplied;
        }
    }
}

