/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;

public class FileChooserPanel
extends OrientablePanel {
    private JLabel label;
    private JButton button;
    private JTextField textField;
    private String buttonText;
    private int verticalGap = 0;
    private ChangesListener changesListener;
    private FileFilter fileFilter;
    private FilenameFilter filenameFilter;
    private boolean isTextScalable;

    public FileChooserPanel(String string, String string2, int n) {
        this(string, string2, null, n, 5, false);
    }

    public FileChooserPanel(String string, String string2, int n, boolean bl) {
        this(string, string2, null, n, 5, bl);
    }

    public FileChooserPanel(String string, String string2, int n, int n2, boolean bl) {
        this(string, string2, null, n, n2, bl);
    }

    public FileChooserPanel(String string, String string2, String string3, int n, int n2, boolean bl) {
        this.isTextScalable = bl;
        this.button = new ToolBarButton(new ChooseFileAction(n));
        this.button.setMargin(new Insets(1, 0, 1, 0));
        this.buttonText = string3;
        this.textField = new OrientableTextField(string2);
        this.textField.setColumns(30);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                FileChooserPanel.this.setValueChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                FileChooserPanel.this.setValueChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        if (this.isTextScalable) {
            String string4 = "align=" + (this.getComponentOrientation().isLeftToRight() ? "left" : "right");
            this.label = new JMnemonicLabel("<html><p " + string4 + ">" + string + "</p></html>", this.textField);
            this.label.setComponentOrientation(this.getComponentOrientation());
        } else {
            this.label = new JMnemonicLabel(string, this.textField);
            this.label.setComponentOrientation(this.getComponentOrientation());
        }
        this.verticalGap = n2 < 0 ? 10 : n2;
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
    }

    private void setValueChanged() {
        if (this.changesListener != null) {
            this.changesListener.setValueChanged();
        }
    }

    protected void buildUI() {
        this.createButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.label, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = this.verticalGap;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.weightx = 0.0;
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.add(this.button);
        gWToolBar.setBorder(null);
        this.add((Component)gWToolBar, gridBagConstraints);
    }

    private void createButton() {
        if (this.buttonText == null) {
            if (ImageResources.ICON_FOLDER == null) {
                this.button.setText("...");
            } else {
                this.button.setIcon(ImageResources.ICON_FOLDER);
                this.button.setBorder(null);
            }
        } else {
            this.button.setText(this.buttonText);
        }
        this.button.setPreferredSize(new Dimension(19, 19));
    }

    public void setChangesListener(ChangesListener changesListener) {
        this.changesListener = changesListener;
    }

    public String getText() {
        String string = this.textField.getText();
        return string == null ? "" : string;
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.label.setEnabled(bl);
        this.button.setEnabled(bl);
        this.textField.setEnabled(bl);
    }

    public void setFilter(String string, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (OS.isMacOS()) {
            OwnFilenameFilter ownFilenameFilter = new OwnFilenameFilter(string);
            for (int i = 0; i < stringArray.length; ++i) {
                ownFilenameFilter.addExtension(stringArray[i]);
            }
            this.filenameFilter = ownFilenameFilter;
        } else {
            OwnFilter ownFilter = new OwnFilter(string);
            for (int i = 0; i < stringArray.length; ++i) {
                ownFilter.addExtension(stringArray[i]);
            }
            this.fileFilter = ownFilter;
        }
    }

    public void setDisplayedMnemonic(int n) {
        if (!OS.isMacOS()) {
            this.label.setDisplayedMnemonic(n);
        }
    }

    public void setDisplayedMnemonic(char c) {
        if (!OS.isMacOS()) {
            this.label.setDisplayedMnemonic(c);
        }
    }

    public void setDisplayedMnemonicIndex(int n) {
        if (!OS.isMacOS()) {
            this.label.setDisplayedMnemonicIndex(n);
        }
    }

    private class OwnFilenameFilter
    implements FilenameFilter {
        private String description;
        private List extensions = new ArrayList();

        public OwnFilenameFilter(String string) {
            this.description = string;
        }

        public boolean accept(File file, String string) {
            String string2 = Utils.getExtention(string);
            boolean bl = this.extensions.contains(string2);
            return bl;
        }

        public void addExtension(String string) {
            this.extensions.add(string);
        }

        public int getExtCount() {
            return this.extensions.size();
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class OwnFilter
    extends FileFilter {
        private String description;
        private List extensions = new ArrayList();

        public OwnFilter(String string) {
            this.description = string;
        }

        public boolean accept(File file) {
            return this.extensions.contains(Utils.getExtention(file.getName()));
        }

        public void addExtension(String string) {
            this.extensions.add(string);
        }

        public int getExtCount() {
            return this.extensions.size();
        }

        public String getDescription() {
            return this.description;
        }
    }

    private class ChooseFileAction
    extends AbstractAction {
        private int dialogMode;

        public ChooseFileAction(int n) {
            if (n != 0 && n != 1) {
                throw new NullPointerException();
            }
            this.dialogMode = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = null;
            File file2 = new File(FileChooserPanel.this.textField.getText());
            file = Utils.getExistingParentFile(file2);
            String string = "";
            if (OS.isMacOS()) {
                if (this.dialogMode == 0) {
                    string = StringResources.SELECT_FILE;
                } else if (this.dialogMode == 1) {
                    string = StringResources.SELECT_DIRECTORY;
                    System.setProperty("apple.awt.fileDialogForDirectories", "true");
                }
                Frame frame = ControlsUtils.getFrameForComponent(FileChooserPanel.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser(frame, string, file, 0);
                if (FileChooserPanel.this.filenameFilter != null) {
                    gWMacFileChooser.setFilenameFilter(FileChooserPanel.this.filenameFilter);
                }
                if (this.dialogMode == 0 && file2.exists()) {
                    gWMacFileChooser.setSelectedFile(file2);
                }
                UIUtils.centerWindow((Window)gWMacFileChooser, FileChooserPanel.this.button);
                gWMacFileChooser.setVisible(true);
                String string2 = gWMacFileChooser.getFile();
                String string3 = gWMacFileChooser.getDirectory();
                if (string2 != null) {
                    boolean bl = false;
                    if (this.dialogMode == 0) {
                        bl = true;
                    } else if (this.dialogMode == 1) {
                        File file3 = new File(string3 + string2);
                        bl = file3.isDirectory();
                    }
                    if (bl) {
                        FileChooserPanel.this.textField.setText(string3 + string2);
                        FileChooserPanel.this.setValueChanged();
                    }
                }
                if (this.dialogMode == 1) {
                    System.setProperty("apple.awt.fileDialogForDirectories", "false");
                }
            } else {
                if (this.dialogMode == 0) {
                    string = StringResources.SELECT_FILE;
                } else if (this.dialogMode == 1) {
                    string = StringResources.SELECT_DIRECTORY;
                }
                Window window = ControlsUtils.getWindowForComponent(FileChooserPanel.this);
                GWFileChooser gWFileChooser = window instanceof Frame ? new GWFileChooser((Frame)window, string, file, this.dialogMode, 0, false) : new GWFileChooser((Dialog)window, string, file, this.dialogMode, 0, false);
                if (FileChooserPanel.this.fileFilter != null) {
                    gWFileChooser.setFileFilter(FileChooserPanel.this.fileFilter);
                    gWFileChooser.setAcceptAllFileFilter(false);
                }
                if (this.dialogMode == 0 && file2.exists()) {
                    gWFileChooser.setSelectedFile(file2);
                }
                UIUtils.centerWindow((Window)gWFileChooser, FileChooserPanel.this.button);
                gWFileChooser.pack();
                gWFileChooser.setVisible(true);
                String[] stringArray = gWFileChooser.getResult();
                if (stringArray != null) {
                    boolean bl = false;
                    File file4 = new File(stringArray[0]);
                    if (this.dialogMode == 0) {
                        bl = OS.isMacOS() ? true : file4.isFile();
                    } else if (this.dialogMode == 1) {
                        bl = file4.isDirectory();
                    }
                    if (bl) {
                        FileChooserPanel.this.textField.setText(stringArray[0]);
                        FileChooserPanel.this.setValueChanged();
                    }
                }
            }
        }
    }
}

