/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.components.customizedbutton.ToolBarButton;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class BackupOptionsPane
extends AbstractOptionPanel {
    private JCheckBox cbBackup = new JMnemonicCheckBox(StringResources.BACKUP_CACHING_MAILBOX);
    private JCheckBox cbDoNotPrompt = new JMnemonicCheckBox(StringResources.DO_NOT_PROMPT_BEFORE_PERFORMING_BACKUP);
    private JButton btnSelectFolder = new ToolBarButton(new SelectFolderAction());
    private JSpinner spDays = new OrientableSpinner(new SpinnerNumberModel(0, 0, 99, 1));
    private JTextField tfPath = new OrientableTextField();

    public static void main(String[] stringArray) {
        StringResources.initTestStringResources();
        JDialog jDialog = new JDialog();
        jDialog.pack();
        jDialog.show();
    }

    public BackupOptionsPane(ChangesListener changesListener, MVCController mVCController) {
        super(changesListener, mVCController);
        this.setName(StringResources.BACKUP_OPTIONS);
        this.cbBackup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = itemEvent.getStateChange() == 1;
                BackupOptionsPane.this.setControlsEnabled(bl);
            }
        });
        this.buildUI();
        this.setControlsEnabled(false);
        this.cbBackup.addItemListener(this.itemListener);
        this.cbDoNotPrompt.addItemListener(this.itemListener);
        this.spDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.tfPath.getDocument().addDocumentListener(new AbstractOptionPanel.CustomDocumentListener(this.changesListener));
    }

    private void setControlsEnabled(boolean bl) {
        this.tfPath.setEditable(bl);
        this.btnSelectFolder.setEnabled(bl);
        this.spDays.setEnabled(bl);
        this.cbDoNotPrompt.setEnabled(bl);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.btnSelectFolder.setPreferredSize(new Dimension(this.btnSelectFolder.getPreferredSize().width, this.tfPath.getPreferredSize().height));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cbBackup, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        OrientablePanel orientablePanel = new OrientablePanel(new BorderLayout(5, 0));
        orientablePanel.add((Component)new JMnemonicLabel(StringResources.DIRECTORY, this.tfPath), "Before");
        orientablePanel.add((Component)this.tfPath, "Center");
        GWToolBar gWToolBar = new GWToolBar();
        gWToolBar.add(this.btnSelectFolder);
        gWToolBar.setBorder(null);
        orientablePanel.add((Component)gWToolBar, "After");
        gridBagConstraints.insets.left = 10;
        this.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        orientablePanel = new OrientablePanel();
        orientablePanel.add(new JMnemonicLabel(StringResources.BACKUP_CACHING_MAILBOX_EVERY, this.spDays));
        orientablePanel.add(this.spDays);
        orientablePanel.add(new OrientableLabel(StringResources.L_DAYS));
        gridBagConstraints.insets.left = 5;
        this.add((Component)orientablePanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cbDoNotPrompt, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    protected void build() {
    }

    public void collectValues() {
        MachineSettings machineSettings = OptionManager.getInstance().getMachineSettings();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        machineSettings.setBackupEnabled(this.cbBackup.isSelected());
        machineSettings.setBackupPromptEnabled(!this.cbDoNotPrompt.isSelected());
        dataStoreSettings.setBackupInterval(((SpinnerNumberModel)this.spDays.getModel()).getNumber().intValue());
        dataStoreSettings.setBackupLocation(this.tfPath.getText());
    }

    public void fireOptionsChanged() {
        MachineSettings machineSettings = OptionManager.getInstance().getMachineSettings();
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getDataStoreSettings();
        this.cbDoNotPrompt.setSelected(!machineSettings.isBackupPromptEnabled());
        this.cbBackup.setSelected(machineSettings.isBackupEnabled());
        this.tfPath.setText(dataStoreSettings.getBackupLocation());
        int n = dataStoreSettings.getBackupInterval();
        if (n >= 0 && n <= 99) {
            this.spDays.getModel().setValue(new Integer(dataStoreSettings.getBackupInterval()));
        }
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
    }

    private class SelectFolderAction
    extends AbstractAction {
        public SelectFolderAction() {
            super("", ImageResources.ICON_FOLDER);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (OS.isMacOS()) {
                File file;
                boolean bl;
                String string = StringResources.SELECT_DIRECTORY;
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                Frame frame = ControlsUtils.getFrameForComponent(BackupOptionsPane.this);
                if (frame == null) {
                    return;
                }
                GWMacFileChooser gWMacFileChooser = new GWMacFileChooser(frame, string, null, 0);
                gWMacFileChooser.setVisible(true);
                String string2 = gWMacFileChooser.getFile();
                String string3 = gWMacFileChooser.getDirectory();
                if (string2 != null && (bl = (file = new File(string3 + string2)).isDirectory())) {
                    BackupOptionsPane.this.tfPath.setText(file.getPath());
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                GWFileChooser gWFileChooser = new GWFileChooser((Dialog)SwingUtilities.getWindowAncestor(BackupOptionsPane.this), StringResources.OPEN, null, 1, 0, false);
                gWFileChooser.setVisible(true);
                String[] stringArray = gWFileChooser.getResult();
                if (stringArray != null) {
                    File file = gWFileChooser.getChooser().getSelectedFile();
                    BackupOptionsPane.this.tfPath.setText(file.getPath());
                }
            }
        }
    }
}

