/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.MVCController;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableSpinner;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class CleanupOptionPane
extends AbstractOptionPanel {
    private AbstractButton rbManualDeleteMail = new OrientableRadioButton(StringResources.MANUAL_DELETE_AND_ARCHIVE);
    private AbstractButton rbManualDeleteAppointment = new OrientableRadioButton(StringResources.MANUAL_DELETE_AND_ARCHIVE);
    private AbstractButton rbAutoDeleteMail = new OrientableRadioButton(StringResources.AUTO_DELETE_AFTER_C);
    private AbstractButton rbAutoDeleteAppointment = new OrientableRadioButton(StringResources.AUTO_DELETE_AFTER_C);
    private AbstractButton rbAutoArchiveMail = new OrientableRadioButton(StringResources.AUTO_ARCHIVE_AFTER_C);
    private AbstractButton rbAutoArchiveAppointment = new OrientableRadioButton(StringResources.AUTO_ARCHIVE_AFTER_C);
    private AbstractButton rbManualEmptyTrash = new OrientableRadioButton(StringResources.MANUAL);
    private AbstractButton rbAutoDeleteTrash = new OrientableRadioButton(StringResources.AUTO_DELETE_AFTER_C);
    private CleanupSpinner spMailDays = new CleanupSpinner();
    private CleanupSpinner spAppointmentDays = new CleanupSpinner();
    private CleanupSpinner spTrashDays = new CleanupSpinner();
    private String userGuid;

    public CleanupOptionPane(ChangesListener changesListener, MVCController mVCController, String string) {
        super(changesListener, mVCController);
        this.userGuid = string;
        this.setName(StringResources.CLEANUP);
        this.buildUI();
        this.rbManualDeleteMail.addItemListener(this.itemListener);
        this.rbManualDeleteAppointment.addItemListener(this.itemListener);
        this.rbAutoDeleteMail.addItemListener(this.itemListener);
        this.rbAutoDeleteAppointment.addItemListener(this.itemListener);
        this.rbAutoArchiveMail.addItemListener(this.itemListener);
        this.rbAutoArchiveAppointment.addItemListener(this.itemListener);
        this.rbManualEmptyTrash.addItemListener(this.itemListener);
        this.rbAutoDeleteTrash.addItemListener(this.itemListener);
        this.spMailDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spAppointmentDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
        this.spTrashDays.addChangeListener(new AbstractOptionPanel.CustomItemChangeListener(this.changesListener));
    }

    protected void build() {
    }

    public void collectValues() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(this.userGuid).getDataStoreSettings();
        Integer n = new Integer(this.getCleanupOption(this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail));
        Integer n2 = new Integer(this.getCleanupOption(this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment));
        Integer n3 = new Integer(this.getCleanupOption(this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null));
        Integer n4 = (Integer)this.spMailDays.getValue();
        Integer n5 = (Integer)this.spAppointmentDays.getValue();
        Integer n6 = (Integer)this.spTrashDays.getValue();
        dataStoreSettings.setCleanupOptions(n, n4, n2, n5, n3, n6);
    }

    private int getCleanupOption(AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3) {
        if (abstractButton.isSelected()) {
            return 0;
        }
        if (abstractButton2.isSelected()) {
            if (abstractButton3 == null) {
                return 1;
            }
            return 1;
        }
        if (abstractButton3 != null && abstractButton3.isSelected()) {
            return 2;
        }
        return -1;
    }

    public void fireOptionsChanged() {
        DataStoreSettings dataStoreSettings = GWCommandManager.getInstance(this.userGuid).getDataStoreSettings();
        DataStoreSettings.CleanupOptions cleanupOptions = dataStoreSettings.getCleanupOption();
        this.selectButtons(cleanupOptions.getMailAndPhone(), this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail);
        this.selectButtons(cleanupOptions.getCalItem(), this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment);
        this.selectButtons(cleanupOptions.getTrash(), this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null);
        this.spMailDays.setValue(new Integer(cleanupOptions.getMailAndPhoneDays()));
        this.spAppointmentDays.setValue(new Integer(cleanupOptions.getCalItemDays()));
        this.spTrashDays.setValue(new Integer(cleanupOptions.getTrashDays()));
        this.spMailDays.setLocked(cleanupOptions.isMailAndPhoneDaysLocked());
        this.spAppointmentDays.setLocked(cleanupOptions.isCalItemDaysLocked());
        this.spTrashDays.setLocked(cleanupOptions.isTrashDaysLocked());
        if (cleanupOptions.isMailAndPhoneLocked()) {
            this.lockButtons(this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail);
        }
        if (cleanupOptions.isCalItemLocked()) {
            this.lockButtons(this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment);
        }
        if (cleanupOptions.isTrashLocked()) {
            this.lockButtons(this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null);
        }
    }

    private void lockButtons(AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3) {
        abstractButton.setEnabled(false);
        abstractButton2.setEnabled(false);
        if (abstractButton3 != null) {
            abstractButton3.setEnabled(false);
        }
    }

    private void selectButtons(int n, AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3) {
        switch (n) {
            case 0: {
                abstractButton.setSelected(true);
                break;
            }
            case 1: {
                abstractButton2.setSelected(true);
                break;
            }
            case 2: {
                if (abstractButton3 == null) break;
                abstractButton3.setSelected(true);
            }
        }
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.buildPane(StringResources.MAIL_AND_PHONE, this.rbManualDeleteMail, this.rbAutoDeleteMail, this.rbAutoArchiveMail, this.spMailDays);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = this.buildPane(StringResources.APPOINTMENT_TASK_AND_REMINDER_NOTE, this.rbManualDeleteAppointment, this.rbAutoDeleteAppointment, this.rbAutoArchiveAppointment, this.spAppointmentDays);
        gridBagConstraints.gridy = 1;
        this.add((Component)jPanel, gridBagConstraints);
        jPanel = this.buildPane(StringResources.EMPTY_TRASH, this.rbManualEmptyTrash, this.rbAutoDeleteTrash, null, this.spTrashDays);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
    }

    private JPanel buildPane(String string, AbstractButton abstractButton, AbstractButton abstractButton2, AbstractButton abstractButton3, final JSpinner jSpinner) {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        orientablePanel.setBorder(titledBorder);
        final OrientableLabel orientableLabel = new OrientableLabel(StringResources.DAYS_L);
        jSpinner.setModel(new SpinnerNumberModel(1, 1, 9999, 1));
        ((JSpinner.DefaultEditor)jSpinner.getEditor()).getTextField().setColumns(2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(abstractButton);
        buttonGroup.add(abstractButton2);
        buttonGroup.add(abstractButton3);
        abstractButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                jSpinner.setEnabled(itemEvent.getStateChange() == 2);
                orientableLabel.setEnabled(itemEvent.getStateChange() == 2);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        orientablePanel.add((Component)abstractButton, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        orientablePanel.add((Component)abstractButton2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        orientablePanel.add((Component)jSpinner, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)orientableLabel, gridBagConstraints);
        if (abstractButton3 != null) {
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            orientablePanel.add((Component)abstractButton3, gridBagConstraints);
        }
        return orientablePanel;
    }

    private static class CleanupSpinner
    extends OrientableSpinner {
        private boolean isLocked = false;

        public void setLocked(boolean bl) {
            this.isLocked = bl;
            if (bl) {
                this.setEnabled(false);
            }
        }

        public void setEnabled(boolean bl) {
            if (!this.isLocked) {
                super.setEnabled(bl);
            }
        }
    }
}

