/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.general;

import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.general.BackupOptionsPane;
import com.novell.gw.jclient.application.frames.options.compose.general.CleanupOptionPane;
import com.novell.gw.jclient.application.frames.options.compose.general.CommonPanel;
import com.novell.gw.jclient.application.frames.options.compose.general.DefaultActionsOptionPane;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;

public class GeneralOptionPane
extends ComposeOption {
    private CommonPanel pnlCommon;
    private GeneralOptions generalOptions;
    private AbstractOptionPanel backupOptionsPane;
    private AbstractOptionPanel cleanupOptionPane;
    private AbstractOptionPanel defaultActionsOptionPane;
    private String userGuid;

    public GeneralOptionPane(String string, MVCController mVCController, String string2) {
        super(string, mVCController);
        this.userGuid = string2;
        this.build();
    }

    protected void build() {
        super.build();
        this.pnlCommon = new CommonPanel(this.changesListener, this.getController(), this.userGuid);
        this.backupOptionsPane = new BackupOptionsPane(this.changesListener, this.getController());
        this.cleanupOptionPane = new CleanupOptionPane(this.changesListener, this.getController(), this.userGuid);
        this.defaultActionsOptionPane = new DefaultActionsOptionPane(this.changesListener, this.getController());
        this.setLayout(new BorderLayout());
        OrientableTabbedPane orientableTabbedPane = new OrientableTabbedPane();
        orientableTabbedPane.add(this.pnlCommon.getName(), new OrientableScrollPane(this.pnlCommon));
        if (GWCommandManager.getInstance(this.userGuid).isCachingDataStore()) {
            orientableTabbedPane.add(this.backupOptionsPane);
        }
        orientableTabbedPane.add(this.cleanupOptionPane.getName(), new OrientableScrollPane(this.cleanupOptionPane));
        orientableTabbedPane.add(this.defaultActionsOptionPane.getName(), new OrientableScrollPane(this.defaultActionsOptionPane));
        this.add((Component)orientableTabbedPane, "Center");
        this.putOptionValuesIntoFields();
    }

    public void save() {
    }

    public void save(MVCController mVCController) {
        super.save(mVCController);
        if (this.changesListener.valueHasChanged()) {
            String string = this.pnlCommon.getCashingPath();
            if (string == null || "".equals(string)) {
                OptionManager.getInstance().setCashingPath("");
            } else if (this.ensurePathExistance(string)) {
                OptionManager.getInstance().setCashingPath(string);
            }
            this.collectValues();
            String string2 = OptionManager.getInstance().getArchiveDir(this.userGuid);
            if (this.isEmptyString(string2)) {
                OptionManager.getInstance().setArchiveDir("", this.userGuid);
            } else if (this.ensurePathExistance(string2)) {
                OptionManager.getInstance().setArchiveDir(string2, this.userGuid);
            }
            OptionManager.getInstance().setGeneralOptions((GeneralOptions)this.generalOptions.clone());
            this.changesListener.setValueSaved();
            this.getController().processCommand(new GlobalCommand(1380));
        }
    }

    private boolean isEmptyString(String string) {
        return string == null || "".equals(string);
    }

    public void putOptionValuesIntoFields() {
        this.generalOptions = (GeneralOptions)OptionManager.getInstance().getGeneralOptions().clone();
        this.pnlCommon.setOptions(this.generalOptions);
        this.backupOptionsPane.fireOptionsChanged();
        this.cleanupOptionPane.fireOptionsChanged();
        this.defaultActionsOptionPane.fireOptionsChanged();
        this.pnlCommon.setCashingPath(OptionManager.getInstance().getCachingPath());
        this.changesListener.setValueSaved();
    }

    public void collectValues() {
        this.pnlCommon.collectValues();
        this.backupOptionsPane.collectValues();
        this.cleanupOptionPane.collectValues();
        this.defaultActionsOptionPane.collectValues();
    }

    private boolean ensurePathExistance(String string) {
        boolean bl = false;
        if (string != null && !"".equals(string)) {
            File file = new File(string);
            if (file.exists()) {
                bl = true;
            } else {
                int n = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.DOES_NOT_EXIST_CREATE_DIRECTORY_Q, new String[]{string}), StringResources.GROUPWISE_CLIENT, 0, 3);
                if (n == 0) {
                    if (file.mkdirs()) {
                        bl = true;
                    } else {
                        JOptionPane.showMessageDialog(this, StringResources.formatString(StringResources.FAILED_TO_CREATE_DIRECTORY, new String[]{string}), StringResources.GROUPWISE_CLIENT, 0);
                        bl = false;
                    }
                }
            }
        }
        return bl;
    }
}

