/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.components.ComponentBorder;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.fontchooser.FontChooserDialog;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import org.apache.log4j.Logger;

class FontPanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$options$compose$printing$FontPanel == null ? (class$com$novell$gw$jclient$application$frames$options$compose$printing$FontPanel = FontPanel.class$("com.novell.gw.jclient.application.frames.options.compose.printing.FontPanel")) : class$com$novell$gw$jclient$application$frames$options$compose$printing$FontPanel));
    private String caption;
    private JLabel lbFont;
    private JButton btnSelectFont;
    private Font font;
    private FontChooserDialog fontChooserDialog;
    private ChangesListener changesListener;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$options$compose$printing$FontPanel;

    public FontPanel(String string, ChangesListener changesListener) {
        this.caption = string;
        this.changesListener = changesListener;
        this.build();
    }

    private void build() {
        this.btnSelectFont = new JButton(new BtnSelectFontAction());
        this.btnSelectFont.setPreferredSize(new Dimension(19, 19));
        this.lbFont = new OrientableLabel();
        OrientableLabel orientableLabel = new OrientableLabel(this.caption);
        this.add(orientableLabel);
        if (!OS.isMacOS()) {
            orientableLabel.setDisplayedMnemonic(StringResources.getMnemonic(this.caption));
            orientableLabel.setDisplayedMnemonicIndex(StringResources.getDisplayedMnemonicIndex(this.caption));
        }
        orientableLabel.setLabelFor(this.btnSelectFont);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new ComponentBorder(orientableLabel), BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.setBorder(compoundBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        if (this.font == null) {
            this.font = new Font(PLAFChanger.getFontName(), 0, 14);
        }
        gridBagConstraints.insets = new Insets(8, 4, 1, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.lbFont, gridBagConstraints);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 1, 2);
        this.add((Component)this.btnSelectFont, gridBagConstraints);
        this.update();
    }

    public void setName(String string) {
        this.btnSelectFont.setName(string);
    }

    private void update() {
        if (this.font != null) {
            String string = this.font.getName();
            string = string + " (";
            switch (this.font.getStyle()) {
                case 0: {
                    string = string + StringResources.PLAIN;
                    break;
                }
                case 1: {
                    string = string + StringResources.BOLD;
                    break;
                }
                case 2: {
                    string = string + StringResources.ITALIC;
                    break;
                }
                case 3: {
                    string = string + StringResources.BOLD_ITALIC;
                    break;
                }
            }
            string = string + ", " + String.valueOf(this.font.getSize()) + ")";
            this.lbFont.setText(string);
            this.lbFont.setFont(Utils.deriveFontForSize(this.font, 14.0f));
        }
    }

    public Font getSelectedFont() {
        return this.font;
    }

    public void setSelectedFont(Font font) {
        this.font = font;
        this.update();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BtnSelectFontAction
    extends AbstractAction {
        public BtnSelectFontAction() {
            super("...");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Window window = ControlsUtils.getWindowForComponent(FontPanel.this);
            if (window instanceof Frame) {
                FontPanel.this.fontChooserDialog = new FontChooserDialog((Frame)window);
            } else if (window instanceof Dialog) {
                FontPanel.this.fontChooserDialog = new FontChooserDialog((Dialog)window);
            }
            FontPanel.this.fontChooserDialog.setModal(true);
            UIUtils.centerWindow((Window)FontPanel.this.fontChooserDialog, window);
            FontPanel.this.fontChooserDialog.setFont(FontPanel.this.font);
            FontPanel.this.fontChooserDialog.pack();
            FontPanel.this.fontChooserDialog.setVisible(true);
            Font font = FontPanel.this.fontChooserDialog.getChoosenFont();
            if (font != null && !FontPanel.this.font.equals(font)) {
                FontPanel.this.font = font;
                FontPanel.this.changesListener.setValueChanged();
                FontPanel.this.update();
            }
            FontPanel.this.fontChooserDialog.dispose();
        }
    }
}

