/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ComposeOption;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingAddressBookPanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingCalendarPanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingGeneralPanel;
import com.novell.gw.jclient.application.frames.options.compose.printing.PrintingMessagePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.BorderLayout;
import java.awt.Component;

public class PrintOptionsPane
extends ComposeOption {
    public static final String HEADER_FONT = "header";
    public static final String SUBHEADER_FONT = "subheader";
    public static final String PLAINHEADER_FONT = "plain";
    public static final String PAGE_SETUP = "page setup";
    private AbstractOptionPanel generalPane;
    private AbstractOptionPanel messagePane;
    private AbstractOptionPanel calendarPane;
    private AbstractOptionPanel addressBookPane;
    private PrintingOptions printingOptions;

    public PrintOptionsPane(String string, MVCController mVCController) {
        super(string, mVCController);
        this.build();
    }

    protected void build() {
        super.build();
        this.setLayout(new BorderLayout());
        OrientableTabbedPane orientableTabbedPane = new OrientableTabbedPane();
        this.generalPane = new PrintingGeneralPanel(this.changesListener, this.controller);
        this.messagePane = new PrintingMessagePanel(this.changesListener, this.controller);
        this.calendarPane = new PrintingCalendarPanel(this.changesListener, this.controller);
        this.addressBookPane = new PrintingAddressBookPanel(this.changesListener, this.controller);
        orientableTabbedPane.add(this.generalPane.getName(), new OrientableScrollPane(this.generalPane));
        orientableTabbedPane.add(this.messagePane.getName(), new OrientableScrollPane(this.messagePane));
        orientableTabbedPane.add(this.calendarPane.getName(), new OrientableScrollPane(this.calendarPane));
        orientableTabbedPane.add(this.addressBookPane.getName(), new OrientableScrollPane(this.addressBookPane));
        this.add((Component)orientableTabbedPane, "Center");
        this.putOptionValuesIntoFields();
    }

    public void save() {
        if (this.changesListener.valueHasChanged()) {
            this.collectValues();
            OptionManager.getInstance().setPrintingOptions((PrintingOptions)this.printingOptions.clone());
            this.changesListener.setValueSaved();
        }
    }

    public void putOptionValuesIntoFields() {
        this.printingOptions = (PrintingOptions)OptionManager.getInstance().getPrintingOptions().clone();
        this.generalPane.setOptions(this.printingOptions);
        this.messagePane.setOptions(this.printingOptions);
        this.calendarPane.setOptions(this.printingOptions);
        this.addressBookPane.setOptions(this.printingOptions);
    }

    public void collectValues() {
        this.generalPane.collectValues();
        this.messagePane.collectValues();
        this.calendarPane.collectValues();
        this.addressBookPane.collectValues();
    }
}

