/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.printing;

import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.frames.options.compose.printing.FontPanel;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.border.Border;

class PrintingGeneralPanel
extends AbstractOptionPanel {
    private PrintingOptions printingOptions;
    private FontPanel fontPanelHeader;
    private FontPanel fontPanelSubHeader;
    private FontPanel fontPanelPlain;
    private JCheckBox cbPrintPageNumber;
    private JCheckBox cbPrintHeader;
    private JButton btnPageSetup;

    public PrintingGeneralPanel(ChangesListener changesListener, MVCController mVCController) {
        super(changesListener, mVCController);
        this.setName(StringResources.GENERAL);
        this.cbPrintPageNumber.getModel().addItemListener(this.itemListener);
        this.cbPrintHeader.getModel().addItemListener(this.itemListener);
    }

    protected void build() {
        Border border = BorderFactory.createEtchedBorder();
        border = BorderFactory.createTitledBorder(border, StringResources.GENERAL);
        this.setBorder(border);
        this.cbPrintPageNumber = new JMnemonicCheckBox(StringResources.PRINT_PAGE_NUMBER);
        this.cbPrintHeader = new JMnemonicCheckBox(StringResources.PRINT_HEADER);
        this.cbPrintHeader.addActionListener(new PrintHeaderAction());
        this.fontPanelHeader = new FontPanel(StringResources.HEADER_PRINTING_FONT, this.changesListener);
        this.fontPanelSubHeader = new FontPanel(StringResources.SUBHEADER_PRINTING_FONT, this.changesListener);
        this.fontPanelPlain = new FontPanel(StringResources.PLAIN_TEXT_PRINTING_FONT, this.changesListener);
        this.btnPageSetup = new JButton(new PageSetupAction());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.cbPrintHeader, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 20, 10, 0);
        this.add((Component)this.cbPrintPageNumber, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 5, 7, 0);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fontPanelHeader, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fontPanelSubHeader, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.fontPanelPlain, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.btnPageSetup, gridBagConstraints);
        if (OS.isMacOS()) {
            this.btnPageSetup.setVisible(false);
        }
        OrientablePanel orientablePanel = new OrientablePanel();
        gridBagConstraints.weighty = 1.0;
        this.add((Component)orientablePanel, gridBagConstraints);
    }

    public void collectValues() {
        this.printingOptions.setFntHeader(this.fontPanelHeader.getSelectedFont());
        this.printingOptions.setFntSubHeader(this.fontPanelSubHeader.getSelectedFont());
        this.printingOptions.setFntPlainTxt(this.fontPanelPlain.getSelectedFont());
        this.printingOptions.setPageNumberPrinted(this.cbPrintPageNumber.isSelected());
        ApplicationOptions.getInstance().put("PRINT_HEADER", new Boolean(this.cbPrintHeader.isSelected()));
    }

    public void fireOptionsChanged() {
        this.fontPanelHeader.setSelectedFont(this.printingOptions.getFntHeader());
        this.fontPanelSubHeader.setSelectedFont(this.printingOptions.getFntSubHeader());
        this.fontPanelPlain.setSelectedFont(this.printingOptions.getFntPlainTxt());
        this.cbPrintPageNumber.setSelected(this.printingOptions.isPageNumberPrinted());
        this.cbPrintHeader.setSelected(ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true));
        this.cbPrintPageNumber.setEnabled(this.cbPrintHeader.isSelected());
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
        if (!(abstractCloneObject instanceof PrintingOptions)) {
            throw new IllegalArgumentException();
        }
        this.printingOptions = (PrintingOptions)abstractCloneObject;
        this.fireOptionsChanged();
    }

    private class PageSetupAction
    extends AbstractAction {
        public PageSetupAction() {
            super(StringResources.PAGE_SETUP);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PrinterJob.lookupPrintServices().length == 0) {
                JOptionPane.showMessageDialog(PrintingGeneralPanel.this, StringResources.PROBLEM_WITH_PRINTERK__PRINTING_FAI);
                return;
            }
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = PrintingGeneralPanel.this.printingOptions.getPrintAttributeSet();
            PageFormat pageFormat = OS.isMacOS() ? printerJob.pageDialog(printerJob.defaultPage()) : printerJob.pageDialog(hashPrintRequestAttributeSet);
            if (pageFormat == null) {
                return;
            }
            PrintingGeneralPanel.this.printingOptions.setPrintAttributeSet(hashPrintRequestAttributeSet);
            PrintingGeneralPanel.this.changesListener.setValueChanged();
        }
    }

    private class PrintHeaderAction
    extends AbstractAction {
        private PrintHeaderAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = PrintingGeneralPanel.this.cbPrintHeader.isSelected();
            PrintingGeneralPanel.this.cbPrintPageNumber.setEnabled(bl);
        }
    }
}

