/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.security;

import com.appframework.components.EmptyStringDocumentListener;
import com.novell.gw.ab.Addressable;
import com.novell.gw.engine.ProxyAccessEntry;
import com.novell.gw.jclient.application.ExtendedGWTable;
import com.novell.gw.jclient.application.controls.ColoredScrollPane;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableTableCellRenderer;
import com.novell.gw.jclient.application.frames.options.OptionsFrame;
import com.novell.gw.jclient.application.frames.options.compose.security.AccessTableModel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ProxyAccessPane
extends OrientablePanel {
    private SearchTextField tfName = new SearchTextField();
    private AbstractButton btnViewAddressBook = new JButton(new ViewABAction());
    private AbstractButton btnAddUser = new JButton(new AddUserAction());
    private AbstractButton btnRemoveUser = new JButton(new RemoveUserAction());
    private AccessTableModel model;
    private JTable tableAccessList;
    private JPanel pnlAccessRights;
    private JCheckBox cbMailReadAccess = new OrientableCheckBox();
    private JCheckBox cbMailWriteAccess = new OrientableCheckBox();
    private JCheckBox cbAppointmentReadAccess = new OrientableCheckBox();
    private JCheckBox cbAppointmentWriteAccess = new OrientableCheckBox();
    private JCheckBox cbNotesReadAccess = new OrientableCheckBox();
    private JCheckBox cbNotesWriteAccess = new OrientableCheckBox();
    private JCheckBox cbTaskReadAccess = new OrientableCheckBox();
    private JCheckBox cbTaskWriteAccess = new OrientableCheckBox();
    private JCheckBox cbSubscribeToMyAlarm = new OrientableCheckBox();
    private JCheckBox cbSubscribeToMyNotifications = new OrientableCheckBox();
    private JCheckBox cbModifyOptionsRulesFolders = new OrientableCheckBox();
    private JCheckBox cbReadItemsMarkedPrivate = new OrientableCheckBox();
    private JButton defaultButton;
    private String userGuid;
    static /* synthetic */ Class class$java$lang$Object;

    public ProxyAccessPane(String string) {
        super(new GridBagLayout());
        this.userGuid = string;
        this.model = new AccessTableModel(this.userGuid);
        this.tableAccessList = new ExtendedGWTable(this.model);
        this.setName(StringResources.PROXY_ACCESS);
        this.buildUI();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.init();
    }

    private void init() {
        this.tableAccessList.getSelectionModel().setSelectionMode(0);
        this.tableAccessList.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = ProxyAccessPane.class$("java.lang.Object")) : class$java$lang$Object, new OrientableTableCellRenderer());
        this.tableAccessList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ProxyAccessPane.this.processItemSelection();
            }
        });
        int n = this.model.getRowCount() > 1 ? 1 : 0;
        this.tableAccessList.setRowSelectionInterval(n, n);
        this.cbMailReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().mail.setReadAccess(ProxyAccessPane.this.cbMailReadAccess.isSelected());
            }
        });
        this.cbMailWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().mail.setWriteAccess(ProxyAccessPane.this.cbMailWriteAccess.isSelected());
            }
        });
        this.cbAppointmentReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().appt.setReadAccess(ProxyAccessPane.this.cbAppointmentReadAccess.isSelected());
            }
        });
        this.cbAppointmentWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().appt.setWriteAccess(ProxyAccessPane.this.cbAppointmentWriteAccess.isSelected());
            }
        });
        this.cbNotesReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().note.setReadAccess(ProxyAccessPane.this.cbNotesReadAccess.isSelected());
            }
        });
        this.cbNotesWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().note.setWriteAccess(ProxyAccessPane.this.cbNotesWriteAccess.isSelected());
            }
        });
        this.cbTaskReadAccess.setAction(new AbstractAction(StringResources.READ){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().todo.setReadAccess(ProxyAccessPane.this.cbTaskReadAccess.isSelected());
            }
        });
        this.cbTaskWriteAccess.setAction(new AbstractAction(StringResources.WRITE){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().todo.setWriteAccess(ProxyAccessPane.this.cbTaskWriteAccess.isSelected());
            }
        });
        this.cbModifyOptionsRulesFolders.setAction(new AbstractAction(StringResources.MODIFY_OPTIONS_RULES_FOLDERS){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setModifySettings(ProxyAccessPane.this.cbModifyOptionsRulesFolders.isSelected());
            }
        });
        this.cbReadItemsMarkedPrivate.setAction(new AbstractAction(StringResources.READ_ITEMS_MARKED_PRIVATE){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setReadPrivate(ProxyAccessPane.this.cbReadItemsMarkedPrivate.isSelected());
            }
        });
        this.cbSubscribeToMyAlarm.setAction(new AbstractAction(StringResources.SUBSCRIBE_TO_MY_ALARMS){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setSubscribeAlarms(ProxyAccessPane.this.cbSubscribeToMyAlarm.isSelected());
            }
        });
        this.cbSubscribeToMyNotifications.setAction(new AbstractAction(StringResources.SUBSCRIBE_TO_MY_NOTIFICATIONS){

            public void actionPerformed(ActionEvent actionEvent) {
                ((ProxyAccessPane)ProxyAccessPane.this).getSelectedAccessEntry().misc.setSubscribeNotify(ProxyAccessPane.this.cbSubscribeToMyNotifications.isSelected());
            }
        });
        this.tfName.getDocument().addDocumentListener(new EmptyStringDocumentListener(this.btnAddUser.getAction()));
        this.tableAccessList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                if (keyEvent.getKeyCode() == n) {
                    ProxyAccessPane.this.btnRemoveUser.getAction().actionPerformed(null);
                }
            }
        });
        this.tfName.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (ProxyAccessPane.this.defaultButton == null) {
                        ProxyAccessPane.this.defaultButton = ProxyAccessPane.this.getRootPane().getDefaultButton();
                    }
                    if (!ProxyAccessPane.this.tfName.getText().equals("")) {
                        ProxyAccessPane.this.getRootPane().setDefaultButton((JButton)ProxyAccessPane.this.btnAddUser);
                    }
                }
            }
        });
        this.tfName.setListener(new SearchResultListener(){

            public void searchFinished(SearchEvent searchEvent) {
                boolean bl = true;
                Addressable addressable = searchEvent.getFoundContact();
                if (addressable != null) {
                    ArrayList<Addressable> arrayList = new ArrayList<Addressable>(1);
                    arrayList.add(addressable);
                    try {
                        ProxyAccessPane.this.model.addContacts(arrayList);
                        int n = ProxyAccessPane.this.model.indexOf(addressable);
                        if (n > 0) {
                            ProxyAccessPane.this.tableAccessList.setRowSelectionInterval(n, n);
                        }
                        bl = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (bl) {
                    JOptionPane.showMessageDialog(null, StringResources.formatString(StringResources.IS_NOT_A_VALID_GROUPWISE_USER, new String[]{ProxyAccessPane.this.tfName.getText(), ProxyAccessPane.this.tfName.getText()}), StringResources.NOVELL_GROUPWISE, 2);
                }
                if (ProxyAccessPane.this.defaultButton != null) {
                    ProxyAccessPane.this.getRootPane().setDefaultButton(ProxyAccessPane.this.defaultButton);
                }
            }
        });
    }

    private JRootPane getRootPane(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window instanceof JDialog) {
            return ((JDialog)window).getRootPane();
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        throw new IllegalStateException();
    }

    private void processItemSelection() {
        int n = this.tableAccessList.getSelectedRow();
        if (n != -1) {
            ProxyAccessEntry proxyAccessEntry = this.model.getProxyAccessEntry(n);
            this.pnlAccessRights.setBorder(BorderFactory.createTitledBorder(StringResources.formatString(StringResources.ACCESS_RIGHTS_FOR, new String[]{proxyAccessEntry.getDisplayName()})));
            this.cbMailReadAccess.setSelected(proxyAccessEntry.mail.hasReadAccess());
            this.cbMailWriteAccess.setSelected(proxyAccessEntry.mail.hasWriteAccess());
            this.cbAppointmentReadAccess.setSelected(proxyAccessEntry.appt.hasReadAccess());
            this.cbAppointmentWriteAccess.setSelected(proxyAccessEntry.appt.hasWriteAccess());
            this.cbNotesReadAccess.setSelected(proxyAccessEntry.note.hasReadAccess());
            this.cbNotesWriteAccess.setSelected(proxyAccessEntry.note.hasWriteAccess());
            this.cbTaskReadAccess.setSelected(proxyAccessEntry.todo.hasReadAccess());
            this.cbTaskWriteAccess.setSelected(proxyAccessEntry.todo.hasWriteAccess());
            this.cbModifyOptionsRulesFolders.setSelected(proxyAccessEntry.misc.hasModifySettings());
            this.cbReadItemsMarkedPrivate.setSelected(proxyAccessEntry.misc.hasReadPrivate());
            this.cbSubscribeToMyAlarm.setSelected(proxyAccessEntry.misc.hasSubscribeAlarms());
            this.cbSubscribeToMyNotifications.setSelected(proxyAccessEntry.misc.hasSubscribeNotify());
            this.btnRemoveUser.setEnabled(this.tableAccessList.getSelectedRow() != 0);
        }
    }

    private ProxyAccessEntry getSelectedAccessEntry() {
        int n = this.tableAccessList.getSelectedRow();
        ProxyAccessEntry proxyAccessEntry = this.model.getProxyAccessEntry(n);
        return proxyAccessEntry;
    }

    public void saveChanges() {
        this.model.saveChanges();
    }

    private void buildUI() {
        JPanel jPanel = this.buildNamePanel();
        OrientablePanel orientablePanel = new OrientablePanel(new GridLayout(2, 1, 0, 5));
        orientablePanel.add(this.btnAddUser);
        orientablePanel.add(this.btnRemoveUser);
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        orientablePanel2.add((Component)jPanel, "Center");
        orientablePanel2.add((Component)orientablePanel, "After");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)orientablePanel2, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)new JLabel(StringResources.ACCESS_LIST_C), gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        ColoredScrollPane coloredScrollPane = new ColoredScrollPane(this.tableAccessList);
        coloredScrollPane.setPreferredSize(new Dimension(200, 200));
        coloredScrollPane.setMinimumSize(new Dimension(100, 100));
        this.add((Component)coloredScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        this.pnlAccessRights = this.buildAccessRightsPane();
        this.add((Component)this.pnlAccessRights, gridBagConstraints);
    }

    private JPanel buildNamePanel() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 21;
        orientablePanel.add((Component)new JLabel(StringResources.NAME_C), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        orientablePanel.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        this.btnViewAddressBook.setPreferredSize(new Dimension(23, 23));
        orientablePanel.add((Component)this.btnViewAddressBook, gridBagConstraints);
        return orientablePanel;
    }

    private JPanel buildAccessRightsPane() {
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridy = 0;
        orientablePanel.add((Component)new JLabel(StringResources.MAIL_PHONE_C), gridBagConstraints);
        orientablePanel.add((Component)this.cbMailReadAccess, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.cbMailWriteAccess, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)new JLabel(StringResources.APPOINTMENTS_C), gridBagConstraints);
        orientablePanel.add((Component)this.cbAppointmentReadAccess, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.cbAppointmentWriteAccess, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)new JLabel(StringResources.REMINDER_NOTES_C), gridBagConstraints);
        orientablePanel.add((Component)this.cbNotesReadAccess, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.cbNotesWriteAccess, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        orientablePanel.add((Component)new JLabel(StringResources.TASKS_C), gridBagConstraints);
        orientablePanel.add((Component)this.cbTaskReadAccess, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.cbTaskWriteAccess, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        ++gridBagConstraints.gridy;
        orientablePanel.add((Component)this.cbModifyOptionsRulesFolders, gridBagConstraints);
        ++gridBagConstraints.gridy;
        orientablePanel.add((Component)this.cbReadItemsMarkedPrivate, gridBagConstraints);
        return orientablePanel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RemoveUserAction
    extends AbstractAction {
        public RemoveUserAction() {
            super(StringResources.REMOVE_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ProxyAccessPane.this.tableAccessList.getSelectedRow();
            ProxyAccessPane.this.model.removeContact(n);
        }
    }

    private class AddUserAction
    extends AbstractAction {
        public AddUserAction() {
            super(StringResources.ADD_USER);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProxyAccessPane.this.tfName.updateListener();
        }
    }

    private class ViewABAction
    extends AbstractAction {
        public ViewABAction() {
            super("", ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OptionsFrame optionsFrame = (OptionsFrame)ControlsUtils.getWindowForComponent(ProxyAccessPane.this);
            AddressSelectorDialog addressSelectorDialog = new AddressSelectorDialog((JDialog)optionsFrame, optionsFrame.getController());
            addressSelectorDialog.showMe();
            if (addressSelectorDialog.isActionCompleteSuccessfully() && addressSelectorDialog.getSelectedContacts().size() > 0) {
                List list = addressSelectorDialog.getSelectedContacts();
                ProxyAccessPane.this.model.addContacts(list);
                Addressable addressable = (Addressable)list.get(0);
                int n = ProxyAccessPane.this.model.indexOf(addressable);
                if (n > 0) {
                    ProxyAccessPane.this.tableAccessList.setRowSelectionInterval(n, n);
                }
            }
        }
    }
}

