/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.frames.options.compose.FileChooserPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.Signature;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.text.DefaultStyledDocument;

public class SignatureAddPromtDialog
extends BasicDialog {
    private JCheckBox cbAddSignature;
    private JCheckBox cbAddVcard;
    private HTMLTextPane taSignature;
    private JButton btnAdd;
    private JButton btnDontAdd;
    private JButton btnCancel;
    private FileChooserPanel fileVcardChooser;
    private int result = -1;
    public static final int ADD_SIGNATURE = 0;
    public static final int DONT_ADD_SIGNATURE = 1;
    public static final int ACTION_CANCELED = 2;

    public static Result showDialog(Component component) {
        Window window = ControlsUtils.getWindowForComponent(component);
        SignatureAddPromtDialog signatureAddPromtDialog = new SignatureAddPromtDialog((ApplicationFrame)component);
        signatureAddPromtDialog.setModal(true);
        UIUtils.centerWindowOnScreen(signatureAddPromtDialog);
        signatureAddPromtDialog.pack();
        signatureAddPromtDialog.setVisible(true);
        return new Result(signatureAddPromtDialog.result, signatureAddPromtDialog.taSignature.getPlainText(), signatureAddPromtDialog.fileVcardChooser.getText());
    }

    private SignatureAddPromtDialog() throws HeadlessException {
        this.buildUI();
    }

    private SignatureAddPromtDialog(ApplicationFrame applicationFrame) throws HeadlessException {
        super(applicationFrame);
        this.buildUI();
    }

    private SignatureAddPromtDialog(Dialog dialog) throws HeadlessException {
        super(dialog);
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.SIGNATURE);
        ClickAction clickAction = new ClickAction();
        this.cbAddSignature = new JMnemonicCheckBox(StringResources.ADD_SIGNATURE);
        this.cbAddVcard = new JMnemonicCheckBox(StringResources.ATTACH_VCARD);
        this.taSignature = new ViewHTMLTextPane();
        this.taSignature.setMode(2);
        this.taSignature.setDocument(new DefaultStyledDocument());
        Font font = this.taSignature.getFont();
        this.taSignature.setFont(new Font(PLAFChanger.getFontName(), font.getStyle(), font.getSize()));
        this.btnAdd = new JMnemonicButton(new AddAction());
        this.btnDontAdd = new JMnemonicButton(new DontAddAction());
        this.btnCancel = new OrientableButton(new CancelAction());
        this.fileVcardChooser = new FileChooserPanel(StringResources.LEAVE_EMPTY_TO_USE_ADDRESS_BOOK, "", 0, true);
        this.cbAddSignature.addActionListener(clickAction);
        this.cbAddVcard.addActionListener(clickAction);
        this.btnAdd.setEnabled(false);
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 7, 0);
        orientablePanel.add((Component)this.cbAddSignature, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taSignature);
        orientableScrollPane.setPreferredSize(new Dimension(orientableScrollPane.getPreferredSize().width, 200));
        orientablePanel.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        orientablePanel.add((Component)this.cbAddVcard, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 3;
        orientablePanel.add((Component)this.fileVcardChooser, gridBagConstraints);
        gridBagConstraints.anchor = 22;
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)this.createButtonPanel(), gridBagConstraints);
        orientablePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(orientablePanel);
        this.setDefaultButton(this.btnAdd);
        this.setCancelButton(this.btnCancel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SignatureAddPromtDialog.this.result = 2;
            }
        });
        this.readOptions();
    }

    private JComponent createButtonPanel() {
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        orientablePanel.add((Component)this.btnAdd, gridBagConstraints);
        orientablePanel.add((Component)this.btnDontAdd, gridBagConstraints);
        orientablePanel.add((Component)this.btnCancel, gridBagConstraints);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        orientablePanel.add((Component)new JPanel(), gridBagConstraints);
        return orientablePanel;
    }

    private void readOptions() {
        String string = ((ApplicationFrame)this.getParent()).getUserGuid();
        Signature signature = OptionManager.getInstance().getSignature(string);
        if (signature != null) {
            this.cbAddSignature.setSelected(signature.isUsedSignature());
            this.cbAddVcard.setSelected(signature.isUsedCard());
            this.btnAdd.setEnabled(signature.isUsedSignature() || signature.isUsedCard());
            this.taSignature.setPlainText(signature.getSignatureText());
            this.taSignature.setCaretPosition(0);
            this.fileVcardChooser.setEnabled(signature.isUsedCard());
            this.fileVcardChooser.setText(signature.getCardFileName());
        }
    }

    private void processAddAnswer() {
        int n;
        String string;
        if (this.cbAddVcard.isSelected() && (string = this.fileVcardChooser.getText()) != null && !"".equals(string) && !new File(string).exists() && (n = JOptionPane.showConfirmDialog(this, StringResources.formatString(StringResources.NO_SUCH_VCF_FILE, new String[]{string}), StringResources.ERROR, 0, 0)) != 0) {
            return;
        }
        this.result = 0;
        this.setVisible(false);
    }

    private class ClickAction
    extends AbstractAction {
        private ClickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignatureAddPromtDialog.this.taSignature.setEnabled(SignatureAddPromtDialog.this.cbAddSignature.isSelected());
            SignatureAddPromtDialog.this.fileVcardChooser.setEnabled(SignatureAddPromtDialog.this.cbAddVcard.isSelected());
            SignatureAddPromtDialog.this.btnAdd.setEnabled(SignatureAddPromtDialog.this.cbAddSignature.isSelected() || SignatureAddPromtDialog.this.cbAddVcard.isSelected());
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignatureAddPromtDialog.this.result = 2;
            SignatureAddPromtDialog.this.setVisible(false);
        }
    }

    private class DontAddAction
    extends AbstractAction {
        public DontAddAction() {
            super(StringResources.DONT_ADD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignatureAddPromtDialog.this.result = 1;
            SignatureAddPromtDialog.this.setVisible(false);
        }
    }

    private class AddAction
    extends AbstractAction {
        public AddAction() {
            super(StringResources.ADD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignatureAddPromtDialog.this.processAddAnswer();
        }
    }

    public static class Result {
        private int resID;
        private String signature;
        private String vCardPath;

        public Result(int n, String string, String string2) {
            if (n < 0 || n > 2) {
                throw new IllegalArgumentException();
            }
            this.resID = n;
            this.signature = string;
            this.vCardPath = string2;
        }

        public int getResultID() {
            return this.resID;
        }

        public String getSignature() {
            return this.signature;
        }

        public String getVCardPath() {
            return this.vCardPath;
        }
    }
}

