/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.compose.send;

import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.ViewHTMLTextPane;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.frames.options.compose.AbstractOptionPanel;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.frames.options.compose.FileChooserPanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.AbstractCloneObject;
import com.novell.gw.jclient.bl.om.options.SendOptions;
import com.novell.gw.jclient.bl.om.options.Signature;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultStyledDocument;
import org.apache.log4j.Logger;

class SignaturePanel
extends AbstractOptionPanel {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$frames$options$compose$send$SignaturePanel == null ? (class$com$novell$gw$jclient$application$frames$options$compose$send$SignaturePanel = SignaturePanel.class$("com.novell.gw.jclient.application.frames.options.compose.send.SignaturePanel")) : class$com$novell$gw$jclient$application$frames$options$compose$send$SignaturePanel));
    private JCheckBox cbAddSign;
    private JCheckBox cbAddVCard;
    private JRadioButton rbAuto;
    private JRadioButton rbPrompt;
    private FileChooserPanel cardChooserPanel;
    private HTMLTextPane taSignature;
    private boolean taSignatureListenerEnabled = true;
    private SendOptions sendOptions;
    private ButtonGroup buttonGroup;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$frames$options$compose$send$SignaturePanel;

    public SignaturePanel(ChangesListener changesListener, MVCController mVCController, String string) {
        super(changesListener, mVCController);
        this.userGuid = string;
    }

    public void build() {
        this.cbAddSign = new JMnemonicCheckBox(new SignatureClickAction());
        this.cbAddVCard = new JMnemonicCheckBox(new VCardClickAction());
        this.rbAuto = new JMnemonicRadioButton(StringResources.AUTOMATICALLY_ADD);
        this.rbPrompt = new JMnemonicRadioButton(StringResources.PROMPT_BEFORE_ADDING);
        RBClickListener rBClickListener = new RBClickListener();
        this.rbAuto.addActionListener(rBClickListener);
        this.rbPrompt.addActionListener(rBClickListener);
        this.taSignature = new ViewHTMLTextPane();
        this.taSignature.setMode(2);
        this.taSignature.setIgnoreDefaultFontAttributes(true);
        this.taSignature.setDocument(new DefaultStyledDocument());
        Font font = this.taSignature.getFont();
        this.taSignature.setFont(new Font(PLAFChanger.getFontName(), font.getStyle(), font.getSize()));
        this.taSignature.getDocument().addDocumentListener(new SignatureDocumentListener());
        this.cardChooserPanel = new FileChooserPanel(StringResources.LEAVE_EMPTY_TO_USE_ADDRESS_BOOK, "", 0, 7, true);
        this.cardChooserPanel.setFilter(StringResources.VCARDS + " (*.vcf)", new String[]{"vcf"});
        this.rbPrompt.setSelected(true);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.rbAuto);
        this.buttonGroup.add(this.rbPrompt);
        this.updateOnSignatureEnablity(false);
        this.updateOnVCardEnablity(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.createSignatureLabel(), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.cbAddSign, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taSignature);
        orientableScrollPane.setMinimumSize(new Dimension(320, 200));
        orientableScrollPane.setPreferredSize(new Dimension(320, 200));
        this.add((Component)orientableScrollPane, gridBagConstraints);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.rbAuto, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.rbPrompt, gridBagConstraints);
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.cbAddVCard, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.cardChooserPanel, gridBagConstraints);
    }

    private JLabel createSignatureLabel() {
        String string = "align=";
        string = UIUtils.getComponentOrientation().isLeftToRight() ? string + "left" : string + "right";
        JLabel jLabel = new JLabel("<html><p " + string + ">" + StringResources.ADD_YOUR_SIGNATURE_AND_OR_VCARD + "</p></html>");
        jLabel.setComponentOrientation(UIUtils.getComponentOrientation());
        return jLabel;
    }

    public void collectValues() {
        Signature signature = OptionManager.getInstance().getSignature(this.userGuid);
        signature.setUseSignature(this.cbAddSign.isSelected());
        signature.setUseECard(this.cbAddVCard.isSelected());
        signature.setSignatureText(this.taSignature.getPlainText());
        signature.setCardFileName(this.cardChooserPanel.getText());
        signature.setPromptOnAdd(this.rbPrompt.isSelected());
        OptionManager.getInstance().setSignature(signature, this.userGuid);
    }

    public void fireOptionsChanged() {
        Signature signature = OptionManager.getInstance().getSignature(this.userGuid);
        this.cbAddSign.setSelected(signature.isUsedSignature());
        this.rbAuto.setEnabled(signature.isUsedSignature() || signature.isUsedCard());
        this.rbPrompt.setEnabled(signature.isUsedSignature() || signature.isUsedCard());
        this.taSignatureListenerEnabled = false;
        this.taSignature.setPlainText(signature.getSignatureText());
        this.taSignature.setEnabled(signature.isUsedSignature());
        this.taSignatureListenerEnabled = true;
        this.rbAuto.setSelected(!signature.isPromptOnAdd());
        this.rbPrompt.setSelected(signature.isPromptOnAdd());
        this.cbAddVCard.setSelected(signature.isUsedCard());
        this.cardChooserPanel.setText(signature.getCardFileName());
        this.cardChooserPanel.setEnabled(signature.isUsedCard());
        if (this.changesListener != null) {
            this.changesListener.setValueSaved();
        }
    }

    public void setOptions(AbstractCloneObject abstractCloneObject) throws IllegalArgumentException {
        if (!(abstractCloneObject instanceof SendOptions)) {
            logger.debug((Object)("Illegal class " + abstractCloneObject == null ? "null" : abstractCloneObject.getClass().getName()));
            throw new IllegalArgumentException();
        }
        this.sendOptions = (SendOptions)abstractCloneObject;
        this.fireOptionsChanged();
    }

    public Insets getInsets() {
        return new Insets(10, 10, 10, 10);
    }

    private void dataChanged() {
        if (this.changesListener != null) {
            this.changesListener.setValueChanged();
        }
    }

    private void updateOnSignatureEnablity(boolean bl) {
        this.taSignature.setEnabled(bl);
        boolean bl2 = bl || this.cbAddVCard.isSelected();
        this.rbAuto.setEnabled(bl2);
        this.rbPrompt.setEnabled(bl2);
    }

    private void updateOnVCardEnablity(boolean bl) {
        this.cardChooserPanel.setEnabled(bl);
        boolean bl2 = bl || this.cbAddSign.isSelected();
        this.rbAuto.setEnabled(bl2);
        this.rbPrompt.setEnabled(bl2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RBClickListener
    implements ActionListener {
        private RBClickListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignaturePanel.this.dataChanged();
        }
    }

    private class SignatureDocumentListener
    implements DocumentListener {
        private SignatureDocumentListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (SignaturePanel.this.taSignatureListenerEnabled) {
                SignaturePanel.this.dataChanged();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (SignaturePanel.this.taSignatureListenerEnabled) {
                SignaturePanel.this.dataChanged();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class VCardClickAction
    extends AbstractAction {
        public VCardClickAction() {
            super(StringResources.ELECTRONIC_BUSINESS_CARD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignaturePanel signaturePanel = SignaturePanel.this;
            signaturePanel.updateOnVCardEnablity(signaturePanel.cbAddVCard.isSelected());
            signaturePanel.dataChanged();
        }
    }

    private class SignatureClickAction
    extends AbstractAction {
        public SignatureClickAction() {
            super(StringResources.SIGNATURE);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SignaturePanel signaturePanel = SignaturePanel.this;
            signaturePanel.updateOnSignatureEnablity(signaturePanel.cbAddSign.isSelected());
            signaturePanel.dataChanged();
        }
    }
}

