/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.frames.options.pageselector;

import com.appframework.components.customizedbutton.ToolBarToggleButton;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.frames.options.pageselector.OptionsPageSelectorController;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class OptionsPageSelector
extends GWToolBar
implements MVCView {
    private static HashMap icons = new HashMap();
    private MVCController controller;
    private HashMap mapNames;
    private HashMap mapButtons;
    private String selectedButtonID;

    public OptionsPageSelector(HashMap hashMap, MVCController mVCController) {
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        this.mapNames = hashMap;
        this.controller = new OptionsPageSelectorController(this, mVCController);
        this.build();
    }

    private void build() {
        this.createButtons();
        this.setLayout(new BorderLayout());
        OrientablePanel orientablePanel = new OrientablePanel(new GridBagLayout());
        this.add((Component)orientablePanel, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 7, 7, 7);
        Object[] objectArray = this.mapNames.keySet().toArray();
        for (int i = 0; i < this.mapNames.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)this.mapButtons.get(objectArray[i]);
            ++gridBagConstraints.gridy;
            if (i == this.mapNames.size() - 1) {
                gridBagConstraints.weighty = 1.0;
            }
            orientablePanel.add((Component)abstractButton, gridBagConstraints);
        }
    }

    private void setBorder() {
        MatteBorder matteBorder = UIUtils.getComponentOrientation().isLeftToRight() ? BorderFactory.createMatteBorder(0, 0, 0, 1, Color.gray) : BorderFactory.createMatteBorder(0, 1, 0, 0, Color.gray);
        this.setBorder(matteBorder);
    }

    public void setSelectedOption(String string) {
        if (this.selectedButtonID != null && this.selectedButtonID.equals(string)) {
            return;
        }
        ((AbstractButton)this.mapButtons.get(string)).setSelected(true);
        this.selectedButtonID = string;
    }

    public void setController(MVCController mVCController) {
        this.controller = mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof String) {
            // empty if block
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void createButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this.mapButtons = new HashMap();
        Object[] objectArray = this.mapNames.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            ToolBarToggleButton toolBarToggleButton = new ToolBarToggleButton(new ActionShowOptionPane(this.mapNames.get(object).toString(), (Icon)icons.get(object), object.toString()));
            toolBarToggleButton.setHorizontalAlignment(10);
            buttonGroup.add(toolBarToggleButton);
            this.mapButtons.put(object, toolBarToggleButton);
        }
    }

    static {
        icons.put("General", ImageResources.OPTIONS_GENERAL);
        icons.put("Send", ImageResources.ICON_ACT_SEND);
        icons.put("Security", ImageResources.ICON_LOCK);
        icons.put("Printing", ImageResources.ACT_PRINT);
    }

    private class ActionShowOptionPane
    extends AbstractAction {
        private String optionID;

        public ActionShowOptionPane(String string, Icon icon, String string2) {
            super(string, icon);
            this.optionID = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.optionID.equals(OptionsPageSelector.this.selectedButtonID)) {
                OptionsPageSelector.this.getController().processCommand(new Command(120, this.optionID));
                OptionsPageSelector.this.selectedButtonID = this.optionID;
            }
        }
    }
}

