/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.options;

import com.appframework.utils.Assertions;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.Engine;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.frames.options.compose.country.Language;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.bl.om.options.EnvironmentOptions;
import com.novell.gw.jclient.bl.om.options.GWTimeZoneOptions;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import com.novell.gw.jclient.bl.om.options.InterfaceFontOptions;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import com.novell.gw.jclient.bl.om.options.LoginOptions;
import com.novell.gw.jclient.bl.om.options.Options;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import com.novell.gw.jclient.bl.om.options.SendOptions;
import com.novell.gw.jclient.bl.om.options.Signature;
import com.novell.gw.jclient.bl.om.options.properties.AlarmOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.EnvironmentOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.GeneralOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.InterfaceFontOptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.OptionsProperties;
import com.novell.gw.jclient.bl.om.options.properties.PrintingOptionsProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.log4j.Logger;

public class OptionManager {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$options$OptionManager == null ? (class$com$novell$gw$jclient$application$options$OptionManager = OptionManager.class$("com.novell.gw.jclient.application.options.OptionManager")) : class$com$novell$gw$jclient$application$options$OptionManager));
    private static OptionManager instance;
    private static final String FILE_GENERAL_OPTIONS = "general.properties";
    private static final String FILE_PRINTING_OPTIONS = "printing.properties";
    private static final String FILE_ENVIRONMENT_OPTIONS = "environment.properties";
    private static final String FILE_ALARM_OPTIONS = "alarm.properties";
    private static final String FILE_INTERFACE_FONT_OPTIONS = "interface_font.properties";
    private final HashMap optionsHash = new HashMap();
    private final HashMap filesMap = new HashMap();
    private final HashMap propertiesMap = new HashMap();
    private MachineSettings machineSettings;
    private MachineSettings.TextOption textOption = null;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$options$OptionManager;

    public static synchronized OptionManager getInstance() {
        if (instance == null) {
            instance = new OptionManager();
        }
        return instance;
    }

    public static synchronized void freeInstance() {
        instance = null;
    }

    public OptionManager() {
        this.filesMap.put("General options", FILE_GENERAL_OPTIONS);
        this.filesMap.put("Printing options", FILE_PRINTING_OPTIONS);
        this.filesMap.put("Environment options", FILE_ENVIRONMENT_OPTIONS);
        this.filesMap.put("Alarm options", FILE_ALARM_OPTIONS);
        this.filesMap.put("Interface Font options", FILE_INTERFACE_FONT_OPTIONS);
        this.propertiesMap.put("General options", new GeneralOptionsProperties());
        this.propertiesMap.put("Environment options", new EnvironmentOptionsProperties());
        this.propertiesMap.put("Printing options", new PrintingOptionsProperties());
        this.propertiesMap.put("Alarm options", new AlarmOptionsProperties());
        this.propertiesMap.put("Interface Font options", new InterfaceFontOptionsProperties());
    }

    public LoginOptions getLoginOptions() {
        LoginOptions loginOptions = (LoginOptions)this.optionsHash.get("Login options");
        if (loginOptions == null) {
            loginOptions = new LoginOptions();
            this.setLoginOptions(loginOptions);
        }
        return loginOptions;
    }

    public void setLoginOptions(LoginOptions loginOptions) {
        if (loginOptions != null) {
            this.optionsHash.put(loginOptions.getID(), loginOptions);
        }
    }

    public GeneralOptions getGeneralOptions() {
        GeneralOptions generalOptions;
        try {
            boolean bl = this.optionsHash.get("General options") == null;
            generalOptions = (GeneralOptions)this.getOptions("General options");
            if (bl) {
                this.readLocale(generalOptions);
            }
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
            generalOptions = new GeneralOptions();
            this.setOptions(generalOptions);
        }
        return generalOptions;
    }

    public String getArchiveDir(String string) {
        String string2 = GWCommandManager.getInstance(string).getArchiveLocation();
        this.getGeneralOptions().setArchiveDir(string2);
        return string2;
    }

    public void setArchiveDir(String string, String string2) {
        this.getGeneralOptions().setArchiveDir(string);
        GWCommandManager.getInstance(string2).setArchiveLocation(string);
    }

    private void readLocale(GeneralOptions generalOptions) {
        EngineLocale engineLocale;
        try {
            engineLocale = EngineLocale.getAvailableLocales();
            if (engineLocale != null && ((EngineLocale[])engineLocale).length > 0) {
                Language[] languageArray = new Language[((EngineLocale[])engineLocale).length];
                for (int i = 0; i < ((EngineLocale)engineLocale).length; ++i) {
                    languageArray[i] = new Language(engineLocale[i].getCode(), engineLocale[i].getDisplayName());
                }
                generalOptions.setAvailableLanguages(languageArray);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        try {
            engineLocale = this.getMachineSettings().getInterfaceLanguage();
            generalOptions.setInterfaceLanguage(new Language(engineLocale.getCode(), engineLocale.getDisplayName()));
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
    }

    public void setGeneralOptions(GeneralOptions generalOptions) {
        String string;
        EngineLocale engineLocale;
        this.setOptions(generalOptions);
        if (generalOptions.getInterfaceLanguage() != null && (engineLocale = EngineLocale.getLocale((String)(string = generalOptions.getInterfaceLanguage().getCode()))) != null && engineLocale.getCode() != EngineLocale.getCurrent().getCode()) {
            this.getMachineSettings().setInterfaceLanguage(engineLocale);
        }
    }

    public PrintingOptions getPrintingOptions() {
        PrintingOptions printingOptions;
        try {
            printingOptions = (PrintingOptions)this.getOptions("Printing options");
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
            printingOptions = new PrintingOptions();
            this.setOptions(printingOptions);
        }
        return printingOptions;
    }

    public void setPrintingOptions(PrintingOptions printingOptions) {
        this.setOptions(printingOptions);
    }

    public SendOptions getSendOptions(String string) {
        boolean bl;
        SendOptions sendOptions = (SendOptions)this.optionsHash.get("Send options");
        boolean bl2 = bl = sendOptions == null;
        if (bl) {
            sendOptions = new SendOptions();
            this.setSendOptions(sendOptions, string);
            this.readServerSendOptions(sendOptions, string);
            bl = false;
        }
        return sendOptions;
    }

    private void readServerSendOptions(SendOptions sendOptions, String string) {
        ItemSendOptions itemSendOptions = null;
        try {
            itemSendOptions = GWCommandManager.getInstance(string).getItemSendOptions();
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
        }
        sendOptions.setItemSendOptions(itemSendOptions == null ? new ItemSendOptions() : itemSendOptions);
    }

    public Signature getSignature(String string) {
        Signature signature = null;
        try {
            signature = GWCommandManager.getInstance(string).getSignature();
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
        }
        this.getSendOptions(string).setSignature(signature);
        return signature;
    }

    public void setSignature(Signature signature, String string) {
        if (signature != null) {
            try {
                this.getSendOptions(string).setSignature(signature);
                GWCommandManager.getInstance(string).modifySignature(this.getSendOptions(string).getSignature());
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException, (Throwable)gWCommandException);
            }
        }
    }

    public void setSendOptions(SendOptions sendOptions, String string) {
        if (sendOptions == null) {
            return;
        }
        this.optionsHash.put(sendOptions.getID(), sendOptions);
        if (sendOptions.getItemSendOptions() != null) {
            try {
                GWCommandManager.getInstance(string).modifyItemSendOptions(sendOptions.getItemSendOptions());
            }
            catch (GWCommandException gWCommandException) {
                logger.error((Object)gWCommandException, (Throwable)gWCommandException);
            }
        }
    }

    public InterfaceFontOptions getInterfaceFontOptions() {
        InterfaceFontOptions interfaceFontOptions;
        try {
            interfaceFontOptions = (InterfaceFontOptions)this.getOptions("Interface Font options");
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
            interfaceFontOptions = new InterfaceFontOptions();
            this.setOptions(interfaceFontOptions);
        }
        return interfaceFontOptions;
    }

    public DateTimeOptions getDateTimeOptions() {
        DateTimeOptions dateTimeOptions;
        Object v = this.optionsHash.get("Date & Time options");
        if (v == null) {
            dateTimeOptions = new DateTimeOptions();
            this.optionsHash.put("Date & Time options", dateTimeOptions);
        } else {
            dateTimeOptions = (DateTimeOptions)v;
        }
        dateTimeOptions = new DateTimeOptions();
        dateTimeOptions.setTimeZoneOptions(new GWTimeZoneOptions());
        this.setDateTimeOptions(dateTimeOptions);
        return dateTimeOptions;
    }

    public void setDateTimeOptions(DateTimeOptions dateTimeOptions) {
        if (dateTimeOptions == null) {
            return;
        }
        this.optionsHash.put("Date & Time options", dateTimeOptions);
    }

    public EnvironmentOptions getEnvironmentOptions() {
        EnvironmentOptions environmentOptions;
        try {
            environmentOptions = (EnvironmentOptions)this.getOptions("Environment options");
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException);
            environmentOptions = new EnvironmentOptions();
            this.setOptions(environmentOptions);
        }
        return environmentOptions;
    }

    public void setEnvironmentOptions(EnvironmentOptions environmentOptions) {
        this.setOptions(environmentOptions);
    }

    void setOptionsToNull() {
        this.optionsHash.clear();
    }

    private Options getOptions(String string) throws GWCommandException {
        Options options = (Options)this.optionsHash.get(string);
        if (options == null) {
            options = this.readOptions(string);
            this.optionsHash.put(string, options);
        }
        return options;
    }

    private void setOptions(Options options) {
        if (options == null) {
            return;
        }
        this.optionsHash.put(options.getID(), options);
        try {
            this.writeOptions(options);
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            logger.debug((Object)exception, (Throwable)exception);
        }
    }

    public void clearOptions() {
        OptionManager.getInstance().optionsHash.clear();
    }

    public String getCachingPath() {
        return this.getMachineSettings().getPathToCache();
    }

    public void setCashingPath(String string) {
        this.getMachineSettings().setPathToCache(string);
    }

    public MachineSettings getMachineSettings() {
        if (this.machineSettings == null) {
            Engine.getInstance();
            this.machineSettings = new MachineSettings();
        }
        return this.machineSettings;
    }

    public MachineSettings.TextOption getTextOption() {
        if (this.textOption == null) {
            DataStore dataStore = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
            this.textOption = this.getMachineSettings().getTextOption(dataStore);
        }
        return this.textOption;
    }

    public boolean setTextOption(Boolean bl, Boolean bl2, Boolean bl3, String string, Integer n, String string2, Integer n2, String string3, Integer n3) {
        DataStore dataStore = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore();
        boolean bl4 = this.getMachineSettings().setTextOption(dataStore, bl, bl2, bl3, string, n, string2, n2, string3, n3);
        this.textOption = null;
        return bl4;
    }

    public synchronized Options readOptions(String string) throws GWCommandException {
        if (!this.filesMap.keySet().contains(string)) {
            Assertions.assertIllegalArgument("Option [" + string + "] is not supported");
        }
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(this.createOptionsFile(string));
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
            throw new GWCommandException("Error while reading file :", iOException);
        }
        return this.getOptionsProperties(string).readOptions(properties);
    }

    public synchronized void writeOptions(Options options) throws GWCommandException {
        Assertions.assertNotNull(options, "Can not write NULL options object");
        String string = options.getID();
        Properties properties = this.getOptionsProperties(string).createProperties(options);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.createOptionsFile(string));
            properties.store(fileOutputStream, string);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException, (Throwable)iOException);
            throw new GWCommandException("Failed to write options '" + string + "' :", iOException);
        }
        catch (Exception exception) {
            logger.error((Object)"Internal error occured while writing properties to the file.");
            logger.error((Object)exception, (Throwable)exception);
        }
    }

    private OptionsProperties getOptionsProperties(String string) throws GWCommandException {
        OptionsProperties optionsProperties = (OptionsProperties)this.propertiesMap.get(string);
        if (optionsProperties == null) {
            throw new GWCommandException("There is no appropriate properties handler for options [" + string + "]");
        }
        return optionsProperties;
    }

    private String getOptionFilePath(String string) {
        String string2 = PathManager.getInstance().getUserOptionsPath();
        if ("Login options".equals(string)) {
            string2 = PathManager.getInstance().getBaseOptionsPath();
        } else if ("Interface Font options".equals(string)) {
            string2 = PathManager.getInstance().getBaseOptionsPath();
        }
        string2 = string2 + this.filesMap.get(string);
        return string2;
    }

    private File createOptionsFile(String string) throws IOException {
        File file = new File(this.getOptionFilePath(string));
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

