/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.basicforms;

import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.components.htmleditor.PrintHTMLTextPane;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.printing.basicforms.PrintForm;
import com.novell.gw.jclient.application.printing.printingitem.ItemChecksPanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.store.GWItemFormatSerializer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.apache.log4j.Logger;

public class HTMLPrintForm
extends PrintForm {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$basicforms$HTMLPrintForm == null ? (class$com$novell$gw$jclient$application$printing$basicforms$HTMLPrintForm = HTMLPrintForm.class$("com.novell.gw.jclient.application.printing.basicforms.HTMLPrintForm")) : class$com$novell$gw$jclient$application$printing$basicforms$HTMLPrintForm));
    private final Font fontHeader = new Font(PLAFChanger.getFontName(), 0, 8);
    protected static final String BODY_TAG = "<body";
    protected static final String START_HEADER = "<!-- START ITEM HEADER -->";
    protected static final String END_HEADER = "<!-- END ITEM HEADER -->";
    protected ItemChecksPanel itemChecksPanel;
    private static double scale = OS.isMacOS() ? 1.0 : 0.7;
    private JHFrame frame = new JHFrame();
    protected HTMLTextPane editor = new PrintHTMLTextPane();
    private Vector transforms;
    private double imgX;
    private double imgY;
    protected AbstractItem item;
    private String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$basicforms$HTMLPrintForm;

    public HTMLPrintForm(URL uRL, ItemChecksPanel itemChecksPanel, String string) {
        this.itemChecksPanel = itemChecksPanel;
        this.userGuid = string;
        this.editor.setEditable(false);
        this.editor.setMode(1);
        this.editor.setIgnoreDefaultFontAttributes(true);
        this.frame.getContentPane().add(this.editor);
        this.setPage(uRL);
    }

    public HTMLPrintForm(AbstractItem abstractItem, ItemChecksPanel itemChecksPanel, String string) {
        this((URL)null, itemChecksPanel, string);
        this.item = abstractItem;
    }

    protected HTMLPrintForm(String string, ItemChecksPanel itemChecksPanel, String string2) {
        this.itemChecksPanel = itemChecksPanel;
        this.userGuid = string2;
        this.editor.setEditable(false);
        this.editor.setMode(2);
        this.editor.setPlainText(string);
        this.editor.setIgnoreDefaultFontAttributes(true);
        this.frame.getContentPane().add(this.editor);
    }

    protected void setPage(URL uRL) {
        if (uRL == null) {
            return;
        }
        try {
            this.editor.setPage(uRL);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
            logger.debug((Object)iOException, (Throwable)iOException);
        }
        this.editor.setMode(1);
        this.editor.updateUI();
        this.editor.repaint();
    }

    public Vector createTransforms(JEditorPane jEditorPane) {
        double d;
        int n = 0;
        double d2 = 0.0;
        double d3 = scale;
        Vector<PageTransform> vector = new Vector<PageTransform>();
        View view = jEditorPane.getUI().getRootView(jEditorPane);
        Rectangle rectangle = this.getViewRec(view, (float)this.pageWidth / (float)d3, (float)this.pageHeight / (float)d3);
        Insets insets = jEditorPane.getInsets();
        this.frame.setBounds(0, 0, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        this.frame.setVisible(true);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.pageWidth, (double)this.pageHeight / d3);
        Position.Bias[] biasArray = new Position.Bias[1];
        do {
            double d4 = double_.getHeight() + d2;
            int n2 = view.viewToModel(0.0f, (float)d4, rectangle, biasArray);
            Shape shape = null;
            try {
                shape = view.modelToView(n2, rectangle, biasArray[0]);
            }
            catch (BadLocationException badLocationException) {
                logger.debug((Object)badLocationException);
            }
            Rectangle2D rectangle2D = shape.getBounds2D();
            double d5 = d2;
            d = rectangle2D.getY() - 1.0;
            if (d4 >= rectangle2D.getY() + rectangle2D.getHeight()) {
                d = rectangle2D.getY() + rectangle2D.getHeight() - 1.0;
            }
            double d6 = rectangle2D.getY();
            double d7 = rectangle2D.getY() + rectangle2D.getHeight() - 1.0;
            double d8 = rectangle2D.getX() + 20.0;
            Rectangle2D rectangle2D2 = rectangle2D;
            while (d8 <= (double)this.pageWidth * d3) {
                int n3 = view.viewToModel((float)d8, (float)d4, rectangle, biasArray);
                Shape shape2 = null;
                try {
                    shape2 = view.modelToView(n3, rectangle, biasArray[0]);
                }
                catch (BadLocationException badLocationException) {
                    logger.debug((Object)badLocationException);
                }
                Rectangle2D rectangle2D3 = shape2.getBounds2D();
                if (rectangle2D2.equals(rectangle2D3) || rectangle2D3.getX() < d8) {
                    d8 += 20.0;
                    continue;
                }
                double d9 = rectangle2D3.getY();
                double d10 = rectangle2D3.getY() + rectangle2D3.getHeight() - 1.0;
                if (d10 > d6) {
                    if (d10 > d7) {
                        if (d10 < d4) {
                            d = d10;
                            d7 = d10;
                            if (d9 < d6) {
                                d6 = d9;
                            }
                        } else if (d9 > d7) {
                            d = d9 - 1.0;
                            d7 = d10;
                            d6 = d9;
                        } else if (d9 < d6) {
                            d = d9 - 1.0;
                            d6 = d9;
                            d7 = d10;
                        } else {
                            d = d6 - 1.0;
                            d7 = d10;
                        }
                    } else if (d7 < d4) {
                        d = d7;
                        if (d9 < d6) {
                            d6 = d9;
                        }
                    } else if (d6 <= d9) {
                        d = d6 - 1.0;
                    } else {
                        d = d9 - 1.0;
                        d6 = d9;
                    }
                }
                rectangle2D2 = rectangle2D3;
                d8 = rectangle2D2.getX() + 20.0;
            }
            PageTransform pageTransform = new PageTransform();
            pageTransform.translate(this.imgX, this.imgY);
            pageTransform.translate(-((double)insets.left) * d3, -((double)insets.top + d5) * d3);
            pageTransform.scale(d3, d3);
            pageTransform.setHeight(d + (double)insets.top);
            vector.add(n, pageTransform);
        } while (!((d2 = d + 1.0) >= rectangle.getHeight()) && ++n <= 100);
        return vector;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Shape shape;
        Shape shape2;
        if (n == 0) {
            this.printHeader();
        }
        this.pageWidth = (int)pageFormat.getImageableWidth();
        this.pageHeight = (int)pageFormat.getImageableHeight();
        this.imgX = pageFormat.getImageableX();
        this.imgY = pageFormat.getImageableY();
        graphics.setColor(Color.black);
        this.commonHeaderH = this.getHeaderHeight(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.editor.setDropTarget(null);
        this.frame.setGraphics(graphics2D);
        if (this.transforms == null) {
            this.transforms = this.createTransforms(this.editor);
        }
        if (n >= this.transforms.size()) {
            return 1;
        }
        if (n >= 30) {
            return 1;
        }
        if (graphics2D.getClip() == null) {
            shape2 = new Rectangle2D.Double(this.imgX, this.imgY, this.pageWidth, this.pageHeight);
            graphics2D.setClip(shape2);
        }
        graphics2D.transform((AffineTransform)this.transforms.get(n));
        shape2 = graphics2D.getClip();
        Rectangle2D rectangle2D = shape2.getBounds2D();
        double d = ((PageTransform)this.transforms.get(n)).getHeight();
        double d2 = rectangle2D.getY() + rectangle2D.getHeight() - 1.0 - d;
        if (d2 > 0.0) {
            shape = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d2);
            graphics2D.clip(shape);
            Shape shape3 = graphics2D.getClip();
            rectangle2D = shape3.getBounds2D();
        }
        if (rectangle2D.getY() < d) {
            shape = graphics2D.getClip();
            rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() - (double)this.commonHeaderH, rectangle2D.getWidth(), this.commonHeaderH);
            graphics2D.setClip(rectangle2D);
            if (ApplicationOptions.getInstance().getBoolean("PRINT_HEADER", true)) {
                this.printCommonHeader(graphics2D, n, this.pageWidth, (int)rectangle2D.getX(), (int)rectangle2D.getY() + 10);
            }
        } else {
            return 1;
        }
        graphics2D.setClip(shape);
        this.editor.paint(graphics2D);
        return 0;
    }

    protected String getItemHeaders() {
        GWItemFormatSerializer gWItemFormatSerializer = new GWItemFormatSerializer(this.item);
        String string = gWItemFormatSerializer.getItemHeader(this.item, this.itemChecksPanel.isDateSelected());
        String string2 = gWItemFormatSerializer.getAdditionalItemHeader(this.item, this.itemChecksPanel.isFromSelected(), this.itemChecksPanel.isToSelected(), this.itemChecksPanel.isDateSelected(), this.itemChecksPanel.isSubjectSelected());
        return string + string2;
    }

    protected void printHeader() {
        String string = (START_HEADER + this.getItemHeaders() + END_HEADER).replaceAll("\n", "<br>");
        StringBuffer stringBuffer = new StringBuffer(this.editor.getText());
        int n = stringBuffer.indexOf(START_HEADER);
        if (n >= 0) {
            int n2 = stringBuffer.indexOf(END_HEADER);
            if (n2 > n) {
                stringBuffer.replace(n, n2 + END_HEADER.length(), string);
            }
        } else {
            int n3 = stringBuffer.indexOf(BODY_TAG);
            if (n3 >= 0) {
                stringBuffer.insert(stringBuffer.indexOf(">", n3) + 1, string);
            }
        }
        this.editor.setStyledText(stringBuffer.toString());
    }

    protected int printCommonHeader(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        graphics.setFont(Utils.deriveFontForSize(this.fontHeader, (float)((double)this.fontHeader.getSize() / scale)));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n5 += fontMetrics.getAscent();
        int n6 = (int)((double)n2 / scale);
        String string = GWCommandManager.getInstance(this.userGuid).getUserFields().getUserName();
        if (this.item != null) {
            string = string + " - " + this.item.getSubject();
        }
        String string2 = GWCalendarUtils.getDateTimeFormat().format(GWCalendarUtils.getToday().getTime());
        int n7 = SwingUtilities.computeStringWidth(fontMetrics, string2);
        String string3 = "";
        int n8 = 0;
        boolean bl = this.itemChecksPanel.isPageNumberSelected();
        if (bl) {
            string3 = StringResources.PAGE + " " + (n + 1);
            n8 = SwingUtilities.computeStringWidth(fontMetrics, string3);
        }
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            int n9 = n6 - n7 + n3;
            int n10 = n6 - n7 - 10 + n3;
            if (bl) {
                graphics.drawString(string3, n6 - n8 + n3, n5 + n4);
                n9 = n9 - n8 - 10;
                n10 = n10 - n8 - 10;
            }
            graphics.drawString(string2, n9, n5 + n4);
            graphics.drawString(UIUtils.cutStringToWidth(string, fontMetrics, n10), n3, n5 + n4);
        } else {
            int n11 = n3;
            int n12 = n6 - n3 - n7 - 10;
            if (bl) {
                graphics.drawString(string3, n3, n5 + n4);
                n11 = n11 + n8 + 10;
                n12 = n12 - n8 - 10;
            }
            graphics.drawString(string2, n11, n5 + n4);
            String string4 = UIUtils.cutStringToWidth(string, fontMetrics, n12);
            int n13 = n6 - SwingUtilities.computeStringWidth(fontMetrics, string4);
            graphics.drawString(string4, n13, n5 + n4);
        }
        graphics.drawLine(n3, n5 + n4 + 5, n3 + (int)((double)n2 / scale), n5 + n4 + 5);
        return n5;
    }

    protected int getHeaderHeight(Graphics graphics) {
        int n = 0;
        graphics.setFont(this.fontHeader);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        return n += fontMetrics.getAscent() + fontMetrics.getHeight() + 10;
    }

    public void onPrintBegin() {
        super.onPrintBegin();
        this.transforms = null;
    }

    public Rectangle getViewRec(View view, float f, float f2) {
        Rectangle rectangle = new Rectangle();
        view.setSize(f, f2);
        rectangle.width = (int)Math.max((long)Math.ceil(view.getMinimumSpan(0)), (long)f);
        rectangle.height = (int)Math.min((long)Math.ceil(view.getPreferredSpan(1)), Integer.MAX_VALUE);
        view.setSize(rectangle.width, rectangle.height);
        if (view.getView(0) instanceof BoxView) {
            BoxView boxView = (BoxView)view.getView(0);
            rectangle.width = boxView.getWidth();
            rectangle.height = boxView.getHeight();
        } else {
            rectangle.height = (int)Math.min((long)Math.ceil(view.getPreferredSpan(1)), Integer.MAX_VALUE);
        }
        return rectangle;
    }

    public String toString() {
        return StringResources.HTML_PRINT_FORM;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_MAIL_HTML;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class JHFrame
    extends JFrame {
        private Graphics graphics;

        JHFrame() {
        }

        public void addNotify() {
            this.getRootPane().addNotify();
        }

        public void validate() {
            this.validateTree();
        }

        public Graphics getGraphics() {
            return this.graphics;
        }

        public void setGraphics(Graphics graphics) {
            this.graphics = graphics;
        }
    }

    class PageTransform
    extends AffineTransform {
        private double height;

        PageTransform() {
        }

        public double getHeight() {
            return this.height;
        }

        public void setHeight(double d) {
            this.height = d;
        }
    }
}

