/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.preview;

import com.appframework.ActionList;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.controls.orientable.OrientableComboBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBarPanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.printing.PrintInformation;
import com.novell.gw.jclient.application.printing.preview.PagePreview;
import com.novell.gw.jclient.application.printing.preview.PreviewContainer;
import com.novell.gw.jclient.application.printing.preview.PrintPreviewActionList;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class PrintPreview
extends GWDialog {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$preview$PrintPreview == null ? (class$com$novell$gw$jclient$application$printing$preview$PrintPreview = PrintPreview.class$("com.novell.gw.jclient.application.printing.preview.PrintPreview")) : class$com$novell$gw$jclient$application$printing$preview$PrintPreview));
    private static final int MAX_PAGES = 10;
    private static final String[] SCALES = new String[]{"10 %", "25 %", "50 %", "100 %"};
    private static String defaultScale = SCALES[3];
    private JPanel toolBar;
    private PageFormat pageFormat;
    private int wPage;
    private int hPage;
    private int w;
    private int h;
    private int pageIndex = 0;
    private int firstPage = 0;
    private Rectangle rMargin;
    private JComboBox cbScale;
    private PreviewContainer previewContainer;
    private JButton btnPrevious;
    private JButton btnNext;
    private JButton btnClose;
    private JButton btnPrint;
    private boolean isRefreshFirstTime = true;
    private boolean isPreviewFinished = false;
    private PrintInformation printInformation;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$preview$PrintPreview;

    public PrintPreview(JDialog jDialog, MVCController mVCController, PrintInformation printInformation) {
        super(jDialog);
        this.setController(new PrintPreviewActionList(this, mVCController));
        this.printInformation = printInformation;
        this.setTitle(StringResources.PRINT_PREVIEW);
        this.setModal(true);
        this.setSize(680, 600);
        this.pageFormat = PrintUtils.getPageFormatFromPrintAttributes(this.printInformation.getPrintAttributes());
        this.rMargin = new Rectangle();
        this.buildUI();
        this.cbScale.addActionListener(new CbScaleAction());
        this.refreshUI();
    }

    private void buildUI() {
        this.toolBar = new GWToolBarPanel();
        this.toolBar.setLayout(new FlowLayout(3));
        ActionList actionList = (ActionList)this.getController();
        actionList.getAction("Print prepared form").setMVCModel(this.printInformation);
        this.btnPrint = new JButton(actionList.getAction("Print prepared form"));
        this.btnClose = new JButton(StringResources.CLOSE);
        this.btnClose.addActionListener(new BtnCloseAction());
        this.cbScale = new OrientableComboBox(SCALES);
        this.cbScale.setMaximumSize(this.cbScale.getPreferredSize());
        this.cbScale.setEditable(false);
        this.cbScale.setSelectedItem(this.getDefaultScale());
        this.toolBar.add(this.btnPrint);
        this.toolBar.add(this.btnClose);
        this.toolBar.add(this.cbScale);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.previewContainer = new PreviewContainer();
        if (this.pageFormat.getHeight() == 0.0 || this.pageFormat.getWidth() == 0.0) {
            logger.debug((Object)"Unable to determine default page size");
            return;
        }
        this.wPage = (int)this.pageFormat.getWidth();
        this.hPage = (int)this.pageFormat.getHeight();
        int n = 100;
        this.w = this.wPage * n / 100;
        this.h = this.hPage * n / 100;
        this.rMargin.x = (int)(this.pageFormat.getImageableX() * (double)n / 100.0);
        this.rMargin.y = (int)(this.pageFormat.getImageableY() * (double)n / 100.0);
        this.rMargin.width = (int)(this.pageFormat.getImageableWidth() * (double)n / 100.0);
        this.rMargin.height = (int)(this.pageFormat.getImageableHeight() * (double)n / 100.0);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.previewContainer);
        orientableScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.getContentPane().add((Component)orientableScrollPane, "Center");
        this.btnPrevious = new JButton(StringResources.PREVIOUS);
        this.btnPrevious.addActionListener(new BtnPreviousAction());
        this.btnNext = new JButton(StringResources.NEXT);
        this.btnNext.addActionListener(new BtnNextAction());
        this.getRootPane().setDefaultButton(this.btnPrint);
        this.btnClose.registerKeyboardAction(new BtnCloseAction(), KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void refreshUI() {
        this.pageIndex = 0;
        this.isPreviewFinished = false;
        this.printInformation.getPrintForm().onPrintBegin();
        try {
            do {
                BufferedImage bufferedImage = new BufferedImage(this.wPage, this.hPage, 1);
                Graphics graphics = bufferedImage.getGraphics();
                graphics.setColor(Color.white);
                graphics.fillRect(0, 0, this.wPage, this.hPage);
                if (this.printInformation.getPrintForm().print(graphics, this.pageFormat, this.pageIndex) != 0) {
                    this.isPreviewFinished = true;
                    break;
                }
                if (this.pageIndex >= this.firstPage) {
                    PagePreview pagePreview = new PagePreview(this.w, this.h, this.rMargin, bufferedImage);
                    this.previewContainer.add(pagePreview);
                }
                ++this.pageIndex;
            } while (this.pageIndex < this.firstPage + 10);
        }
        catch (PrinterException printerException) {
            logger.error((Object)printerException);
            logger.debug((Object)printerException, (Throwable)printerException);
        }
        if (!this.cbScale.getSelectedItem().toString().equals("100 %")) {
            this.scalePage();
        }
        this.previewContainer.updateUI();
        if (this.isRefreshFirstTime) {
            this.isRefreshFirstTime = false;
            if (this.pageIndex >= 10) {
                this.addPrevNextButtons();
            }
        }
        if (this.firstPage == 0) {
            this.btnPrevious.setEnabled(false);
        } else {
            this.btnPrevious.setEnabled(true);
        }
        if (this.isPreviewFinished) {
            this.btnNext.setEnabled(false);
        } else {
            this.btnNext.setEnabled(true);
        }
    }

    public PreviewContainer getPreviewContainer() {
        return this.previewContainer;
    }

    private void scalePage() {
        int n;
        String string = this.cbScale.getSelectedItem().toString();
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.trim();
        try {
            n = Integer.parseInt(string);
            this.setDefaultScale(this.cbScale.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        int n2 = this.wPage * n / 100;
        int n3 = this.hPage * n / 100;
        this.rMargin.x = (int)(this.pageFormat.getImageableX() * (double)n / 100.0);
        this.rMargin.y = (int)(this.pageFormat.getImageableY() * (double)n / 100.0);
        this.rMargin.width = (int)(this.pageFormat.getImageableWidth() * (double)n / 100.0);
        this.rMargin.height = (int)(this.pageFormat.getImageableHeight() * (double)n / 100.0);
        Component[] componentArray = this.previewContainer.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof PagePreview)) continue;
            PagePreview pagePreview = (PagePreview)componentArray[i];
            pagePreview.setScaledSize(n2, n3, this.rMargin);
        }
        this.previewContainer.doLayout();
        this.validate();
    }

    private void addPrevNextButtons() {
        this.toolBar.add(this.btnPrevious);
        this.toolBar.add(this.btnNext);
    }

    private String getDefaultScale() {
        return defaultScale;
    }

    private void setDefaultScale(String string) {
        defaultScale = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BtnNextAction
    extends AbstractAction {
        BtnNextAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreview.this.firstPage += 10;
            PrintPreview.this.previewContainer.removeAll();
            PrintPreview.this.refreshUI();
        }
    }

    class BtnPreviousAction
    extends AbstractAction {
        BtnPreviousAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreview.this.firstPage -= 10;
            PrintPreview.this.previewContainer.removeAll();
            PrintPreview.this.refreshUI();
        }
    }

    class CbScaleAction
    extends AbstractAction {
        CbScaleAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreview.this.scalePage();
        }
    }

    class BtnCloseAction
    extends AbstractAction {
        BtnCloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PrintPreview.this.dispose();
        }
    }
}

