/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingaddressbook;

import com.appframework.components.DigitDocument;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTextField;
import com.novell.gw.jclient.application.frames.options.compose.ChangesListener;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingaddressbook.ABItem;
import com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookChecksPanelController;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class AddressBookChecksPanel
extends OrientablePanel
implements MVCView {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$application$printing$printingaddressbook$AddressBookChecksPanel == null ? (class$com$novell$gw$jclient$application$printing$printingaddressbook$AddressBookChecksPanel = AddressBookChecksPanel.class$("com.novell.gw.jclient.application.printing.printingaddressbook.AddressBookChecksPanel")) : class$com$novell$gw$jclient$application$printing$printingaddressbook$AddressBookChecksPanel));
    private AddressBookChecksPanelController controller;
    public JCheckBox cbPageNumber;
    private JList lstContents;
    private JTextField tfRowsNumber;
    private JTextField tfColsNumber;
    private Dimension dimTextField = new Dimension(30, 20);
    private CheckListener checkListener;
    private boolean showPageNumber = true;
    private int rowsNumber = OptionManager.getInstance().getPrintingOptions().getRowsNumber();
    private int colsNumber = OptionManager.getInstance().getPrintingOptions().getRowsNumber();
    private ChangesListener changesListener;
    static /* synthetic */ Class class$com$novell$gw$jclient$application$printing$printingaddressbook$AddressBookChecksPanel;

    public AddressBookChecksPanel(MVCController mVCController) {
        this(true, new ChangesListener(), mVCController);
    }

    public AddressBookChecksPanel(boolean bl, ChangesListener changesListener, MVCController mVCController) {
        this.controller = new AddressBookChecksPanelController(this, mVCController);
        this.showPageNumber = bl;
        this.changesListener = changesListener;
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.tfRowsNumber = new OrientableTextField();
        this.tfRowsNumber.setDocument(new DigitDocument());
        this.tfRowsNumber.getDocument().addDocumentListener(new TfRowsNumberListener());
        this.tfRowsNumber.setText(Integer.toString(this.rowsNumber));
        this.tfColsNumber = new OrientableTextField();
        this.tfColsNumber.setDocument(new DigitDocument());
        this.tfColsNumber.getDocument().addDocumentListener(new TfColsNumberListener());
        this.tfColsNumber.setText(Integer.toString(this.colsNumber));
        this.lstContents = new OrientableList();
        this.checkListener = new CheckListener(this.lstContents);
        this.lstContents.addMouseListener(this.checkListener);
        this.lstContents.addKeyListener(this.checkListener);
        CheckListCellRenderer checkListCellRenderer = new CheckListCellRenderer();
        this.lstContents.setCellRenderer(checkListCellRenderer);
        this.lstContents.setSelectionMode(0);
        this.lstContents.setVisibleRowCount(0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        int n = 0;
        int n2 = 0;
        if (this.showPageNumber) {
            this.cbPageNumber = new OrientableCheckBox(StringResources.PRINT_PAGE_NUMBER);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.cbPageNumber.setSelected(true);
            this.add((Component)this.cbPageNumber, gridBagConstraints);
            ++n;
            ++n2;
        }
        JMnemonicLabel jMnemonicLabel = new JMnemonicLabel(StringResources.ADDRESS_BOOK_FIELDS_SELECTION_LIST_C, this.lstContents);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jMnemonicLabel, gridBagConstraints);
        this.lstContents = new JList();
        this.checkListener = new CheckListener(this.lstContents);
        this.lstContents.addMouseListener(this.checkListener);
        this.lstContents.addKeyListener(this.checkListener);
        checkListCellRenderer = new CheckListCellRenderer();
        this.lstContents.setCellRenderer(checkListCellRenderer);
        this.lstContents.setSelectionMode(0);
        this.lstContents.setVisibleRowCount(0);
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.lstContents);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)orientableScrollPane, gridBagConstraints);
        JMnemonicLabel jMnemonicLabel2 = new JMnemonicLabel(StringResources.NUMBER_OF_ROWS, this.tfRowsNumber);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagConstraints.fill = 11;
        this.add((Component)jMnemonicLabel2, gridBagConstraints);
        this.tfRowsNumber = new OrientableTextField();
        this.tfRowsNumber.setDocument(new DigitDocument());
        this.tfRowsNumber.getDocument().addDocumentListener(new TfRowsNumberListener());
        this.tfRowsNumber.setText(Integer.toString(this.rowsNumber));
        this.tfRowsNumber.setColumns(2);
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.tfRowsNumber, gridBagConstraints);
        JMnemonicLabel jMnemonicLabel3 = new JMnemonicLabel(StringResources.NUMBER_OF_COLUMNS, this.tfColsNumber);
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)jMnemonicLabel3, gridBagConstraints);
        this.tfColsNumber = new OrientableTextField();
        this.tfColsNumber.setDocument(new DigitDocument());
        this.tfColsNumber.getDocument().addDocumentListener(new TfColsNumberListener());
        this.tfColsNumber.setText(Integer.toString(this.colsNumber));
        this.tfColsNumber.setColumns(2);
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.insets = new Insets(5, 10, 0, 10);
        this.add((Component)this.tfColsNumber, gridBagConstraints);
        this.setSelectionState(OptionManager.getInstance().getPrintingOptions().getAddressBookSelectionState());
        this.setNames();
    }

    private void setNames() {
        this.tfRowsNumber.setName("Rows number");
        this.tfColsNumber.setName("Cols number");
        this.lstContents.setName("address book fields");
    }

    public ArrayList getCheckedItems() {
        ArrayList<ABItem> arrayList = new ArrayList<ABItem>();
        ListModel listModel = this.lstContents.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (!checkableItem.isSelected()) continue;
            arrayList.add(checkableItem.getItem());
        }
        return arrayList;
    }

    public HashMap getSelectionState() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        ListModel listModel = this.lstContents.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            if (checkableItem.isSelected()) {
                hashMap.put(checkableItem.toString(), new Boolean(true));
                continue;
            }
            hashMap.put(checkableItem.toString(), new Boolean(false));
        }
        return hashMap;
    }

    public void setSelectionState(Map map) {
        Vector<CheckableItem> vector = new Vector<CheckableItem>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ABItem aBItem = (ABItem)iterator.next();
            Boolean bl = (Boolean)map.get(aBItem);
            vector.add(new CheckableItem(aBItem, bl));
        }
        this.lstContents.setListData(vector);
        this.setListEnabled(true);
    }

    public int getRowsNumber() {
        return this.rowsNumber;
    }

    public int getColsNumber() {
        return this.colsNumber;
    }

    public void setRowsNumber(int n) {
        this.rowsNumber = n;
        this.tfRowsNumber.setText(Integer.toString(this.rowsNumber));
    }

    public void setColsNumber(int n) {
        this.colsNumber = n;
        this.tfColsNumber.setText(Integer.toString(this.colsNumber));
    }

    public void setListEnabled(boolean bl) {
        ListModel listModel = this.lstContents.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            CheckableItem checkableItem = (CheckableItem)listModel.getElementAt(i);
            checkableItem.setEnabled(bl);
        }
        this.lstContents.removeMouseListener(this.checkListener);
        this.lstContents.removeKeyListener(this.checkListener);
        if (bl) {
            this.lstContents.addMouseListener(this.checkListener);
            this.lstContents.addKeyListener(this.checkListener);
        }
        this.lstContents.setEnabled(bl);
    }

    public void setController(MVCController mVCController) {
        this.controller = (AddressBookChecksPanelController)mVCController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n == 1 || n == 3) {
                this.setListEnabled(false);
            } else {
                this.setListEnabled(true);
            }
            if (n == 0) {
                this.tfColsNumber.setEnabled(false);
                this.tfRowsNumber.setEnabled(false);
            } else if (n == 2) {
                this.tfColsNumber.setEnabled(true);
                this.tfRowsNumber.setEnabled(true);
            }
        }
    }

    public Object getMVCModel() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class TfRowsNumberListener
    implements DocumentListener {
        TfRowsNumberListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doChange();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.doChange();
        }

        private void doChange() {
            if (AddressBookChecksPanel.this.tfRowsNumber.getText().length() == 0) {
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(AddressBookChecksPanel.this.tfRowsNumber.getText());
                AddressBookChecksPanel.this.rowsNumber = n;
                AddressBookChecksPanel.this.changesListener.setValueChanged();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, StringResources.PLEASE_INSERT_INTEGER_VALUE);
                logger.debug((Object)numberFormatException);
            }
        }
    }

    class TfColsNumberListener
    implements DocumentListener {
        TfColsNumberListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doChange();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doChange();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.doChange();
        }

        private void doChange() {
            if (AddressBookChecksPanel.this.tfColsNumber.getText().length() == 0) {
                return;
            }
            int n = 0;
            try {
                n = Integer.parseInt(AddressBookChecksPanel.this.tfColsNumber.getText());
                AddressBookChecksPanel.this.colsNumber = n;
                AddressBookChecksPanel.this.changesListener.setValueChanged();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(null, StringResources.PLEASE_INSERT_INTEGER_VALUE);
                logger.debug((Object)numberFormatException);
            }
        }
    }

    class CheckListener
    implements MouseListener,
    KeyListener {
        protected JList list;

        public CheckListener(JList jList) {
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.doCheck();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == ' ') {
                this.doCheck();
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        protected void doCheck() {
            int n = this.list.getSelectedIndex();
            if (n < 0) {
                return;
            }
            CheckableItem checkableItem = (CheckableItem)this.list.getModel().getElementAt(n);
            checkableItem.invertSelected();
            this.list.repaint();
            AddressBookChecksPanel.this.changesListener.setValueChanged();
        }
    }

    class CheckListCellRenderer
    extends OrientableCheckBox
    implements ListCellRenderer {
        protected Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckListCellRenderer() {
            this.setOpaque(true);
            this.setBorder(this.noFocusBorder);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            CheckableItem checkableItem = (CheckableItem)object;
            this.setSelected(checkableItem.isSelected());
            this.setFont(jList.getFont());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : this.noFocusBorder);
            this.setEnabled(checkableItem.isEnabled());
            if (checkableItem.isEnabled()) {
                this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
                this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    public class CheckableItem {
        private ABItem item;
        private boolean isSelected;
        private boolean isEnabled = false;

        public CheckableItem(ABItem aBItem, boolean bl) {
            this.item = aBItem;
            this.isSelected = bl;
        }

        public void invertSelected() {
            this.isSelected = !this.isSelected;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
        }

        public String toString() {
            return this.item.toString();
        }

        public void setEnabled(boolean bl) {
            this.isEnabled = bl;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public ABItem getItem() {
            return this.item;
        }
    }
}

