/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar;

import com.appframework.components.IntegerSpinner;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateChangeEvent;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateSelector;
import com.novell.gw.jclient.application.controls.gwcalendar.monthlycalendar.selector.DateValueChangeListener;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarChecksPanelController;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.options.PrintingOptions;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CalendarChecksPanel
extends OrientablePanel
implements MVCView {
    private MVCController controller;
    public GregorianCalendar gcCurrDay;
    public GregorianCalendar gcCurrWeek;
    public GregorianCalendar gcCurrMonth;
    private int printingType = 0;
    public JCheckBox cbPageNumber;
    public JCheckBox cbNewPage;
    public int daysForPrinting = OptionManager.getInstance().getPrintingOptions().getNumberOfDays();
    public int daysForPrintingDefault = OptionManager.getInstance().getPrintingOptions().getNumberOfDays();
    private DateSelector dsDate;
    private DateValueChangeListener dateListener;
    private JSpinner spinnerDaysCount;
    private JPanel pnlCheckBoxes;
    public JCheckBox cbAllDayEvents;
    public JCheckBox cbAppointments;
    public JCheckBox cbAStartTime;
    public JCheckBox cbAEndTime;
    public JCheckBox cbAFrom;
    public JCheckBox cbAPlace;
    public JCheckBox cbTasks;
    public JCheckBox cbTPriority;
    public JCheckBox cbTStartDate;
    public JCheckBox cbTDueDate;
    public JCheckBox cbTFrom;
    public JCheckBox cbReminderNotes;
    public JCheckBox cbRNStartDate;
    public JCheckBox cbRNFrom;

    public CalendarChecksPanel(MVCController mVCController) {
        this.controller = new CalendarChecksPanelController(this, mVCController);
        this.initDates(GWCalendarUtils.getToday());
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        PrintingOptions printingOptions = OptionManager.getInstance().getPrintingOptions();
        this.cbPageNumber = new OrientableCheckBox(StringResources.PRINT_PAGE_NUMBER);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.cbPageNumber.setSelected(printingOptions.isPageNumberPrinted());
        this.add((Component)this.cbPageNumber, gridBagConstraints);
        this.cbNewPage = new OrientableCheckBox(StringResources.START_DAY_FROM_NEW_PAGE);
        this.cbNewPage.setSelected(printingOptions.isDayOnNewPage());
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.cbNewPage, gridBagConstraints);
        JLabel jLabel = new JLabel(StringResources.STARTING_DATE_C);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(StringResources.NUMBER_OF_DAYS_C);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(12, 30, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        this.dsDate = new DateSelector();
        this.dsDate.setIcon(ImageResources.ICON_ACT_VIEW_CALENDAR);
        this.dsDate.setDate(this.gcCurrDay);
        this.dateListener = new DateChangeListener();
        this.dsDate.addDateChangeListener(this.dateListener);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(7, 0, 0, 0);
        this.add((Component)this.dsDate, gridBagConstraints);
        this.spinnerDaysCount = new IntegerSpinner(new SpinnerNumberModel(1, 1, 31, 1));
        this.spinnerDaysCount.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.spinnerDaysCount.setComponentOrientation(UIUtils.getComponentOrientation());
        this.spinnerDaysCount.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                CalendarChecksPanel.this.daysForPrinting = (Integer)CalendarChecksPanel.this.spinnerDaysCount.getValue();
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(7, 30, 0, 60);
        this.add((Component)this.spinnerDaysCount, gridBagConstraints);
        this.builCheckBoxes();
        Border border = BorderFactory.createEtchedBorder();
        this.pnlCheckBoxes.setBorder(BorderFactory.createTitledBorder(border, StringResources.CONTENT));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlCheckBoxes, gridBagConstraints);
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    private void initDates(GregorianCalendar gregorianCalendar) {
        this.gcCurrDay = gregorianCalendar;
        this.gcCurrWeek = GWCalendarUtils.getDateForDayOfWeek(gregorianCalendar, 1);
        this.gcCurrMonth = (GregorianCalendar)gregorianCalendar.clone();
        this.gcCurrMonth.set(5, 1);
    }

    private void builCheckBoxes() {
        this.pnlCheckBoxes = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(0, 5, 0, 0);
        Insets insets2 = new Insets(0, 21, 0, 10);
        PrintingOptions printingOptions = OptionManager.getInstance().getPrintingOptions();
        this.cbAllDayEvents = new OrientableCheckBox(StringResources.ALL_DAY_EVENTS);
        this.cbAllDayEvents.setSelected(printingOptions.isAllDayEventPrinted());
        gridBagConstraints.insets = insets;
        this.pnlCheckBoxes.add((Component)this.cbAllDayEvents, gridBagConstraints);
        this.cbAppointments = new OrientableCheckBox(StringResources.APPOINTMENTS);
        this.cbAppointments.addActionListener(new CbAppointmentsAction());
        this.cbAppointments.setSelected(printingOptions.isAppointmentPrinted());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        this.pnlCheckBoxes.add((Component)this.cbAppointments, gridBagConstraints);
        this.cbAStartTime = new OrientableCheckBox(StringResources.START_TIME);
        this.cbAStartTime.setSelected(printingOptions.isAppointmentStartPrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 1;
        this.pnlCheckBoxes.add((Component)this.cbAStartTime, gridBagConstraints);
        this.cbAEndTime = new OrientableCheckBox(StringResources.END_TIME);
        this.cbAEndTime.setSelected(printingOptions.isAppointmentEndPrinted());
        gridBagConstraints.gridy = 2;
        this.pnlCheckBoxes.add((Component)this.cbAEndTime, gridBagConstraints);
        this.cbAPlace = new OrientableCheckBox(StringResources.PLACE);
        this.cbAPlace.setSelected(true);
        this.cbAPlace.setSelected(printingOptions.isAppointmentFromPrinted());
        gridBagConstraints.gridy = 3;
        this.pnlCheckBoxes.add((Component)this.cbAPlace, gridBagConstraints);
        this.cbAFrom = new OrientableCheckBox(StringResources.FROM);
        this.cbAFrom.setSelected(printingOptions.isAppointmentFromPrinted());
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 4;
        this.pnlCheckBoxes.add((Component)this.cbAFrom, gridBagConstraints);
        this.cbTasks = new OrientableCheckBox(StringResources.TASKS);
        this.cbTasks.addActionListener(new CbTasksAction());
        this.cbTasks.setSelected(printingOptions.isTaskPrinted());
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        this.pnlCheckBoxes.add((Component)this.cbTasks, gridBagConstraints);
        this.cbTPriority = new OrientableCheckBox(StringResources.PRIORITY_TASK);
        this.cbTPriority.setSelected(true);
        this.cbTPriority.setSelected(printingOptions.isTaskStartPrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 1;
        this.pnlCheckBoxes.add((Component)this.cbTPriority, gridBagConstraints);
        this.cbTStartDate = new OrientableCheckBox(StringResources.START_DATE);
        this.cbTStartDate.setSelected(printingOptions.isTaskStartPrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 2;
        this.pnlCheckBoxes.add((Component)this.cbTStartDate, gridBagConstraints);
        this.cbTDueDate = new OrientableCheckBox(StringResources.DUE_DATE);
        this.cbTDueDate.setSelected(printingOptions.isTaskDuePrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 3;
        this.pnlCheckBoxes.add((Component)this.cbTDueDate, gridBagConstraints);
        this.cbTFrom = new OrientableCheckBox(StringResources.FROM);
        this.cbTFrom.setSelected(printingOptions.isTaskFromPrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 4;
        this.pnlCheckBoxes.add((Component)this.cbTFrom, gridBagConstraints);
        this.cbReminderNotes = new OrientableCheckBox(StringResources.REMINDER_NOTES);
        this.cbReminderNotes.addActionListener(new CbNotesAction());
        this.cbReminderNotes.setSelected(printingOptions.isNotePrinted());
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.pnlCheckBoxes.add((Component)this.cbReminderNotes, gridBagConstraints);
        this.cbRNStartDate = new OrientableCheckBox(StringResources.START_DATE);
        this.cbRNStartDate.setSelected(printingOptions.isNoteStartPrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        this.pnlCheckBoxes.add((Component)this.cbRNStartDate, gridBagConstraints);
        this.cbRNFrom = new OrientableCheckBox(StringResources.FROM);
        this.cbRNFrom.setSelected(printingOptions.isNoteFromPrinted());
        gridBagConstraints.insets = insets2;
        gridBagConstraints.gridy = 2;
        this.pnlCheckBoxes.add((Component)this.cbRNFrom, gridBagConstraints);
    }

    public int getPrintingType() {
        return this.printingType;
    }

    public void setController(MVCController mVCController) {
        if (mVCController instanceof CalendarChecksPanelController) {
            this.controller = mVCController;
        }
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object object) {
        if (object instanceof Integer) {
            this.printingType = (Integer)object;
            if (this.printingType == 0) {
                this.daysForPrinting = this.daysForPrintingDefault;
                this.dsDate.setDate(this.gcCurrDay);
                this.spinnerDaysCount.setEnabled(true);
                this.spinnerDaysCount.setValue(new Integer(this.daysForPrinting));
            } else if (this.printingType == 1) {
                this.daysForPrinting = 7;
                this.dsDate.setDate(this.gcCurrWeek);
                this.spinnerDaysCount.setEnabled(false);
                this.spinnerDaysCount.setValue(new Integer(7));
            } else if (this.printingType == 2) {
                this.dsDate.setDate(this.gcCurrMonth);
                this.spinnerDaysCount.setEnabled(false);
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.gcCurrMonth.clone();
                gregorianCalendar.add(2, 1);
                gregorianCalendar.add(5, -1);
                this.daysForPrinting = gregorianCalendar.get(5) - this.gcCurrMonth.get(5) + 1;
                this.spinnerDaysCount.setValue(new Integer(this.daysForPrinting));
            }
        } else if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            this.initDates((GregorianCalendar)gregorianCalendar.clone());
            this.daysForPrinting = 1;
            this.spinnerDaysCount.setValue(new Integer(1));
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private class DateChangeListener
    implements DateValueChangeListener {
        private DateChangeListener() {
        }

        public void valueChanged(DateChangeEvent dateChangeEvent) {
            Date date = dateChangeEvent.getDate().getTime();
            CalendarChecksPanel calendarChecksPanel = CalendarChecksPanel.this;
            if (calendarChecksPanel.printingType == 0) {
                calendarChecksPanel.gcCurrDay.setTime(date);
            } else if (calendarChecksPanel.printingType == 1) {
                calendarChecksPanel.gcCurrWeek.setTime(date);
                calendarChecksPanel.gcCurrWeek = GWCalendarUtils.getDateForDayOfWeek(calendarChecksPanel.gcCurrWeek, 1);
                calendarChecksPanel.daysForPrinting = 7;
            } else if (calendarChecksPanel.printingType == 2) {
                calendarChecksPanel.gcCurrMonth.setTime(date);
                calendarChecksPanel.gcCurrMonth.set(5, 1);
                GregorianCalendar gregorianCalendar = (GregorianCalendar)calendarChecksPanel.gcCurrMonth.clone();
                gregorianCalendar.add(2, 1);
                gregorianCalendar.add(5, -1);
                calendarChecksPanel.daysForPrinting = gregorianCalendar.get(5) - calendarChecksPanel.gcCurrMonth.get(5) + 1;
                calendarChecksPanel.spinnerDaysCount.setValue(new Integer(calendarChecksPanel.daysForPrinting));
            }
        }
    }

    private class CbNotesAction
    extends AbstractAction {
        private CbNotesAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CalendarChecksPanel.this.cbReminderNotes.isSelected()) {
                CalendarChecksPanel.this.cbRNStartDate.setEnabled(true);
                CalendarChecksPanel.this.cbRNFrom.setEnabled(true);
            } else {
                CalendarChecksPanel.this.cbRNStartDate.setEnabled(false);
                CalendarChecksPanel.this.cbRNFrom.setEnabled(false);
            }
        }
    }

    private class CbTasksAction
    extends AbstractAction {
        private CbTasksAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CalendarChecksPanel.this.cbTasks.isSelected()) {
                CalendarChecksPanel.this.cbTPriority.setEnabled(true);
                CalendarChecksPanel.this.cbTStartDate.setEnabled(true);
                CalendarChecksPanel.this.cbTDueDate.setEnabled(true);
                CalendarChecksPanel.this.cbTFrom.setEnabled(true);
            } else {
                CalendarChecksPanel.this.cbTStartDate.setEnabled(false);
                CalendarChecksPanel.this.cbTDueDate.setEnabled(false);
                CalendarChecksPanel.this.cbTFrom.setEnabled(false);
                CalendarChecksPanel.this.cbTPriority.setEnabled(false);
            }
        }
    }

    private class CbAppointmentsAction
    extends AbstractAction {
        private CbAppointmentsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (CalendarChecksPanel.this.cbAppointments.isSelected()) {
                CalendarChecksPanel.this.cbAStartTime.setEnabled(true);
                CalendarChecksPanel.this.cbAEndTime.setEnabled(true);
                CalendarChecksPanel.this.cbAFrom.setEnabled(true);
                CalendarChecksPanel.this.cbAPlace.setEnabled(true);
            } else {
                CalendarChecksPanel.this.cbAStartTime.setEnabled(false);
                CalendarChecksPanel.this.cbAEndTime.setEnabled(false);
                CalendarChecksPanel.this.cbAFrom.setEnabled(false);
                CalendarChecksPanel.this.cbAPlace.setEnabled(false);
            }
        }
    }
}

