/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.printing.printingcalendar.printforms;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.printing.printingcalendar.CalendarChecksPanel;
import com.novell.gw.jclient.application.printing.printingcalendar.printforms.CalendarForm;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.ImageIcon;

public class DailyListForm
extends CalendarForm {
    protected int dayPageIndex = -1;
    private int firstDayOnPage = 0;
    private int firstDayOnPageCopy = 0;
    private int lastDayOnPage = -1;
    protected int firstAllDayEventOnPage = 0;
    protected int firstAllDayEventOnPageCopy = 0;
    protected int lastAllDayEventOnPage = 0;
    private int lastAllDayEventOnPageCopy = 0;
    protected boolean isPrintingAllDayEventsFinished = true;
    protected boolean isPrintingAllDayEventsFinishedCopy = true;
    protected int firstAppointmentOnPage = 0;
    protected int firstAppointmentOnPageCopy = 0;
    protected int lastAppointmentOnPage = 0;
    private int lastAppointmentOnPageCopy = 0;
    protected boolean isPrintingAppointmentsFinished = true;
    protected boolean isPrintingAppointmentsFinishedCopy = true;
    private int firstTaskOnPage = 0;
    private int firstTaskOnPageCopy = 0;
    private int lastTaskOnPageCopy = 0;
    private int lastTaskOnPage = 0;
    private boolean isPrintingTasksFinished = true;
    private boolean isPrintingTasksFinishedCopy = true;
    private int firstReminderNoteOnPage = 0;
    private int firstReminderNoteOnPageCopy = 0;
    private int lastReminderNoteOnPage = 0;
    private int lastReminderNoteOnPageCopy = 0;
    private boolean isPrintingReminderNotesFinished = true;
    private boolean isPrintingReminderNotesFinishedCopy = true;
    protected static int DATE_WIDTH = 80;
    protected static final int CELL_WIDTH = 80;
    protected static final int PLACE_WIDTH = 100;
    private boolean isPrintingDayFinished = false;
    private boolean isPrintingDayFinishedCopy = false;
    protected int printingY = 0;
    private boolean isPrintFirstTime = true;
    private boolean isPrintingLastDay = false;
    protected boolean isPriningNewPage = true;
    protected GregorianCalendar gcDay;
    private GregorianCalendar gcDayCopy;
    private static int H_GAP = 4;
    private AbstractFolder folder;
    private ItemList itemList;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$AppointmentItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$TaskItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$ReminderNote;

    public DailyListForm(MVCController mVCController) {
        this.setController(mVCController);
        try {
            this.folder = GWCommandManager.getInstance(ControlsUtils.getUserGuid(this.getController())).getCalendarFolder();
            this.itemList = this.folder.getItemList();
        }
        catch (GWCommandException gWCommandException) {
            ErrorDialog.processGWException(gWCommandException);
        }
    }

    public AbstractFolder getFolder() {
        return this.folder;
    }

    public ItemList getItemList() {
        return this.itemList;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        super.print(graphics, pageFormat, n);
        boolean bl = false;
        if (n > this.dayPageIndex && this.isPrintingDayFinished) {
            this.firstDayOnPage = this.lastDayOnPage + 1;
            if (this.firstDayOnPage >= this.calendarChecksPanel.daysForPrinting) {
                this.isPrintFirstTime = true;
                System.gc();
                return 1;
            }
        }
        this.refreshPrint(n);
        if (!this.isPrintingDayFinished && this.firstDayOnPage == this.calendarChecksPanel.daysForPrinting) {
            --this.firstDayOnPage;
            this.isPrintingLastDay = true;
        }
        int n2 = this.firstDayOnPage;
        while (n2 < this.calendarChecksPanel.daysForPrinting) {
            if (this.isPrintingDayFinished) {
                this.gcDay.add(5, 1);
                this.lastDayOnPage = n2++;
                this.beforePrintNewDay();
            }
            if (this.isPrintingLastDay) {
                n2 = ++this.firstDayOnPage;
            }
            graphics.setFont(this.FNT_HEADER);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n3 = this.printingY;
            this.paintHeaderRow(graphics, StringResources.DATE_C, GWCalendarUtils.getDateFormat().format(this.gcDay.getTime()), n3);
            this.printingY += fontMetrics.getHeight() + 10;
            if (this.calendarChecksPanel.cbAllDayEvents.isSelected() && (bl = this.printAllDayEvents(graphics)) && !this.isPrintingAllDayEventsFinished) {
                return 0;
            }
            if (this.calendarChecksPanel.cbAppointments.isSelected() && (bl = this.printAppointments(graphics)) && !this.isPrintingAppointmentsFinished) {
                return 0;
            }
            if (this.calendarChecksPanel.cbTasks.isSelected() && (bl = this.printTasks(graphics)) && !this.isPrintingTasksFinished) {
                return 0;
            }
            if (this.calendarChecksPanel.cbReminderNotes.isSelected() && (bl = this.printReminderNotes(graphics)) && !this.isPrintingReminderNotesFinished) {
                return 0;
            }
            this.isPrintingDayFinished = true;
            if (!this.calendarChecksPanel.cbNewPage.isSelected()) continue;
            Runtime.getRuntime().gc();
            return 0;
        }
        this.isPrintingDayFinished = true;
        return 0;
    }

    public void onPrintBegin() {
        if (this.calendarChecksPanel.getPrintingType() == 0) {
            this.gcDay = (GregorianCalendar)this.calendarChecksPanel.gcCurrDay.clone();
        } else if (this.calendarChecksPanel.getPrintingType() == 1) {
            this.gcDay = (GregorianCalendar)this.calendarChecksPanel.gcCurrWeek.clone();
        } else if (this.calendarChecksPanel.getPrintingType() == 2) {
            this.gcDay = (GregorianCalendar)this.calendarChecksPanel.gcCurrMonth.clone();
        }
        this.gcDay.add(5, -1);
        this.dayPageIndex = -1;
        this.isPrintingLastDay = false;
        this.lastDayOnPage = -1;
        this.firstDayOnPage = -1;
        this.firstAllDayEventOnPage = 0;
        this.lastAllDayEventOnPage = -1;
        this.isPrintingAllDayEventsFinished = true;
        this.firstAppointmentOnPage = 0;
        this.lastAppointmentOnPage = -1;
        this.isPrintingAppointmentsFinished = true;
        this.firstTaskOnPage = 0;
        this.lastTaskOnPage = -1;
        this.isPrintingTasksFinished = true;
        this.firstReminderNoteOnPage = 0;
        this.lastReminderNoteOnPage = -1;
        this.isPrintingReminderNotesFinished = true;
        this.isPrintingDayFinished = true;
        this.printingY = 0;
        this.isPrintFirstTime = false;
        this.isPriningNewPage = true;
        this.findAdditionsLength();
    }

    private void findAdditionsLength() {
        BufferedImage bufferedImage = new BufferedImage(1000, 100, 2);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setFont(this.FNT_PLAIN);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        GregorianCalendar gregorianCalendar = GWCalendarUtils.getToday();
        gregorianCalendar.set(5, 29);
        gregorianCalendar.set(2, 11);
        gregorianCalendar.set(1, 0);
        gregorianCalendar.set(11, 11);
        gregorianCalendar.set(12, 59);
        String string = GWCalendarUtils.getDateFormat().format(gregorianCalendar.getTime());
        DATE_WIDTH = (int)fontMetrics.getStringBounds(string, graphics).getWidth() + 20;
    }

    protected void beforePrintNewDay() {
        this.firstDayOnPage = this.lastDayOnPage + 1;
        this.isPrintingDayFinished = false;
        this.isPrintingAllDayEventsFinished = false;
        this.lastAllDayEventOnPage = -1;
        this.firstAllDayEventOnPage = 0;
        this.isPrintingAppointmentsFinished = false;
        this.lastAppointmentOnPage = -1;
        this.firstAppointmentOnPage = this.getStartAppointments();
        this.isPrintingTasksFinished = false;
        this.lastTaskOnPage = -1;
        this.firstTaskOnPage = 0;
        this.isPrintingReminderNotesFinished = false;
        this.lastReminderNoteOnPage = -1;
        this.firstReminderNoteOnPage = 0;
    }

    protected void refreshPrint(int n) {
        if (n > this.dayPageIndex) {
            this.dayPageIndex = n;
            this.printingY = 0;
            this.firstDayOnPageCopy = this.firstDayOnPage;
            this.gcDayCopy = (GregorianCalendar)this.gcDay.clone();
            this.isPrintingDayFinishedCopy = this.isPrintingDayFinished;
            this.isPrintingAllDayEventsFinishedCopy = this.isPrintingAllDayEventsFinished;
            if (this.isPrintingAllDayEventsFinished) {
                this.firstAllDayEventOnPage = 0;
                this.lastAllDayEventOnPage = -1;
            } else {
                this.firstAllDayEventOnPage = this.lastAllDayEventOnPage + 1;
            }
            this.firstAllDayEventOnPageCopy = this.firstAllDayEventOnPage;
            this.lastAllDayEventOnPageCopy = this.lastAllDayEventOnPage;
            this.isPrintingAppointmentsFinishedCopy = this.isPrintingAppointmentsFinished;
            if (this.isPrintingAppointmentsFinished) {
                this.firstAppointmentOnPage = this.getStartAppointments();
                this.lastAppointmentOnPage = -1;
            } else {
                this.firstAppointmentOnPage = this.lastAppointmentOnPage + 1;
            }
            this.firstAppointmentOnPageCopy = this.firstAppointmentOnPage;
            this.lastAppointmentOnPageCopy = this.lastAppointmentOnPage;
            this.isPrintingTasksFinishedCopy = this.isPrintingTasksFinished;
            if (this.isPrintingTasksFinished) {
                this.firstTaskOnPage = 0;
                this.lastTaskOnPage = -1;
            } else {
                this.firstTaskOnPage = this.lastTaskOnPage + 1;
            }
            this.firstTaskOnPageCopy = this.firstTaskOnPage;
            this.lastTaskOnPageCopy = this.lastTaskOnPage;
            this.isPrintingReminderNotesFinishedCopy = this.isPrintingReminderNotesFinished;
            if (this.isPrintingReminderNotesFinished) {
                this.firstReminderNoteOnPage = 0;
                this.lastReminderNoteOnPage = -1;
            } else {
                this.firstReminderNoteOnPage = this.lastReminderNoteOnPage + 1;
            }
            this.firstReminderNoteOnPageCopy = this.firstReminderNoteOnPage;
            this.lastReminderNoteOnPageCopy = this.lastReminderNoteOnPage;
            this.isPriningNewPage = true;
        } else {
            this.firstDayOnPage = this.firstDayOnPageCopy;
            this.gcDay = (GregorianCalendar)this.gcDayCopy.clone();
            this.printingY = 0;
            this.isPrintingDayFinished = this.isPrintingDayFinishedCopy;
            this.isPrintingAllDayEventsFinished = this.isPrintingAllDayEventsFinishedCopy;
            this.lastAllDayEventOnPage = this.lastAllDayEventOnPageCopy;
            this.firstAllDayEventOnPage = this.firstAllDayEventOnPageCopy;
            this.isPrintingAppointmentsFinished = this.isPrintingAppointmentsFinishedCopy;
            this.lastAppointmentOnPage = this.lastAppointmentOnPageCopy;
            this.firstAppointmentOnPage = this.firstAppointmentOnPageCopy;
            this.isPrintingTasksFinished = this.isPrintingTasksFinishedCopy;
            this.firstTaskOnPage = this.firstTaskOnPageCopy;
            this.lastTaskOnPage = this.lastTaskOnPageCopy;
            this.isPrintingReminderNotesFinished = this.isPrintingReminderNotesFinishedCopy;
            this.lastReminderNoteOnPage = this.lastReminderNoteOnPageCopy;
            this.firstReminderNoteOnPage = this.firstReminderNoteOnPageCopy;
            this.isPriningNewPage = false;
        }
    }

    protected boolean printAllDayEvents(Graphics graphics) {
        graphics.setFont(this.FNT_HEADER);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.printingY;
        int n3 = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingAllDayEventsFinished) {
            return false;
        }
        if (n2 + n * 3 > n3) {
            this.printingY = 0;
            return true;
        }
        n2 = this.printAppointmentsHeader(graphics, n2, n, StringResources.ALL_DAY_EVENTS_C);
        IDObjectsCollection iDObjectsCollection = GWCalendarUtils.getAllDayEvents(this.getItemList(), this.gcDay.getTime());
        this.printAllDayEventsCollection(iDObjectsCollection, ++n2, n, n3, graphics);
        return true;
    }

    protected boolean printAppointments(Graphics graphics) {
        graphics.setFont(this.FNT_HEADER);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.printingY;
        int n3 = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingAppointmentsFinished) {
            return false;
        }
        if (n2 + n * 3 > n3) {
            this.printingY = 0;
            return true;
        }
        n2 = this.printAppointmentsHeader(graphics, n2, n, StringResources.APPOINTMENTS_C);
        IDObjectsCollection iDObjectsCollection = GWCalendarUtils.getAppointments(this.getItemList(), this.gcDay.getTime());
        this.printAppointmentsCollection(iDObjectsCollection, n2, n, n3, graphics);
        return true;
    }

    protected void printAllDayEventsCollection(IDObjectsCollection iDObjectsCollection, int n, int n2, int n3, Graphics graphics) {
        for (int i = this.firstAllDayEventOnPage; i < iDObjectsCollection.size(); ++i) {
            if (n + n2 > n3) {
                this.printingY = 0;
                break;
            }
            this.lastAllDayEventOnPage = i;
            n = this.printAppointmentItem(iDObjectsCollection, i, graphics, n);
        }
        if (this.lastAllDayEventOnPage >= iDObjectsCollection.size() - 1) {
            this.isPrintingAllDayEventsFinished = true;
        }
        this.printingY = n + 10;
    }

    protected void printAppointmentsCollection(IDObjectsCollection iDObjectsCollection, int n, int n2, int n3, Graphics graphics) {
        for (int i = this.firstAppointmentOnPage; i < iDObjectsCollection.size(); ++i) {
            if (n + n2 > n3) {
                this.printingY = 0;
                break;
            }
            this.lastAppointmentOnPage = i;
            n = this.printAppointmentItem(iDObjectsCollection, i, graphics, n);
        }
        if (this.lastAppointmentOnPage >= iDObjectsCollection.size() - 1) {
            this.isPrintingAppointmentsFinished = true;
        }
        this.printingY = n + 10;
    }

    private int printAppointmentItem(IDObjectsCollection iDObjectsCollection, int n, Graphics graphics, int n2) {
        AppointmentItem appointmentItem = (AppointmentItem)iDObjectsCollection.getIDObjectAt(n);
        if (this.calendarChecksPanel.cbAFrom.isSelected()) {
            this.drawAlignedString(graphics, appointmentItem.getSender().getDisplayText() == null ? "" : appointmentItem.getSender().getDisplayText(), this.getFromX(), n2, 80);
        }
        if (this.calendarChecksPanel.cbAEndTime.isSelected()) {
            this.drawAlignedString(graphics, GWCalendarUtils.getTimeFormat().format(appointmentItem.getEndDate()), this.getAppointmentEndTimeX(), n2, DATE_WIDTH);
        }
        if (this.calendarChecksPanel.cbAStartTime.isSelected()) {
            this.drawAlignedString(graphics, GWCalendarUtils.getTimeFormat().format(appointmentItem.getStartDate()), this.getAppointmentStartTimeX(), n2, DATE_WIDTH);
        }
        int n3 = n2;
        if (this.calendarChecksPanel.cbAPlace.isSelected()) {
            n3 = appointmentItem.getLocation() != null ? (n3 += this.printMultilineString(graphics, appointmentItem.getLocation(), 100, n3, this.getAppointmentPlaceX())) : (n3 += this.printMultilineString(graphics, " ", 100, n3, this.getAppointmentPlaceX()));
        }
        int n4 = n2;
        String string = this.composeAppointmentSubjectString(appointmentItem);
        n4 += this.printMultilineString(graphics, string, this.getSubjectWidth(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem), n4, this.getSubjectX(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem));
        n2 = n4 > n3 ? n4 : n3;
        return n2;
    }

    protected String composeAppointmentSubjectString(AppointmentItem appointmentItem) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (appointmentItem.getSubject() != null) {
            stringBuffer.append(appointmentItem.getSubject());
        }
        return stringBuffer.toString();
    }

    protected int getSubjectX(Class clazz) {
        return this.isLeftToRight ? 0 : this.pageWidth - this.getSubjectWidth(clazz);
    }

    protected int getSubjectWidth(Class clazz) {
        int n = 0;
        if (clazz.equals(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem)) {
            if (this.calendarChecksPanel.cbAFrom.isSelected()) {
                n += 80;
            }
            if (this.calendarChecksPanel.cbAEndTime.isSelected()) {
                n += DATE_WIDTH;
            }
            if (this.calendarChecksPanel.cbAStartTime.isSelected()) {
                n += DATE_WIDTH;
            }
            if (this.calendarChecksPanel.cbAPlace.isSelected()) {
                n += 100;
            }
        } else if (clazz.equals(class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? (class$com$novell$gw$jclient$bl$om$items$TaskItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.TaskItem")) : class$com$novell$gw$jclient$bl$om$items$TaskItem)) {
            if (this.calendarChecksPanel.cbTFrom.isSelected()) {
                n += 80;
            }
            if (this.calendarChecksPanel.cbTStartDate.isSelected()) {
                n += DATE_WIDTH;
            }
            if (this.calendarChecksPanel.cbTDueDate.isSelected()) {
                n += DATE_WIDTH;
            }
            if (this.calendarChecksPanel.cbTPriority.isSelected()) {
                n += 80;
            }
        } else if (clazz.equals(class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? (class$com$novell$gw$jclient$bl$om$items$ReminderNote = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.ReminderNote")) : class$com$novell$gw$jclient$bl$om$items$ReminderNote)) {
            if (this.calendarChecksPanel.cbRNFrom.isSelected()) {
                n += 80;
            }
            if (this.calendarChecksPanel.cbRNStartDate.isSelected()) {
                n += DATE_WIDTH;
            }
        }
        return this.pageWidth - n;
    }

    private int getAppointmentPlaceX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - 100 : 0;
        if (this.calendarChecksPanel.cbAFrom.isSelected()) {
            int n3 = n = this.isLeftToRight ? n - 80 : 80;
        }
        if (this.calendarChecksPanel.cbAEndTime.isSelected()) {
            int n4 = n = this.isLeftToRight ? n - DATE_WIDTH : n + DATE_WIDTH;
        }
        if (this.calendarChecksPanel.cbAStartTime.isSelected()) {
            n = this.isLeftToRight ? n - DATE_WIDTH : n + DATE_WIDTH;
        }
        n = this.isLeftToRight ? n - 5 : n + 5;
        return n;
    }

    protected int getAppointmentStartTimeX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (this.calendarChecksPanel.cbAFrom.isSelected()) {
            int n3 = n = this.isLeftToRight ? n - 80 : 80;
        }
        if (this.calendarChecksPanel.cbAEndTime.isSelected()) {
            n = this.isLeftToRight ? n - DATE_WIDTH : n + DATE_WIDTH;
        }
        return n;
    }

    protected int getAppointmentEndTimeX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (this.calendarChecksPanel.cbAFrom.isSelected()) {
            n = this.isLeftToRight ? n - 80 : 80;
        }
        return n;
    }

    private int getTaskPriorityX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - 80 : 0;
        if (this.calendarChecksPanel.cbTFrom.isSelected()) {
            int n3 = n = this.isLeftToRight ? n - 80 : 80;
        }
        if (this.calendarChecksPanel.cbTDueDate.isSelected()) {
            int n4 = n = this.isLeftToRight ? n - DATE_WIDTH : n + DATE_WIDTH;
        }
        if (this.calendarChecksPanel.cbTStartDate.isSelected()) {
            n = this.isLeftToRight ? n - DATE_WIDTH : n + DATE_WIDTH;
        }
        return n;
    }

    private int getTaskStartDateX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (this.calendarChecksPanel.cbTFrom.isSelected()) {
            int n3 = n = this.isLeftToRight ? n - 80 : 80;
        }
        if (this.calendarChecksPanel.cbTDueDate.isSelected()) {
            n = this.isLeftToRight ? n - DATE_WIDTH : n + DATE_WIDTH;
        }
        return n;
    }

    private int getTaskDueDateX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (this.calendarChecksPanel.cbTFrom.isSelected()) {
            n = this.isLeftToRight ? n - 80 : 80;
        }
        return n;
    }

    protected int getFromX() {
        return this.isLeftToRight ? this.pageWidth - 80 : 0;
    }

    private int getReminderNoteStartDateX() {
        int n;
        int n2 = n = this.isLeftToRight ? this.pageWidth - DATE_WIDTH : 0;
        if (this.calendarChecksPanel.cbRNFrom.isSelected()) {
            n = this.isLeftToRight ? n - 80 : 80;
        }
        return n;
    }

    protected int printAppointmentsHeader(Graphics graphics, int n, int n2, String string) {
        String string2;
        this.paintHeaderRow(graphics, string, "", n);
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, (n += n2) - n2 + H_GAP, this.pageWidth, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, n - n2 + H_GAP, this.pageWidth, n2);
        graphics.setFont(this.FNT_PLAIN);
        this.drawAlignedString(graphics, StringResources.SUBJECT, this.getSubjectX(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem), n, this.getSubjectWidth(class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem));
        if (this.calendarChecksPanel.cbAFrom.isSelected()) {
            string2 = UIUtils.cutStringToWidth(StringResources.FROM, graphics, 80);
            this.drawAlignedString(graphics, string2, this.getFromX(), n, 80);
        }
        if (this.calendarChecksPanel.cbAEndTime.isSelected()) {
            string2 = UIUtils.cutStringToWidth(StringResources.END_TIME, graphics, DATE_WIDTH);
            this.drawAlignedString(graphics, string2, this.getAppointmentEndTimeX(), n, DATE_WIDTH);
        }
        if (this.calendarChecksPanel.cbAStartTime.isSelected()) {
            string2 = UIUtils.cutStringToWidth(StringResources.START_TIME, graphics, DATE_WIDTH);
            this.drawAlignedString(graphics, string2, this.getAppointmentStartTimeX(), n, DATE_WIDTH);
        }
        if (this.calendarChecksPanel.cbAPlace.isSelected()) {
            string2 = UIUtils.cutStringToWidth(StringResources.PRINT_PLACE, graphics, 100);
            this.drawAlignedString(graphics, string2, this.getAppointmentPlaceX(), n, 100);
        }
        return n += n2;
    }

    protected boolean printTasks(Graphics graphics) {
        graphics.setFont(this.FNT_HEADER);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.printingY;
        int n3 = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingTasksFinished) {
            return false;
        }
        if (n2 + n * 3 > n3) {
            this.printingY = 0;
            return true;
        }
        n2 = this.printTaskHeader(graphics, n2, n);
        ++n2;
        IDObjectsCollection iDObjectsCollection = GWCalendarUtils.getTasks(this.getItemList(), this.gcDay.getTime());
        for (int i = this.firstTaskOnPage; i < iDObjectsCollection.size(); ++i) {
            if (n2 + n > n3) {
                this.printingY = 0;
                break;
            }
            this.lastTaskOnPage = i;
            TaskItem taskItem = (TaskItem)iDObjectsCollection.getIDObjectAt(i);
            if (this.calendarChecksPanel.cbTFrom.isSelected()) {
                this.drawAlignedString(graphics, taskItem.getSender().getDisplayText() == null ? " " : taskItem.getSender().getDisplayText(), this.getFromX(), n2, 80);
            }
            if (this.calendarChecksPanel.cbTDueDate.isSelected()) {
                this.drawAlignedString(graphics, GWCalendarUtils.getDateFormat().format(taskItem.getEndDate()), this.getTaskDueDateX(), n2, DATE_WIDTH);
            }
            if (this.calendarChecksPanel.cbTStartDate.isSelected()) {
                this.drawAlignedString(graphics, GWCalendarUtils.getDateFormat().format(new Date(taskItem.getDateTaskAssigned())), this.getTaskStartDateX(), n2, DATE_WIDTH);
            }
            if (this.calendarChecksPanel.cbTPriority.isSelected()) {
                this.drawAlignedString(graphics, taskItem.getPriorityName(), this.getTaskPriorityX(), n2, 80);
            }
            n2 = taskItem.getSubject() != null ? (n2 += this.printMultilineString(graphics, taskItem.getSubject(), this.getSubjectWidth(class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? DailyListForm.class$("com.novell.gw.jclient.bl.om.items.TaskItem") : class$com$novell$gw$jclient$bl$om$items$TaskItem), n2, this.getSubjectX(class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? DailyListForm.class$("com.novell.gw.jclient.bl.om.items.TaskItem") : class$com$novell$gw$jclient$bl$om$items$TaskItem))) : (n2 += n);
            ++n2;
        }
        if (this.lastTaskOnPage >= iDObjectsCollection.size() - 1) {
            this.isPrintingTasksFinished = true;
        }
        this.printingY = n2 + 10;
        return true;
    }

    private int printTaskHeader(Graphics graphics, int n, int n2) {
        String string;
        this.paintHeaderRow(graphics, StringResources.TASKS_C, "", n);
        graphics.setFont(this.FNT_PLAIN);
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, (n += n2) - n2 + H_GAP, this.pageWidth, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, n - n2 + H_GAP, this.pageWidth, n2);
        this.drawAlignedString(graphics, StringResources.SUBJECT, this.getSubjectX(class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? (class$com$novell$gw$jclient$bl$om$items$TaskItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.TaskItem")) : class$com$novell$gw$jclient$bl$om$items$TaskItem), n, this.getSubjectWidth(class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? (class$com$novell$gw$jclient$bl$om$items$TaskItem = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.TaskItem")) : class$com$novell$gw$jclient$bl$om$items$TaskItem));
        if (this.calendarChecksPanel.cbTFrom.isSelected()) {
            string = UIUtils.cutStringToWidth(StringResources.FROM, graphics, 80);
            this.drawAlignedString(graphics, string, this.getFromX(), n, 80);
        }
        if (this.calendarChecksPanel.cbTDueDate.isSelected()) {
            string = UIUtils.cutStringToWidth(StringResources.DUE_DATE, graphics, DATE_WIDTH);
            this.drawAlignedString(graphics, string, this.getTaskDueDateX(), n, DATE_WIDTH);
        }
        if (this.calendarChecksPanel.cbTStartDate.isSelected()) {
            string = UIUtils.cutStringToWidth(StringResources.START_DATE, graphics, DATE_WIDTH);
            this.drawAlignedString(graphics, string, this.getTaskStartDateX(), n, DATE_WIDTH);
        }
        if (this.calendarChecksPanel.cbTPriority.isSelected()) {
            string = UIUtils.cutStringToWidth(StringResources.PRIORITY, graphics, 80);
            this.drawAlignedString(graphics, string, this.getTaskPriorityX(), n, 80);
        }
        return n += n2;
    }

    protected boolean printReminderNotes(Graphics graphics) {
        graphics.setFont(this.FNT_HEADER);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getHeight();
        int n2 = this.printingY;
        int n3 = this.pageHeight - this.commonHeaderH;
        if (this.isPrintingReminderNotesFinished) {
            return false;
        }
        if (n2 + n * 3 > n3) {
            this.printingY = 0;
            return true;
        }
        n2 = this.printNotesHeader(graphics, n2, n);
        ++n2;
        IDObjectsCollection iDObjectsCollection = GWCalendarUtils.getNotes(this.getItemList(), this.gcDay.getTime());
        for (int i = this.firstReminderNoteOnPage; i < iDObjectsCollection.size(); ++i) {
            if (n2 + n > n3) {
                this.printingY = 0;
                break;
            }
            this.lastReminderNoteOnPage = i;
            ReminderNote reminderNote = (ReminderNote)iDObjectsCollection.getIDObjectAt(i);
            if (this.calendarChecksPanel.cbRNFrom.isSelected()) {
                this.drawAlignedString(graphics, reminderNote.getSender().getDisplayText() == null ? " " : reminderNote.getSender().getDisplayText(), this.getFromX(), n2, 80);
            }
            if (this.calendarChecksPanel.cbRNStartDate.isSelected()) {
                this.drawAlignedString(graphics, GWCalendarUtils.getDateFormat().format(reminderNote.getStartDate()), this.getReminderNoteStartDateX(), n2, DATE_WIDTH);
            }
            n2 = reminderNote.getSubject() != null ? (n2 += this.printMultilineString(graphics, reminderNote.getSubject(), this.getSubjectWidth(class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? DailyListForm.class$("com.novell.gw.jclient.bl.om.items.ReminderNote") : class$com$novell$gw$jclient$bl$om$items$ReminderNote), n2, this.getSubjectX(class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? DailyListForm.class$("com.novell.gw.jclient.bl.om.items.ReminderNote") : class$com$novell$gw$jclient$bl$om$items$ReminderNote))) : (n2 += n);
            ++n2;
        }
        if (this.lastReminderNoteOnPage >= iDObjectsCollection.size() - 1) {
            this.isPrintingReminderNotesFinished = true;
        }
        this.printingY = n2 + 10;
        return true;
    }

    private int printNotesHeader(Graphics graphics, int n, int n2) {
        String string;
        this.paintHeaderRow(graphics, StringResources.REMINDER_NOTES_C, "", n);
        graphics.setFont(this.FNT_PLAIN);
        graphics.setColor(new Color(240, 240, 240));
        graphics.fillRect(0, (n += n2) - n2 + H_GAP, this.pageWidth, n2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, n - n2 + H_GAP, this.pageWidth, n2);
        this.drawAlignedString(graphics, StringResources.SUBJECT, this.getSubjectX(class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? (class$com$novell$gw$jclient$bl$om$items$ReminderNote = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.ReminderNote")) : class$com$novell$gw$jclient$bl$om$items$ReminderNote), n, this.getSubjectWidth(class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? (class$com$novell$gw$jclient$bl$om$items$ReminderNote = DailyListForm.class$("com.novell.gw.jclient.bl.om.items.ReminderNote")) : class$com$novell$gw$jclient$bl$om$items$ReminderNote));
        if (this.calendarChecksPanel.cbRNFrom.isSelected()) {
            string = UIUtils.cutStringToWidth(StringResources.FROM, graphics, 80);
            this.drawAlignedString(graphics, string, this.getFromX(), n, 80);
        }
        if (this.calendarChecksPanel.cbRNStartDate.isSelected()) {
            string = UIUtils.cutStringToWidth(StringResources.START_DATE, graphics, DATE_WIDTH);
            this.drawAlignedString(graphics, string, this.getReminderNoteStartDateX(), n, DATE_WIDTH);
        }
        return n += n2;
    }

    protected int printMultilineString(Graphics graphics, String string, int n, int n2, int n3) {
        int n4 = n2;
        List list = UIUtils.breakStringIntoSubstrings(string, graphics.getFontMetrics(this.getFont()), n);
        for (int i = 0; i < list.size(); ++i) {
            this.drawAlignedString(graphics, (String)list.get(i), n3, n4, n);
            n4 += graphics.getFontMetrics().getHeight();
        }
        if ((n4 -= n2) == 0) {
            n4 = graphics.getFontMetrics().getHeight();
        }
        return n4;
    }

    public String toString() {
        return StringResources.PRINT_APPOINTMENTSK_TASKS_AND_REMIN;
    }

    public ImageIcon getIcon() {
        return ImageResources.PRINT_FRM_DAILY_LIST;
    }

    protected int getStartAppointments() {
        return 0;
    }

    public void setMVCModel(Object object) {
        super.setMVCModel(object);
        if (object instanceof CalendarChecksPanel) {
            this.gcDay = (GregorianCalendar)this.calendarChecksPanel.gcCurrDay.clone();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

