/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.utils.Assertions;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.SystemAddressBook;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;

class AddressBookItemsFactory {
    AddressBookItemsFactory() {
    }

    public static AbstractAddressBook createAddressBook(AddressBook addressBook) {
        if (addressBook.isFrequentContacts()) {
            return AddressBookItemsFactory.buildFrequentContactsAddressBook(addressBook);
        }
        if (addressBook instanceof SystemAddressBook) {
            return AddressBookItemsFactory.buildSystemAddressBok((SystemAddressBook)addressBook);
        }
        if (addressBook instanceof com.novell.gw.ab.PersonalAddressBook) {
            return AddressBookItemsFactory.buildPersonalAddressBook((com.novell.gw.ab.PersonalAddressBook)addressBook);
        }
        Assertions.assertIllegalArgument("Unexpected Address Book type");
        return null;
    }

    private static AbstractAddressBook buildFrequentContactsAddressBook(AddressBook addressBook) {
        FrequentContactsAddressBook frequentContactsAddressBook = new FrequentContactsAddressBook(String.valueOf(addressBook.getId()), addressBook);
        return frequentContactsAddressBook;
    }

    private static AbstractAddressBook buildPersonalAddressBook(com.novell.gw.ab.PersonalAddressBook personalAddressBook) {
        PersonalAddressBook personalAddressBook2 = new PersonalAddressBook(String.valueOf(personalAddressBook.getId()), (AddressBook)personalAddressBook);
        return personalAddressBook2;
    }

    private static AbstractAddressBook buildSystemAddressBok(SystemAddressBook systemAddressBook) {
        GroupWiseAddressBook groupWiseAddressBook = new GroupWiseAddressBook(String.valueOf(systemAddressBook.getId()), (AddressBook)systemAddressBook);
        return groupWiseAddressBook;
    }
}

