/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.utils.Assertions;
import com.appframework.utils.Utils;
import com.novell.gw.ab.AddressBook;
import com.novell.gw.ab.AddressBookManager;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.Recipient;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.DataStoreListener;
import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.engine.Engine;
import com.novell.gw.engine.EngineCallback;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.engine.EngineUtils;
import com.novell.gw.engine.Filter;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.JunkMailListManager;
import com.novell.gw.engine.JunkMailSettings;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.engine.ProxyAccessList;
import com.novell.gw.engine.ProxyHistoryEntry;
import com.novell.gw.engine.ProxyHistoryList;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.folder.Folder;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.application.FoldersChangeListener;
import com.novell.gw.jclient.application.actions.item.SaveCallBack;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.bl.eng_impl.AddressBookItemsFactory;
import com.novell.gw.jclient.bl.eng_impl.EngineCallBackListener;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWUserInfo;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.FrequentContactsAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.GWItemAttachment;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.jclient.bl.om.items.UnknownTableItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.MimeEncoding;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.Priority;
import com.novell.gw.jclient.bl.om.items.sendoptions.Security;
import com.novell.gw.jclient.bl.om.options.ItemSendOptions;
import com.novell.gw.jclient.bl.om.options.LoginOptions;
import com.novell.gw.jclient.bl.om.options.Signature;
import com.novell.gw.message.Appointment;
import com.novell.gw.message.BusySearch;
import com.novell.gw.message.DocumentReference;
import com.novell.gw.message.Mail;
import com.novell.gw.message.Message;
import com.novell.gw.message.MessageAttachment;
import com.novell.gw.message.Note;
import com.novell.gw.message.PhoneMessage;
import com.novell.gw.message.SharedAddressBookNotification;
import com.novell.gw.message.Task;
import com.novell.gw.rules.Rule;
import com.novell.gw.rules.RuleList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EngineCommandManager
extends GWCommandManager {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$eng_impl$EngineCommandManager == null ? (class$com$novell$gw$jclient$bl$eng_impl$EngineCommandManager = EngineCommandManager.class$("com.novell.gw.jclient.bl.eng_impl.EngineCommandManager")) : class$com$novell$gw$jclient$bl$eng_impl$EngineCommandManager));
    private static Engine engine = Engine.getInstance();
    private static EngineCallBackListener callback;
    private static DataStore userDataStore;
    private DataStore currentDataStore;
    private static FoldersChangeListener foldersChangeListener;
    private boolean isProxyDataStore;
    private GWUserInfo currentUserInfo;
    private static final String BACKUP_DATA_STORE = "BACKUP_DATA_STORE";
    private static final String ARCHIVE_DATA_STORE = "ARCHIVE_DATA_STORE";
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$eng_impl$EngineCommandManager;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$folders$ContactsFolder;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$folders$CalendarFolder;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$AppointmentItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$ReminderNote;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$TaskItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$DocumentItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$MailItem;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$PhoneItem;

    private EngineCommandManager(DataStore dataStore) {
        this.currentDataStore = dataStore != null ? dataStore : userDataStore;
        if (!(this.currentDataStore.isArchiveDB() || this.currentDataStore.isBackupDB() || this.currentDataStore.equals(userDataStore))) {
            this.isProxyDataStore = true;
        }
        this.currentUserInfo = EngineCommandManager.createUserInfo(this.currentDataStore);
    }

    public EngineCommandManager() {
        this(userDataStore);
    }

    public static ContactsFolder getContactsFolder() {
        return (ContactsFolder)FoldersCache.getFolder(class$com$novell$gw$jclient$bl$om$folders$ContactsFolder == null ? (class$com$novell$gw$jclient$bl$om$folders$ContactsFolder = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.folders.ContactsFolder")) : class$com$novell$gw$jclient$bl$om$folders$ContactsFolder, userInfo.getGuid());
    }

    public static Locale getLocale() {
        return EngineLocale.getCurrent().getLocale();
    }

    public static LoginParameters parseCommandLine(String[] stringArray) {
        return Engine.parseCommandLine((String[])stringArray);
    }

    public static GWUserInfo loginUser(LoginParameters loginParameters) throws GWCommandException {
        logger.debug((Object)"loginUser entered");
        callback = new EngineCallBackListener();
        engine.setCallback((EngineCallback)callback);
        try {
            userDataStore = engine.login(loginParameters, 0);
            if (userDataStore == null) {
                return null;
            }
            userInfo = EngineCommandManager.createUserInfo(userDataStore);
            instances.put(userInfo.getGuid(), new EngineCommandManager(userDataStore));
            EngineCommandManager.saveLoginOptions();
        }
        catch (EngineException engineException) {
            throw new GWCommandException("Engine error.", "Internal error. " + engineException.getMessage(), engineException);
        }
        logger.debug((Object)"loginUser exited");
        return userInfo;
    }

    private static GWUserInfo createUserInfo(DataStore dataStore) {
        GWUserInfo gWUserInfo = new GWUserInfo(dataStore.getUserId());
        gWUserInfo.setName(dataStore.getUserId());
        gWUserInfo.setUserFields(dataStore.getUserFields());
        if (dataStore.isArchiveDB()) {
            gWUserInfo.setGuid(ARCHIVE_DATA_STORE);
        } else if (dataStore.isBackupDB()) {
            gWUserInfo.setGuid(BACKUP_DATA_STORE);
        } else {
            gWUserInfo.setGuid(dataStore.getUserFields().getGuid());
        }
        gWUserInfo.setPassword("");
        gWUserInfo.setFileId(dataStore.getUserFileId());
        gWUserInfo.setPostOffice(dataStore.getHost());
        try {
            gWUserInfo.setPort(Integer.valueOf(dataStore.getTcpIpPort()));
        }
        catch (NumberFormatException numberFormatException) {
            gWUserInfo.setPort(1677);
        }
        gWUserInfo.setServerIP(dataStore.getTcpIpAddress());
        gWUserInfo.setCachingPath(engine.getPathToCache());
        gWUserInfo.setFromText(dataStore.getUserFullName());
        return gWUserInfo;
    }

    private static void saveLoginOptions() {
        LoginOptions loginOptions = OptionManager.getInstance().getLoginOptions();
        loginOptions.setUserName(userInfo.getName());
        loginOptions.setServerName(userInfo.getServerIP());
        loginOptions.setServerPort(userInfo.getPort());
        loginOptions.setMode(EngineCommandManager.getCurrentMode());
        OptionManager.getInstance().setCashingPath(userInfo.getCachingPath());
        OptionManager.getInstance().setLoginOptions(loginOptions);
    }

    public boolean switchToCaching() {
        logger.debug((Object)"switchToCaching entered");
        boolean bl = false;
        if (engine.canSwitchMode(6)) {
            callback.setCurrentSwitchingMode(6);
            engine.switchMode(6);
            bl = true;
            this.isProxyDataStore = false;
        }
        logger.debug((Object)"switchToCaching exited");
        return bl;
    }

    public boolean switchToOnline() {
        logger.debug((Object)"switchToOnline entered");
        boolean bl = false;
        if (engine.canSwitchMode(1)) {
            callback.setCurrentSwitchingMode(1);
            engine.switchMode(1);
            bl = true;
            this.isProxyDataStore = false;
        }
        logger.debug((Object)"switchToOnline exited");
        return bl;
    }

    public static int getCurrentMode() {
        if (userDataStore.isCaching()) {
            return 6;
        }
        if (userDataStore.isOnline()) {
            return 1;
        }
        if (userDataStore.isRemote()) {
            return 3;
        }
        logger.error((Object)"unsopported client mode");
        return -1;
    }

    public static String getProductVersionName() {
        return engine.getProductVersionName();
    }

    public Addressable getUserFields() {
        return this.currentDataStore.getUserFields();
    }

    public GWUserInfo getCurrentUserInfo() {
        return this.currentUserInfo;
    }

    public static GWUserInfo getUserInfo() {
        return userInfo;
    }

    public static String getUserGuid() {
        return userInfo.getGuid();
    }

    public static boolean logoutUser() throws GWCommandException {
        try {
            EngineCommandManager.shutdown();
            return true;
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable, throwable);
            throw new GWCommandException("Engine error.", "Internal error. " + throwable, throwable);
        }
    }

    private static void shutdown() {
        instances.remove(userInfo.getGuid());
        userDataStore.dispose();
        userDataStore = null;
        engine = null;
    }

    public AbstractFolder getRootFolder() throws GWCommandException {
        try {
            if (FoldersCache.containsRootFolder(this.currentUserInfo.getGuid())) {
                return FoldersCache.getRootFolder(this.currentUserInfo.getGuid());
            }
            this.currentDataStore.removeDataStoreListener((DataStoreListener)foldersChangeListener);
            this.currentDataStore.addDataStoreListener((DataStoreListener)foldersChangeListener);
            foldersChangeListener.setUserGuid(this.currentUserInfo.getGuid());
            Folder[] folderArray = this.currentDataStore.getRootFolders();
            AbstractFolder abstractFolder = (AbstractFolder)this.buildFolders(folderArray).getIDObjectAt(0);
            FoldersCache.putRootFolder(abstractFolder, this.currentUserInfo.getGuid());
            return abstractFolder;
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable, throwable);
            throw new GWCommandException("Engine error.", "Internal error. " + throwable, throwable);
        }
    }

    private IDObjectsCollection buildFolders(Folder[] folderArray) {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        for (int i = 0; i < folderArray.length; ++i) {
            Folder folder = folderArray[i];
            if (folder.isDeleted()) continue;
            AbstractFolder abstractFolder = this.getGWFolder(folder);
            this.buildFolders(folder.getSubFolders());
            iDObjectsCollection.addIDObject(abstractFolder);
        }
        return iDObjectsCollection;
    }

    private AbstractFolder createGWFolder(Folder folder) {
        Assertions.assertNotNull(folder, "Can't be null");
        AbstractFolder abstractFolder = null;
        String string = String.valueOf(folder.getId());
        String string2 = folder.getName();
        Class clazz = GWEngineUtils.getFolderClass(folder);
        try {
            abstractFolder = (AbstractFolder)clazz.newInstance();
            abstractFolder.setID(string);
            abstractFolder.setName(string2);
            abstractFolder.setNativeFolder(folder);
            abstractFolder.setUserGuid(this.currentUserInfo.getGuid());
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        return abstractFolder;
    }

    public CalendarFolder getCalendarFolder() throws GWCommandException {
        if (!FoldersCache.containsFolder(class$com$novell$gw$jclient$bl$om$folders$CalendarFolder == null ? (class$com$novell$gw$jclient$bl$om$folders$CalendarFolder = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.folders.CalendarFolder")) : class$com$novell$gw$jclient$bl$om$folders$CalendarFolder, this.currentUserInfo.getGuid())) {
            this.getRootFolder();
        }
        return (CalendarFolder)FoldersCache.getFolder(class$com$novell$gw$jclient$bl$om$folders$CalendarFolder == null ? (class$com$novell$gw$jclient$bl$om$folders$CalendarFolder = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.folders.CalendarFolder")) : class$com$novell$gw$jclient$bl$om$folders$CalendarFolder, this.currentUserInfo.getGuid());
    }

    public IDObjectsCollection search(TimeInterval timeInterval, int n) throws GWCommandException {
        long l = System.currentTimeMillis();
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        Date date = timeInterval.getStartDateAsDate();
        Date date2 = timeInterval.getEndDateAsDate();
        ItemListFilter itemListFilter = new ItemListFilter();
        itemListFilter.setItemType(n);
        if (n == 8) {
            itemListFilter.setDateRange(n, date, date2);
        } else {
            itemListFilter.setDateValue(34, date, true);
            if (n != 4) {
                itemListFilter.setDateValue(53, date2, false);
            }
        }
        CalendarFolder calendarFolder = this.getCalendarFolder();
        logger.debug((Object)"::search() : get folder content...");
        ItemList itemList = calendarFolder.getNativeFolder().getContents(itemListFilter);
        logger.debug((Object)("::search() : items found:[" + itemList.getSize() + "]"));
        iDObjectsCollection.addCollection(this.getCalendarItems(itemList));
        long l2 = System.currentTimeMillis();
        logger.debug((Object)("search [" + GWCalendarUtils.getDateTimeFormat().format(date) + " - " + GWCalendarUtils.getDateTimeFormat().format(date2) + "] time [" + (l2 - l) + "] and finded [" + iDObjectsCollection.size() + "]"));
        return iDObjectsCollection;
    }

    private IDObjectsCollection getCalendarItems(ItemList itemList) throws GWCommandException {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        for (int i = 0; i < itemList.getSize(); ++i) {
            Message message;
            AbstractItem abstractItem;
            Item item = itemList.getItemAt(i);
            if (!(item instanceof Message) || !((abstractItem = this.getGWItem(message = (Message)item)) instanceof AbstractCalendarItem)) continue;
            abstractItem.setProcessing(false);
            iDObjectsCollection.addIDObject(abstractItem);
        }
        return iDObjectsCollection;
    }

    public static IDObjectsCollection getDirectories() {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        iDObjectsCollection.addIDObject(AddressBookItemsFactory.createAddressBook((AddressBook)userDataStore.getAddressBookManager().getSystemAddressBook()));
        Iterator iterator = userDataStore.getAddressBookManager().getPersonalAddressBooksIterator();
        while (iterator.hasNext()) {
            AddressBook addressBook = (AddressBook)iterator.next();
            iDObjectsCollection.addIDObject(AddressBookItemsFactory.createAddressBook(addressBook));
        }
        return iDObjectsCollection;
    }

    public static GroupWiseAddressBook getGroupWiseAdressBook() {
        IDObjectsCollection iDObjectsCollection = EngineCommandManager.getDirectories();
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            AbstractAddressBook abstractAddressBook = (AbstractAddressBook)iDObjectsCollection.getIDObjectAt(i);
            if (!(abstractAddressBook instanceof GroupWiseAddressBook)) continue;
            return (GroupWiseAddressBook)abstractAddressBook;
        }
        return null;
    }

    public static FrequentContactsAddressBook getFrequentContactsAddressBook() {
        com.novell.gw.ab.PersonalAddressBook personalAddressBook = userDataStore.getAddressBookManager().getFrequentContactsBook();
        if (personalAddressBook != null) {
            return (FrequentContactsAddressBook)AddressBookItemsFactory.createAddressBook((AddressBook)personalAddressBook);
        }
        return null;
    }

    public void directorySaveAs(AbstractAddressBook abstractAddressBook, String string, String string2) throws GWCommandException {
        throw new GWCommandException("directorySaveAs is not supported yet");
    }

    public static void createAddressBook(String string) throws EngineException {
        com.novell.gw.ab.PersonalAddressBook personalAddressBook = userDataStore.getAddressBookManager().createAddressBook(string);
    }

    public static void deleteDirectory(PersonalAddressBook personalAddressBook) throws EngineException {
        userDataStore.getAddressBookManager().deleteAddressBook((com.novell.gw.ab.PersonalAddressBook)personalAddressBook.getNativeAddressBook());
    }

    public AbstractFolder createFolder(String string, String string2, AbstractFolder abstractFolder, int n) {
        Folder folder = this.currentDataStore.createFolder(string, string2, abstractFolder.getNativeFolder(), n);
        AbstractFolder abstractFolder2 = this.getGWFolder(folder);
        return abstractFolder2;
    }

    public AbstractFolder createSharedFolder(String string, String string2, AbstractFolder abstractFolder, int n, FolderSharedList folderSharedList) {
        Folder folder = null;
        folder = this.currentDataStore.createSharedFolder(string, string2, abstractFolder.getNativeFolder(), n, folderSharedList);
        AbstractFolder abstractFolder2 = this.getGWFolder(folder);
        return abstractFolder2;
    }

    public void sendItem(AbstractItem abstractItem, SendCallback sendCallback) throws GWCommandException, UnresolvedAddressException {
        logger.debug((Object)"sendItem entered");
        try {
            Message message = this.prepareItemToSending(abstractItem);
            message.send(this.currentDataStore.getGroupWiseAccount(), sendCallback);
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            throw unresolvedAddressException;
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)engineException), engineException);
        }
        logger.debug((Object)"sendItem exited");
    }

    public GWBusySearch composeBusySearch(RecipientDescriptionsList recipientDescriptionsList, Date date, int n, TimeInterval timeInterval) throws GWCommandException {
        logger.debug((Object)"composeBusySearch entered");
        try {
            DistributionList distributionList = recipientDescriptionsList.getDistributionList();
            BusySearch busySearch = new BusySearch(this.currentDataStore, date, new Date(date.getTime() + 3600000L), distributionList, date, n);
            if (EngineCommandManager.isAllRecipientsAreUnresolved(distributionList)) {
                return null;
            }
            GWBusySearch gWBusySearch = new GWBusySearch(busySearch);
            gWBusySearch.setRecipientDescriptionsList(recipientDescriptionsList);
            gWBusySearch.setAppointmentTime(timeInterval);
            gWBusySearch.setStartDate(date);
            gWBusySearch.setDaysCount(n);
            return gWBusySearch;
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)engineException), engineException);
        }
    }

    private static boolean isAllRecipientsAreUnresolved(DistributionList distributionList) {
        for (int i = 0; i < distributionList.getSize(); ++i) {
            Recipient recipient = distributionList.getRecipient(i);
            if (recipient.isUnresolved()) continue;
            return false;
        }
        return true;
    }

    public void acceptSharedAddressBook(SharedAddressBookNotificationItem sharedAddressBookNotificationItem) throws GWCommandException {
        try {
            ((SharedAddressBookNotification)sharedAddressBookNotificationItem.getNativeItem()).accept(this.currentDataStore.getAddressBookManager());
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)engineException), engineException);
        }
    }

    public void rejectSharedAddressBook(SharedAddressBookNotificationItem sharedAddressBookNotificationItem) throws GWCommandException {
        try {
            ((SharedAddressBookNotification)sharedAddressBookNotificationItem.getNativeItem()).reject(this.currentDataStore.getAddressBookManager());
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)engineException), engineException);
        }
    }

    public boolean changePassword(String string, String string2) throws GWCommandException {
        logger.debug((Object)"changePassword entered");
        try {
            this.currentDataStore.getSettings().setPassword(string, string2);
            logger.debug((Object)"changePassword exited");
            return true;
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            logger.debug((Object)"changePassword exited");
            return false;
        }
    }

    public boolean modifySignature(Signature signature) throws GWCommandException {
        try {
            int n = 0;
            if (signature.isUsedSignature()) {
                n = signature.isPromptOnAdd() ? 201 : 1;
            }
            return this.currentDataStore.getSettings().setSignature(new Boolean(signature.isUsedSignature()), n, signature.getSignatureText(), Boolean.valueOf(signature.isUsedCard()), signature.getCardFileName(), this.currentDataStore.getGroupWiseAccount());
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
            throw new GWCommandException(exception);
        }
    }

    public Signature getSignature() throws GWCommandException {
        Signature signature = null;
        DataStoreSettings.SignatureOptions signatureOptions = this.currentDataStore.getSettings().getSignature(this.currentDataStore.getGroupWiseAccount());
        if (signatureOptions != null) {
            boolean bl = signatureOptions.isSignatureOn();
            boolean bl2 = false;
            switch (signatureOptions.getSignatureStatus()) {
                case 0: {
                    bl2 = false;
                    break;
                }
                case 201: {
                    bl2 = true;
                    break;
                }
                case 1: {
                    bl2 = false;
                }
            }
            signature = new Signature(signatureOptions.getSignatureText(), bl, bl2, signatureOptions.getVCardFileName(), signatureOptions.isVCardOn());
        }
        return signature;
    }

    public RuleList getRuleList() {
        return this.currentDataStore.getRuleList();
    }

    public ItemSendOptions getItemSendOptions() throws GWCommandException {
        Notification notification;
        DataStoreSettings dataStoreSettings = this.currentDataStore.getSettings();
        ItemSendOptions itemSendOptions = new ItemSendOptions();
        if (dataStoreSettings == null) {
            return itemSendOptions;
        }
        DataStoreSettings.SendOptionPriority sendOptionPriority = dataStoreSettings.getSendOptionPriority();
        DataStoreSettings.SendOptionSecurity sendOptionSecurity = dataStoreSettings.getSendOptionSecurityClassification();
        DataStoreSettings.SendOptionReplyRequested sendOptionReplyRequested = dataStoreSettings.getSendOptionReplyRequested();
        DataStoreSettings.SendOptionMimeEncoding sendOptionMimeEncoding = dataStoreSettings.getSendOptionMimeEncoding();
        if (sendOptionPriority != null) {
            itemSendOptions.setPriorityLocked(sendOptionPriority.getPriorityLocked());
            itemSendOptions.setPriority(Priority.getPriority(sendOptionPriority.getPriority()));
        }
        if (sendOptionSecurity != null) {
            itemSendOptions.setSecurityLocked(sendOptionSecurity.getSecurityLocked());
            itemSendOptions.setSecurity(Security.getSecurity(sendOptionSecurity.getSecurityLevel()));
        }
        if (sendOptionReplyRequested != null) {
            itemSendOptions.setReplyRequestLocked(sendOptionReplyRequested.isReplyRequestedLocked());
            itemSendOptions.setReplyRequestDay(sendOptionReplyRequested.getReplyWithinDays());
            itemSendOptions.setReplyRequested(sendOptionReplyRequested.isReplyRequested());
            itemSendOptions.setReplyWhenConvenient(sendOptionReplyRequested.isReplyWhenConvenient());
        }
        if (sendOptionMimeEncoding != null) {
            itemSendOptions.setMimeEncodingType(MimeEncoding.getEncoding(sendOptionMimeEncoding.getMimeEncoding()));
            itemSendOptions.setMimeLocked(sendOptionMimeEncoding.isMimeEncodingLocked());
        }
        if ((notification = this.readNotification(1, 16384)) != null) {
            itemSendOptions.setRNMailOpened(notification);
        }
        if ((notification = this.readNotification(1, 32)) != null) {
            itemSendOptions.setRNMailDeleted(notification);
        }
        if ((notification = this.readNotification(8, 1)) != null) {
            itemSendOptions.setRNAppAccepted(notification);
        }
        if ((notification = this.readNotification(8, 32)) != null) {
            itemSendOptions.setRNAppDeclined(notification);
        }
        if ((notification = this.readNotification(8, 16384)) != null) {
            itemSendOptions.setRNAppOpened(notification);
        }
        if ((notification = this.readNotification(4, 1)) != null) {
            itemSendOptions.setRNTaskAccepted(notification);
        }
        if ((notification = this.readNotification(4, 8)) != null) {
            itemSendOptions.setRNTaskCompleted(notification);
        }
        if ((notification = this.readNotification(4, 32)) != null) {
            itemSendOptions.setRNTaskDeclined(notification);
        }
        if ((notification = this.readNotification(4, 16384)) != null) {
            itemSendOptions.setRNTaskOpened(notification);
        }
        if ((notification = this.readNotification(2, 1)) != null) {
            itemSendOptions.setRNNoteAccepted(notification);
        }
        if ((notification = this.readNotification(2, 32)) != null) {
            itemSendOptions.setRNNoteDeclined(notification);
        }
        if ((notification = this.readNotification(2, 16384)) != null) {
            itemSendOptions.setRNNoteOpened(notification);
        }
        return itemSendOptions;
    }

    public void modifyItemSendOptions(ItemSendOptions itemSendOptions) throws GWCommandException {
        Assertions.assertNotNull(itemSendOptions, "Can't modify items send options to null");
        DataStoreSettings dataStoreSettings = this.currentDataStore.getSettings();
        dataStoreSettings.setSendOptionPriority(itemSendOptions.getPriority().getValue());
        dataStoreSettings.setSendOptionSecurityClassification(itemSendOptions.getSecurity().getValue(), itemSendOptions.getSecurity().toString());
        dataStoreSettings.setSendOptionReplyRequested(itemSendOptions.isReplyRequested(), itemSendOptions.isReplyWhenConvenient(), itemSendOptions.getReplyRequestDay());
        dataStoreSettings.setSendOptionMimeEncoding(itemSendOptions.getMimeEncoding().getValue());
        dataStoreSettings.setSendOptionReturnNotification(1, new int[]{16384, 32}, new boolean[]{itemSendOptions.getRNMailOpened().isMailNotify(), itemSendOptions.getRNMailDeleted().isMailNotify()}, new boolean[]{itemSendOptions.getRNMailOpened().isNotify(), itemSendOptions.getRNMailDeleted().isNotify()});
        dataStoreSettings.setSendOptionReturnNotification(8, new int[]{16384, 1, 32}, new boolean[]{itemSendOptions.getRNAppOpened().isMailNotify(), itemSendOptions.getRNAppAccepted().isMailNotify(), itemSendOptions.getRNAppDeclined().isMailNotify()}, new boolean[]{itemSendOptions.getRNAppOpened().isNotify(), itemSendOptions.getRNAppAccepted().isNotify(), itemSendOptions.getRNAppDeclined().isNotify()});
        dataStoreSettings.setSendOptionReturnNotification(2, new int[]{16384, 1, 32}, new boolean[]{itemSendOptions.getRNNoteOpened().isMailNotify(), itemSendOptions.getRNNoteAccepted().isMailNotify(), itemSendOptions.getRNNoteDeclined().isMailNotify()}, new boolean[]{itemSendOptions.getRNNoteOpened().isNotify(), itemSendOptions.getRNNoteAccepted().isNotify(), itemSendOptions.getRNNoteDeclined().isNotify()});
        dataStoreSettings.setSendOptionReturnNotification(4, new int[]{16384, 1, 32, 8}, new boolean[]{itemSendOptions.getRNTaskOpened().isMailNotify(), itemSendOptions.getRNTaskAccepted().isMailNotify(), itemSendOptions.getRNTaskDeclined().isMailNotify(), itemSendOptions.getRNTaskCompleted().isMailNotify()}, new boolean[]{itemSendOptions.getRNTaskOpened().isNotify(), itemSendOptions.getRNTaskAccepted().isNotify(), itemSendOptions.getRNTaskDeclined().isNotify(), itemSendOptions.getRNTaskCompleted().isNotify()});
    }

    public AbstractItem getEnclosedItem(GWAttachment gWAttachment) throws GWCommandException {
        GWItemAttachment gWItemAttachment;
        AbstractItem abstractItem = null;
        if (gWAttachment instanceof GWItemAttachment) {
            gWItemAttachment = (GWItemAttachment)gWAttachment;
            abstractItem = this.getGWItem(gWItemAttachment.getMessageAttachment());
        } else if (gWAttachment.getNativeAttachment() instanceof MessageAttachment) {
            gWItemAttachment = ((MessageAttachment)gWAttachment.getNativeAttachment()).getMessage();
            abstractItem = this.getGWItem((Message)gWItemAttachment);
        }
        gWItemAttachment = gWAttachment.getNativeAttachment();
        abstractItem.setDisplayType(gWItemAttachment.getDisplayType());
        return abstractItem;
    }

    public TableItem getTableItem(Item item) throws GWCommandException {
        if (item instanceof Message) {
            return this.getGWItem((Message)item);
        }
        if (item instanceof Folder) {
            return this.getGWFolder((Folder)item);
        }
        return new UnknownTableItem(item);
    }

    public AbstractFolder getGWFolder(Folder folder) {
        String string = String.valueOf(folder.getId());
        if (FoldersCache.containsFolder(string, this.currentUserInfo.getGuid())) {
            return FoldersCache.getFolder(string, this.currentUserInfo.getGuid());
        }
        AbstractFolder abstractFolder = this.createGWFolder(folder);
        FoldersCache.addFolder(abstractFolder, this.currentUserInfo.getGuid());
        return abstractFolder;
    }

    public AbstractItem getGWItem(Message message) throws GWCommandException {
        String string = String.valueOf(message.getId());
        if (ItemsCache.containsItem(string, this.currentUserInfo.getGuid())) {
            AbstractItem abstractItem = ItemsCache.getItem(string, this.currentUserInfo.getGuid());
            abstractItem.clear();
            abstractItem.setNativeItem(message);
            if (!ItemListsCache.containsDirty(this.getItemListForItem(abstractItem), this.currentUserInfo.getGuid())) {
                abstractItem.setProcessing(false);
            }
            return abstractItem;
        }
        AbstractItem abstractItem = GWItemFactory.gwObjectToItem(message);
        ItemsCache.putItem(abstractItem, this.currentUserInfo.getGuid());
        return abstractItem;
    }

    public AbstractItem find(String string) throws GWCommandException {
        Item item = this.currentDataStore.findItem(string);
        if (item instanceof Message) {
            return this.getGWItem((Message)item);
        }
        if (item != null) {
            logger.warn((Object)("Invalid object found using GID: [" + string + "]. Object: [" + item + "]"));
        }
        return null;
    }

    public boolean setArchiveLocation(String string) {
        return this.currentDataStore.getSettings().setArchivePath(string);
    }

    public String getArchiveLocation() {
        if (this.currentDataStore.getSettings() == null) {
            return null;
        }
        return this.currentDataStore.getSettings().getArchivePath();
    }

    private static void clearStatics() {
        OptionManager.getInstance().clearOptions();
    }

    public String performProxy(ProxyHistoryEntry proxyHistoryEntry) throws EngineException {
        String string = !this.currentUserInfo.getGuid().equals(proxyHistoryEntry.getGuid()) ? this.switchDataStore(engine.getProxyDataStore(proxyHistoryEntry)) : this.currentUserInfo.getGuid();
        return string;
    }

    private String switchDataStore(DataStore dataStore) {
        EngineCommandManager.clearStatics();
        String string = dataStore.isArchiveDB() ? ARCHIVE_DATA_STORE : (dataStore.isBackupDB() ? BACKUP_DATA_STORE : dataStore.getUserFields().getGuid());
        GWCommandManager.removeFrameRef(this.currentUserInfo.getGuid());
        GWCommandManager.addFrameRef(string);
        if (instances.get(string) == null) {
            instances.put(string, new EngineCommandManager(dataStore));
        }
        return string;
    }

    public String switchToUserMode() {
        String string = this.switchDataStore(userDataStore);
        return string;
    }

    public String switchToArchiveMode() throws GWCommandException {
        String string = this.getArchiveLocation();
        if (!Utils.fileExists(string)) {
            throw new GWCommandException("Archive folder : [" + string + "] can does not exists");
        }
        DataStore dataStore = this.currentDataStore.openArchiveDB(true);
        if (dataStore == null || !dataStore.isArchiveDB()) {
            throw new GWCommandException("Engine failed to switch into Archive mode");
        }
        String string2 = this.switchDataStore(dataStore);
        this.isProxyDataStore = false;
        return string2;
    }

    public void switchOnlineDataStore() {
        this.currentDataStore = userDataStore;
        this.currentUserInfo = userInfo;
        this.isProxyDataStore = false;
    }

    public boolean isArchive() {
        if (this.currentDataStore == null) {
            return false;
        }
        return this.currentDataStore.isArchiveDB();
    }

    public boolean isOnlineDataStore() {
        if (this.currentDataStore == null) {
            return false;
        }
        return this.currentDataStore.isOnline();
    }

    public boolean isCachingDataStore() {
        if (this.currentDataStore == null) {
            return false;
        }
        return this.currentDataStore.isCaching();
    }

    public void archiveItems(IDObjectsCollection iDObjectsCollection) throws GWCommandException {
        if (!this.isArchive() && !Utils.checkArchivePath(this.currentUserInfo.getGuid())) {
            return;
        }
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            AbstractItem abstractItem = (AbstractItem)iDObjectsCollection.getIDObjectAt(i);
            try {
                if (!abstractItem.canArchive()) continue;
                abstractItem.getNativeItem().archive();
                continue;
            }
            catch (EngineException engineException) {
                logger.error((Object)engineException, (Throwable)engineException);
                throw new GWCommandException("Engine error.", "Can't archive message. " + (Object)((Object)engineException), engineException);
            }
        }
    }

    public static String getNativeVersion() {
        return engine.getVersionStringNative();
    }

    public static String getXplatVersion() {
        return engine.getVersionStringJava();
    }

    public static boolean canSwitchCaching() {
        return engine.canSwitchMode(6);
    }

    public static boolean canSwitchOnline() {
        return engine.canSwitchMode(1);
    }

    public void syncDataStore() {
        logger.debug((Object)"syncDataStore entered");
        if (EngineCommandManager.getCurrentMode() == 6) {
            this.currentDataStore.sync();
        }
        logger.debug((Object)"syncDataStore exited");
    }

    public void postItem(AbstractItem abstractItem, SendCallback sendCallback) throws GWCommandException {
        logger.debug((Object)"postItem entered");
        Message message = this.prepareItemToSending(abstractItem);
        message.setDistributionList(null);
        try {
            message.post(this.currentDataStore.getGroupWiseAccount(), sendCallback);
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)engineException), engineException);
        }
        logger.debug((Object)"postItem exited");
    }

    private Message prepareItemToSending(AbstractItem abstractItem) {
        MessageBody messageBody = abstractItem.getMessage();
        Message message = abstractItem.getNativeItem();
        String string = messageBody.getMessage();
        if (!"".equals(string)) {
            message.setBodyText(string);
        }
        abstractItem.setProcessing(true);
        ItemListsCache.addDirty(this.getItemListForItem(abstractItem), this.currentUserInfo.getGuid());
        abstractItem.setMessage(new MessageBody(abstractItem.getID()));
        EngineCommandManager.setDistributionList(abstractItem, message);
        if (message instanceof Appointment) {
            AppointmentItem appointmentItem = (AppointmentItem)abstractItem;
            Appointment appointment = (Appointment)message;
            EngineCommandManager.prepareAppointment(appointment, appointmentItem);
        } else if (message instanceof Task) {
            TaskItem taskItem = (TaskItem)abstractItem;
            Task task = (Task)message;
            EngineCommandManager.prepareTask(taskItem, task);
        } else if (message instanceof Note) {
            ReminderNote reminderNote = (ReminderNote)abstractItem;
            Note note = (Note)message;
            EngineCommandManager.prepareNote(reminderNote, note);
        } else if (message instanceof PhoneMessage) {
            // empty if block
        }
        return message;
    }

    private static void prepareNote(ReminderNote reminderNote, Note note) {
        note.setAutoDate(reminderNote.getStartDates(), 0L);
    }

    private static void prepareTask(TaskItem taskItem, Task task) {
        logger.debug((Object)":: prepareTask entered");
        String string = taskItem.getTaskPriority();
        if (string.length() > 0) {
            char c = string.charAt(0);
            if (Character.isLetter(c) && task.setTaskCategory(c)) {
                string = string.substring(1);
            }
            if (string.length() > 0) {
                try {
                    task.setTaskPriority(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error((Object)numberFormatException, (Throwable)numberFormatException);
                }
            }
        }
        logger.debug((Object)(":: task start date: [" + taskItem.getStartDate() + "]"));
        logger.debug((Object)(":: task end date: [" + taskItem.getEndDate() + "]"));
        task.setAutoDate(taskItem.getStartDates(), 0L);
        task.setDueDate(taskItem.getEndDate());
        logger.debug((Object)(":: native task date: [" + task.getDate() + "]"));
        logger.debug((Object)(":: native task due to date: [" + task.getDueDate() + "]"));
        logger.debug((Object)":: prepareTask exited");
    }

    private static void prepareAppointment(Appointment appointment, AppointmentItem appointmentItem) {
        logger.debug((Object)":: prepareAppointment entered");
        appointment.setPlace(appointmentItem.getLocation());
        Date[] dateArray = appointmentItem.getStartDates();
        logger.debug((Object)(":: appointment start dates: [" + dateArray + ']'));
        logger.debug((Object)(":: appointment start date0: [" + dateArray[0] + "]"));
        long l = EngineUtils.timeToFlaimTime((long)appointmentItem.getDuration());
        appointment.setAutoDate(dateArray, l);
        logger.debug((Object)(":: native appointment date: [" + appointment.getDate() + ']'));
        logger.debug((Object)":: prepareAppointment exited");
    }

    private static void setDistributionList(AbstractItem abstractItem, Message message) {
        DistributionList distributionList = new DistributionList();
        List list = abstractItem.getRecipientsList();
        for (int i = 0; i < list.size(); ++i) {
            Recipient recipient = (Recipient)list.get(i);
            distributionList.addRecipient(recipient);
        }
        message.setDistributionList(distributionList);
    }

    public void modifyItem(AbstractItem abstractItem, SendCallback sendCallback) throws UnresolvedAddressException {
        logger.debug((Object)"modifyItem entered");
        Message message = this.prepareItemToSending(abstractItem);
        message.setDistributionList(null);
        try {
            message.modify(sendCallback);
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            throw unresolvedAddressException;
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
        }
        logger.debug((Object)"modifyItem exited");
    }

    public static AbstractAddressBook getContactsFolderAddressBook() {
        com.novell.gw.ab.PersonalAddressBook personalAddressBook = ((com.novell.gw.folder.ContactsFolder)EngineCommandManager.getContactsFolder().getNativeFolder()).getAddressBook(userDataStore.getAddressBookManager());
        if (personalAddressBook != null) {
            return AddressBookItemsFactory.createAddressBook((AddressBook)personalAddressBook);
        }
        return null;
    }

    public static AbstractAddressBook getContactAddressBook(Contact contact) {
        AddressBook addressBook = userDataStore.getAddressBookManager().getAddressBook(contact.getBookId());
        return AddressBookItemsFactory.createAddressBook(addressBook);
    }

    public static AbstractAddressBook getAddressBook(String string) {
        AddressBook addressBook = userDataStore.getAddressBookManager().getAddressBook(Integer.parseInt(string));
        return AddressBookItemsFactory.createAddressBook(addressBook);
    }

    public static IDObjectsCollection getEditableAddressBooks() {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        iDObjectsCollection = EngineCommandManager.getDirectories();
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            if (!((AbstractAddressBook)iDObjectsCollection.getIDObjectAt(i)).isReadOnly()) continue;
            iDObjectsCollection.removeIDObject(iDObjectsCollection.getIDObjectAt(i));
        }
        return iDObjectsCollection;
    }

    public void setCachingPath(String string) {
        engine.setPathToCache(string);
    }

    public static AddressBookManager getAddressBookManager() {
        return userDataStore.getAddressBookManager();
    }

    public static EngineCallBackListener getCallBackListener() {
        return callback;
    }

    public AbstractItem getNextItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        ItemList itemList = this.getItemListForItem(abstractItem);
        int n = itemList.indexOf((Item)message);
        return this.getItemAt(itemList, ++n);
    }

    public AbstractItem getPrevItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        ItemList itemList = this.getItemListForItem(abstractItem);
        int n = itemList.indexOf((Item)message);
        return this.getItemAt(itemList, --n);
    }

    private AbstractItem getItemAt(ItemList itemList, int n) {
        Item item = itemList.getItemAt(n);
        try {
            TableItem tableItem = this.getTableItem(item);
            if (tableItem instanceof AbstractItem) {
                return (AbstractItem)tableItem;
            }
        }
        catch (GWCommandException gWCommandException) {
            logger.error((Object)gWCommandException, (Throwable)gWCommandException);
        }
        return null;
    }

    public boolean hasNextItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        ItemList itemList = this.getItemListForItem(abstractItem);
        int n = itemList.indexOf((Item)message);
        return EngineCommandManager.hasItemAt(itemList, ++n);
    }

    private static boolean hasItemAt(ItemList itemList, int n) {
        Item item;
        int n2 = itemList.getSize();
        return n < n2 && n >= 0 && (item = itemList.getItemAt(n)) instanceof Message;
    }

    public boolean hasPrevItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        ItemList itemList = this.getItemListForItem(abstractItem);
        int n = itemList.indexOf((Item)message);
        return EngineCommandManager.hasItemAt(itemList, --n);
    }

    public ItemList getItemListForItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        AbstractFolder abstractFolder = this.getGWFolder(message.getViewFolder());
        ItemList itemList = abstractFolder.getItemList();
        return itemList;
    }

    public static AccountSettings getAccountSettings() {
        return userDataStore.getAccountSettings();
    }

    public static Account[] getAccounts() {
        return userDataStore.getAccounts();
    }

    private Notification readNotification(int n, int n2) {
        DataStoreSettings.SendOptionNotification sendOptionNotification = null;
        DataStoreSettings dataStoreSettings = this.currentDataStore.getSettings();
        if (dataStoreSettings != null) {
            sendOptionNotification = dataStoreSettings.getSendOptionReturnNotification(n, n2);
        }
        return Notification.getNotification(sendOptionNotification);
    }

    public ProxyAccessList getProxyAccessList() {
        return this.currentDataStore.getProxyAccessList();
    }

    public static ProxyHistoryList getProxyHistoryList() {
        return userDataStore.getProxyHistoryList();
    }

    public static void cancelSync() {
        engine.cancelSync();
    }

    public static void relogin() throws EngineException {
        userDataStore = engine.relogin();
        userInfo = EngineCommandManager.createUserInfo(userDataStore);
        instances.put(userInfo.getGuid(), new EngineCommandManager(userDataStore));
    }

    public static void setOnlinePassword(String string, String string2) {
        logger.debug((Object)"changeOnlinePassword entered");
        userDataStore.setOnlineMailboxPassword(string, string2);
        userInfo.setPassword("");
        logger.debug((Object)"changeOnlinePassword exited");
    }

    public AbstractItem composeNewItem(Class clazz) throws GWCommandException {
        return this.composeNewItem(clazz, null);
    }

    public AbstractItem composeNewItem(Class clazz, AbstractFolder abstractFolder) throws GWCommandException {
        AbstractItem abstractItem = null;
        Appointment appointment = null;
        if ((class$com$novell$gw$jclient$bl$om$items$AppointmentItem == null ? (class$com$novell$gw$jclient$bl$om$items$AppointmentItem = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.items.AppointmentItem")) : class$com$novell$gw$jclient$bl$om$items$AppointmentItem).equals(clazz)) {
            appointment = abstractFolder == null ? new Appointment(this.currentDataStore) : new Appointment(this.currentDataStore, abstractFolder.getNativeFolder());
            abstractItem = new AppointmentItem((Note)appointment);
        } else if ((class$com$novell$gw$jclient$bl$om$items$ReminderNote == null ? (class$com$novell$gw$jclient$bl$om$items$ReminderNote = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.items.ReminderNote")) : class$com$novell$gw$jclient$bl$om$items$ReminderNote).equals(clazz)) {
            appointment = abstractFolder == null ? new Note(this.currentDataStore) : new Note(this.currentDataStore, abstractFolder.getNativeFolder());
            abstractItem = new ReminderNote((Note)appointment);
        } else if ((class$com$novell$gw$jclient$bl$om$items$TaskItem == null ? (class$com$novell$gw$jclient$bl$om$items$TaskItem = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.items.TaskItem")) : class$com$novell$gw$jclient$bl$om$items$TaskItem).equals(clazz)) {
            appointment = abstractFolder == null ? new Task(this.currentDataStore) : new Task(this.currentDataStore, abstractFolder.getNativeFolder());
            abstractItem = new TaskItem((Note)((Task)appointment));
        } else if ((class$com$novell$gw$jclient$bl$om$items$DocumentItem == null ? (class$com$novell$gw$jclient$bl$om$items$DocumentItem = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.items.DocumentItem")) : class$com$novell$gw$jclient$bl$om$items$DocumentItem).equals(clazz)) {
            appointment = new DocumentReference(this.currentDataStore);
            abstractItem = new DocumentItem((Message)appointment);
        } else if ((class$com$novell$gw$jclient$bl$om$items$MailItem == null ? (class$com$novell$gw$jclient$bl$om$items$MailItem = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.items.MailItem")) : class$com$novell$gw$jclient$bl$om$items$MailItem).equals(clazz)) {
            appointment = abstractFolder == null ? new Mail(this.currentDataStore) : new Mail(this.currentDataStore, abstractFolder.getNativeFolder());
            abstractItem = new MailItem((Message)appointment);
        } else if ((class$com$novell$gw$jclient$bl$om$items$PhoneItem == null ? (class$com$novell$gw$jclient$bl$om$items$PhoneItem = EngineCommandManager.class$("com.novell.gw.jclient.bl.om.items.PhoneItem")) : class$com$novell$gw$jclient$bl$om$items$PhoneItem).equals(clazz)) {
            appointment = abstractFolder == null ? new PhoneMessage(this.currentDataStore) : new PhoneMessage(this.currentDataStore, abstractFolder.getNativeFolder());
            abstractItem = new PhoneItem((Message)appointment);
        } else {
            throw new GWCommandException("Operation for given object type [" + clazz.getName() + "]is not supported");
        }
        return abstractItem;
    }

    public QueryFolder find(String string, String string2, String string3, String string4) {
        return (QueryFolder)this.createGWFolder(this.currentDataStore.find(string, string2, string3, string4, ""));
    }

    public static boolean canExit() {
        return engine.canDispose();
    }

    public AbstractItem getNextUnreadItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        ItemList itemList = this.getItemListForItem(abstractItem);
        int n = itemList.indexOf((Item)message);
        for (int i = ++n; i < itemList.getSize(); ++i) {
            Message message2;
            Item item = itemList.getItemAt(i);
            if (!(item instanceof Message) || GWItemFactory.isMessageReaded(message2 = (Message)item)) continue;
            return this.getItemAt(itemList, i);
        }
        return null;
    }

    public AbstractItem getPrevUnreadItem(AbstractItem abstractItem) {
        Message message = abstractItem.getNativeItem();
        ItemList itemList = this.getItemListForItem(abstractItem);
        int n = itemList.indexOf((Item)message);
        for (int i = --n; i >= 0; --i) {
            Message message2;
            Item item = itemList.getItemAt(i);
            if (!(item instanceof Message) || GWItemFactory.isMessageReaded(message2 = (Message)item)) continue;
            return this.getItemAt(itemList, i);
        }
        return null;
    }

    public TableItem getFirstItem(AbstractFolder abstractFolder) {
        boolean bl = ApplicationOptions.getInstance().getBoolean("QUICKVIEWER_VISIBLE", false);
        boolean bl2 = abstractFolder.isSelectFirstUnreadItemState();
        ItemList itemList = abstractFolder.getItemList();
        int n = -1;
        if (bl2) {
            n = itemList.getFirstUnreadItemIndex(bl);
        }
        int n2 = itemList.getSize();
        if (n < 0 || n >= n2) {
            n = 0;
        }
        try {
            Item item = null;
            while (n >= 0 && n < n2 && !((item = itemList.getItemAt(n)) instanceof Message)) {
                ++n;
            }
            if (item != null) {
                return this.getTableItem(item);
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
        }
        return null;
    }

    public AbstractItem getLastUnreadItem(AbstractFolder abstractFolder) {
        ItemList itemList = abstractFolder.getItemList();
        for (int i = itemList.getSize() - 1; i >= 0; --i) {
            Message message;
            Item item = itemList.getItemAt(i);
            if (!(item instanceof Message) || GWItemFactory.isMessageReaded(message = (Message)item)) continue;
            return this.getItemAt(itemList, i);
        }
        return null;
    }

    public static void setNCCSearchOrder(AddressBook[] addressBookArray) {
        userDataStore.getAddressBookManager().setSearchOrder(addressBookArray);
    }

    public static AddressBook[] getNCCSearchOrder() {
        return userDataStore.getAddressBookManager().getSearchOrder();
    }

    public boolean isProxyDataStore() {
        return this.isProxyDataStore;
    }

    public void saveDraft(AbstractItem abstractItem, String string, SendCallback sendCallback) throws UnresolvedAddressException {
        Message message = this.prepareItemToSending(abstractItem);
        message.saveDraft(string, sendCallback);
        abstractItem.setSaved(true);
    }

    public void modifyDraft(AbstractItem abstractItem, SaveCallBack saveCallBack) throws EngineException, UnresolvedAddressException {
        Message message = this.prepareItemToSending(abstractItem);
        message.modify((SendCallback)saveCallBack);
    }

    public String getProxyUserName() {
        String string = this.currentDataStore.getUserFullName();
        if (string == null || "".equals(string)) {
            string = this.currentDataStore.getUserId();
        }
        return string;
    }

    public DataStore getCurrentDataStore() {
        return this.currentDataStore;
    }

    public boolean isJunkMailMasterEnabled() {
        return this.currentDataStore.getJunkMail().isJunkMailMasterEnabled();
    }

    public JunkMailSettings getJunkMailSettings() {
        return this.currentDataStore.getJunkMail().getSettings();
    }

    public JunkMailListManager getJunkMailListManager() throws EngineException {
        return this.currentDataStore.getJunkMail().getListManager();
    }

    public void setJunkMailSettings(JunkMailSettings junkMailSettings) throws GWCommandException {
        try {
            this.currentDataStore.getJunkMail().setSettings(junkMailSettings);
        }
        catch (EngineException engineException) {
            logger.error((Object)engineException, (Throwable)engineException);
            throw new GWCommandException("Engine error.", "Internal error. " + (Object)((Object)engineException), engineException);
        }
    }

    public Rule createRule() {
        return new Rule(this.currentDataStore);
    }

    public static String getResourceString(int n) {
        return engine.getResourceString(n);
    }

    public boolean performBackupOnDB(boolean bl, boolean bl2) {
        return this.currentDataStore.performBackupOnDB(bl, bl2);
    }

    public String openBackupDB() throws GWCommandException {
        if (instances.get(BACKUP_DATA_STORE) == null) {
            DataStore dataStore = this.currentDataStore.openBackupDB();
            if (dataStore != null) {
                return this.switchDataStore(dataStore);
            }
            throw new GWCommandException("Engine failed to switch into backup mode");
        }
        return this.switchDataStore(((EngineCommandManager)EngineCommandManager.instances.get((Object)BACKUP_DATA_STORE)).currentDataStore);
    }

    public boolean isBackupDB() {
        return this.currentDataStore.isBackupDB();
    }

    public DataStoreSettings getDataStoreSettings() {
        return this.currentDataStore.getSettings();
    }

    public Enumeration getDisplaySettingsEnumeration(int n) {
        if (this.isProxyDataStore) {
            return userDataStore.getDisplaySettingsEnumeration(n);
        }
        return this.currentDataStore.getDisplaySettingsEnumeration(n);
    }

    public Filter createRuleFilter() {
        return new Filter(this.currentDataStore, true);
    }

    public AbstractFolder findFolderInCurrentDataStore(AbstractFolder abstractFolder) {
        Folder folder = userDataStore.findFolder(abstractFolder.getNativeFolder(), this.getCurrentDataStore());
        return this.getGWFolder(folder);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        foldersChangeListener = new FoldersChangeListener();
    }
}

