/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl;

import com.appframework.components.GWTextArea;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import org.apache.log4j.Logger;

public class StatusWindowFrame
extends JFrame {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$eng_impl$StatusWindowFrame == null ? (class$com$novell$gw$jclient$bl$eng_impl$StatusWindowFrame = StatusWindowFrame.class$("com.novell.gw.jclient.bl.eng_impl.StatusWindowFrame")) : class$com$novell$gw$jclient$bl$eng_impl$StatusWindowFrame));
    private JTextArea taLog;
    private JProgressBar progress;
    private JButton btnHide;
    private JLabel time;
    private JButton btnCancel;
    private LeftTimer timer;
    long startTime;
    private SimpleDateFormat format;
    private DateFormat localFormat;
    private boolean doOutput = true;
    private JCheckBox chkAutoShow;
    private boolean doAutoShow;
    private boolean isManualyOpened = false;
    private final Color BORDER_COLOR = Color.LIGHT_GRAY.darker();
    private boolean isLeftToRight = true;
    private CompListener boundsListener;
    private String WINH_KEY = "SYNCFRAME.WIN_HEIGHT";
    private String WINW_KEY = "SYNCFRAME.WIN_WIDTH";
    private String WINX_KEY = "SYNCFRAME.WIN_X";
    private String WINY_KEY = "SYNCFRAME.WIN_Y";
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$eng_impl$StatusWindowFrame;

    public StatusWindowFrame() {
        this.setFocusableWindowState(false);
        this.format = new SimpleDateFormat("HH:mm:ss");
        this.format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.localFormat = GWCalendarUtils.getTimeFormatMedium();
        this.isLeftToRight = UIUtils.getComponentOrientation().isLeftToRight();
        this.boundsListener = new CompListener();
        this.timer = new LeftTimer(100, new TimeTickAction());
        this.buildUI();
        this.initFrame();
        this.makeNonFocusable();
        this.taLog.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (OS.isLeftMouseButton(mouseEvent) && !StatusWindowFrame.this.getFocusableWindowState()) {
                    StatusWindowFrame.this.setFocusableWindowState(true);
                }
            }
        });
        this.pack();
    }

    private void makeNonFocusable() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            component.setFocusable(false);
        }
    }

    private void buildUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        jPanel.setComponentOrientation(UIUtils.getComponentOrientation());
        OrientablePanel orientablePanel = new OrientablePanel();
        orientablePanel.setLayout(new BorderLayout());
        OrientablePanel orientablePanel2 = new OrientablePanel(new BorderLayout());
        this.taLog = new GWTextArea();
        this.taLog.setForeground(Color.BLUE);
        this.taLog.setBackground(Color.LIGHT_GRAY);
        this.taLog.setEditable(false);
        this.taLog.setBorder(new EmptyBorder(10, 10, 10, 10));
        OrientableScrollPane orientableScrollPane = new OrientableScrollPane(this.taLog);
        orientablePanel2.add((Component)orientableScrollPane, "Center");
        OrientablePanel orientablePanel3 = new OrientablePanel(new BorderLayout());
        orientablePanel3.add((Component)orientablePanel2, "Center");
        this.progress = new JProgressBar();
        this.progress.setBackground(Color.LIGHT_GRAY);
        this.progress.setBorder(new LineBorder(Color.DARK_GRAY));
        this.progress.setBorderPainted(true);
        this.progress.setMinimum(0);
        this.progress.setStringPainted(true);
        this.progress.setComponentOrientation(UIUtils.getComponentOrientation());
        orientablePanel3.add((Component)this.progress, "South");
        OrientablePanel orientablePanel4 = new OrientablePanel(new GridBagLayout());
        orientablePanel4.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        OrientablePanel orientablePanel5 = new OrientablePanel(new BorderLayout());
        orientablePanel5.setBorder(null);
        this.time = new JLabel();
        this.time.setForeground(Color.GRAY);
        orientablePanel5.add((Component)this.time, "After");
        gridBagConstraints.anchor = 22;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        orientablePanel4.add((Component)orientablePanel5, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        OrientablePanel orientablePanel6 = new OrientablePanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.btnHide = new JButton(StringResources.HIDE);
        this.btnHide.addActionListener(new HideButtonActionListener());
        gridBagConstraints2.insets = new Insets(2, 0, 2, 2);
        gridBagConstraints2.fill = 0;
        orientablePanel6.add((Component)this.btnHide, gridBagConstraints2);
        this.btnCancel = new JButton(StringResources.CANCEL);
        this.btnCancel.setEnabled(false);
        this.btnCancel.addActionListener(new CancelButtonActionListener());
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.insets = new Insets(2, 10, 2, 2);
        orientablePanel6.add((Component)this.btnCancel, gridBagConstraints2);
        this.chkAutoShow = new OrientableCheckBox();
        this.chkAutoShow.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                StatusWindowFrame.this.doAutoShow = !StatusWindowFrame.this.doAutoShow;
                logger.debug((Object)("!Storing autoshow status window = " + StatusWindowFrame.this.doAutoShow));
                EngineCommandManager.getAccountSettings().setSyncStatusWindowEnabled(StatusWindowFrame.this.doAutoShow);
            }
        });
        this.chkAutoShow.setText(StringResources.SHOW_DURING_SEND_RETRIEVE);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        orientablePanel4.add((Component)this.chkAutoShow, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(2, 10, 2, 2);
        gridBagConstraints.fill = 0;
        orientablePanel4.add((Component)orientablePanel6, gridBagConstraints);
        orientablePanel.add((Component)orientablePanel3, "Center");
        orientablePanel.add((Component)orientablePanel4, "South");
        jPanel.add((Component)orientablePanel, "Center");
        LineBorder lineBorder = new LineBorder(this.BORDER_COLOR, 4);
        jPanel.setBorder(lineBorder);
    }

    private void initFrame() {
        this.setTitle(StringResources.UPDATING_MAILBOX);
        this.setIconImage(ImageResources.GW_ICON.getImage());
    }

    public boolean showDuringSendReceive() {
        return this.chkAutoShow.isSelected();
    }

    public void setProgressMax(int n) {
        this.progress.setMaximum(n);
    }

    public void setProgressCurrect(int n) {
        this.progress.setValue(n);
    }

    public void setStatus(String string) {
        this.progress.setString(string);
    }

    public synchronized void updateLog(String string) {
        if (this.doOutput) {
            int n = this.taLog.getDocument().getLength();
            if (n > 10000) {
                try {
                    this.taLog.getDocument().remove(0, 2000);
                }
                catch (BadLocationException badLocationException) {
                    logger.error((Object)badLocationException, (Throwable)badLocationException);
                }
            }
            long l = System.currentTimeMillis();
            String string2 = this.localFormat.format(new Date(l));
            if (string != null && string.length() > 0) {
                this.taLog.append(this.isLeftToRight ? string2 + ' ' + string + '\n' : string + ' ' + string2 + '\n');
            }
            this.scrollDown();
        }
    }

    private void scrollDown() {
        Rectangle rectangle = new Rectangle(this.taLog.getVisibleRect().width, 20);
        rectangle.x = 0;
        rectangle.y = this.taLog.getBounds().height - 20;
        this.taLog.scrollRectToVisible(rectangle);
    }

    private synchronized void doHide() {
        GWClient.getApplication().processCommand(new GlobalCommand(850));
        this.isManualyOpened = false;
        super.hide();
    }

    private void doCancel() {
        EngineCommandManager.cancelSync();
        GWClient.getApplication().processCommand(new GlobalCommand(910));
    }

    public void hide() {
        if (this.isShowing()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doHide();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new HideRunner());
                }
                catch (InterruptedException interruptedException) {
                    logger.error((Object)interruptedException, (Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
                }
            }
        }
    }

    public void startTimer() {
        this.timer.start();
    }

    public void stopTimer() {
        this.timer.stop();
    }

    private synchronized void doShow() {
        this.doAutoShow = EngineCommandManager.getAccountSettings().isSyncStatusWindowEnabled();
        logger.debug((Object)("!Getting autoshow status window = " + this.doAutoShow));
        this.chkAutoShow.setSelected(this.doAutoShow);
        GWClient.getApplication().processCommand(new GlobalCommand(860));
        this.doUpdateSizeLocation();
        this.setFocusableWindowState(this.isManualyOpened);
        this.taLog.select(0, 0);
        this.taLog.scrollRectToVisible(new Rectangle());
        super.show();
    }

    private void doUpdateSizeLocation() {
        logger.debug((Object)"doUpdateSizeLocation entered");
        this.removeComponentListener(this.boundsListener);
        if (EngineCommandManager.getUserInfo() == null) {
            logger.debug((Object)"user = null");
            UIUtils.setPrefferedWindowSize(360, 400, this);
            UIUtils.centerWindowOnScreen(this);
        } else {
            logger.debug((Object)"get FrameParameters");
            int n = ApplicationOptions.getInstance().getInteger(this.WINH_KEY, 400);
            int n2 = ApplicationOptions.getInstance().getInteger(this.WINW_KEY, 360);
            int n3 = ApplicationOptions.getInstance().getInteger(this.WINX_KEY, 0);
            int n4 = ApplicationOptions.getInstance().getInteger(this.WINY_KEY, 0);
            Rectangle rectangle = new Rectangle(n3, n4, n2, n);
            if (this.checkBounds(rectangle)) {
                logger.debug((Object)"check bounds = TRUE");
                UIUtils.setPrefferedWindowSizeLocation(this, n, n3, n4);
            } else {
                logger.debug((Object)"check bounds = FALSE");
                UIUtils.setPrefferedWindowSize(360, 400, this);
                UIUtils.centerWindowOnScreen(this);
            }
        }
        this.addComponentListener(this.boundsListener);
        logger.debug((Object)"doUpdateSizeLocation exited");
    }

    public void show() {
        if (!this.isShowing()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doShow();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new ShowRunner());
                }
                catch (InterruptedException interruptedException) {
                    logger.error((Object)interruptedException, (Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
                }
            }
        }
    }

    private synchronized void doUpdateTime() {
        long l = System.currentTimeMillis();
        long l2 = l - this.startTime;
        String string = this.format.format(new Date(l2));
        this.time.setText(StringResources.formatString(StringResources.TIME_ELAPSED_C, new String[]{string}));
    }

    private void updateTime() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateTime();
        } else {
            try {
                SwingUtilities.invokeAndWait(new TimerUpdateRunner());
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)interruptedException, (Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
            }
        }
    }

    public void switchView() {
        if (this.isVisible()) {
            this.isManualyOpened = false;
            this.dispose();
        } else {
            this.isManualyOpened = true;
            this.show();
        }
    }

    public boolean isManualyOpened() {
        return this.isManualyOpened && this.doAutoShow;
    }

    private void updateParams() {
        logger.debug((Object)"updateParams entered");
        Rectangle rectangle = this.getBounds();
        if (this.checkBounds(rectangle)) {
            ApplicationOptions.getInstance().put(this.WINH_KEY, new Integer(rectangle.height));
            ApplicationOptions.getInstance().put(this.WINW_KEY, new Integer(rectangle.width));
            ApplicationOptions.getInstance().put(this.WINX_KEY, new Integer(rectangle.x));
            ApplicationOptions.getInstance().put(this.WINY_KEY, new Integer(rectangle.y));
        }
        logger.debug((Object)"updateParams exited");
    }

    private boolean checkBounds(Rectangle rectangle) {
        double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double d3 = rectangle.getX();
        double d4 = rectangle.getY();
        double d5 = rectangle.getWidth();
        double d6 = rectangle.getHeight();
        double d7 = d2 - 200.0;
        double d8 = d - 200.0;
        return !(d3 < 0.0 || d4 < 0.0 || d3 > d8 || d4 > d7 || d6 > d7) && !(d5 > d8);
    }

    public void setSyncStarted(boolean bl) {
        this.btnCancel.setEnabled(bl);
    }

    private void showMe() {
        super.show();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class TitleListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Point pointPressed = null;

        private TitleListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.pointPressed = mouseEvent.getPoint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.pointPressed = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = this.pointPressed;
            synchronized (point) {
                if (this.pointPressed == null) {
                    return;
                }
                StatusWindowFrame statusWindowFrame = StatusWindowFrame.this;
                Point point2 = mouseEvent.getPoint();
                point2.translate(-this.pointPressed.x, -this.pointPressed.y);
                SwingUtilities.convertPointToScreen(point2, statusWindowFrame);
                statusWindowFrame.setLocation(point2);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class CompListener
    extends ComponentAdapter {
        private CompListener() {
        }

        public void componentResized(ComponentEvent componentEvent) {
            StatusWindowFrame.this.updateParams();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            StatusWindowFrame.this.updateParams();
        }
    }

    private class HideRunner
    implements Runnable {
        private HideRunner() {
        }

        public void run() {
            StatusWindowFrame.this.doHide();
        }
    }

    private class ShowRunner
    implements Runnable {
        private ShowRunner() {
        }

        public void run() {
            StatusWindowFrame.this.doShow();
        }
    }

    private class TimerUpdateRunner
    implements Runnable {
        private TimerUpdateRunner() {
        }

        public void run() {
            StatusWindowFrame.this.doUpdateTime();
        }
    }

    private class TimeTickAction
    implements ActionListener {
        private TimeTickAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusWindowFrame.this.updateTime();
        }
    }

    private class LeftTimer
    extends Timer {
        public LeftTimer(int n, ActionListener actionListener) {
            super(n, actionListener);
        }

        public void start() {
            StatusWindowFrame.this.startTime = System.currentTimeMillis();
            super.start();
        }
    }

    private class CancelButtonActionListener
    implements ActionListener {
        private CancelButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusWindowFrame.this.doCancel();
        }
    }

    private class HideButtonActionListener
    implements ActionListener {
        private HideButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusWindowFrame.this.dispose();
        }
    }
}

