/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.eng_impl.utils;

import com.novell.gw.engine.DisplayColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfo;
import com.novell.gw.jclient.bl.eng_impl.utils.SortOrder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ColumnInfos
implements Cloneable,
Serializable {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$eng_impl$utils$ColumnInfos == null ? (class$com$novell$gw$jclient$bl$eng_impl$utils$ColumnInfos = ColumnInfos.class$("com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos")) : class$com$novell$gw$jclient$bl$eng_impl$utils$ColumnInfos));
    private ArrayList infos = new ArrayList();
    private String type;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$eng_impl$utils$ColumnInfos;

    public ColumnInfos() {
    }

    public ColumnInfos(DisplayColumnInfo[] displayColumnInfoArray) {
        this();
        if (displayColumnInfoArray == null) {
            throw new IllegalArgumentException("Input paramether can not be NULL");
        }
        for (int i = 0; i < displayColumnInfoArray.length; ++i) {
            DisplayColumnInfo displayColumnInfo = displayColumnInfoArray[i];
            if (displayColumnInfo == null) continue;
            this.infos.add(new ColumnInfo(displayColumnInfo));
        }
    }

    public void add(int n, ColumnInfo columnInfo) {
        this.infos.add(n, columnInfo);
    }

    public boolean add(ColumnInfo columnInfo) {
        return this.infos.add(columnInfo);
    }

    public ColumnInfo remove(int n) {
        return (ColumnInfo)this.infos.remove(n);
    }

    public boolean remove(ColumnInfo columnInfo) {
        return this.infos.remove(columnInfo);
    }

    public void clear() {
        this.infos.clear();
    }

    public int size() {
        return this.infos.size();
    }

    public ColumnInfo get(int n) {
        return (ColumnInfo)this.infos.get(n);
    }

    public ColumnInfo getSorted() {
        for (int i = 0; i < this.infos.size(); ++i) {
            ColumnInfo columnInfo = (ColumnInfo)this.infos.get(i);
            if (columnInfo == null || !columnInfo.isSorted()) continue;
            return columnInfo;
        }
        return null;
    }

    public ColumnInfo[] toArray() {
        return this.infos.toArray(new ColumnInfo[0]);
    }

    public DisplayColumnInfo[] getNativeColumnInfos() {
        DisplayColumnInfo[] displayColumnInfoArray = new DisplayColumnInfo[this.infos.size()];
        for (int i = 0; i < this.infos.size(); ++i) {
            ColumnInfo columnInfo = (ColumnInfo)this.infos.get(i);
            displayColumnInfoArray[i] = columnInfo.getNativeColumnInfo();
        }
        return displayColumnInfoArray;
    }

    public String getColumnsListAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.infos.size();
        for (int i = 0; i < n; ++i) {
            ColumnInfo columnInfo = (ColumnInfo)this.infos.get(i);
            stringBuffer.append(columnInfo.getName());
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ColumnInfos columnInfos = (ColumnInfos)super.clone();
        columnInfos.type = this.type;
        columnInfos.infos = new ArrayList();
        for (int i = 0; i < this.infos.size(); ++i) {
            ColumnInfo columnInfo = (ColumnInfo)this.infos.get(i);
            columnInfos.infos.add(columnInfo.clone());
        }
        return columnInfos;
    }

    void addColumnInfo(ColumnInfo columnInfo) {
        this.infos.add(columnInfo);
    }

    public String getType() {
        return this.type;
    }

    private void clearSortInfos() {
        for (int i = 0; i < this.infos.size(); ++i) {
            ((ColumnInfo)this.infos.get(i)).setSorted(false);
        }
    }

    public ColumnInfo getColumnInfo(int n) {
        ColumnInfo columnInfo = null;
        for (int i = 0; i < this.infos.size(); ++i) {
            ColumnInfo columnInfo2 = (ColumnInfo)this.infos.get(i);
            if (columnInfo2.getFieldID() != n) continue;
            columnInfo = columnInfo2;
            break;
        }
        return columnInfo;
    }

    public void setSortColumn(ColumnInfo columnInfo, SortOrder sortOrder) {
        if (this.infos.contains(columnInfo)) {
            this.clearSortInfos();
            columnInfo.setSortOrder(sortOrder);
        } else {
            this.setSortColumn(columnInfo.getFieldID(), sortOrder);
        }
    }

    public void setSortColumn(int n, SortOrder sortOrder) {
        ColumnInfo columnInfo = this.getColumnInfo(n);
        if (columnInfo != null) {
            this.clearSortInfos();
            columnInfo.setSortOrder(sortOrder);
        }
    }

    public void moveInfos(ColumnInfo columnInfo, ColumnInfo columnInfo2) {
        if (this.infos.contains(columnInfo) && this.infos.contains(columnInfo2)) {
            int n = this.infos.indexOf(columnInfo);
            int n2 = this.infos.indexOf(columnInfo2);
            Collections.swap(this.infos, n, n2);
        }
    }

    public static ColumnInfos getDifferenceByFieldID(ColumnInfos columnInfos, ColumnInfos columnInfos2) throws CloneNotSupportedException {
        ColumnInfos columnInfos3 = (ColumnInfos)columnInfos.clone();
        Iterator iterator = columnInfos3.infos.iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            if (columnInfos2.getColumnInfo(columnInfo.getFieldID()) == null) continue;
            iterator.remove();
        }
        return columnInfos3;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof ColumnInfos && this.doEquals((ColumnInfos)object);
    }

    private boolean doEquals(ColumnInfos columnInfos) {
        if (this.getColumnsListAsString().equals(columnInfos.getColumnsListAsString()) && this.infos.size() == columnInfos.infos.size()) {
            for (int i = 0; i < this.infos.size(); ++i) {
                if (this.infos.get(i).equals(columnInfos.infos.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ColumnInfo getColumnInfoAt(int n) {
        return (ColumnInfo)this.infos.get(n - 1);
    }

    public boolean removeColumnInfoAt(int n) {
        return this.remove(this.getColumnInfoAt(n));
    }

    public int getIndexOf(ColumnInfo columnInfo) {
        return this.infos.indexOf(columnInfo) + 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Column infos: [");
        Iterator iterator = this.infos.iterator();
        while (iterator.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)iterator.next();
            stringBuffer.append("[").append("name = ").append(columnInfo.getName()).append(", width = ").append(columnInfo.getWidth()).append("]");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

