/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.folders;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.utils.Assertions;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.folder.Folder;
import com.novell.gw.folder.FolderCountInfo;
import com.novell.gw.folder.FolderListener;
import com.novell.gw.folder.FolderSharedList;
import com.novell.gw.jclient.bl.eng_impl.utils.FolderDisplaySettings;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.DocumentFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SharedRefFolder;
import com.novell.gw.jclient.bl.om.folders.TaskListFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UnopenedFolder;
import com.novell.gw.jclient.bl.om.items.TableItem;
import java.io.Serializable;
import org.apache.log4j.Logger;

public abstract class AbstractFolder
implements TableItem,
Serializable {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$om$folders$AbstractFolder == null ? (class$com$novell$gw$jclient$bl$om$folders$AbstractFolder = AbstractFolder.class$("com.novell.gw.jclient.bl.om.folders.AbstractFolder")) : class$com$novell$gw$jclient$bl$om$folders$AbstractFolder));
    private String id;
    private String name;
    private FolderDisplaySettings displaySettings;
    protected Folder nativeFolder;
    private boolean exist = true;
    protected String userGuid;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$folders$AbstractFolder;

    public AbstractFolder() {
    }

    protected AbstractFolder(String string) {
        this(string, string);
    }

    protected AbstractFolder(String string, String string2) {
        this.id = string;
        this.name = string2;
    }

    public boolean isExist() {
        return this.exist;
    }

    public void setExist(boolean bl) {
        this.exist = bl;
        if (!bl) {
            this.id = "doen't exist";
        }
    }

    public Folder getNativeFolder() {
        return this.nativeFolder;
    }

    public void setNativeFolder(Folder folder) {
        this.nativeFolder = folder;
    }

    public IDObjectsCollection getChildFolders() {
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        Folder[] folderArray = this.nativeFolder.getSubFolders();
        for (int i = 0; i < folderArray.length; ++i) {
            Folder folder = folderArray[i];
            AbstractFolder abstractFolder = GWCommandManager.getInstance(this.userGuid).getGWFolder(folder);
            iDObjectsCollection.addIDObject(abstractFolder);
        }
        return iDObjectsCollection;
    }

    public ItemList getItemList() {
        String string = this.getID();
        if (!ItemListsCache.containsKey(string, this.userGuid)) {
            logger.debug((Object)("!!!!!!!!!!!!!! GETTING NEW (FRESH) ITEM LIST FOR FOLDER :" + this.getName() + " !!!!!!!!!!!!!!!!!!!"));
            ItemList itemList = this.nativeFolder.getContents();
            ItemListsCache.put(string, itemList, this.userGuid);
        }
        return ItemListsCache.get(string, this.userGuid);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getDisplayCount() {
        if (this.nativeFolder != null) {
            return this.nativeFolder.getDisplayCount();
        }
        return -1;
    }

    public int hashCode() {
        return this.getID().hashCode() + this.getName().hashCode();
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean rename(String string) {
        boolean bl = false;
        if (this.canRename() && (bl = this.nativeFolder.setName(string))) {
            this.setName(string);
        }
        return false;
    }

    public boolean canDelete() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canDelete();
    }

    public boolean canRename() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canRename();
    }

    public boolean canHaveChildren() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canHaveChildren();
    }

    public boolean isCalendarFolder() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.isCalendarFolder();
    }

    public boolean isJunkMailFolder() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.isJunkMailFolder();
    }

    public boolean canShare() {
        if (this.nativeFolder == null) {
            Assertions.assertIllegalState("Native folder is NULL");
        }
        return this.nativeFolder.canShare();
    }

    public void setID(String string) {
        this.id = string;
    }

    public boolean move(AbstractFolder abstractFolder) {
        if (!this.canMoveTo(abstractFolder)) {
            return false;
        }
        Folder folder = abstractFolder.getNativeFolder();
        return this.nativeFolder.moveTo(folder, 0);
    }

    public boolean canMoveTo(AbstractFolder abstractFolder) {
        if (abstractFolder instanceof UnopenedFolder || abstractFolder instanceof CalendarFolder || abstractFolder instanceof QueryFolder || abstractFolder instanceof TaskListFolder || abstractFolder instanceof SentItemsFolder || abstractFolder instanceof DocumentFolder || abstractFolder instanceof TrashFolder) {
            return false;
        }
        if (abstractFolder instanceof SharedRefFolder && !((SharedRefFolder)abstractFolder).isAddRight()) {
            return false;
        }
        if (abstractFolder.getID() == this.id) {
            return false;
        }
        return !this.isAncestor(abstractFolder);
    }

    private boolean isAncestor(AbstractFolder abstractFolder) {
        Folder folder = this.nativeFolder.findFolder(abstractFolder.nativeFolder.getId());
        return folder != null;
    }

    public String getSubject() {
        return this.getName();
    }

    public FolderCountInfo getCountOFContents() {
        return this.nativeFolder.getCountOfContents();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AbstractFolder)) {
            return false;
        }
        AbstractFolder abstractFolder = (AbstractFolder)object;
        return this.getID().equals(abstractFolder.getID());
    }

    public Item getNativeObject() {
        return this.getNativeFolder();
    }

    public boolean hasUnopenedItems() {
        boolean bl = false;
        if (this.nativeFolder != null) {
            bl = this.nativeFolder.hasUnreadItems();
        }
        return bl;
    }

    public void setFolderListener(FolderListener folderListener) {
        this.nativeFolder.removeFolderListener(folderListener);
        this.nativeFolder.addFolderListener(folderListener);
    }

    public boolean isSelectFirstUnreadItemState() {
        return this.nativeFolder.getSelectFirstUnreadItemState();
    }

    public void setSelectFirstUnreadItemState(boolean bl) {
        if (this.isSelectFirstUnreadItemState() != bl) {
            this.nativeFolder.setSelectFirstUnreadItemState(bl);
        }
    }

    public String getDescription() {
        return this.nativeFolder.getDescription();
    }

    public void setDescription(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.getDescription())) {
            this.nativeFolder.setDescription(string);
        }
    }

    public abstract String getTypeString();

    public boolean canSortSubfolders() {
        return this.nativeFolder.canSortSubFolders();
    }

    public AbstractFolder getParent() {
        Folder folder = this.nativeFolder.getParent();
        return GWCommandManager.getInstance(this.userGuid).getGWFolder(folder);
    }

    public String getDisplayCountString() {
        int n = this.getDisplayCount();
        if (n > 0) {
            return " [" + n + "]";
        }
        return "";
    }

    public FolderDisplaySettings getFolderDisplaySettings() {
        if (this.displaySettings == null) {
            this.displaySettings = new FolderDisplaySettings(this.nativeFolder.getDisplaySettings());
        } else {
            this.displaySettings.setNativeDisplaySettings(this.nativeFolder.getDisplaySettings());
        }
        return this.displaySettings;
    }

    public void setFolderDisplaySettings(FolderDisplaySettings folderDisplaySettings) {
        this.getNativeFolder().linkTo(folderDisplaySettings.getNativeDisplaySettings());
        this.displaySettings = folderDisplaySettings;
    }

    public String toString() {
        return this.getName() + this.getDisplayCountString();
    }

    public void removeFolderListener(FolderListener folderListener) {
        this.nativeFolder.removeFolderListener(folderListener);
    }

    public TransferItems getTransferItems() {
        return this.nativeFolder.getTransferItems();
    }

    public boolean transfer(TransferItems transferItems, int n) {
        return this.nativeFolder.transfer(transferItems, n);
    }

    public boolean sortSubFolders() {
        return this.nativeFolder.sortSubFolders();
    }

    public String getUserGuid() {
        return this.userGuid;
    }

    public void setUserGuid(String string) {
        this.userGuid = string;
    }

    public void setSharedList(FolderSharedList folderSharedList) throws GWCommandException {
        boolean bl = this.nativeFolder.setSharedList(folderSharedList);
        if (!bl) {
            throw new GWCommandException("Unnable to share folder");
        }
    }

    public boolean isCalendarViewEnabled() {
        return this.getFolderDisplaySettings().getViewMode() == 6;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

