/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.appframework.cache.IDObjectsCollection;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.components.htmleditor.hyperlink.LinkParser;
import com.appframework.utils.Assertions;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.Recipient;
import com.novell.gw.account.AccountSettings;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.Item;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageBody;
import com.novell.gw.jclient.bl.om.items.Sender;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.sendoptions.ComposeItemSendOptions;
import com.novell.gw.jclient.bl.om.items.sendoptions.MimeEncoding;
import com.novell.gw.jclient.bl.om.items.sendoptions.Notification;
import com.novell.gw.jclient.bl.om.items.sendoptions.Priority;
import com.novell.gw.jclient.bl.om.items.sendoptions.Security;
import com.novell.gw.message.Attachment;
import com.novell.gw.message.Message;
import com.novell.gw.message.MessageAttachment;
import com.novell.gw.message.Note;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.log4j.Logger;

public abstract class AbstractItem
implements TableItem,
Serializable {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$om$items$AbstractItem == null ? (class$com$novell$gw$jclient$bl$om$items$AbstractItem = AbstractItem.class$("com.novell.gw.jclient.bl.om.items.AbstractItem")) : class$com$novell$gw$jclient$bl$om$items$AbstractItem));
    public static final int SUBTYPE_REPLY_REQUESTED = 105;
    protected Message nativeItem;
    protected String sharedFolderName;
    protected MessageBody message;
    protected IDObjectsCollection attachments;
    private ArrayList recipientsList = null;
    private boolean isHTMLMessageComposition = false;
    private String replyFwdOriginalSenderDisplayNameText;
    private boolean saved = false;
    private boolean processing = false;
    private String displayType;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$AbstractItem;

    protected AbstractItem(Message message) {
        Assertions.assertNotNull(message, "NativeItem can not be NULL");
        this.nativeItem = message;
        this.message = new MessageBody(this.getID());
    }

    protected AbstractItem() {
    }

    public boolean isDeleted() {
        return this.nativeItem.isDeleted();
    }

    public long getCheckListDueDate() {
        long l = 0L;
        Date date = this.nativeItem.getChecklistDueDate();
        if (date != null) {
            l = date.getTime();
        }
        return l;
    }

    public boolean hasBodyText() {
        return this.nativeItem.hasBodyText();
    }

    public void setCheckListDueDate(long l) {
        throw new IllegalStateException("Not implemented yet");
    }

    public String getID() {
        return String.valueOf(this.nativeItem.getId());
    }

    public String getGID() {
        return this.nativeItem.getGID();
    }

    public int getPriority() {
        return this.nativeItem.getPriority();
    }

    public String getPriorityName() {
        switch (this.getPriority()) {
            case 1: {
                return StringResources.LOW;
            }
            case 2: {
                return StringResources.NORMAL;
            }
            case 4: {
                return StringResources.HIGH;
            }
        }
        return "";
    }

    public void setPriority(int n) {
        this.nativeItem.setPriority(n);
    }

    public Sender getSender() {
        return new Sender(this.nativeItem.getFromText(), this.nativeItem.getSenderEmailAddress());
    }

    public String getSenderID() {
        return this.nativeItem.getSenderId();
    }

    public String getTo() {
        List list = this.getRecipients(1);
        return ControlsUtils.recipientsToString(list);
    }

    public String getCc() {
        List list = this.getRecipients(2);
        return ControlsUtils.recipientsToString(list);
    }

    public String getSubject() {
        String string = this.nativeItem.getSubject();
        return string == null ? "" : string;
    }

    public int getSendOptions() {
        int n = this.nativeItem.getSendOptions();
        return n;
    }

    public void setSubject(String string) {
        this.nativeItem.setSubject(string);
    }

    public String getSharedFolderName() {
        return this.sharedFolderName;
    }

    public void setSharedFolderName(String string) {
        this.sharedFolderName = string;
    }

    public boolean isSentItemRead() {
        if (this.isSentItem()) {
            int n = this.nativeItem.getOpenTotals();
            return n > 0;
        }
        return false;
    }

    public boolean isStatusRead() {
        return GWItemFactory.isMessageReaded(this.nativeItem);
    }

    public boolean isStatusCompleted() {
        return this.nativeItem.isCompleted();
    }

    public boolean isPrivate() {
        return this.nativeItem.isPrivate();
    }

    public Date getDate() {
        return this.nativeItem.getDate();
    }

    public boolean hasPaperClipAttachments() {
        return this.nativeItem.hasPaperclipAttachments();
    }

    public MessageBody getMessage() {
        if (!this.message.isLoaded()) {
            this.loadMessage();
        }
        return this.message;
    }

    public void setMessage(MessageBody messageBody) {
        this.message = messageBody;
    }

    public void setMessage(String string) {
        this.message.setMessage(string);
    }

    public void setMessage(String string, String string2) {
        this.message.setMessage(string, string2);
    }

    public IDObjectsCollection getAttachments() {
        if (this.attachments == null) {
            this.initAttachments();
        }
        return this.attachments;
    }

    public void setAttachments(IDObjectsCollection iDObjectsCollection) {
        if (iDObjectsCollection == null) {
            this.attachments = new IDObjectsCollection();
        } else {
            this.attachments = iDObjectsCollection;
            for (int i = 0; i < this.attachments.size(); ++i) {
                if (!(this.attachments.getIDObjectAt(i) instanceof GWAttachment)) continue;
                ((GWAttachment)this.attachments.getIDObjectAt(i)).setGwItem(this);
            }
        }
    }

    public int getSecurity() {
        return this.nativeItem.getSecurity();
    }

    public String toString() {
        return this.getSubject();
    }

    public long getSize() {
        long l = 0L;
        String string = this.nativeItem.getSubject();
        if (string != null) {
            l += (long)(string.length() * 2);
        }
        l += this.getMessage().getSize();
        for (int i = 0; i < this.getAttachments().size(); ++i) {
            l += ((GWAttachment)this.getAttachments().getIDObjectAt(i)).getSize();
        }
        return l;
    }

    public String getFolderName() {
        return this.nativeItem.getFolder().getName();
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    public int getSentItemStatus() {
        return this.nativeItem.getSentItemStatus();
    }

    public boolean isSentItem() {
        return this.nativeItem.getBoxType() == 2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractItem)) {
            return false;
        }
        return ((AbstractItem)object).getID().equals(this.getID());
    }

    public synchronized void setRecipients(List list) {
        if (this.recipientsList != null) {
            this.recipientsList.clear();
        } else {
            this.recipientsList = new ArrayList();
        }
        this.recipientsList.addAll(list);
    }

    public String getBc() {
        List list = this.getRecipients(4);
        return ControlsUtils.recipientsToString(list);
    }

    public List getToRecipients() {
        return this.getRecipients(1);
    }

    public List getCcRecipients() {
        return this.getRecipients(2);
    }

    public List getBcRecipients() {
        return this.getRecipients(4);
    }

    private List getRecipients(int n) {
        ArrayList<Recipient> arrayList = new ArrayList<Recipient>();
        int n2 = this.getRecipients().size();
        for (int i = 0; i < n2; ++i) {
            Recipient recipient = (Recipient)this.getRecipients().get(i);
            if ((recipient.getCopyType() & n) != n) continue;
            arrayList.add(recipient);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setComposeItemSendOptions(ComposeItemSendOptions composeItemSendOptions) {
        if (composeItemSendOptions != null) {
            this.nativeItem.setPriority(composeItemSendOptions.getPriority().getValue());
            this.nativeItem.setSecurity(composeItemSendOptions.getSecurity().getValue());
            if (composeItemSendOptions.isReplyRequested()) {
                if (composeItemSendOptions.isReplyWhenConvenient()) {
                    this.nativeItem.setReplyWhenConvenient(true);
                } else {
                    this.nativeItem.setReplyWithinDays(composeItemSendOptions.getReplyRequestDay());
                }
            } else {
                this.nativeItem.setReplyRequested(false);
            }
            this.nativeItem.setNotifyWhenOpened(composeItemSendOptions.getRNWhenOpened().getValue());
            this.nativeItem.setNotifyWhenDeleted(composeItemSendOptions.getRNWhenDeleted().getValue());
            this.nativeItem.setMimeEncoding(composeItemSendOptions.getMimeEncoding().getValue());
        }
    }

    public ComposeItemSendOptions getComposeItemSendOptions(ComposeItemSendOptions composeItemSendOptions) {
        if (composeItemSendOptions != null) {
            composeItemSendOptions.setPriority(Priority.getPriority(this.nativeItem.getPriority()));
            composeItemSendOptions.setSecurity(Security.getSecurity(this.nativeItem.getSecurity()));
            composeItemSendOptions.setReplyRequested(this.nativeItem.isReplyRequested());
            if (composeItemSendOptions.isReplyRequested() && this.nativeItem.isReplyWithinDays()) {
                composeItemSendOptions.setReplyRequestDay(this.nativeItem.getReplyRequestDays());
                composeItemSendOptions.setReplyWhenConvenient(false);
            }
            composeItemSendOptions.setRNWhenOpened(this.getNotification(this.nativeItem.getNotifyWhenOpened()));
            composeItemSendOptions.setRNWhenDeleted(this.getNotification(this.nativeItem.getNotifyWhenDeleted()));
            composeItemSendOptions.setMimeEncodingType(MimeEncoding.getEncoding(this.nativeItem.getMimeEncoding()));
        }
        return composeItemSendOptions;
    }

    public void appendSignature(String string) {
        if (string != null && string.length() != 0) {
            StringBuffer stringBuffer = null;
            String string2 = this.getMessage().getMessage();
            int n = -1;
            String string3 = null;
            AccountSettings accountSettings = EngineCommandManager.getAccountSettings();
            if (this.replyFwdOriginalSenderDisplayNameText != null) {
                if (this.isHTMLMessageComposition) {
                    AccountSettings.HTMLReplyFormat hTMLReplyFormat = accountSettings.getHTMLReplyFormat();
                    n = hTMLReplyFormat.getReplyType() != 0 && hTMLReplyFormat.isReplyInsertAtBottom() ? Math.max(string2.indexOf("</body>"), string2.indexOf("</BODY>")) : string2.indexOf("&gt;&gt;&gt;", n);
                    string3 = this.normalizeSignatureForHTML(string);
                } else {
                    AccountSettings.PlainTextReplyFormat plainTextReplyFormat = accountSettings.getPlainTextReplyFormat();
                    if (plainTextReplyFormat.getReplyType() != 0 && plainTextReplyFormat.isReplyInsertAtBottom()) {
                        this.setMessage(this.getRtfSignature(string, string2));
                        return;
                    }
                    n = string2.indexOf("\\par\n>>>");
                    if (n < 0) {
                        n = string2.lastIndexOf("}");
                    }
                    string3 = "\\par\\par " + string.replaceAll("\n", "\\\\par ") + "\\par";
                }
            } else if (this.isHTMLMessageComposition) {
                n = Math.max(string2.indexOf("</body>"), string2.indexOf("</BODY>"));
                string3 = this.normalizeSignatureForHTML(string);
            } else {
                this.setMessage(this.getRtfSignature(string, string2));
                return;
            }
            if (n >= 0 && string3 != null && n <= (stringBuffer = new StringBuffer(string2)).length()) {
                stringBuffer.insert(n, string3);
                this.setMessage(stringBuffer.toString());
            }
        }
    }

    private String normalizeSignatureForHTML(String string) {
        string = LinkParser.createLinkedText(string);
        String string2 = "<br>" + HTMLUtils.encodeInUTF(string.replaceAll("\n", "<br>")) + "<br>" + "<br>";
        return string2;
    }

    private String getRtfSignature(String string, String string2) {
        int n = string2.lastIndexOf("}");
        if (n > 0) {
            String string3 = "\\par\\par " + string.replaceAll("\n", "\\\\par ") + "\\par";
            string2 = string2.substring(0, n - 1) + string3 + string2.substring(n);
        }
        return string2;
    }

    public boolean isHTMLMessageComposition() {
        return this.isHTMLMessageComposition;
    }

    public void setHTMLMessageComposition(boolean bl) {
        this.isHTMLMessageComposition = bl;
    }

    private void initAttachments() {
        Attachment[] attachmentArray = new Attachment[]{};
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        try {
            attachmentArray = this.nativeItem.getAttachments();
            for (int i = 0; i < attachmentArray.length; ++i) {
                Attachment attachment = attachmentArray[i];
                if (attachment == null) continue;
                iDObjectsCollection.addIDObject(this.createAttachmentFromgwAttachment(attachment));
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable, throwable);
        }
        this.setAttachments(iDObjectsCollection);
    }

    private GWAttachment createAttachmentFromgwAttachment(Attachment attachment) {
        GWAttachment gWAttachment = new GWAttachment(attachment);
        return gWAttachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMessage() {
        Document document;
        Object object;
        Object object2 = null;
        String string = null;
        InputStreamReader inputStreamReader = this.nativeItem.getBodyRtfReader();
        if (inputStreamReader != null) {
            object = new RTFEditorKit();
            try {
                string = this.readRTFText(inputStreamReader);
                document = ((StyledEditorKit)object).createDefaultDocument();
                ((RTFEditorKit)object).read(new StringReader(string), document, 0);
                object2 = HTMLUtils.fixChars(document.getText(0, document.getLength()));
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
            finally {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException);
                }
            }
        }
        if (this.nativeItem.showHTMLOnlyWarning() || inputStreamReader != null && object2 != null && ((String)object2).equals("")) {
            object = new RTFEditorKit();
            try {
                string = "{\\rtf1 \\b " + StringResources.HTML_ONLY_WARNING + "\\b0}";
                document = ((StyledEditorKit)object).createDefaultDocument();
                ((RTFEditorKit)object).read(new StringReader(string), document, 0);
                object2 = document.getText(0, document.getLength());
            }
            catch (IOException iOException) {
                logger.error((Object)iOException, (Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                logger.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        if ((object = this.nativeItem.getStaticTextForMessageBody(0)) != null) {
            Object object3 = object2 = object2 == null ? object : (String)object + (String)object2;
        }
        if (object2 != null) {
            this.message.setMessage((String)object2, string);
        }
        this.message.setLoaded(true);
    }

    private String readStream(InputStreamReader inputStreamReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read()) > -1) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private String readRTFText(InputStreamReader inputStreamReader) throws IOException {
        int n;
        char[] cArray = new char[1024];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public String getHTMLBodyTextFile() {
        return this.nativeItem.saveBodyHtmlToTempFile();
    }

    private synchronized List getRecipients() {
        if (this.recipientsList == null) {
            this.initRecipientsList();
        }
        return this.recipientsList;
    }

    public synchronized List getRecipientsList() {
        return new ArrayList(this.getRecipients());
    }

    private synchronized void initRecipientsList() {
        this.recipientsList = new ArrayList();
        DistributionList distributionList = this.nativeItem.getDistributionList();
        for (int i = 0; i < distributionList.getSize(); ++i) {
            Recipient recipient = distributionList.getRecipient(i);
            this.recipientsList.add(recipient);
        }
    }

    public boolean isHTMLMessage() {
        return this.nativeItem.isHTMLMessage();
    }

    public int getSubType() {
        return -1;
    }

    public int getBoxType() {
        return this.nativeItem.getBoxType();
    }

    public DistributionList getDistributionList() {
        return this.nativeItem.getDistributionList();
    }

    public boolean canDoInfo() {
        return this.nativeItem.canDoInfo();
    }

    public boolean canOpen() {
        return this.nativeItem.canOpen();
    }

    public boolean canSave() {
        return this.nativeItem.canSave();
    }

    public boolean canPrint() {
        return this.nativeItem.canPrint();
    }

    public boolean canAccept() {
        return this.nativeItem.canAccept();
    }

    public boolean canDelete() {
        return this.nativeItem.canDelete();
    }

    public boolean canForward() {
        return this.nativeItem.canForward();
    }

    public boolean canDecline() {
        return this.nativeItem.canDecline();
    }

    public boolean canReply() {
        return this.nativeItem.canReply();
    }

    public boolean canResend() {
        return this.nativeItem.canResend();
    }

    public boolean canComplete() {
        return this.nativeItem.canComplete();
    }

    public boolean canMarkReadLater() {
        return this.nativeItem.canMarkReadLater();
    }

    public boolean canUnDelete() {
        return this.nativeItem.canUndelete();
    }

    public boolean canEmpty() {
        return this.nativeItem.canEmpty();
    }

    public boolean canMarkRead() {
        return this.nativeItem.canMarkRead();
    }

    public boolean canDeleteAndEmpty() {
        return this.nativeItem.canDeleteAndEmpty();
    }

    public void setNativeItem(Message message) {
        this.nativeItem = message;
    }

    public Message getNativeItem() {
        return this.nativeItem;
    }

    public Item getNativeObject() {
        return this.getNativeItem();
    }

    public boolean canDelegate() {
        return this.nativeItem.canDelegate();
    }

    public boolean isPersonal() {
        return this.nativeItem.isPersonal();
    }

    public synchronized void clear() {
        this.clearAttachments();
        this.recipientsList = null;
    }

    public boolean isDelegated() {
        if (this.nativeItem instanceof Note) {
            return ((Note)this.nativeItem).isDelegated();
        }
        return false;
    }

    public boolean isForwarded() {
        return this.nativeItem.isForwarded();
    }

    public boolean isReplied() {
        return this.nativeItem.isRepliedTo();
    }

    public AbstractFolder getViewFolder(String string) {
        return GWCommandManager.getInstance(string).getGWFolder(this.nativeItem.getViewFolder());
    }

    public boolean isDraft() {
        return this.nativeItem.isDraft();
    }

    public boolean isSent() {
        return this.nativeItem.getBoxType() == 2;
    }

    public void setReplyFwdOriginalSenderDisplayNameText(String string) {
        this.replyFwdOriginalSenderDisplayNameText = string;
    }

    public int getTransferOptions(TransferItems transferItems) {
        return this.nativeItem.getTransferOptions(transferItems);
    }

    public boolean hasExtendedAttachments() {
        if (!this.hasPaperClipAttachments()) {
            IDObjectsCollection iDObjectsCollection = this.getAttachments();
            Iterator iterator = iDObjectsCollection.iterator();
            while (iterator.hasNext()) {
                GWAttachment gWAttachment = (GWAttachment)iterator.next();
                if (gWAttachment.isSystemAttachment()) continue;
                return true;
            }
        }
        return this.hasPaperClipAttachments();
    }

    public boolean canMarkPrivate() {
        return this.nativeItem.canMarkPrivate();
    }

    public void setSaved(boolean bl) {
        this.saved = bl;
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected final Notification getNotification(int n) {
        boolean bl = n == 1 || n == 3;
        boolean bl2 = n == 2 || n == 3;
        return Notification.getNotification(bl, bl2, false);
    }

    public void clearAttachments() {
        this.attachments = null;
    }

    public boolean addAttachment(AbstractItem abstractItem) {
        this.clearAttachments();
        return this.nativeItem.addAttachment(abstractItem.getNativeItem());
    }

    public boolean addAttachment(String string) {
        this.clearAttachments();
        return this.nativeItem.addAttachment(string);
    }

    public boolean deleteAttachment(GWAttachment gWAttachment) {
        this.clearAttachments();
        return this.nativeItem.deleteAttachment(gWAttachment.getNativeAttachment());
    }

    public void deleteAttachment(AbstractItem abstractItem) {
        this.clearAttachments();
        Attachment[] attachmentArray = this.nativeItem.getAttachments();
        for (int i = 0; i < attachmentArray.length; ++i) {
            MessageAttachment messageAttachment;
            Attachment attachment = attachmentArray[i];
            if (!(attachment instanceof MessageAttachment) || (messageAttachment = (MessageAttachment)attachment).getMessage().getId() != abstractItem.getNativeItem().getId()) continue;
            this.nativeItem.deleteAttachment(i);
        }
    }

    public boolean isProcessing() {
        return this.processing;
    }

    public void setProcessing(boolean bl) {
        this.processing = bl;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String string) {
        this.displayType = string;
    }

    public boolean isIMAPDeleted() {
        return this.nativeItem.isIMAPDeleted();
    }

    public boolean canReplyToOriginalTopic() {
        return this.nativeItem.canReplyToOriginalTopic();
    }

    public boolean transfer(TransferAttachments transferAttachments, int n) {
        return this.nativeItem.transfer(transferAttachments, n);
    }

    public boolean restore() {
        return this.nativeItem.restore();
    }

    public void markOpen() throws EngineException {
        this.nativeItem.markOpen();
    }

    public void markComplete(boolean bl) throws EngineException {
        this.nativeItem.markComplete(bl);
    }

    public boolean isReplyRequested() {
        return this.nativeItem.isReplyRequested();
    }

    public boolean isInChecklist() {
        return this.nativeItem.isInChecklist();
    }

    public boolean canShowInChecklist() {
        return this.nativeItem.canShowInChecklist();
    }

    public void showInChecklist(boolean bl) {
        this.nativeItem.showInChecklist(bl);
    }

    public boolean isChecklistDummyItem() {
        return this.nativeItem.isChecklistDummyItem();
    }

    public boolean canArchive() {
        return this.nativeItem.canArchive();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

