/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items;

import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.cache.IDObjectsCollection;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.Command;
import com.appframework.mvc.ControllerManager;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.MachineSettings;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionAttachmentOpen;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.InstallSharedABDialog;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.dialogs.installfolder.InstallFolderDialog;
import com.novell.gw.jclient.application.dialogs.saveasdialog.SaveAsDialog;
import com.novell.gw.jclient.application.frames.FramesFactory;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.eng_impl.GWItemFactory;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import com.novell.gw.jclient.bl.om.items.ItemDescription;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MessageUtils {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$om$items$MessageUtils == null ? (class$com$novell$gw$jclient$bl$om$items$MessageUtils = MessageUtils.class$("com.novell.gw.jclient.bl.om.items.MessageUtils")) : class$com$novell$gw$jclient$bl$om$items$MessageUtils));
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$om$items$MessageUtils;

    public static void openItem(AbstractItem abstractItem, ItemDescription itemDescription, MVCController mVCController) {
        MessageUtils.openItem(abstractItem, itemDescription, mVCController, false);
    }

    public static void openItem(AbstractItem abstractItem, ItemDescription itemDescription, MVCController mVCController, boolean bl) {
        FrameOpen frameOpen = GWClient.getOpenFrame(abstractItem);
        if (frameOpen == null) {
            FrameOpen frameOpen2 = Application.getLastFrameOpen();
            frameOpen = new FrameOpen(itemDescription, GWClient.getApplication(), mVCController);
            GlobalCommand globalCommand = new GlobalCommand(480, frameOpen);
            frameOpen.getController().processCommand(globalCommand);
            if (bl && frameOpen2 != null) {
                frameOpen.showMe(frameOpen2.getLocation().x + 20, frameOpen2.getLocation().y + 20);
            } else {
                frameOpen.showMe();
            }
        } else {
            frameOpen.showItemContent();
            if (frameOpen.isVisible()) {
                frameOpen.setVisible(true);
            }
            UIUtils.restoreFrameState(frameOpen);
            frameOpen.toFront();
        }
    }

    public static void doOpenItem(ItemDescription itemDescription, boolean bl, ApplicationFrame applicationFrame, MVCController mVCController) {
        AbstractItem abstractItem = itemDescription.getItem();
        if (abstractItem instanceof GWSharedFolderNotification) {
            InstallFolderDialog installFolderDialog = new InstallFolderDialog(applicationFrame, (GWSharedFolderNotification)abstractItem);
            installFolderDialog.showMe();
        } else if (abstractItem instanceof SharedAddressBookNotificationItem) {
            InstallSharedABDialog installSharedABDialog = new InstallSharedABDialog((Frame)applicationFrame, (SharedAddressBookNotificationItem)abstractItem);
            installSharedABDialog.pack();
            ((Dialog)installSharedABDialog).setVisible(true);
        } else if (abstractItem instanceof DocumentItem) {
            MessageUtils.openDocumentItem(abstractItem);
        } else if (abstractItem.isPersonal()) {
            if (abstractItem.isProcessing()) {
                return;
            }
            MessageUtils.openPostedItem(abstractItem, mVCController);
        } else if (abstractItem.isDraft()) {
            String string = ControlsUtils.getUserGuid(mVCController);
            MessageUtils.openDraftItem(abstractItem, string);
        } else {
            MessageUtils.openItem(abstractItem, itemDescription, mVCController, bl);
        }
    }

    private static void openDocumentItem(AbstractItem abstractItem) {
        DocumentItem documentItem = (DocumentItem)abstractItem;
        GWAttachment gWAttachment = (GWAttachment)documentItem.getAttachments().getIDObjectAt(0);
        ActionAttachmentOpen.openAttachment(gWAttachment);
    }

    private static void openPostedItem(AbstractItem abstractItem, MVCController mVCController) {
        FrameCompose frameCompose = GWClient.getComposeFrame(abstractItem);
        if (frameCompose != null) {
            if (!frameCompose.isVisible()) {
                frameCompose.setVisible(true);
            }
            UIUtils.restoreFrameState(frameCompose);
            frameCompose.toFront();
        } else {
            try {
                ApplicationFrame applicationFrame;
                Object object;
                AbstractItem abstractItem2 = GWItemFactory.gwObjectToItem(abstractItem.getNativeItem());
                boolean bl = abstractItem2.getNativeItem().canModify();
                boolean bl2 = HTMLUtils.isDefaultComposeHTML();
                if (bl2 && bl) {
                    if (abstractItem2.isHTMLMessage()) {
                        HTMLUtils.setupHTMLMessageBody(abstractItem2);
                    } else {
                        HTMLUtils.convertPlainTextToHTMLMessageBody(abstractItem2);
                    }
                }
                if (bl) {
                    object = ControlsUtils.getUserGuid(mVCController);
                    applicationFrame = new FrameComposePostedItem(abstractItem2, (MVCController)GWClient.getApplication(), true, mVCController, false, (String)object);
                } else {
                    applicationFrame = new FrameOpen(new ItemDescription(abstractItem2), GWClient.getApplication(), mVCController);
                }
                applicationFrame.showMe();
                object = new GlobalCommand(480, applicationFrame);
                applicationFrame.getController().processCommand((Command)object);
            }
            catch (GWCommandException gWCommandException) {
                logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
            }
        }
    }

    private static void openDraftItem(AbstractItem abstractItem, String string) {
        FrameCompose frameCompose = GWClient.getComposeFrame(abstractItem);
        if (frameCompose != null) {
            if (!frameCompose.isVisible()) {
                frameCompose.setVisible(true);
            }
            UIUtils.restoreFrameState(frameCompose);
            frameCompose.toFront();
        } else {
            try {
                boolean bl;
                AbstractItem abstractItem2 = GWItemFactory.gwObjectToItem(abstractItem.getNativeItem());
                MachineSettings.TextOption textOption = OptionManager.getInstance().getTextOption();
                boolean bl2 = bl = textOption.isDefaultComposeHTML() && !textOption.isHTMLDisallowed();
                if (bl) {
                    if (abstractItem2.isHTMLMessage()) {
                        HTMLUtils.setupHTMLMessageBody(abstractItem2);
                    } else {
                        HTMLUtils.convertPlainTextToHTMLMessageBody(abstractItem2);
                    }
                }
                FrameCompose frameCompose2 = FramesFactory.getComposeFrame(abstractItem2, GWClient.getApplication(), true, string);
                frameCompose2.showMe();
                GlobalCommand globalCommand = new GlobalCommand(480, frameCompose2);
                frameCompose2.getController().processCommand(globalCommand);
            }
            catch (GWCommandException gWCommandException) {
                logger.debug((Object)gWCommandException, (Throwable)gWCommandException);
            }
        }
    }

    public static MVCController getMainFrameController(MVCController mVCController) {
        Level level = LevelManager.getInstance().getFrameLevel(mVCController.getLevel());
        MVCController mVCController2 = ControllerManager.getInstance().get(level);
        if (mVCController2.getMVCView() instanceof ApplicationFrame) {
            return mVCController2;
        }
        return null;
    }

    private static boolean isDeletingAllowed(boolean bl, Component component) {
        if (OptionManager.getInstance().getGeneralOptions().isDeleteConfirmationAllowed()) {
            String string;
            String string2;
            if (bl) {
                string2 = StringResources.DELETE_SELECTED_MESSAGES_Q;
                string = StringResources.DELETE_MESSAGES;
            } else {
                string2 = StringResources.DELETE_SELECTED_MESSAGE_Q;
                string = StringResources.DELETE_MESSAGE;
            }
            int n = JOptionPane.showConfirmDialog(component, string2, string, 0);
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    public static void delete(IDObjectsCollection iDObjectsCollection, ItemList itemList, Component component) {
        if (!MessageUtils.isDeletingAllowed(true, component)) {
            return;
        }
        Application.disableFrames(iDObjectsCollection);
        GWEngineUtils.deleteItems(iDObjectsCollection, itemList);
    }

    public static boolean delete(ItemList itemList, AbstractItem abstractItem, Component component) {
        if (!MessageUtils.isDeletingAllowed(false, component)) {
            return false;
        }
        IDObjectsCollection iDObjectsCollection = new IDObjectsCollection();
        iDObjectsCollection.addIDObject(abstractItem);
        Application.disableFrames(iDObjectsCollection);
        GWEngineUtils.deleteItem(itemList, abstractItem);
        return true;
    }

    public static void saveAttachment(final GWAttachment gWAttachment, final String string) {
        MessageUtils.showBusyCursor(true);
        Thread thread = new Thread(){

            public void run() {
                if (gWAttachment != null) {
                    try {
                        GWEngineUtils.saveAttachment(gWAttachment, string);
                    }
                    catch (GWCommandException gWCommandException) {
                        logger.error((Object)gWCommandException, (Throwable)gWCommandException);
                        SwingUtilities.invokeLater(new Runnable(this, gWCommandException){
                            private final /* synthetic */ GWCommandException val$e1;
                            private final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                                this.val$e1 = gWCommandException;
                            }

                            public void run() {
                                ErrorDialog.processGWException(this.val$e1);
                            }
                        });
                    }
                }
            }
        };
        thread.start();
        MessageUtils.repaint(thread);
        MessageUtils.showBusyCursor(false);
    }

    private static void showBusyCursor(boolean bl) {
        IDObjectsCollection iDObjectsCollection = Application.getAllFrames();
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            JFrame jFrame = (JFrame)((Object)iDObjectsCollection.getIDObjectAt(i));
            MessageUtils.showBusyCursor(jFrame, bl);
        }
    }

    private static void repaintFrames() {
        IDObjectsCollection iDObjectsCollection = Application.getAllFrames();
        for (int i = 0; i < iDObjectsCollection.size(); ++i) {
            JFrame jFrame = (JFrame)((Object)iDObjectsCollection.getIDObjectAt(i));
            JComponent jComponent = (JComponent)jFrame.getContentPane();
            jComponent.paintImmediately(jComponent.getVisibleRect());
            jFrame.getJMenuBar().paintImmediately(jFrame.getJMenuBar().getVisibleRect());
            Window[] windowArray = jFrame.getOwnedWindows();
            for (int j = 0; j < windowArray.length; ++j) {
                Container container;
                Window window = windowArray[j];
                if (!(window instanceof JDialog) || !((JDialog)window).isShowing() || !((container = ((JDialog)window).getContentPane()) instanceof JComponent)) continue;
                ((JComponent)container).paintImmediately(((JComponent)container).getVisibleRect());
            }
        }
    }

    private static void showBusyCursor(JFrame jFrame, boolean bl) {
        if (jFrame != null) {
            int n;
            int n2 = n = bl ? 3 : 0;
            if (bl && !UIUtils.isJDKMoreThan5()) {
                jFrame.setEnabled(true);
            }
            jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(n));
            jFrame.getGlassPane().setVisible(bl);
            Window[] windowArray = jFrame.getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                if (!(windowArray[i] instanceof JDialog) || !((JDialog)windowArray[i]).isShowing()) continue;
                JDialog jDialog = (JDialog)windowArray[i];
                jDialog.getGlassPane().setCursor(Cursor.getPredefinedCursor(n));
                jDialog.getGlassPane().setVisible(bl);
                if (!(jDialog instanceof SaveAsDialog) || bl || UIUtils.isJDKMoreThan5()) continue;
                jDialog.getParent().setEnabled(false);
            }
        }
    }

    private static void repaint(Thread thread) {
        while (thread.isAlive()) {
            MessageUtils.repaintFrames();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException2) {
                    logger.error((Object)interruptedException2);
                    logger.debug((Object)interruptedException2, (Throwable)interruptedException2);
                }
                if (Thread.currentThread().isInterrupted()) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

