/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.om.items.sendoptions;

import com.novell.gw.engine.DataStoreSettings;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.sendoptions.NameValueEnum;

public final class Notification
extends NameValueEnum {
    private static final int MAIL_NOTIFICATION = 1;
    private static final int NOTIFICATION = 2;
    public static final Notification NONE = new Notification(StringResources.NONE, 0);
    public static final Notification MAIL_RECEIPT = new Notification(StringResources.MAIL_RECEIPT, 1);
    public static final Notification NOTIFY = new Notification(StringResources.NOTIFY, 2);
    public static final Notification NOTIFY_AND_MAIL = new Notification(StringResources.NOTIFY_AND_MAIL, 3);
    public static final Notification[] NOTIFICATION_LIST = new Notification[]{NONE, MAIL_RECEIPT, NOTIFY, NOTIFY_AND_MAIL};
    private boolean locked;

    private Notification(String string, int n) {
        super(string, n);
    }

    private Notification(String string, int n, boolean bl) {
        super(string, n);
        this.locked = bl;
    }

    public boolean isMailNotify() {
        return (this.getValue() & 1) > 0;
    }

    public boolean isNotify() {
        return (this.getValue() & 2) > 0;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public static Notification getNotification(DataStoreSettings.SendOptionNotification sendOptionNotification) {
        if (sendOptionNotification != null) {
            return Notification.getNotification(sendOptionNotification.isMailNotificationSet(), sendOptionNotification.isNotificationSet(), sendOptionNotification.isNotificationLocked());
        }
        return null;
    }

    public static Notification getNotification(boolean bl, boolean bl2, boolean bl3) {
        int n = (bl ? 1 : 0) | (bl2 ? 2 : 0);
        String string = "";
        if (bl && bl2) {
            string = StringResources.NOTIFY_AND_MAIL;
        } else if (!bl && !bl2) {
            string = StringResources.NONE;
        } else if (bl && !bl2) {
            string = StringResources.MAIL_RECEIPT;
        } else if (!bl && bl2) {
            string = StringResources.NOTIFY;
        }
        return new Notification(string, n, bl3);
    }
}

