/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.bl.store.mail;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.store.GWItemFormatSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class MailSerializer
extends GWItemFormatSerializer {
    private static Logger logger = Logger.getLogger((Class)(class$com$novell$gw$jclient$bl$store$mail$MailSerializer == null ? (class$com$novell$gw$jclient$bl$store$mail$MailSerializer = MailSerializer.class$("com.novell.gw.jclient.bl.store.mail.MailSerializer")) : class$com$novell$gw$jclient$bl$store$mail$MailSerializer));
    public static final String GW_ITEM_ID = "GWItemID";
    private boolean withAttachments;
    private boolean dragNDrop;
    static /* synthetic */ Class class$com$novell$gw$jclient$bl$store$mail$MailSerializer;

    public MailSerializer(AbstractItem abstractItem, boolean bl, boolean bl2) {
        super(abstractItem);
        this.withAttachments = bl;
        this.dragNDrop = bl2;
    }

    protected String addTitleValue(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(string2);
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void saveAttachments(String string, AbstractItem abstractItem, boolean bl) {
        int n = abstractItem.getAttachments().size();
        for (int i = 0; i < n; ++i) {
            GWAttachment gWAttachment = (GWAttachment)abstractItem.getAttachments().getIDObjectAt(i);
            if (gWAttachment.isMessageAttachment()) continue;
            String string2 = string + System.getProperty("file.separator") + gWAttachment.getFileName();
            MailSerializer.saveAttachment(string2, gWAttachment, bl);
        }
    }

    public static void saveAttachment(String string, GWAttachment gWAttachment, boolean bl) {
        File file = new File(string);
        if (file.exists()) {
            if (bl) {
                return;
            }
            int n = JOptionPane.showConfirmDialog(null, StringResources.formatString(StringResources.FILE_ALREADY_EXISTS_OVERWRITE_Q, new String[]{file.getPath()}), StringResources.SAVE_ATTACHMENT, 0, 2);
            if (n == 1) {
                return;
            }
        }
        MessageUtils.saveAttachment(gWAttachment, string);
    }

    public void save(String string) throws GWException {
        String string2;
        super.save(string);
        if (this.withAttachments) {
            string2 = new File(string).getParent();
            this.saveAttachments(string2, this.theItem, this.dragNDrop);
        }
        string2 = new MimeMessage(Session.getDefaultInstance((Properties)new Properties(), null));
        try {
            InternetAddress internetAddress;
            string2.setHeader(GW_ITEM_ID, this.theItem.getGID());
            String string3 = this.theItem.getSenderID();
            if (string3 != null) {
                internetAddress = new InternetAddress(string3);
                string2.setFrom((Address)internetAddress);
            }
            internetAddress = new InternetAddress[1];
            String string4 = this.theItem.getTo();
            if (string4 != null) {
                try {
                    internetAddress[0] = new InternetAddress(string4);
                    string2.setReplyTo((Address[])internetAddress);
                }
                catch (AddressException addressException) {
                    logger.debug((Object)("Can't obtain internet address from -" + string4));
                }
            }
            GregorianCalendar gregorianCalendar = GWCalendarUtils.getTodayUTC();
            gregorianCalendar.setTimeInMillis(this.theItem.getDate().getTime());
            gregorianCalendar.add(14, -GWCalendarUtils.getZoneOffset());
            string2.setSentDate(gregorianCalendar.getTime());
            string2.setSubject(this.theItem.getSubject() == null ? "" : this.theItem.getSubject());
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(this.theMessage);
            MimeMultipart mimeMultipart = new MimeMultipart();
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            if (this.withAttachments && this.theItem.getAttachments() != null) {
                int n = this.theItem.getAttachments().size();
                for (int i = 0; i < n; ++i) {
                    GWAttachment gWAttachment = (GWAttachment)this.theItem.getAttachments().getIDObjectAt(i);
                    if (gWAttachment.isMessageAttachment()) continue;
                    mimeBodyPart = new MimeBodyPart();
                    String string5 = ControlsUtils.getAttachmentFilePath(gWAttachment).getAbsolutePath();
                    if (!gWAttachment.isLocalFile()) {
                        GWEngineUtils.saveAttachment(gWAttachment);
                    }
                    FileDataSource fileDataSource = new FileDataSource(string5);
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                    mimeBodyPart.setFileName(gWAttachment.getFileName());
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
            string2.setContent((Multipart)mimeMultipart);
            string2.saveChanges();
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            string2.writeTo((OutputStream)fileOutputStream);
            fileOutputStream.close();
        }
        catch (MessagingException messagingException) {
            logger.error((Object)messagingException, (Throwable)messagingException);
            throw new GWException(StringResources.CANT_EXPORT_TO_FILE);
        }
        catch (IOException iOException) {
            throw new GWException(StringResources.SAVE_ERROR_C + ' ' + iOException.getMessage());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

