/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ab;

import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.Item;
import java.util.Calendar;
import java.util.Date;

public abstract class Contact
extends Item
implements Addressable {
    public static final int TYPE_USER = 0;
    public static final int TYPE_GROUP = 1;
    public static final int TYPE_RESOURCE = 2;
    public static final int TYPE_ORGANIZATION = 3;
    protected int pGWContact = 0;
    private int id = -1;

    private static native void initMethodIds();

    private static native int getType(int var0);

    private static native String getFullAddress(int var0);

    private static Date createDateObject(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3, n4, n5, n6);
        return calendar.getTime();
    }

    public static Contact createContact(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        int n2 = Contact.getType(n);
        switch (n2) {
            case 0: {
                return new UserContact(n);
            }
            case 1: {
                return new GroupContact(n);
            }
            case 2: {
                return new ResourceContact(n);
            }
            case 3: {
                return new OrganizationContact(n);
            }
        }
        return null;
    }

    private native void dispose(int var1);

    private native String getAdditionalRouting(int var1);

    private native int getAddressableType(int var1);

    private native int getAddressFormat(int var1);

    private native int getBookId(int var1);

    private native String getBookName(int var1);

    private native String getComments(int var1);

    private native Date getCreateDate(int var1);

    private native String getDisplayName(int var1);

    private native String getDistinguishedName(int var1);

    private native int getDistributionType(int var1);

    private native String getDomain(int var1);

    private native String getEmailAddress(int var1);

    private native String getExternalDisplayName(int var1);

    private native String getExternalGuid(int var1);

    private native String getFid(int var1);

    private native String getFirstName(int var1);

    private native String getGuid(int var1);

    private native int getId(int var1);

    private native String getInternetDomain(int var1);

    private native String getLastName(int var1);

    private native Date getModifiedDate(int var1);

    private native String getNetId(int var1);

    private native String getPostOffice(int var1);

    private native String getPreferredEmailId(int var1);

    private native Date getReferenceDate(int var1);

    private native int getReferenceCount(int var1);

    private native String getUserName(int var1);

    private native int getVersion(int var1);

    private native boolean isModified(int var1);

    private native void save(int var1, int var2) throws EngineException;

    private native boolean setComments(int var1, String var2);

    private native boolean setDisplayName(int var1, String var2);

    private native boolean setEmailAddress(int var1, String var2);

    private native boolean setFirstName(int var1, String var2);

    private native boolean setLastName(int var1, String var2);

    private native Date getDateValue(int var1, int var2);

    private native boolean setDateValue(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private native int getIntValue(int var1, int var2);

    private native boolean setIntValue(int var1, int var2, int var3);

    private native String getStringValue(int var1, int var2);

    private native boolean setStringValue(int var1, int var2, String var3);

    private native int[] getUserDefinedFields(int var1);

    private native String getUserDefinedField(int var1, int var2);

    private native boolean setUserDefinedField(int var1, int var2, String var3);

    private native int getAddressablePointer(int var1);

    public Contact() {
    }

    protected Contact(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWContact = n;
    }

    public int getPointer() {
        return this.pGWContact;
    }

    public int getAddressablePointer() {
        return this.getAddressablePointer(this.pGWContact);
    }

    public static String getFullAddress(Addressable addressable) {
        return Contact.getFullAddress(addressable != null ? addressable.getAddressablePointer() : 0);
    }

    public int getId() {
        if (this.id == -1) {
            this.id = this.getId(this.pGWContact);
        }
        return this.id;
    }

    public int getBookId() {
        return this.getBookId(this.pGWContact);
    }

    public String getBookName() {
        return this.getBookName(this.pGWContact);
    }

    public Date getDateValue(int n) {
        return this.getDateValue(this.pGWContact, n);
    }

    public boolean setDateValue(int n, Date date) {
        return this.setDateValue(this.pGWContact, n, date.getYear(), date.getMonth(), date.getDay(), date.getHours(), date.getMinutes(), date.getSeconds());
    }

    public int getIntValue(int n) {
        return this.getIntValue(this.pGWContact, n);
    }

    public boolean setIntValue(int n, int n2) {
        return this.setIntValue(this.pGWContact, n, n2);
    }

    public String getStringValue(int n) {
        return this.getStringValue(this.pGWContact, n);
    }

    public boolean setStringValue(int n, String string) {
        return this.setStringValue(this.pGWContact, n, string);
    }

    public int[] getUserDefinedFields() {
        return this.getUserDefinedFields(this.pGWContact);
    }

    public String getUserDefinedField(int n) {
        return this.getUserDefinedField(this.pGWContact, n);
    }

    public boolean setUserDefinedField(int n, String string) {
        return this.setUserDefinedField(this.pGWContact, n, string);
    }

    public void save() throws EngineException {
        this.save(this.pGWContact, 0);
    }

    public void save(int n) throws EngineException {
        this.save(this.pGWContact, n);
    }

    public boolean isModified() {
        return this.isModified(this.pGWContact);
    }

    public String getAdditionalRouting() {
        return this.getAdditionalRouting(this.pGWContact);
    }

    public int getAddressableType() {
        return this.getAddressableType(this.pGWContact);
    }

    public int getAddressFormat() {
        return this.getAddressFormat(this.pGWContact);
    }

    public String getDisplayName() {
        return this.getDisplayName(this.pGWContact);
    }

    public boolean setDisplayName(String string) {
        return this.setDisplayName(this.pGWContact, string);
    }

    public String getDistinguishedName() {
        return this.getDistinguishedName(this.pGWContact);
    }

    public String getDomain() {
        return this.getDomain(this.pGWContact);
    }

    public String getEmailAddress() {
        return this.getEmailAddress(this.pGWContact);
    }

    public boolean setEmailAddress(String string) {
        return this.setEmailAddress(this.pGWContact, string);
    }

    public String getExternalDisplayName() {
        return this.getExternalDisplayName(this.pGWContact);
    }

    public String getExternalGuid() {
        return this.getExternalGuid(this.pGWContact);
    }

    public String getFid() {
        return this.getFid(this.pGWContact);
    }

    public String getFirstName() {
        return this.getFirstName(this.pGWContact);
    }

    public boolean setFirstName(String string) {
        return this.setFirstName(this.pGWContact, string);
    }

    public String getGuid() {
        return this.getGuid(this.pGWContact);
    }

    public String getInternetDomain() {
        return this.getInternetDomain(this.pGWContact);
    }

    public String getLastName() {
        return this.getLastName(this.pGWContact);
    }

    public boolean setLastName(String string) {
        return this.setLastName(this.pGWContact, string);
    }

    public String getNetId() {
        return this.getNetId(this.pGWContact);
    }

    public String getPostOffice() {
        return this.getPostOffice(this.pGWContact);
    }

    public String getPreferredEmailId() {
        return this.getPreferredEmailId(this.pGWContact);
    }

    public String getUserName() {
        return this.getUserName(this.pGWContact);
    }

    public Date getCreateDate() {
        return this.getCreateDate(this.pGWContact);
    }

    public Date getModifiedDate() {
        return this.getModifiedDate(this.pGWContact);
    }

    public Date getReferenceDate() {
        return this.getReferenceDate(this.pGWContact);
    }

    public int getReferenceCount() {
        return this.getReferenceCount(this.pGWContact);
    }

    public int getVersion() {
        return this.getVersion(this.pGWContact);
    }

    public int getDistributionType() {
        return this.getDistributionType(this.pGWContact);
    }

    public String getComments() {
        return this.getComments(this.pGWContact);
    }

    public boolean setComments(String string) {
        return this.setComments(this.pGWContact, string);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Contact) {
            Contact contact = (Contact)object;
            bl = contact.getId() == this.getId() && contact.getBookId() == this.getBookId();
        }
        return bl;
    }

    public void dispose() {
        if (this.pGWContact != 0) {
            this.dispose(this.pGWContact);
            this.pGWContact = 0;
        }
    }

    static {
        Contact.initMethodIds();
    }
}

