/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.ab;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.Addressable;

public class Recipient {
    public static final int COPY_TYPE_TO = 1;
    public static final int COPY_TYPE_CC = 2;
    public static final int COPY_TYPE_BC = 4;
    public static final int COPY_TYPE_DEFAULT = 1;
    private int pGWRecipient = 0;
    private Addressable addressable;
    private int copyType;

    private static native int create(int var0, int var1);

    private native void dispose(int var1);

    private native int getAddressable(int var1);

    private native int getCopyType(int var1);

    private native boolean isSameAddress(int var1, int var2);

    private static native boolean isSameAddressStatic(int var0, int var1);

    private native boolean isUnresolved(int var1);

    private native void setUnresolved(int var1, boolean var2);

    public Recipient(Addressable addressable) {
        this(addressable, 1);
    }

    public Recipient(Addressable addressable, int n) {
        this(Recipient.create(addressable.getAddressablePointer(), n));
        if (!(addressable instanceof Address)) {
            this.addressable = addressable;
        }
    }

    public Recipient(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWRecipient = n;
    }

    public Addressable getAddressable() {
        if (this.addressable == null) {
            this.addressable = new Address(this.getAddressable(this.pGWRecipient));
        }
        return this.addressable;
    }

    public int getCopyType() {
        if (this.copyType == 0) {
            this.copyType = this.getCopyType(this.pGWRecipient);
        }
        return this.copyType;
    }

    public int getPointer() {
        return this.pGWRecipient;
    }

    public boolean isUnresolved() {
        return this.isUnresolved(this.pGWRecipient);
    }

    public boolean isSameAddress(Addressable addressable) {
        return this.isSameAddress(this.pGWRecipient, addressable.getAddressablePointer());
    }

    public static boolean isSameAddress(Addressable addressable, Addressable addressable2) {
        return Recipient.isSameAddressStatic(addressable.getAddressablePointer(), addressable2.getAddressablePointer());
    }

    void setUnresolved(boolean bl) {
        this.setUnresolved(this.pGWRecipient, bl);
    }

    public void dispose() {
        if (this.pGWRecipient != 0) {
            this.dispose(this.pGWRecipient);
            this.pGWRecipient = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

