/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.account;

import com.novell.gw.account.CapAccount;
import com.novell.gw.account.GroupWiseAccount;
import com.novell.gw.account.ImapAccount;
import com.novell.gw.account.NntpAccount;
import com.novell.gw.account.Pop3Account;
import com.novell.gw.engine.DataStore;

public abstract class Account {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_POP3 = 1;
    public static final int TYPE_IMAP = 2;
    public static final int TYPE_GROUPWISE = 3;
    public static final int TYPE_NNTP = 4;
    public static final int TYPE_CAP = 7;
    protected int pAccount = 0;
    protected int type = 0;
    protected String fromText;
    protected String name;
    protected String userId;
    private DataStore owner = null;

    private static native int getType(int var0);

    private native String getEmailAddress(int var1);

    private native String getFromText(int var1);

    private native String getName(int var1);

    private native String getOrganization(int var1);

    private native String getUserId(int var1);

    private native void setEmailAddress(int var1, String var2);

    private native void setFromText(int var1, String var2);

    private native void setName(int var1, String var2);

    private native void setOrganization(int var1, String var2);

    private native void sync(int var1);

    public static native String getLastConnectedMsg();

    public static Account createAccount(int n, DataStore dataStore) {
        if (n == 0) {
            throw new NullPointerException();
        }
        Account account = null;
        switch (Account.getType(n)) {
            case 1: {
                account = new Pop3Account(n, dataStore);
                break;
            }
            case 2: {
                account = new ImapAccount(n, dataStore);
                break;
            }
            case 3: {
                account = new GroupWiseAccount(n, dataStore);
                break;
            }
            case 4: {
                account = new NntpAccount(n, dataStore);
                break;
            }
            case 7: {
                account = new CapAccount(n, dataStore);
            }
        }
        return account;
    }

    Account(int n, DataStore dataStore) {
        if (n == 0 || dataStore == null) {
            throw new NullPointerException();
        }
        this.pAccount = n;
        this.owner = dataStore;
    }

    protected Account() {
    }

    public int getPointer() {
        return this.pAccount;
    }

    public String getEmailAddress() {
        return this.getEmailAddress(this.pAccount);
    }

    public String getFromText() {
        if (this.fromText == null) {
            this.fromText = this.getFromText(this.pAccount);
        }
        return this.fromText;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getName(this.pAccount);
        }
        return this.name;
    }

    public String getOrganization() {
        return this.getOrganization(this.pAccount);
    }

    public DataStore getParent() {
        return this.owner;
    }

    public int getType() {
        return Account.getType(this.pAccount);
    }

    public String getUserId() {
        if (this.userId == null) {
            this.userId = this.getUserId(this.pAccount);
        }
        return this.userId;
    }

    public void setEmailAddress(String string) {
        this.setEmailAddress(this.pAccount, string);
    }

    public void setFromText(String string) {
        this.setFromText(this.pAccount, string);
        this.fromText = null;
    }

    public void setName(String string) {
        this.setName(this.pAccount, string);
        this.name = null;
    }

    public void setOrganization(String string) {
        this.setOrganization(this.pAccount, string);
    }

    public void sync() {
        this.sync(this.pAccount);
    }
}

