/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.account;

public class AccountSettings {
    private int pAccSettings = 0;
    private int tmpReplyType;
    private boolean tmpReplyInsertAtBottom;
    private int tmpReplyChar;
    private boolean tmpReplyIncludeHeaders;

    private static native void initIds();

    private native String getFromName(int var1);

    private native boolean getHTMLReplyFormat(int var1);

    private native boolean getPlainTextReplyFormat(int var1);

    private native int getSyncInterval(int var1);

    private native boolean isIntervalSyncEnabled(int var1);

    private native boolean isStartupSyncEnabled(int var1);

    private native boolean isSyncStatusWindowEnabled(int var1);

    private native void setFromName(int var1, String var2);

    private native boolean setHTMLReplyFormat(int var1, int var2, int var3, int var4);

    private native void setIntervalSyncEnabled(int var1, boolean var2);

    private native boolean setPlainTextReplyFormat(int var1, int var2, int var3, int var4);

    private native void setStartupSyncEnabled(int var1, boolean var2);

    private native void setSyncInterval(int var1, int var2);

    private native void setSyncStatusWindowEnabled(int var1, boolean var2);

    public AccountSettings() {
    }

    public AccountSettings(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pAccSettings = n;
    }

    public String getFromText() {
        return this.getFromName(this.pAccSettings);
    }

    public synchronized HTMLReplyFormat getHTMLReplyFormat() {
        this.tmpReplyType = 0;
        this.tmpReplyInsertAtBottom = false;
        this.tmpReplyIncludeHeaders = false;
        HTMLReplyFormat hTMLReplyFormat = null;
        if (this.getHTMLReplyFormat(this.pAccSettings)) {
            hTMLReplyFormat = new HTMLReplyFormat(this.tmpReplyType, this.tmpReplyInsertAtBottom, this.tmpReplyIncludeHeaders);
        }
        return hTMLReplyFormat;
    }

    public synchronized PlainTextReplyFormat getPlainTextReplyFormat() {
        this.tmpReplyType = 0;
        this.tmpReplyInsertAtBottom = false;
        this.tmpReplyChar = 62;
        PlainTextReplyFormat plainTextReplyFormat = null;
        if (this.getPlainTextReplyFormat(this.pAccSettings)) {
            plainTextReplyFormat = new PlainTextReplyFormat(this.tmpReplyType, this.tmpReplyInsertAtBottom, (char)this.tmpReplyChar);
        }
        return plainTextReplyFormat;
    }

    public int getSyncInterval() {
        return this.getSyncInterval(this.pAccSettings);
    }

    public boolean isSyncStatusWindowEnabled() {
        return this.isSyncStatusWindowEnabled(this.pAccSettings);
    }

    public boolean isIntervalSyncEnabled() {
        return this.isIntervalSyncEnabled(this.pAccSettings);
    }

    public boolean isStartupSyncEnabled() {
        return this.isStartupSyncEnabled(this.pAccSettings);
    }

    public void setFromText(String string) {
        this.setFromName(this.pAccSettings, string);
    }

    public boolean setHTMLReplyFormat(Integer n, Boolean bl, Boolean bl2) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (n != null) {
            n2 = n;
        }
        if (bl != null) {
            int n5 = n3 = bl == true ? 1 : 0;
        }
        if (bl2 != null) {
            n4 = bl2 == true ? 1 : 0;
        }
        return this.setHTMLReplyFormat(this.pAccSettings, n2, n3, n4);
    }

    public void setIntervalSyncEnabled(boolean bl) {
        this.setIntervalSyncEnabled(this.pAccSettings, bl);
    }

    public boolean setPlainTextReplyFormat(Integer n, Boolean bl, Character c) {
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        if (n != null) {
            n2 = n;
        }
        if (bl != null) {
            int n5 = n3 = bl == true ? 1 : 0;
        }
        if (c != null) {
            n4 = c.charValue();
        }
        return this.setPlainTextReplyFormat(this.pAccSettings, n2, n3, n4);
    }

    public void setStartupSyncEnabled(boolean bl) {
        this.setStartupSyncEnabled(this.pAccSettings, bl);
    }

    public void setSyncInterval(int n) {
        this.setSyncInterval(this.pAccSettings, n);
    }

    public void setSyncStatusWindowEnabled(boolean bl) {
        this.setSyncStatusWindowEnabled(this.pAccSettings, bl);
    }

    static {
        AccountSettings.initIds();
    }

    public class PlainTextReplyFormat {
        public static final int REPLY_FORMAT_GW_CLASSIC = 0;
        public static final int REPLY_FORMAT_INCLUDE_HEADERS = 1;
        public static final int REPLY_FORMAT_INTERNET_STANDARD = 2;
        private int replyType;
        private boolean replyInsertAtBottom;
        private char replyChar;

        public PlainTextReplyFormat(int n, boolean bl, char c) {
            this.replyType = n;
            this.replyInsertAtBottom = bl;
            this.replyChar = c;
        }

        public int getReplyType() {
            return this.replyType;
        }

        public boolean isReplyInsertAtBottom() {
            return this.replyInsertAtBottom;
        }

        public char getReplyChar() {
            return this.replyChar;
        }
    }

    public class HTMLReplyFormat {
        public static final int REPLY_FORMAT_GW_CLASSIC = 0;
        public static final int REPLY_FORMAT_HTML_ENHANCED = 1;
        private int replyType;
        private boolean replyInsertAtBottom;
        private boolean replyIncludeHeaders;

        public HTMLReplyFormat(int n, boolean bl, boolean bl2) {
            this.replyType = n;
            this.replyInsertAtBottom = bl;
            this.replyIncludeHeaders = bl2;
        }

        public int getReplyType() {
            return this.replyType;
        }

        public boolean isReplyInsertAtBottom() {
            return this.replyInsertAtBottom;
        }

        public boolean isReplyIncludeHeaders() {
            return this.replyIncludeHeaders;
        }
    }
}

