/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.account.Account;
import com.novell.gw.engine.DataStore;
import com.novell.gw.engine.EngineException;
import java.io.File;

public class DataStoreSettings {
    public static final int SET_SIG_NO_SIGNATURE = 0;
    public static final int SET_SIG_ALWAYS_ADD = 1;
    public static final int SET_SIG_ALWAYS_PROMPT = 201;
    public static final int SET_CLEANUP_MANUAL = 0;
    public static final int SET_CLEANUP_AUTO_DELETE = 1;
    public static final int SET_CLEANUP_AUTO_PURGE = 1;
    public static final int SET_CLEANUP_AUTO_ARCHIVE = 2;
    private int pGWSettings;
    private int tmpnMailAndPhone;
    private boolean tmpbMailAndPhoneLocked;
    private int tmpnMailAndPhoneDays;
    private boolean tmpbMailAndPhoneDaysLocked;
    private int tmpnCalItem;
    private boolean tmpbCalItemLocked;
    private int tmpnCalItemDays;
    private boolean tmpbCalItemDaysLocked;
    private int tmpnTrash;
    private boolean tmpbTrashLocked;
    private int tmpnTrashDays;
    private boolean tmpbTrashDaysLocked;
    private int tmpSecurity;
    private boolean tmpSecurityLocked;
    private String tmpSecurityDisplayText;
    private int tmpPriority;
    private boolean tmpPriorityLocked;
    private boolean tmpReplyRequest;
    private boolean tmpReplyWhenConvenient;
    private boolean tmpReplyRequestLocked;
    private int tmpReplyWithinDays;
    private boolean tmpMailNotification;
    private boolean tmpNotification;
    private boolean tmpNotificationLocked;
    private boolean tmpSignatureOn;
    private int tmpSignatureStatus;
    private String tmpSignatureText;
    private boolean tmpVCardOn;
    private String tmpVCardFileName;
    private int tmpMimeEncoding;
    private boolean tmpMimeEncodingLocked;

    private static native int create(int var0);

    private native void dispose(int var1);

    private native String getArchivePath(int var1);

    private native boolean setArchivePath(int var1, String var2);

    private native boolean isPasswordSet(int var1);

    private native void setPassword(int var1, String var2, String var3) throws EngineException;

    private native boolean getSignatureAndvCard(int var1, int var2);

    private native boolean setSignatureAndvCard(int var1, int var2, int var3, String var4, int var5, String var6, int var7);

    private native boolean getCleanupOptions(int var1);

    private native boolean setCleanupOptions(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private native boolean getSendOptionReturnNotification(int var1, int var2, int var3);

    private native boolean setSendOptionReturnNotification(int var1, int var2, int var3, int[] var4, boolean[] var5, boolean[] var6);

    private native boolean getSendOptionReplyRequest(int var1);

    private native boolean setSendOptionReplyRequest(int var1, boolean var2, boolean var3, int var4);

    private native boolean getSendOptionSecurityClassification(int var1);

    private native boolean setSendOptionSecurityClassification(int var1, int var2, String var3);

    private native boolean getSendOptionPriority(int var1);

    private native boolean setSendOptionPriority(int var1, int var2);

    private native boolean getSendOptionMimeEncoding(int var1);

    private native boolean setSendOptionMimeEncoding(int var1, int var2);

    private native int getBackupInterval(int var1);

    private native void setBackupInterval(int var1, int var2);

    private native String getBackupLocation(int var1);

    private native boolean setBackupLocation(int var1, String var2);

    private static native void initIds();

    public DataStoreSettings() {
    }

    DataStoreSettings(DataStore dataStore) {
        this(DataStoreSettings.create(dataStore.getPointer()));
    }

    DataStoreSettings(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pGWSettings = n;
    }

    public synchronized SignatureOptions getSignature(Account account) {
        this.tmpSignatureOn = false;
        this.tmpSignatureStatus = 0;
        this.tmpSignatureText = null;
        this.tmpVCardOn = false;
        this.tmpVCardFileName = null;
        if (this.getSignatureAndvCard(this.pGWSettings, account != null ? account.getPointer() : 0)) {
            return new SignatureOptions(this.tmpSignatureOn, this.tmpSignatureStatus, this.tmpSignatureText, this.tmpVCardOn, this.tmpVCardFileName);
        }
        return null;
    }

    public boolean setSignature(Boolean bl, int n, String string, Boolean bl2, String string2, Account account) {
        int n2 = -1;
        int n3 = -1;
        if (bl != null) {
            int n4 = n2 = bl == true ? 1 : 0;
        }
        if (bl2 != null) {
            n3 = bl2 == true ? 1 : 0;
        }
        return this.setSignatureAndvCard(this.pGWSettings, n2, n, string, n3, string2, account != null ? account.getPointer() : 0);
    }

    public synchronized SendOptionSecurity getSendOptionSecurityClassification() {
        this.tmpSecurity = 100;
        this.tmpSecurityLocked = false;
        this.tmpSecurityDisplayText = null;
        if (this.getSendOptionSecurityClassification(this.pGWSettings)) {
            return new SendOptionSecurity(this.tmpSecurity, this.tmpSecurityLocked, this.tmpSecurityDisplayText);
        }
        return null;
    }

    public boolean setSendOptionSecurityClassification(int n, String string) {
        return this.setSendOptionSecurityClassification(this.pGWSettings, n, string);
    }

    public synchronized SendOptionPriority getSendOptionPriority() {
        this.tmpPriority = 2;
        this.tmpPriorityLocked = false;
        if (this.getSendOptionPriority(this.pGWSettings)) {
            return new SendOptionPriority(this.tmpPriority, this.tmpPriorityLocked);
        }
        return null;
    }

    public boolean setSendOptionPriority(int n) {
        return this.setSendOptionPriority(this.pGWSettings, n);
    }

    public synchronized SendOptionReplyRequested getSendOptionReplyRequested() {
        this.tmpReplyRequest = false;
        this.tmpReplyRequestLocked = false;
        this.tmpReplyWhenConvenient = false;
        this.tmpReplyWithinDays = 0;
        if (this.getSendOptionReplyRequest(this.pGWSettings)) {
            return new SendOptionReplyRequested(this.tmpReplyRequest, this.tmpReplyRequestLocked, this.tmpReplyWhenConvenient, this.tmpReplyWithinDays);
        }
        return null;
    }

    public boolean setSendOptionReplyRequested(boolean bl, boolean bl2, int n) {
        return this.setSendOptionReplyRequest(this.pGWSettings, bl, bl2, n);
    }

    public boolean setSendOptionMimeEncoding(int n) {
        return this.setSendOptionMimeEncoding(this.pGWSettings, n);
    }

    public synchronized SendOptionMimeEncoding getSendOptionMimeEncoding() {
        this.tmpMimeEncoding = 2;
        this.tmpMimeEncodingLocked = false;
        if (this.getSendOptionMimeEncoding(this.pGWSettings)) {
            return new SendOptionMimeEncoding(this.tmpMimeEncoding, this.tmpMimeEncodingLocked);
        }
        return null;
    }

    public synchronized SendOptionNotification getSendOptionReturnNotification(int n, int n2) {
        this.tmpMailNotification = false;
        this.tmpNotification = false;
        this.tmpNotificationLocked = false;
        if (this.getSendOptionReturnNotification(this.pGWSettings, n, n2)) {
            return new SendOptionNotification(this.tmpMailNotification, this.tmpNotification, this.tmpNotificationLocked);
        }
        return null;
    }

    public boolean setSendOptionReturnNotification(int n, int[] nArray, boolean[] blArray, boolean[] blArray2) {
        int n2 = nArray.length;
        if (blArray.length < n2) {
            n2 = blArray.length;
        }
        if (blArray2.length < n2) {
            n2 = blArray2.length;
        }
        return this.setSendOptionReturnNotification(this.pGWSettings, n, n2, nArray, blArray, blArray2);
    }

    public synchronized CleanupOptions getCleanupOption() {
        this.tmpnMailAndPhone = 0;
        this.tmpbMailAndPhoneLocked = false;
        this.tmpnMailAndPhoneDays = 0;
        this.tmpbMailAndPhoneDaysLocked = false;
        this.tmpnCalItem = 0;
        this.tmpbCalItemLocked = false;
        this.tmpnCalItemDays = 0;
        this.tmpbCalItemDaysLocked = false;
        this.tmpnTrash = 0;
        this.tmpbTrashLocked = false;
        this.tmpnTrashDays = 0;
        this.tmpbTrashDaysLocked = false;
        if (this.getCleanupOptions(this.pGWSettings)) {
            return new CleanupOptions(this.tmpnMailAndPhone, this.tmpbMailAndPhoneLocked, this.tmpnMailAndPhoneDays, this.tmpbMailAndPhoneDaysLocked, this.tmpnCalItem, this.tmpbCalItemLocked, this.tmpnCalItemDays, this.tmpbCalItemDaysLocked, this.tmpnTrash, this.tmpbTrashLocked, this.tmpnTrashDays, this.tmpbTrashDaysLocked);
        }
        return null;
    }

    public boolean setCleanupOptions(Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6) {
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        int n11 = -1;
        int n12 = -1;
        if (n != null) {
            n7 = n;
        }
        if (n2 != null) {
            n8 = n2;
        }
        if (n3 != null) {
            n9 = n3;
        }
        if (n4 != null) {
            n10 = n4;
        }
        if (n5 != null) {
            n11 = n5;
        }
        if (n6 != null) {
            n12 = n6;
        }
        return this.setCleanupOptions(this.pGWSettings, n7, n8, n9, n10, n11, n12);
    }

    public String getArchivePath() {
        String string = this.getArchivePath(this.pGWSettings);
        return string;
    }

    public boolean setArchivePath(File file) {
        if (file == null) {
            return this.setArchivePath(this.pGWSettings, "");
        }
        return this.setArchivePath(file.getPath());
    }

    public boolean setArchivePath(String string) {
        return this.setArchivePath(this.pGWSettings, string);
    }

    public boolean isPasswordSet() {
        return this.isPasswordSet(this.pGWSettings);
    }

    public void setPassword(String string, String string2) throws EngineException {
        this.setPassword(this.pGWSettings, string, string2);
    }

    public int getBackupInterval() {
        return this.getBackupInterval(this.pGWSettings);
    }

    public void setBackupInterval(int n) {
        this.setBackupInterval(this.pGWSettings, n);
    }

    public String getBackupLocation() {
        return this.getBackupLocation(this.pGWSettings);
    }

    public boolean setBackupLocation(String string) {
        return this.setBackupLocation(this.pGWSettings, string);
    }

    public void dispose() {
        if (this.pGWSettings != 0) {
            this.dispose(this.pGWSettings);
            this.pGWSettings = 0;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    static {
        DataStoreSettings.initIds();
    }

    public class CleanupOptions {
        private int nMailAndPhone;
        private boolean bMailAndPhoneLocked;
        private int nMailAndPhoneDays;
        private boolean bMailAndPhoneDaysLocked;
        private int nCalItem;
        private boolean bCalItemLocked;
        private int nCalItemDays;
        private boolean bCalItemDaysLocked;
        private int nTrash;
        private boolean bTrashLocked;
        private int nTrashDays;
        private boolean bTrashDaysLocked;

        CleanupOptions(int n, boolean bl, int n2, boolean bl2, int n3, boolean bl3, int n4, boolean bl4, int n5, boolean bl5, int n6, boolean bl6) {
            this.nMailAndPhone = n;
            this.bMailAndPhoneLocked = bl;
            this.nMailAndPhoneDays = n2;
            this.bMailAndPhoneDaysLocked = bl2;
            this.nCalItem = n3;
            this.bCalItemLocked = bl3;
            this.nCalItemDays = n4;
            this.bCalItemDaysLocked = bl4;
            this.nTrash = n5;
            this.bTrashLocked = bl5;
            this.nTrashDays = n6;
            this.bTrashDaysLocked = bl6;
        }

        public int getMailAndPhone() {
            return this.nMailAndPhone;
        }

        public boolean isMailAndPhoneLocked() {
            return this.bMailAndPhoneLocked;
        }

        public int getMailAndPhoneDays() {
            return this.nMailAndPhoneDays;
        }

        public boolean isMailAndPhoneDaysLocked() {
            return this.bMailAndPhoneDaysLocked;
        }

        public int getCalItem() {
            return this.nCalItem;
        }

        public boolean isCalItemLocked() {
            return this.bCalItemLocked;
        }

        public int getCalItemDays() {
            return this.nCalItemDays;
        }

        public boolean isCalItemDaysLocked() {
            return this.bCalItemDaysLocked;
        }

        public int getTrash() {
            return this.nTrash;
        }

        public boolean isTrashLocked() {
            return this.bTrashLocked;
        }

        public int getTrashDays() {
            return this.nTrashDays;
        }

        public boolean isTrashDaysLocked() {
            return this.bTrashDaysLocked;
        }
    }

    public class SendOptionNotification {
        private boolean mailNotification;
        private boolean notification;
        private boolean notificationLocked;

        SendOptionNotification(boolean bl, boolean bl2, boolean bl3) {
            this.mailNotification = bl;
            this.notification = bl2;
            this.notificationLocked = bl3;
        }

        public boolean isMailNotificationSet() {
            return this.mailNotification;
        }

        public boolean isNotificationSet() {
            return this.notification;
        }

        public boolean isNotificationLocked() {
            return this.notificationLocked;
        }
    }

    public class SendOptionReplyRequested {
        private boolean replyRequest;
        private boolean replyRequestLocked;
        private boolean replyWhenConvenient;
        private int replyWithinDays;

        SendOptionReplyRequested(boolean bl, boolean bl2, boolean bl3, int n) {
            this.replyRequest = bl;
            this.replyRequestLocked = bl2;
            this.replyWhenConvenient = bl3;
            this.replyWithinDays = n;
        }

        public boolean isReplyRequested() {
            return this.replyRequest;
        }

        public boolean isReplyRequestedLocked() {
            return this.replyRequestLocked;
        }

        public boolean isReplyWhenConvenient() {
            return this.replyWhenConvenient;
        }

        public int getReplyWithinDays() {
            return this.replyWithinDays;
        }
    }

    public class SendOptionPriority {
        private int priority;
        private boolean priorityLocked;

        SendOptionPriority(int n, boolean bl) {
            this.priority = n;
            this.priorityLocked = bl;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean getPriorityLocked() {
            return this.priorityLocked;
        }
    }

    public class SendOptionSecurity {
        private int security;
        private boolean securityLocked;
        private String securityDisplayText;

        SendOptionSecurity(int n, boolean bl, String string) {
            this.security = n;
            this.securityLocked = bl;
            this.securityDisplayText = string;
        }

        public int getSecurityLevel() {
            return this.security;
        }

        public boolean getSecurityLocked() {
            return this.securityLocked;
        }

        public String getSecurityDisplayText() {
            return this.securityDisplayText;
        }
    }

    public class SignatureOptions {
        private boolean signatureOn;
        private int signatureStatus;
        private String signatureText;
        private boolean vCardOn;
        private String vCardFileName;

        SignatureOptions(boolean bl, int n, String string, boolean bl2, String string2) {
            this.signatureOn = bl;
            this.signatureStatus = n;
            this.signatureText = string;
            this.vCardOn = bl2;
            this.vCardFileName = string2;
        }

        public boolean isSignatureOn() {
            return this.signatureOn;
        }

        public int getSignatureStatus() {
            return this.signatureStatus;
        }

        public String getSignatureText() {
            return this.signatureText;
        }

        public boolean isVCardOn() {
            return this.vCardOn;
        }

        public String getVCardFileName() {
            return this.vCardFileName;
        }
    }

    public class SendOptionMimeEncoding {
        private int mimeEncoding;
        private boolean mimeEncodingLocked;

        SendOptionMimeEncoding(int n, boolean bl) {
            this.mimeEncoding = n;
            this.mimeEncodingLocked = bl;
        }

        public boolean isMimeEncodingLocked() {
            return this.mimeEncodingLocked;
        }

        public int getMimeEncoding() {
            return this.mimeEncoding;
        }
    }
}

