/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.engine;

import com.novell.gw.ab.Addressable;
import com.novell.gw.engine.ProxyHistoryEntry;
import java.util.ArrayList;

public class ProxyHistoryList {
    protected ArrayList entryList;
    private int pHistoryList = 0;

    private native int add(int var1, String var2, String var3, String var4, String var5, String var6, String var7);

    private native int addHistoryEntry(int var1, int var2);

    private native int addAddressable(int var1, int var2);

    private native boolean remove(int var1, int var2);

    private native int get(int var1, int var2);

    private native int getSize(int var1);

    private native void commit(int var1);

    private native void dispose(int var1);

    public ProxyHistoryList(int n) {
        if (n == 0) {
            throw new NullPointerException();
        }
        this.pHistoryList = n;
        this.readEntries();
    }

    public int size() {
        if (this.entryList == null) {
            return 0;
        }
        return this.entryList.size();
    }

    public int add(ProxyHistoryEntry proxyHistoryEntry) {
        int n = this.getSize(this.pHistoryList);
        int n2 = this.addHistoryEntry(this.pHistoryList, proxyHistoryEntry.getPointer());
        if (n2 >= 0 && this.getSize(this.pHistoryList) > n) {
            this.entryList.add(n2, proxyHistoryEntry);
        }
        return n2;
    }

    public int add(String string, String string2, String string3, String string4, String string5, String string6) {
        int n = this.getSize(this.pHistoryList);
        int n2 = this.add(this.pHistoryList, string, string2, string3, string4, string5, string6);
        if (n2 >= 0 && this.getSize(this.pHistoryList) > n) {
            int n3 = this.get(this.pHistoryList, n2);
            ProxyHistoryEntry proxyHistoryEntry = new ProxyHistoryEntry(n3);
            this.entryList.add(n2, proxyHistoryEntry);
        }
        return n2;
    }

    public int add(Addressable addressable) {
        int n = this.getSize(this.pHistoryList);
        int n2 = this.addAddressable(this.pHistoryList, addressable.getAddressablePointer());
        if (n2 >= 0 && this.getSize(this.pHistoryList) > n) {
            int n3 = this.get(this.pHistoryList, n2);
            ProxyHistoryEntry proxyHistoryEntry = new ProxyHistoryEntry(n3);
            this.entryList.add(n2, proxyHistoryEntry);
        }
        return n2;
    }

    public boolean remove(int n) {
        boolean bl = this.remove(this.pHistoryList, n);
        if (bl) {
            this.entryList.remove(n);
        }
        return bl;
    }

    public ProxyHistoryEntry get(int n) {
        if (n < this.entryList.size()) {
            return (ProxyHistoryEntry)this.entryList.get(n);
        }
        return null;
    }

    private void readEntries() {
        if (this.entryList == null) {
            int n = 0;
            ProxyHistoryEntry proxyHistoryEntry = null;
            int n2 = this.getSize(this.pHistoryList);
            this.entryList = new ArrayList(n2);
            for (int i = 0; i < n2; ++i) {
                n = this.get(this.pHistoryList, i);
                proxyHistoryEntry = n != 0 ? new ProxyHistoryEntry(n) : null;
                this.entryList.add(i, proxyHistoryEntry);
            }
        }
    }

    public void commit() {
        this.commit(this.pHistoryList);
    }

    public void cancel() {
        this.dispose();
    }

    public void dispose() {
        this.entryList = null;
        this.dispose(this.pHistoryList);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

