/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.util.DataReader;
import java.io.IOException;

public class CompiledTLex
extends TLex {
    static final int HEADER_SIZE = 256;
    static final byte[] MAGIC = new byte[]{-96, 65, 90, 99, 104, 101, 99, 107};
    static final byte MAJOR_VERSION = 1;
    static final byte MINOR_VERSION = 3;
    DataReader reader_;
    int compoundMin_ = 0;
    int curNodeFlags_;
    int[] sharedSuffixes_;
    static final int FAKE_CHILD = 1;
    static final int SHARED_CHILD = 2;

    public CompiledTLex(Object location) {
        super(location);
    }

    public CompiledTLex setReader(DataReader reader) throws IOException, SpellException {
        byte minor;
        this.reader_ = reader;
        if (this.reader_ == null) {
            return null;
        }
        for (int i = 0; i < MAGIC.length; ++i) {
            if (reader.getByte() == MAGIC[i]) continue;
            throw new SpellException("bad magic number");
        }
        byte major = reader.getByte();
        if (major * 100 + (minor = reader.getByte()) > 103) {
            throw new SpellException("version " + major + "." + minor + " not supported");
        }
        int controlBlock = reader.getInt();
        this.compoundMin_ = reader.getInt();
        this.load(controlBlock);
        return this;
    }

    int getCompoundMin() {
        return this.compoundMin_;
    }

    int step(int node, byte ch) {
        if (node <= 0) {
            throw new RuntimeException("bad node " + node);
        }
        ++this.stepCnt_;
        this.reader_.seek(node);
        byte kidCnt = this.reader_.getByte();
        int kidRank = this.reader_.sortedArrayFind(ch, kidCnt);
        if (kidRank < 0) {
            return -1;
        }
        byte flags = this.reader_.getByte();
        int ptrSize = (flags & 3) + 1;
        this.reader_.skip(kidRank * ptrSize);
        int kid = this.reader_.getInt(ptrSize);
        if ((kid & 1) == 0) {
            return node - (kid >> 1);
        }
        if ((kid & 2) != 0) {
            return this.sharedSuffixes_[kid >> 2];
        }
        this.curNodeFlags_ = kid >> 2;
        return 0;
    }

    int getFlags(int node) {
        int flags;
        if (node < 0) {
            return -1;
        }
        if (node > 0) {
            this.reader_.seek(node);
            byte cnt = this.reader_.getByte();
            if (cnt > 0) {
                this.reader_.skip(cnt);
            }
            flags = this.reader_.getByte() >> 2;
        } else {
            flags = this.curNodeFlags_;
        }
        return CompiledTLex.actualWord(flags) ? flags : -1;
    }

    TLex.KEnum newKEnum(int node) {
        return new KEnum(node);
    }

    void load(int controlOffset) throws IOException, SpellException {
        this.reader_.seek(controlOffset);
        this.rootNode_ = this.reader_.getInt();
        int charsOffset = this.reader_.getInt();
        int sharedSuffixesOffset = this.reader_.getInt();
        this.reader_.seek(charsOffset);
        super.load(this.reader_);
        this.reader_.seek(sharedSuffixesOffset);
        int C = this.reader_.getInt();
        this.sharedSuffixes_ = new int[C];
        for (int c = 0; c < C; ++c) {
            this.sharedSuffixes_[c] = this.reader_.getInt(4);
        }
    }

    class KEnum
    implements TLex.KEnum {
        int node_;
        int kidCnt_;
        int kidPtr_;
        byte[] chars_;
        int[] kids_;

        public KEnum(int node) {
            this.node_ = node;
            CompiledTLex.this.reader_.seek(this.node_);
            this.kidCnt_ = CompiledTLex.this.reader_.getByte();
            this.chars_ = CompiledTLex.this.reader_.getBytes(this.kidCnt_);
            int byteSize = (CompiledTLex.this.reader_.getByte() & 3) + 1;
            this.kids_ = CompiledTLex.this.reader_.getIntArray(this.kidCnt_, byteSize);
            this.kidPtr_ = -1;
        }

        public boolean next() {
            return ++this.kidPtr_ < this.kidCnt_;
        }

        public int getCurrentNode() {
            int kid = this.kids_[this.kidPtr_];
            if ((kid & 1) == 0) {
                return this.node_ - (kid >> 1);
            }
            if ((kid & 2) != 0) {
                return CompiledTLex.this.sharedSuffixes_[kid >> 2];
            }
            CompiledTLex.this.curNodeFlags_ = kid >> 2;
            return 0;
        }

        public byte getCurrentChar() {
            return this.chars_[this.kidPtr_];
        }
    }
}

