/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CompiledTLex;
import azcheck.engine.CompositeTLex;
import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.EditableTLex;
import azcheck.engine.SpellException;
import azcheck.engine.TLex;
import azcheck.util.CoreReader;
import azcheck.util.Logger;
import azcheck.util.QuickSort;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DictionaryManager {
    protected String dictPath;
    protected Hashtable dictBindings = new Hashtable();
    protected Hashtable autoLocated = new Hashtable();
    protected Hashtable langInfo = new Hashtable();
    protected Hashtable cdiCache = new Hashtable();
    Logger logger;
    static final String DEFAULT_DICT = "/default";
    static final String LANGUAGE_FILE = "language";
    static final String DICT_ARCHIVE_EXT = ".dar";
    static final String COMPILED_DICT_EXT = ".cdi";
    static final byte[] MULTILINK_MAGIC = new byte[]{64, 109, 117, 108, 116, 105, 108, 105, 110, 107, 58};

    public DictionaryManager() throws IOException {
        this(null);
    }

    public DictionaryManager(String dictPath) throws IOException {
        if (dictPath == null) {
            dictPath = this.dictsDir();
        }
        if (dictPath != null) {
            this.setAccessPath(dictPath);
        } else {
            this.defaultDictionaries();
        }
    }

    public void defineDictionary(String name, URL location) throws IOException {
        this.log("defineDictionary " + name + " as " + location);
        if (name.indexOf(47) < 0) {
            name = name + DEFAULT_DICT;
        }
        if (location == null) {
            URL url = this.getClass().getResource("/" + name);
            if (url == null) {
                throw new IOException("dictionary name '" + name + "' not locatable as a resource");
            }
            location = url;
        }
        DictionaryManagerItem bound = new DictionaryManagerItem(name);
        bound.location = location;
        this.dictBindings.put(name, bound);
        DictionaryManagerItem info = (DictionaryManagerItem)this.langInfo.get(DictionaryManager.getLanguage(name));
        if (info != null) {
            bound.english = info.english;
            bound.local = info.local;
            bound.encoding = info.encoding;
        }
    }

    public synchronized void setAccessPath(String dictPath) throws IOException {
        this.log("setAccessPath " + dictPath);
        if (dictPath == null) {
            throw new IllegalArgumentException("dictPath argument must not be null");
        }
        try {
            File dirAccess = new File(dictPath);
            if (dirAccess.isDirectory()) {
                this.unloadDictionaries();
                File[] dars = dirAccess.listFiles();
                for (int d = 0; d < dars.length; ++d) {
                    this.scanArchive(dars[d]);
                }
            }
        }
        catch (Exception e) {
            this.log("setAccessPath: Security!");
        }
        this.defaultDictionaries();
    }

    public void defaultDictionaries() {
        this.defLocate("en", "English", "English", "ISO8859_1");
        this.defLocate("en-CA", "English (CA)", "English (CA)", "ISO8859_1");
        this.defLocate("en-GB", "English (GB)", "English (GB)", "ISO8859_1");
        this.defLocate("en-US", "English (US)", "English (US)", "ISO8859_1");
        this.defLocate("fr", "French", "Fran\u00e7ais", "ISO8859_1");
        this.defLocate("fr-BE", "French (BE)", "Fran\u00e7ais (BE)", "ISO8859_1");
        this.defLocate("fr-CA", "French (CA)", "Fran\u00e7ais (CA)", "ISO8859_1");
        this.defLocate("fr-CH", "French (CH)", "Fran\u00e7ais (CH)", "ISO8859_1");
        this.defLocate("de", "German", "Deutsch", "ISO8859_1");
        this.defLocate("es", "Spanish", "Espa\u00f1ol", "ISO8859_1");
        this.defLocate("it", "Italian", "Italiano", "ISO8859_1");
        this.defLocate("pt", "Portuguese", "Portugu\u00eas", "ISO8859_1");
        this.defLocate("nl", "Dutch", "Nederlands", "ISO8859_1");
        this.defLocate("da", "Danish", "Dansk", "ISO8859_1");
        this.defLocate("fi", "Finnish", "Suomi", "ISO8859_1");
        this.defLocate("no", "Norwegian", "Norsk", "ISO8859_1");
        this.defLocate("sv", "Swedish", "svensk", "ISO8859_1");
        this.defLocate("cs", "Czech", "Cesko", "ISO8859_2");
        this.defLocate("pl", "Polish", "Polski", "ISO8859_2");
        this.defLocate("ru", "Russian", "\u0440\u0443\u0441\u0441\u040a\u0408\u0409", "KOI8_R");
    }

    private String dictsDir() {
        try {
            this.dictPath = System.getProperty("java.class.path");
            int start = 0;
            while (start < this.dictPath.length()) {
                int end = this.dictPath.indexOf(File.pathSeparatorChar, start);
                if (end < 0) {
                    end = this.dictPath.length();
                }
                if (end != start) {
                    File dicts;
                    File dir = new File(this.dictPath.substring(start, end - start));
                    if (!dir.isDirectory()) {
                        dir = dir.getParentFile();
                    }
                    if ((dicts = new File(dir, "dicts")).isDirectory()) {
                        return dicts.getCanonicalPath();
                    }
                }
                start = end + 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void scanArchive(File archive) {
        try {
            ZipFile zip = new ZipFile(archive);
            Enumeration<? extends ZipEntry> iter = zip.entries();
            URL base = new URL("jar:file:" + archive.getCanonicalPath() + "!/");
            while (iter.hasMoreElements()) {
                ZipEntry zentry = iter.nextElement();
                String entName = zentry.getName();
                if (entName.endsWith("/language") || entName.endsWith("/") || entName.endsWith(COMPILED_DICT_EXT) || entName.startsWith("META")) continue;
                this.autoLocated.put(entName, new URL(base, entName));
            }
            zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void defLocate(String name, String ename, String lname, String encoding) {
        DictionaryManagerItem info = new DictionaryManagerItem(name);
        info.english = ename;
        info.local = lname;
        info.encoding = encoding;
        this.langInfo.put(name, info);
        String fullName = name + DEFAULT_DICT;
        URL url = this.getClass().getResource("/" + fullName);
        if (url == null) {
            info.location = this.autoLocated.get(fullName);
            if (info.location == null) {
                if (this.logger != null) {
                    this.log(fullName + " not located! ");
                }
                return;
            }
            if (this.logger != null) {
                this.log(fullName + " auto: " + info.location);
            }
        } else {
            info.location = url;
            if (this.logger != null) {
                this.log(fullName + " as resource: " + url);
            }
        }
        this.dictBindings.put(fullName, info);
    }

    public synchronized void addAccessPaths(String dictPath) throws IOException {
        int sep = dictPath.indexOf(File.pathSeparatorChar);
        if (sep > 1) {
            throw new IllegalArgumentException("deprecated method");
        }
        this.setAccessPath(dictPath);
    }

    public String getAccessPath() {
        return this.dictPath;
    }

    public synchronized DictionaryManagerItem[] listLanguages() throws IOException {
        Object[] items = new DictionaryManagerItem[this.dictBindings.size()];
        Enumeration e = this.dictBindings.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            items[i++] = (DictionaryManagerItem)e.nextElement();
        }
        QuickSort.sort(items, new QuickSort.Compare(){

            public int compare(Object o1, Object o2) {
                DictionaryManagerItem i1 = (DictionaryManagerItem)o1;
                DictionaryManagerItem i2 = (DictionaryManagerItem)o2;
                return i1.local.compareTo(i2.local);
            }
        });
        return items;
    }

    public DictionaryManagerItem getLanguageInfo(String name) {
        return (DictionaryManagerItem)this.langInfo.get(name);
    }

    public synchronized void unloadDictionaries() {
        this.cdiCache = new Hashtable();
    }

    public synchronized void clear() {
        this.unloadDictionaries();
        this.dictBindings = new Hashtable();
        this.dictPath = null;
    }

    public synchronized TLex load(String dictName, TLex hints) throws IOException, SpellException {
        DictionaryManagerItem info;
        if (dictName.indexOf(47) < 0) {
            dictName = dictName + DEFAULT_DICT;
        }
        if ((info = (DictionaryManagerItem)this.dictBindings.get(dictName)) == null) {
            throw new SpellException("undefined dictionary name: " + dictName);
        }
        TLex tlex = this.load((URL)info.location, hints);
        return tlex;
    }

    public synchronized TLex load(URL dictURL, TLex hints) throws IOException, SpellException {
        byte[] data = this.getDataFromCache(dictURL);
        if (data != null) {
            CompiledTLex cd = new CompiledTLex(dictURL);
            cd.setReader(new CoreReader(data));
            return cd;
        }
        InputStream source = dictURL.openStream();
        if (source == null) {
            throw new IOException("empty or unreachable dictionary: " + dictURL);
        }
        data = this.readDataBlock(0, source);
        source.close();
        if (data.length > 2 && data[0] == CompiledTLex.MAGIC[0] && data[1] == CompiledTLex.MAGIC[1]) {
            CompiledTLex cd = new CompiledTLex(dictURL);
            cd.setReader(new CoreReader(data));
            Entry e = new Entry();
            e.softref = new SoftReference<byte[]>(data);
            ++e.refs;
            e.data = data;
            this.cdiCache.put(dictURL, e);
            return cd;
        }
        if (data[0] == MULTILINK_MAGIC[0] && data[1] == MULTILINK_MAGIC[1]) {
            CompositeTLex comp = new CompositeTLex(dictURL);
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
            if (dictURL == null) {
                throw new IllegalArgumentException("base URL needed for loading composite dictionaries");
            }
            String L = br.readLine();
            while ((L = br.readLine()) != null) {
                if ((L = L.trim()).length() == 0 || L.charAt(0) == '#') {
                    if (!L.startsWith("##Copyright: ")) continue;
                    comp.setCopyright(L.substring(13));
                    continue;
                }
                boolean forgiving = false;
                if (L.charAt(0) == '?') {
                    forgiving = true;
                    L = L.substring(1);
                }
                TLex sub = null;
                if (!forgiving) {
                    sub = this.load(new URL(dictURL, L), hints);
                } else {
                    try {
                        sub = this.load(new URL(dictURL, L), hints);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (sub == null) continue;
                comp.addMember(sub);
                if (hints != null) continue;
                hints = sub;
            }
            return comp;
        }
        if (hints == null) {
            throw new SpellException("cannot load text dictionary without hints");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        EditableTLex ed = new EditableTLex(dictURL == null ? "?" : dictURL.toString(), hints);
        ed.load(br, true);
        return ed;
    }

    protected synchronized void reloadCompiledDictionary(CompiledTLex cd) throws IOException, SpellException {
        cd.setReader(new CoreReader(this.getDataFromCache((URL)cd.getLocation())));
    }

    byte[] getDataFromCache(URL dictURL) throws IOException {
        Entry e = (Entry)this.cdiCache.get(dictURL);
        if (e == null) {
            return null;
        }
        ++e.refs;
        byte[] data = e.data;
        if (data == null) {
            byte[] byArray = data = e.softref == null ? null : (byte[])e.softref.get();
        }
        if (data != null) {
            return data;
        }
        InputStream stream = dictURL.openStream();
        data = this.readDataBlock(0, stream);
        stream.close();
        e.softref = new SoftReference<byte[]>(data);
        e.data = data;
        return data;
    }

    synchronized boolean releaseCompiledDictionary(Object location) {
        Entry e = (Entry)this.cdiCache.get(location);
        if (e == null || e.refs == 0) {
            return false;
        }
        if (--e.refs == 0) {
            e.data = null;
        }
        return true;
    }

    byte[] readDataBlock(int reserve, InputStream source) throws IOException {
        Vector<byte[]> blocks = new Vector<byte[]>();
        if (reserve > 0) {
            blocks.add(new byte[reserve]);
        }
        int size = reserve;
        int ptr = 0;
        while (true) {
            byte[] block = new byte[65536];
            int bpt = 0;
            int bsize = source.read(block, bpt, block.length);
            while (bsize > 0 && (bpt += bsize) < block.length) {
                bsize = source.read(block, bpt, block.length - bpt);
            }
            if (bpt <= 0) break;
            size += bpt;
            blocks.add(block);
        }
        byte[] data = new byte[size];
        for (int b = 0; b < blocks.size(); ++b) {
            byte[] block = (byte[])blocks.get(b);
            System.arraycopy(block, 0, data, ptr, Math.min(size, block.length));
            size -= block.length;
            ptr += block.length;
        }
        return data;
    }

    protected boolean checkMagic(byte[] magic, byte[] data) {
        for (int m = 0; m < magic.length; ++m) {
            if (data[m] == magic[m]) continue;
            return false;
        }
        return true;
    }

    static String getLanguage(String path) {
        int p = path.indexOf(47);
        return p < 0 ? path : path.substring(0, p);
    }

    private void log(String msg) {
        if (this.logger != null) {
            this.logger.log(msg);
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private static class Entry {
        int refs;
        byte[] data;
        SoftReference softref;

        private Entry() {
        }
    }
}

