/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CharChecker;
import azcheck.engine.CompiledTLex;
import azcheck.engine.CompositeTLex;
import azcheck.engine.DictionaryManager;
import azcheck.engine.DictionaryManagerItem;
import azcheck.engine.EditableTLex;
import azcheck.engine.EditableWord;
import azcheck.engine.SpellException;
import azcheck.engine.SuggestionBox;
import azcheck.engine.Suggestions;
import azcheck.engine.TLex;
import azcheck.util.CharSequence;
import azcheck.util.Logger;
import azcheck.util.StringCharSeq;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpellChecker {
    public static final int ERR_NONE = 0;
    public static final int ERR_REPLACE = 1;
    public static final int ERR_UNKNOWN_WORD = 2;
    public static final int ERR_WRONG_CAP = 3;
    public static final int ERR_DUPLICATE = 4;
    public static final int ERR_PUNCTUATION = 5;
    public static final String TEMPORARY_DICT = "<temporary>";
    public static final String PERSONAL_DICT = "<personal>";
    public static final int SELECT = 0;
    public static final int ADD = 1;
    public static final int REMOVE = -1;
    public static final int SAVE = 2;
    public static final int FORCE_DEFAULT = 3;
    public static final int FORCE_MAX = 5;
    public static final int FORCE_FASTER = 2;
    private boolean ignoreCase_ = false;
    private boolean ignoreMixedCase_ = false;
    private boolean ignoreDigits_ = true;
    private boolean ignoreURL_ = false;
    private boolean ignoreDuplicates_ = false;
    private boolean checkPunctuation_ = false;
    private boolean allowCompound_ = true;
    private boolean allowPrefixes_ = true;
    private boolean allowFileExt_ = true;
    private boolean autoReplace_ = true;
    private int suggestionForce_ = 3;
    private int suggestionLimit_ = 15;
    protected CharSequence inputSeq_;
    protected int inputSeqLen_;
    protected int wCursor_;
    protected int wLength_ = -1;
    private boolean boSentence_ = false;
    private int prevWordLength_;
    private char[] prevWord_ = new char[256];
    protected DictionaryManager dictManager_;
    protected DictionaryManagerItem[] languages_ = null;
    protected Vector langPool_ = new Vector();
    protected Lang curLang_;
    protected String prefsLang_ = null;
    protected String personalPath_ = null;
    protected EditableTLex fileExtensions_ = new EditableTLex("ext", null);
    protected Logger logger;
    private static final String LANG_MARK = "%L%";
    private static final String NO_LANGUAGE = "no language selected";
    private static final String[] CommonExtensions = new String[]{"asp", "au", "avi", "bat", "bin", "bmp", "c", "cab", "cc", "class", "com", "cpp", "css", "dat", "deb", "dll", "doc", "dtd", "dvi", "eps", "exe", "frm", "gif", "gz", "h", "hlp", "hh", "hpp", "htm", "html", "ini", "jar", "java", "jpe", "jpeg", "jpg", "js", "jsp", "latex", "mid", "mif", "mov", "mp2", "mp3", "mpe", "mpeg", "mpg", "pdf", "php", "png", "ppm", "ppt", "ps", "qt", "ra", "rf", "rgb", "rtf", "sgm", "sgml", "sh", "sys", "tar", "tcl", "tex", "tgz", "tif", "tiff", "txt", "wav", "xls", "xml", "xhtml", "vb", "vba", "z", "zip"};
    private static String urlChars1 = ".?:~";
    private static String urlChars2 = "/\\@_#";
    private static String puncts = ".,:;!?";
    private static String sentenceFinal = ".!?";

    public SpellChecker(String dictPath) throws IOException {
        this.dictManager_ = new DictionaryManager(dictPath);
        this.init();
    }

    public SpellChecker(DictionaryManager manager) {
        this.dictManager_ = manager;
        this.init();
    }

    public SpellChecker(SpellChecker src) {
        this.dictManager_ = src.getDictionaryManager();
        this.init();
        Properties op = new Properties();
        src.saveOptions(op);
        this.loadOptions(op);
    }

    public SpellChecker() {
        this.dictManager_ = null;
        this.init();
    }

    public void setInput(CharSequence input) {
        this.inputSeq_ = input;
        this.inputSeqLen_ = input.length();
        this.wCursor_ = 0;
        this.wLength_ = 0;
        this.prevWordLength_ = 0;
        this.boSentence_ = false;
    }

    public void setInput(String input) {
        this.setInput(new StringCharSeq(input));
    }

    public CharSequence getInput() {
        return this.inputSeq_;
    }

    public int checkNext() throws SpellException {
        this.wCursor_ += this.wLength_;
        int punctStart = this.wCursor_;
        CharChecker rules = this.getCharChecker();
        while (this.wCursor_ < this.inputSeqLen_) {
            char cc = this.inputSeq_.charAt(this.wCursor_);
            if (!rules.isWordStart(cc)) {
                if (!Character.isWhitespace(cc)) {
                    this.prevWordLength_ = 0;
                }
            } else {
                int last;
                if (!this.punctuationOK(punctStart, this.wCursor_)) {
                    return 5;
                }
                for (last = this.wCursor_ + 1; last < this.inputSeqLen_ && rules.isWordChar(this.inputSeq_.charAt(last)); ++last) {
                }
                while (last > this.wCursor_ && !rules.isWordEnd(this.inputSeq_.charAt(last - 1))) {
                    --last;
                }
                this.wLength_ = last - this.wCursor_;
                if (this.wLength_ > 0 && this.wLength_ <= 256) {
                    int evt = this.checkWord(this.inputSeq_, this.wCursor_, this.wLength_);
                    if (evt != 0) {
                        return evt;
                    }
                    if (!this.ignoreDuplicates_) {
                        int ld = this.wLength_;
                        if (this.prevWordLength_ == this.wLength_) {
                            while (--ld >= 0 && this.inputSeq_.charAt(this.wCursor_ + ld) == this.prevWord_[ld]) {
                            }
                        }
                        for (int i = 0; i < this.wLength_; ++i) {
                            this.prevWord_[i] = this.inputSeq_.charAt(this.wCursor_ + i);
                        }
                        this.prevWordLength_ = this.wLength_;
                        if (ld < 0) {
                            return 4;
                        }
                    }
                    this.boSentence_ = false;
                    punctStart = last;
                    this.wCursor_ = last - 1;
                }
            }
            ++this.wCursor_;
        }
        if (!this.punctuationOK(punctStart, this.wCursor_)) {
            return 5;
        }
        return 0;
    }

    public int getPosition() {
        return this.wCursor_;
    }

    public String getWord() {
        char[] word = new char[this.wLength_];
        for (int i = 0; i < this.wLength_; ++i) {
            word[i] = this.inputSeq_.charAt(this.wCursor_ + i);
        }
        return new String(word);
    }

    public int checkWord(String word) throws SpellException {
        StringCharSeq seq = new StringCharSeq(word);
        this.setInput(seq);
        this.wLength_ = word.length();
        return this.checkWord(seq, 0, this.wLength_);
    }

    public int checkWord(CharSequence text, int wordStart, int wordLength) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        if (wordLength <= 1) {
            return 0;
        }
        byte cap = TLex.capType(text, wordStart, wordLength);
        if (cap == 3 && this.ignoreMixedCase_) {
            return 0;
        }
        if (this.ignoreDigits_) {
            int i = wordStart + wordLength;
            while (--i >= wordStart && !Character.isDigit(text.charAt(i))) {
            }
            if (i >= wordStart) {
                return 0;
            }
        }
        if (this.ignoreURL_ && this.looksLikeURL(text, wordStart, wordLength)) {
            return 0;
        }
        if (this.allowFileExt_) {
            int dot = wordLength;
            while (--dot >= 0 && text.charAt(wordStart + dot) != '.') {
            }
            try {
                if (++dot > 0 && this.fileExtensions_.lookup(text, wordStart + dot, wordLength - dot) != null) {
                    return 0;
                }
            }
            catch (SpellException ex) {
                // empty catch block
            }
        }
        if (this.autoReplace_ && this.curLang_.getReplacement(text, wordStart, wordLength) != null) {
            return 1;
        }
        int flags = this.curLang_.simpleSearch(text, wordStart, wordLength);
        if (flags < 0) {
            if (this.curLang_.compoundSearch(text, wordStart, wordLength, this.allowCompound_, this.allowPrefixes_)) {
                return 0;
            }
            return 2;
        }
        if (!this.ignoreCase_ && (cap < TLex.getWordType(flags) || this.boSentence_ && cap == 0)) {
            return 3;
        }
        return 0;
    }

    public Suggestions getSuggestions() throws SpellException {
        return this.getSuggestions(this.inputSeq_, this.wCursor_, this.wLength_);
    }

    public Suggestions getSuggestions(String word) throws SpellException {
        return this.getSuggestions(new StringCharSeq(word), 0, word.length());
    }

    public Suggestions getSuggestions(CharSequence text, int wordStart, int wordLength) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        SuggestionBox box = new SuggestionBox();
        box.setWord(text, wordStart, wordLength);
        if (this.boSentence_) {
            box.mustCapitalize();
        }
        if (wordLength == 2 && this.isPunct(text.charAt(wordStart + 1))) {
            if (text.charAt(wordStart) != ' ') {
                box.add(new String(new char[]{text.charAt(wordStart)}), 1);
            }
            box.add(new String(new char[]{text.charAt(wordStart + 1)}), 1);
        } else {
            this.curLang_.approximateSearch(text, wordStart, wordLength, box, this.suggestionForce_);
        }
        box.selectBestSuggestions(this.suggestionLimit_);
        return box;
    }

    public void learnWord(String word, String dictionary) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.learnWord(word, dictionary);
    }

    public void learnSuggestion(String word, String replacement, String dictionary) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.learnSuggestion(word, replacement, dictionary);
    }

    public void learnBannedWord(String word, String dictionary) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.learnBannedWord(word, dictionary);
    }

    public void learnAutoReplacement(String word, String replacement, String dictionary) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.autoReplacement(word, replacement, dictionary);
    }

    public String getReplacement(String word) throws SpellException {
        if (this.curLang_ == null) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.getReplacement(new StringCharSeq(word), 0, word.length());
    }

    public void setDictionaryPath(String path) throws IOException {
        this.dictManager_.setAccessPath(path);
    }

    public void addDictionaryPaths(String paths) throws IOException {
        this.dictManager_.addAccessPaths(paths);
    }

    public DictionaryManager getDictionaryManager() {
        return this.dictManager_;
    }

    public void setDictionaryManager(DictionaryManager man) {
        this.dictManager_ = man;
    }

    public DictionaryManagerItem[] listLanguages() throws IOException {
        return this.dictManager_.listLanguages();
    }

    public void setSelectedLanguage(String name) throws IOException, SpellException {
        if (this.curLang_ != null && this.curLang_.name.equals(name)) {
            return;
        }
        if (this.curLang_ != null) {
            this.curLang_.close();
        }
        this.curLang_ = this.findLanguage(DictionaryManager.getLanguage(name), true);
        if (this.curLang_.members_.size() == 0) {
            this.curLang_.loadDictionary(name);
        } else {
            this.curLang_.open();
        }
    }

    public String getPrefsLang_() {
        return this.prefsLang_;
    }

    public String getSelectedLanguage() {
        if (this.curLang_ == null) {
            return null;
        }
        return this.curLang_.name;
    }

    public DictionaryManagerItem getSelectedLanguageInfo() throws IOException {
        if (this.curLang_ == null) {
            return null;
        }
        return this.dictManager_.getLanguageInfo(this.curLang_.name);
    }

    public String getCopyright() {
        TLex dict = this.curLang_ == null ? null : this.curLang_.getMember(0);
        if (dict == null) {
            return null;
        }
        return dict.getCopyright();
    }

    public void clearLanguageDictionaries() throws IOException, SpellException {
        if (this.curLang_ != null) {
            this.curLang_.clear(true);
        }
    }

    public void selectDictionary(String dictName) throws IOException, SpellException {
        if (this.curLang_ != null) {
            if (dictName.equals(this.curLang_.name)) {
                return;
            }
            this.curLang_.close();
        }
        this.curLang_ = this.findLanguage(DictionaryManager.getLanguage(dictName), true);
        this.curLang_.clear(false);
        this.curLang_.loadDictionary(dictName);
    }

    public void setPersonalDictionaryPath(String path) {
        this.personalPath_ = path;
    }

    public void savePersonalDictionaries() throws IOException {
        if (this.personalPath_ != null) {
            int d = this.langPool_.size();
            while (--d >= 0) {
                ((Lang)this.langPool_.elementAt(d)).savePDict(true);
            }
        }
    }

    public String[] listEditableDictionaries() throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        String[] list = new String[this.curLang_.eDicts_.size()];
        for (int d = 0; d < this.curLang_.eDicts_.size(); ++d) {
            list[d] = ((EditableTLex)this.curLang_.eDicts_.get(d)).getLocation().toString();
        }
        return list;
    }

    public boolean manageEditableDictionary(String id, int action) throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.manageEditableDictionary(id, action);
    }

    public EditableWord[] getEditableWords() throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.getEditableWords();
    }

    public void changeWord(EditableWord word) throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        this.curLang_.changeWord(word);
    }

    public CharChecker getCharChecker() throws SpellException {
        if (this.curLang_ == null || this.curLang_.members_.size() == 0) {
            throw new SpellException(NO_LANGUAGE);
        }
        return this.curLang_.getMember(0);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase_;
    }

    public void setIgnoreCase(boolean ignore) {
        this.ignoreCase_ = ignore;
    }

    public boolean getIgnoreMixedCase() {
        return this.ignoreMixedCase_;
    }

    public void setIgnoreMixedCase(boolean ignore) {
        this.ignoreMixedCase_ = ignore;
    }

    public boolean getIgnoreDigits() {
        return this.ignoreDigits_;
    }

    public void setIgnoreDigits(boolean ignore) {
        this.ignoreDigits_ = ignore;
    }

    public boolean getIgnoreURL() {
        return this.ignoreURL_;
    }

    public void setIgnoreURL(boolean ignore) {
        this.ignoreURL_ = ignore;
    }

    public boolean getIgnoreDuplicates() {
        return this.ignoreDuplicates_;
    }

    public void setIgnoreDuplicates(boolean ignore) {
        this.ignoreDuplicates_ = ignore;
    }

    public boolean getCheckPunctuation() {
        return this.checkPunctuation_;
    }

    public void setCheckPunctuation(boolean check) {
        this.checkPunctuation_ = check;
    }

    public boolean getAutoReplace() {
        return this.autoReplace_;
    }

    public void setAutoReplace(boolean set) {
        this.autoReplace_ = set;
    }

    public int getSuggestionForce() {
        return this.suggestionForce_;
    }

    public void setSuggestionForce(int force) {
        if (force < 0 || force > 5) {
            throw new IllegalArgumentException();
        }
        this.suggestionForce_ = force;
    }

    public int getSuggestionLimit() {
        return this.suggestionLimit_;
    }

    public void setSuggestionLimit(int limit) {
        this.suggestionLimit_ = limit;
    }

    public boolean getAllowCompound() {
        return this.allowCompound_;
    }

    public void setAllowCompound(boolean allow) {
        this.allowCompound_ = allow;
    }

    public boolean getAllowPrefixes() {
        return this.allowPrefixes_;
    }

    public void setAllowPrefixes(boolean allow) {
        this.allowPrefixes_ = allow;
    }

    public boolean getAllowFileExtensions() {
        return this.allowFileExt_;
    }

    public void setAllowFileExtensions(boolean allow) {
        this.allowFileExt_ = allow;
    }

    public void addFileExtension(String extension) {
        if (extension.charAt(0) == '.') {
            extension = extension.substring(1);
        }
        try {
            this.fileExtensions_.addWord(extension, (byte)1, null);
        }
        catch (SpellException spellException) {
            // empty catch block
        }
    }

    public void loadOptions(Properties options) {
        Enumeration<?> enumeration = options.propertyNames();
        while (enumeration.hasMoreElements()) {
            String prop = (String)enumeration.nextElement();
            String value = options.getProperty(prop);
            try {
                if (prop.equals("azcheck.IgnoreCase")) {
                    this.ignoreCase_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.IgnoreMixedCase")) {
                    this.ignoreMixedCase_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.IgnoreDigits")) {
                    this.ignoreDigits_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.IgnoreURL")) {
                    this.ignoreURL_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.IgnoreDuplicates")) {
                    this.ignoreDuplicates_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.CheckPunctuation")) {
                    this.checkPunctuation_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.AllowCompound")) {
                    this.allowCompound_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.AllowPrefixes")) {
                    this.allowPrefixes_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.AllowFileExtensions")) {
                    this.allowFileExt_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.AutoReplace")) {
                    this.autoReplace_ = value.equals("true");
                    continue;
                }
                if (prop.equals("azcheck.SuggestionForce")) {
                    this.suggestionForce_ = Integer.parseInt(value);
                    continue;
                }
                if (prop.equals("azcheck.SuggestionLimit")) {
                    this.suggestionLimit_ = Integer.parseInt(value);
                    continue;
                }
                if (!prop.equals("azcheck.Language")) continue;
                this.setSelectedLanguage(value);
                this.prefsLang_ = value;
            }
            catch (Exception e) {}
        }
    }

    public void saveOptions(Properties options) {
        options.setProperty("azcheck.IgnoreCase", this.ignoreCase_ ? "true" : "false");
        options.setProperty("azcheck.IgnoreMixedCase", this.ignoreMixedCase_ ? "true" : "false");
        options.setProperty("azcheck.IgnoreDigits", this.ignoreDigits_ ? "true" : "false");
        options.setProperty("azcheck.IgnoreURL", this.ignoreURL_ ? "true" : "false");
        options.setProperty("azcheck.IgnoreDuplicates", this.ignoreDuplicates_ ? "true" : "false");
        options.setProperty("azcheck.CheckPunctuation", this.checkPunctuation_ ? "true" : "false");
        options.setProperty("azcheck.AllowCompound", this.allowCompound_ ? "true" : "false");
        options.setProperty("azcheck.AllowPrefixes", this.allowPrefixes_ ? "true" : "false");
        options.setProperty("azcheck.AllowFileExtensions", this.allowFileExt_ ? "true" : "false");
        options.setProperty("azcheck.AutoReplace", this.autoReplace_ ? "true" : "false");
        options.setProperty("azcheck.SuggestionForce", "" + this.suggestionForce_);
        options.setProperty("azcheck.SuggestionLimit", "" + this.suggestionLimit_);
        options.setProperty("azcheck.Language", this.curLang_ == null ? "" : this.curLang_.name);
    }

    private void init() {
        int x = CommonExtensions.length;
        while (--x >= 0) {
            this.addFileExtension(CommonExtensions[x]);
        }
    }

    Lang findLanguage(String langName, boolean create) throws IOException {
        this.languages_ = this.dictManager_.listLanguages();
        int lng = this.languages_.length;
        while (--lng >= 0 && !this.languages_[lng].name.equals(langName)) {
        }
        if (lng < 0) {
            langName = "unknown";
        }
        Lang lang = null;
        int i = this.langPool_.size();
        while (--i >= 0) {
            lang = (Lang)this.langPool_.get(i);
            if (!lang.name.equals(langName)) continue;
            return lang;
        }
        if (create) {
            lang = new Lang(langName);
            this.langPool_.addElement(lang);
            if (lng >= 0 && this.languages_[lng].encoding != null) {
                lang.encoding = this.languages_[lng].encoding;
            }
        }
        return lang;
    }

    boolean looksLikeURL(CharSequence text, int wordStart, int wordLength) {
        int urlc1Cnt = 0;
        int urlc2Cnt = 0;
        for (int i = 0; i < wordLength; ++i) {
            char c = text.charAt(wordStart + i);
            if (urlChars1.indexOf(c) >= 0) {
                ++urlc1Cnt;
                continue;
            }
            if (urlChars2.indexOf(c) < 0) continue;
            ++urlc2Cnt;
        }
        return urlc1Cnt > 1 || urlc2Cnt > 0;
    }

    private boolean isPunct(char c) {
        return puncts.indexOf(c) >= 0;
    }

    boolean punctuationOK(int start, int end) {
        this.boSentence_ = false;
        char prevChar = '\u0000';
        for (int p = start; p < end; ++p) {
            char c = this.inputSeq_.charAt(p);
            boolean white = Character.isWhitespace(c);
            if (sentenceFinal.indexOf(c) >= 0) {
                this.boSentence_ = true;
            } else if (!white) {
                this.boSentence_ = false;
            }
            if (this.checkPunctuation_ && !white && this.isPunct(c)) {
                if (prevChar == ' ') {
                    this.wCursor_ = p - 1;
                    this.wLength_ = 2;
                    return false;
                }
                if (this.isPunct(prevChar)) {
                    if (prevChar == '.' && c == '.' && p + 1 < end && this.inputSeq_.charAt(p + 1) == '.') {
                        ++p;
                    } else {
                        this.wCursor_ = p - 1;
                        this.wLength_ = 2;
                        return false;
                    }
                }
            }
            prevChar = c;
        }
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        if (this.dictManager_ != null) {
            this.dictManager_.logger = logger;
        }
    }

    private void log(String msg) {
        if (this.logger != null) {
            this.logger.log(msg);
        }
    }

    class Lang
    extends CompositeTLex {
        String name;
        String encoding = "UTF8";
        Vector eDicts_ = new Vector();
        int currentEdit_ = -1;

        Lang(String name) {
            super(name);
            this.name = name;
        }

        void approximateSearch(CharSequence text, int wordStart, int wordLength, SuggestionBox box, int force) throws SpellException {
            super.approximateSearch(text, wordStart, wordLength, box, force);
            if (force <= 0) {
                return;
            }
            for (int d = 0; d < this.eDicts_.size(); ++d) {
                EditableTLex.Entry e = ((EditableTLex)this.eDicts_.get(d)).lookup(text, wordStart, wordLength);
                if (e == null || e.type != 2) continue;
                StringTokenizer tok = new StringTokenizer(e.value, "\t");
                while (tok.hasMoreTokens()) {
                    box.add(tok.nextToken(), 0);
                }
            }
        }

        void learnWord(String word, String dictionary) throws SpellException {
            EditableTLex dict = this.getEditableDict(dictionary);
            if (dict == null) {
                throw new SpellException("no such dictionary: " + dictionary);
            }
            dict.addWord(word, (byte)0, null);
        }

        void learnSuggestion(String word, String replacement, String dictionary) throws SpellException {
            EditableTLex dict = this.getEditableDict(dictionary);
            if (dict == null) {
                throw new SpellException("no such dictionary: " + dictionary);
            }
            dict.addWord(word, (byte)2, replacement);
        }

        void learnBannedWord(String word, String dictionary) throws SpellException {
            EditableTLex dict = this.getEditableDict(dictionary);
            if (dict == null) {
                throw new SpellException("no such dictionary: " + dictionary);
            }
            dict.addWord(word, (byte)3, null);
        }

        void autoReplacement(String word, String replacement, String dictionary) throws SpellException {
            EditableTLex dict = this.getEditableDict(dictionary);
            if (dict == null) {
                throw new SpellException("no such dictionary: " + dictionary);
            }
            dict.addWord(word, (byte)1, replacement);
        }

        String getReplacement(CharSequence text, int wordStart, int wordLength) {
            for (int d = 0; d < this.eDicts_.size(); ++d) {
                try {
                    EditableTLex.Entry e = ((EditableTLex)this.eDicts_.get(d)).lookup(text, wordStart, wordLength);
                    if (e == null || e.type != 1) continue;
                    return e.value;
                }
                catch (SpellException e) {
                    return null;
                }
            }
            return null;
        }

        TLex loadDictionary(String dictName) throws IOException, SpellException {
            EditableTLex ed;
            TLex dict = SpellChecker.this.dictManager_.load(dictName, this.getMember(0));
            if (dict instanceof EditableTLex) {
                this.eDicts_.add(dict);
            }
            this.addMember(dict);
            if (this.getEditableDict(SpellChecker.TEMPORARY_DICT) == null) {
                ed = new EditableTLex(SpellChecker.TEMPORARY_DICT, dict);
                this.addMember(ed);
                this.eDicts_.add(ed);
            }
            if (SpellChecker.this.personalPath_ != null && this.getEditableDict(SpellChecker.PERSONAL_DICT) == null) {
                ed = new EditableTLex(SpellChecker.PERSONAL_DICT, dict);
                this.eDicts_.add(ed);
                this.addMember(ed);
                this.readEditableDict(ed, this.instantiatePDPath(), true);
            }
            return dict;
        }

        void close() {
            for (int i = 0; i < this.members_.size(); ++i) {
                TLex lex = (TLex)this.members_.get(i);
                if (!(lex instanceof CompiledTLex)) continue;
                SpellChecker.this.dictManager_.releaseCompiledDictionary(lex.getLocation());
                try {
                    ((CompiledTLex)lex).setReader(null);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        void open() throws SpellException, IOException {
            for (int i = 0; i < this.members_.size(); ++i) {
                TLex dict = (TLex)this.members_.get(i);
                if (!(dict instanceof CompiledTLex)) continue;
                SpellChecker.this.dictManager_.reloadCompiledDictionary((CompiledTLex)dict);
            }
        }

        void clear(boolean all) throws IOException {
            this.savePDict(true);
            this.close();
            if (all) {
                this.eDicts_.setSize(0);
            }
            this.members_.removeAllElements();
            if (!all) {
                for (int e = 0; e < this.eDicts_.size(); ++e) {
                    this.members_.add(this.eDicts_.get(e));
                }
            }
        }

        EditableTLex getEditableDict(String name) {
            for (int d = 0; d < this.eDicts_.size(); ++d) {
                EditableTLex ed = (EditableTLex)this.eDicts_.get(d);
                if (!name.equals(ed.getLocation())) continue;
                return ed;
            }
            return null;
        }

        boolean manageEditableDictionary(String id, int action) {
            if (id == null) {
                return false;
            }
            int dict = this.eDicts_.size();
            while (--dict >= 0 && !id.equals(((EditableTLex)this.eDicts_.get(dict)).getLocation())) {
            }
            switch (action) {
                case 0: {
                    if (dict < 0) {
                        return false;
                    }
                    this.currentEdit_ = dict;
                    break;
                }
                case 1: {
                    try {
                        TLex edict = SpellChecker.this.dictManager_.load(new URL("file:" + id), this.getMember(0));
                        if (!(edict instanceof EditableTLex)) {
                            return false;
                        }
                        edict.setLocation(id);
                        this.currentEdit_ = this.eDicts_.size();
                        this.eDicts_.add(edict);
                        this.addMember(edict);
                        break;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                case 2: {
                    if (dict < 0 || id.equals(SpellChecker.TEMPORARY_DICT)) {
                        return false;
                    }
                    try {
                        if (id.equals(SpellChecker.PERSONAL_DICT)) {
                            this.savePDict(false);
                            break;
                        }
                        EditableTLex edict = (EditableTLex)this.eDicts_.get(dict);
                        this.saveEditableDict(edict, edict.getLocation().toString());
                        break;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
                case -1: {
                    if (dict < 0) {
                        return false;
                    }
                    Object edict = this.eDicts_.remove(dict);
                    this.members_.remove(edict);
                    this.currentEdit_ = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("action");
                }
            }
            return true;
        }

        EditableWord[] getEditableWords() throws SpellException {
            if (this.currentEdit_ < 0) {
                throw new SpellException("no dictionary selected");
            }
            EditableTLex edict = (EditableTLex)this.eDicts_.get(this.currentEdit_);
            return edict.getEditableWords();
        }

        void changeWord(EditableWord word) throws SpellException {
            if (this.currentEdit_ < 0) {
                throw new SpellException("no dictionary selected");
            }
            EditableTLex edict = (EditableTLex)this.eDicts_.get(this.currentEdit_);
            if (word.type == -1) {
                edict.removeWord(word.word);
            } else {
                edict.addWord(word.word, (byte)word.type, word.value, true);
            }
        }

        void savePDict(boolean reload) throws IOException {
            EditableTLex ed = this.getEditableDict(SpellChecker.PERSONAL_DICT);
            if (ed == null) {
                return;
            }
            String path = this.instantiatePDPath();
            if (reload) {
                this.readEditableDict(ed, path, false);
            }
            this.saveEditableDict(ed, path);
        }

        void saveEditableDict(EditableTLex edict, String path) throws IOException {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), this.encoding));
            edict.save(out);
            out.close();
        }

        void readEditableDict(EditableTLex dict, String path, boolean override) {
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), this.encoding));
                try {
                    dict.load(in, override);
                }
                catch (SpellException e) {
                    // empty catch block
                }
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        String instantiatePDPath() {
            int p = SpellChecker.this.personalPath_.indexOf(SpellChecker.LANG_MARK);
            if (p < 0) {
                return SpellChecker.this.personalPath_ + "." + this.name;
            }
            return SpellChecker.this.personalPath_.substring(0, p) + this.name + SpellChecker.this.personalPath_.substring(p + SpellChecker.LANG_MARK.length());
        }
    }
}

