/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.Suggestions;
import azcheck.engine.TLex;
import azcheck.engine.TLexRules;
import azcheck.util.CharSequence;
import azcheck.util.QuickSort;

public class SuggestionBox
implements Suggestions {
    protected String targetWord_;
    protected byte targetCap_;
    protected byte eSpace;
    protected byte eDash;
    protected TLex rules_;
    protected int suggestCnt_ = 0;
    protected Item[] suggestions_;
    static final int SUGGEST_MAX = 100;
    protected byte[] currentWord_;
    protected int cursor_;
    protected int cost_;
    protected int costMax_;
    protected int splitCount_ = 0;
    protected String suffix_;
    protected StringBuffer sbuffer_ = new StringBuffer();

    public String getWord() {
        return this.targetWord_;
    }

    public int getCount() {
        return this.suggestCnt_;
    }

    public String getSuggestion(int rank) {
        return this.suggestions_[rank].word;
    }

    public int getSuggestionPenalty(int rank) {
        return this.suggestions_[rank].cost;
    }

    public boolean contain(String word, int maxRank) {
        int last = maxRank < 0 || maxRank > this.suggestCnt_ ? this.suggestCnt_ : maxRank;
        for (int i = 0; i < last; ++i) {
            if (!this.suggestions_[i].word.equals(word)) continue;
            return true;
        }
        return false;
    }

    public String[] toArray() {
        String[] a = new String[this.suggestCnt_];
        for (int s = 0; s < this.suggestCnt_; ++s) {
            a[s] = this.getSuggestion(s);
        }
        return a;
    }

    SuggestionBox() {
        this.suggestions_ = new Item[100];
        for (int s = 0; s < 100; ++s) {
            this.suggestions_[s] = new Item();
        }
        this.currentWord_ = new byte[256];
    }

    void setWord(CharSequence text, int start, int length) {
        char[] word = new char[length];
        for (int i = 0; i < length; ++i) {
            word[i] = text.charAt(start + i);
        }
        this.targetWord_ = new String(word);
        this.targetCap_ = TLexRules.capType(text, start, length);
    }

    void mustCapitalize() {
        if (this.targetCap_ == 0) {
            this.targetCap_ = 1;
        }
    }

    void setCostMaximum(int max) {
        this.costMax_ = max;
    }

    void selectBestSuggestions(int maxCount) {
        QuickSort.Compare comp = new QuickSort.Compare(){

            public int compare(Object o1, Object o2) {
                Item s1 = (Item)o1;
                Item s2 = (Item)o2;
                int cmp = s1.cost - s2.cost;
                if (cmp != 0) {
                    return cmp;
                }
                return s1.word.compareTo(s2.word);
            }
        };
        QuickSort.sort(this.suggestions_, 0, this.suggestCnt_ - 1, comp);
        if (this.suggestCnt_ > maxCount) {
            this.suggestCnt_ = maxCount;
        }
    }

    int getCursor() {
        return this.cursor_;
    }

    int getCost() {
        return this.cost_;
    }

    void back(int cursor, int cost) {
        this.cursor_ = cursor;
        this.cost_ = cost;
        if (this.cursor_ == 0 && this.cost_ == 0) {
            this.splitCount_ = 0;
        }
    }

    boolean put(byte ch) {
        this.currentWord_[this.cursor_++] = ch;
        return this.cost_ <= this.costMax_;
    }

    boolean put(byte[] chars, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.currentWord_[this.cursor_ + i - start] = chars[i];
        }
        this.cursor_ += end - start;
        return this.cost_ <= this.costMax_;
    }

    void dumpCurWord(int prevCurs) {
        for (int p = 0; p < this.cursor_; ++p) {
            if (p == prevCurs) {
                System.out.print(":");
            }
            System.out.print(this.rules_.decode(this.currentWord_[p]));
        }
        System.out.println();
    }

    boolean checkCost(int cost) {
        return this.cost_ + cost <= this.costMax_;
    }

    void putCost(int cost) {
        this.cost_ += cost;
    }

    int split(int diff) {
        this.splitCount_ += diff;
        return this.splitCount_;
    }

    void storeWord(int flags) {
        if (flags < 0) {
            return;
        }
        int dictCap = TLex.getWordType(flags);
        if (dictCap > 0 && this.splitCount_ > 0) {
            this.cost_ += 27;
        }
        if (dictCap < this.targetCap_ && this.targetCap_ != 3) {
            dictCap = this.targetCap_;
        }
        boolean cap1 = false;
        boolean capall = false;
        if (dictCap == 1) {
            cap1 = true;
        } else if (dictCap == 2) {
            capall = true;
        }
        this.sbuffer_.setLength(0);
        int lastC = 0;
        for (int c = 0; c < this.cursor_; ++c) {
            char ch = this.rules_.decode(this.currentWord_[c]);
            if (ch == ' ') {
                lastC = c + 1;
            }
            this.sbuffer_.append(capall || cap1 && c == 0 ? Character.toUpperCase(ch) : ch);
        }
        if (this.suffix_ != null) {
            if (this.suffix_.charAt(0) == '-' && this.sbuffer_.charAt(this.sbuffer_.length() - 1) == '-') {
                this.sbuffer_.append(this.suffix_.substring(1));
            } else {
                this.sbuffer_.append(this.suffix_);
            }
        }
        String word = new String(this.sbuffer_);
        if ((flags & 8) != 0) {
            this.cost_ += -3;
        }
        this.add(word, this.cost_);
    }

    public void setSuffix(String suffix) {
        this.suffix_ = suffix;
    }

    public void add(String word, int cost) {
        int p = this.suggestCnt_;
        while (--p >= 0) {
            if (!this.suggestions_[p].word.equals(word)) continue;
            if (this.suggestions_[p].cost > cost) {
                this.suggestions_[p].cost = cost;
            }
            return;
        }
        if (this.suggestCnt_ < 100) {
            this.suggestions_[this.suggestCnt_].word = word;
            ++this.suggestCnt_;
            this.suggestions_[this.suggestCnt_].cost = cost;
        } else {
            p = this.suggestCnt_;
            while (--p >= 0) {
                if (this.suggestions_[p].cost <= cost) continue;
                this.suggestions_[p].word = word;
                this.suggestions_[p].cost = cost;
                break;
            }
        }
    }

    void setRules(TLex rules) {
        this.rules_ = rules;
        this.eSpace = this.rules_.encode(' ');
        this.eDash = this.rules_.encode('-');
    }

    static class Item {
        String word;
        int cost;

        Item() {
        }
    }
}

