/*
 * Decompiled with CFR 0.152.
 */
package azcheck.engine;

import azcheck.engine.CharChecker;
import azcheck.engine.SpellException;
import azcheck.util.CharSequence;
import azcheck.util.DataReader;

public class TLexRules
implements CharChecker {
    public static final byte CAP_ANY = 0;
    public static final byte CAP_PROPERNAME = 1;
    public static final byte CAP_UP = 2;
    public static final byte CAP_MIXED = 3;
    protected CProps[] charHash_ = new CProps[256];
    protected CProps[] charTable_ = new CProps[256];
    protected int charCount_ = 0;
    static final byte NON_INITIAL = 1;
    static final byte NON_FINAL = 2;
    static final byte SPACE = 4;

    public TLexRules() {
        this.findChar(0, true);
        CProps sp = this.findChar(32, true);
        sp.flags = (byte)7;
        this.charTable_[255] = new CProps('^', -1);
        this.charTable_[254] = new CProps('$', -2);
    }

    public void shareRules(TLexRules table) {
        if (table != null) {
            this.charHash_ = table.charHash_;
            this.charTable_ = table.charTable_;
        } else {
            try {
                char c;
                for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                    this.defineWordChar(c);
                }
                for (c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                    this.defineWordChar(c);
                }
                for (c = '\ufffd'; c <= '\ufffd'; c = (char)(c + '\u0001')) {
                    this.defineWordChar(c);
                }
                this.defineWordChar('-');
                this.defineWordChar('.');
                this.defineWordChar('\'');
            }
            catch (SpellException spellException) {
                // empty catch block
            }
        }
    }

    public int getSize() {
        return this.charCount_;
    }

    public byte encode(char c) {
        CProps props = this.findChar(c, false);
        return props == null ? (byte)-1 : (byte)props.code;
    }

    public byte[] encode(String s, boolean rule) {
        byte[] res = new byte[s.length()];
        int c = res.length;
        while (--c >= 0) {
            char ch = s.charAt(c);
            if (rule && ch == '$') {
                res[c] = -2;
                continue;
            }
            if (rule && ch == '^') {
                res[c] = -1;
                continue;
            }
            res[c] = this.encode(ch);
            if (res[c] != -1) continue;
            return null;
        }
        return res;
    }

    public char decode(byte b) {
        return this.getChar((byte)b).xvalue;
    }

    public String decode(byte[] b, int start, int length) {
        char[] dec = new char[length];
        for (int i = 0; i < length; ++i) {
            dec[i] = this.getChar((byte)b[start + i]).xvalue;
        }
        return new String(dec);
    }

    public CProps defineWordChar(char c) throws SpellException {
        if (this.charCount_ >= 250) {
            throw new SpellException("too many characters defined", this.charCount_);
        }
        return this.findChar(c, true);
    }

    public void defineRecoding(char c, int code) throws SpellException {
        CProps pa = this.findChar(code, true);
        this.addAlias(pa, c);
    }

    public boolean isWordChar(char c) {
        CProps props = this.findChar(c, false);
        return props != null && (props.flags & 4) == 0;
    }

    public boolean isWordStart(char c) {
        CProps props = this.findChar(c, false);
        return props != null && (props.flags & 5) == 0;
    }

    public boolean isWordEnd(char c) {
        CProps props = this.findChar(c, false);
        return props != null && (props.flags & 6) == 0;
    }

    public void setInitial(byte code) {
        this.getChar((byte)code).flags = (byte)(this.getChar((byte)code).flags & 0xFFFFFFFE);
    }

    public void setFinal(byte code) {
        this.getChar((byte)code).flags = (byte)(this.getChar((byte)code).flags & 0xFFFFFFFD);
    }

    public static byte capType(CharSequence word, int start, int length) {
        int upCnt = 0;
        int letterCount = length;
        int capitalCnt = 0;
        boolean afterNonLetter = true;
        for (int i = 0; i < length; ++i) {
            char c = word.charAt(start + i);
            if (Character.isUpperCase(c)) {
                ++upCnt;
                if (afterNonLetter) {
                    ++capitalCnt;
                }
            }
            boolean bl = afterNonLetter = !Character.isLetter(c);
            if (!afterNonLetter) continue;
            --letterCount;
        }
        if (upCnt == letterCount) {
            return 2;
        }
        if (upCnt != 0) {
            return upCnt == capitalCnt ? (byte)1 : 3;
        }
        return 0;
    }

    public void addCloseCharacter(byte code, byte neighbor, byte cost) {
        CProps props = this.getChar(code);
        int cfsize = props.closeFriends == null ? 0 : props.closeFriends.length;
        byte[] ncf = new byte[cfsize + 2];
        if (cfsize > 0) {
            System.arraycopy(props.closeFriends, 0, ncf, 0, cfsize);
        }
        props.closeFriends = ncf;
        props.closeFriends[cfsize] = neighbor;
        props.closeFriends[cfsize + 1] = cost;
    }

    public int charCloseness(byte code1, byte code2, int defaultDist) {
        CProps props = this.getChar(code1);
        if (props == null) {
            return defaultDist;
        }
        byte[] friends = props.closeFriends;
        if (friends != null) {
            for (int b = friends.length - 2; b >= 0; b -= 2) {
                if (friends[b] != code2) continue;
                return friends[b + 1];
            }
        }
        return defaultDist;
    }

    public void load(DataReader reader) throws SpellException {
        for (int i = 0; i < 256; ++i) {
            CProps props;
            char c = (char)reader.getInt(2);
            if (c == '\u0000' && i > 0) continue;
            byte code = reader.getByte();
            if (code == -1 || code == -2) {
                this.charTable_[code & 0xFF] = props = new CProps(c, code);
            } else {
                props = this.defineWordChar(c);
            }
            props.flags = reader.getByte();
            int nfr = reader.getInt(4);
            if (nfr > 0) {
                props.closeFriends = reader.getBytes(nfr);
            }
            int nconf = reader.getInt(2);
            MRule lastc = null;
            for (int cf = 0; cf < nconf; ++cf) {
                int L = reader.getInt(4);
                MRule nc = new MRule(null);
                nc.data = reader.getBytes(L);
                if (lastc == null) {
                    props.mistRules = nc;
                } else {
                    lastc.next = nc;
                }
                lastc = nc;
            }
        }
    }

    protected CProps getChar(byte code) {
        return this.charTable_[code & 0xFF];
    }

    protected CProps findChar(int c, boolean insert) {
        int hKey = c & 0xFF;
        CProps p = this.charHash_[hKey];
        while (p != null) {
            if (p.xvalue == c) {
                return p.alias != null ? p.alias : p;
            }
            p = p.next;
        }
        if (insert) {
            p = new CProps((char)c, (byte)this.charCount_++);
            p.next = this.charHash_[hKey];
            this.charHash_[hKey] = p;
            this.charTable_[p.code & 0xFF] = p;
        }
        return p;
    }

    protected void addAlias(CProps props, int c) {
        int hKey = c & 0xFF;
        CProps p = new CProps((char)c, props.code);
        p.alias = props;
        p.next = this.charHash_[hKey];
        this.charHash_[hKey] = p;
    }

    protected static class MRule {
        byte[] data;
        public MRule next;
        static final int FIRST_ITEM = 0;
        static final byte MATCH_START = -1;
        static final byte MATCH_END = -2;

        public MRule(MRule next) {
            this.next = next;
        }

        public MRule(byte[] leftPart, MRule next) {
            this.next = next;
            this.data = new byte[leftPart.length + 2];
            this.data[0] = 0;
            this.data[1] = (byte)leftPart.length;
            System.arraycopy(leftPart, 0, this.data, 2, leftPart.length);
        }

        final int itemCount() {
            return this.data[0];
        }

        final int matchedChars() {
            int shifted = 0;
            int p = this.itemSize(0);
            while (--p >= 0) {
                if (this.data[2 + p] == -1 || this.data[2 + p] == -2) continue;
                ++shifted;
            }
            return shifted;
        }

        final int itemCost(int itemIndex) {
            return this.data[itemIndex];
        }

        final int itemSize(int itemIndex) {
            return this.data[itemIndex + 1];
        }

        final int itemNext(int itemIndex) {
            return itemIndex + 2 + this.data[itemIndex + 1];
        }

        final byte itemCode(int itemIndex, int rank) {
            return this.data[itemIndex + 2 + rank];
        }

        final boolean itemEquals(int itemIndex, byte[] that) {
            if (this.itemSize(itemIndex) != that.length) {
                return false;
            }
            int n = that.length;
            while (--n >= 0) {
                if (this.itemCode(itemIndex, n) == that[n]) continue;
                return false;
            }
            return true;
        }

        void addItem(byte[] item, int cost) {
            int cur = this.itemNext(0);
            int cnt = this.itemCount();
            while (--cnt > 0) {
                if (this.itemEquals(cur, item)) {
                    return;
                }
                cur = this.itemNext(cur);
            }
            byte[] ndata = new byte[this.data.length + item.length + 2];
            int pw = 0;
            for (int i = 0; i < this.data.length; ++i) {
                ndata[pw++] = this.data[i];
            }
            ndata[0] = (byte)(ndata[0] + 1);
            ndata[pw++] = (byte)cost;
            ndata[pw++] = (byte)item.length;
            for (int ni = 0; ni < item.length; ++ni) {
                ndata[pw++] = item[ni];
            }
            this.data = ndata;
        }

        boolean matches(byte[] word, int pos, int wlen) {
            int wpos = pos;
            int end = 2 + this.data[1];
            for (int p = 2; p < end; ++p) {
                if (this.data[p] == -1) {
                    if (pos <= 0) continue;
                    return false;
                }
                if (this.data[p] == -2) {
                    if (wpos >= wlen) continue;
                    return false;
                }
                if (wpos >= wlen || this.data[p] != word[wpos]) {
                    return false;
                }
                ++wpos;
            }
            return true;
        }
    }

    protected static class CProps {
        public char xvalue;
        public byte code;
        public byte flags = 0;
        public byte[] closeFriends;
        public MRule mistRules;
        public CProps next;
        public CProps alias;

        CProps(char v, byte code) {
            this.xvalue = v;
            this.code = code;
        }
    }
}

