/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.CharChecker;
import azcheck.engine.SpellException;
import azcheck.ui.JTextSource;
import azcheck.ui.SpellControl;
import azcheck.util.StringCharSeq;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class JTextAutoSpellCheck
extends JTextSource
implements DocumentListener {
    long last = System.currentTimeMillis();
    SpellControl checker;
    String dictionary;
    Object hiliTag;
    DefaultHighlighter.DefaultHighlightPainter hiPainter = new SpellHiliter();
    Vector hilights = new Vector();
    private static final String PKEY = "=auto=spell=checker=";

    public JTextAutoSpellCheck(JTextComponent textComponent, SpellControl checker, String dictionary, boolean checkAllImmediately) throws IOException, SpellException {
        super(textComponent);
        this.checker = checker;
        this.dictionary = dictionary;
        textComponent.getDocument().addDocumentListener(this);
        textComponent.putClientProperty(PKEY, this);
        if (checkAllImmediately) {
            this.checkAll();
        }
    }

    public static void stopChecking(JTextComponent textComponent) {
        JTextAutoSpellCheck autosc = (JTextAutoSpellCheck)textComponent.getClientProperty(PKEY);
        if (autosc != null) {
            textComponent.getDocument().removeDocumentListener(autosc);
            autosc.eraseHighlights();
        }
    }

    public void checkAll() throws IOException, SpellException {
        AbstractDocument doc = (AbstractDocument)this.source_.getDocument();
        int max = doc.getLength();
        try {
            Element el;
            int pos = 0;
            while (pos <= max && (el = this.checkableElement(pos, true)) != null) {
                this.checkElement(el);
                pos = el.getEndOffset() + 1;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void eraseHighlights() {
        int h = this.hilights.size();
        while (--h >= 0) {
            Highlighter.Highlight hi = (Highlighter.Highlight)this.hilights.get(h);
            this.source_.getHighlighter().removeHighlight(hi);
            this.hilights.remove(hi);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (this.busy_) {
            return;
        }
        long now = System.currentTimeMillis();
        boolean timesUp = now - this.last > 500L;
        int length = e.getLength();
        boolean isWhiteSpace = false;
        boolean isReturn = false;
        if (length == 1) {
            DocumentEvent.EventType type = e.getType();
            Document document = e.getDocument();
            int offset = e.getOffset();
            String text = "";
            try {
                text = document.getText(offset, 1);
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            isWhiteSpace = text.equals(" ") || text.equals(",") || text.equals(".") || text.equals(";") || text.equals(":");
            boolean bl = isReturn = text.equals("\n") || text.equals("\r");
        }
        if (timesUp || isWhiteSpace) {
            this.checkAround();
        }
        if (isReturn) {
            try {
                this.checkAll();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.last = now;
    }

    public void removeUpdate(DocumentEvent e) {
        if (this.busy_) {
            return;
        }
        this.checkAround();
    }

    public void changedUpdate(DocumentEvent e) {
        if (this.busy_) {
            return;
        }
    }

    void checkAround() {
        try {
            CharChecker cchecker = this.checker.getCharChecker();
            AbstractDocument doc = (AbstractDocument)this.source_.getDocument();
            int selStart = this.source_.getSelectionStart();
            int selEnd = this.source_.getSelectionEnd();
            boolean min = false;
            int max = doc.getLength();
            Element startElem = this.checkableElement(selStart, true);
            Element endElem = this.checkableElement(selStart, false);
            if (startElem != null) {
                this.checkElement(startElem);
            }
            if (endElem != null && endElem != startElem) {
                this.checkElement(endElem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkElement(Element elem) throws IOException, BadLocationException, SpellException {
        int start = elem.getStartOffset();
        int end = elem.getEndOffset();
        int h = this.hilights.size();
        while (--h >= 0) {
            Highlighter.Highlight hi = (Highlighter.Highlight)this.hilights.get(h);
            if (hi.getStartOffset() < start || hi.getEndOffset() > end) continue;
            this.source_.getHighlighter().removeHighlight(hi);
            this.hilights.remove(hi);
        }
        int size = ((AbstractDocument)this.source_.getDocument()).getLength();
        if (start >= (end = Math.min(end, size))) {
            return;
        }
        String text = this.source_.getText(start, end - start);
        String currentDic = this.checker.getSelectedLanguage();
        try {
            int err;
            if (this.dictionary != null) {
                this.checker.setSelectedLanguage(this.dictionary);
            }
            this.checker.setInput(new StringCharSeq(text));
            while ((err = this.checker.checkNext()) != 0) {
                if (err != 2 && err != 3) continue;
                int epos = start + this.checker.getPosition();
                String eword = this.checker.getWord();
                Highlighter highlighter = this.source_.getHighlighter();
                int i = epos + eword.length();
                this.hilights.add(highlighter.addHighlight(epos, i, this.hiPainter));
            }
        }
        finally {
            this.checker.setSelectedLanguage(currentDic);
        }
    }

    static class SpellHiliter
    extends DefaultHighlighter.DefaultHighlightPainter {
        SpellHiliter() {
            super(Color.red);
        }

        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            g.setColor(this.getColor());
            try {
                Shape shape = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                Rectangle r = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                g.fillRect(r.x, r.y + r.height - 2, r.width, 2);
                return r;
            }
            catch (BadLocationException e) {
                return null;
            }
        }
    }
}

