/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.CharChecker;
import azcheck.ui.TextSource;
import azcheck.util.CharSequence;
import azcheck.util.StringCharSeq;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;

public class JTextSource
implements TextSource {
    protected JTextComponent source_;
    protected int currentStart_;
    protected boolean busy_ = false;

    public JTextSource(JTextComponent source) {
        this.source_ = source;
    }

    public CharSequence getText(CharChecker checker) {
        if (checker == null) {
            throw new IllegalArgumentException("no spell-checker");
        }
        try {
            int end;
            String prelude;
            int pos = this.source_.getSelectionEnd();
            AbstractDocument doc = (AbstractDocument)this.source_.getDocument();
            boolean docMin = false;
            int docMax = doc.getLength();
            Element element = this.checkableElement(pos, true);
            if (element == null) {
                return null;
            }
            int min = element.getStartOffset();
            int max = element.getEndOffset();
            if (max > docMax) {
                max = docMax;
            }
            int start = pos;
            int stop = pos - 30;
            if (stop < min) {
                stop = min;
            }
            if (stop < pos && (checker.isWordEnd((prelude = this.source_.getText(stop, pos + 1 - stop)).charAt(start - stop)) || !checker.isWordEnd(prelude.charAt(start - 1 - stop)))) {
                while (start >= stop && checker.isWordChar(prelude.charAt(start - stop))) {
                    --start;
                }
                ++start;
            }
            if (start < min) {
                start = min;
            }
            if ((end = start + 5000) > max) {
                end = max;
            }
            this.currentStart_ = start;
            String text = this.source_.getText(start, end - start);
            int length = text.length();
            if (end < max) {
                while (checker.isWordChar(text.charAt(length - 1))) {
                    --length;
                }
            }
            return new StringCharSeq(text, length);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean spellCheckable(Element element) {
        Object mu = ((AbstractDocument.AbstractElement)element).getAttribute("mark-up");
        return mu == null;
    }

    public void highlight(int position, int length) {
        if (position < 0) {
            int cursel = Math.max(0, this.source_.getSelectionEnd() - 1);
            this.source_.select(cursel, cursel + length);
        } else {
            int start = this.currentStart_ + position;
            int docEnd = this.source_.getDocument().getLength();
            start = Math.min(docEnd, start);
            this.source_.select(start, start + length);
        }
        Caret caret = this.source_.getCaret();
        caret.setVisible(true);
        caret.setSelectionVisible(true);
    }

    public void replace(int position, int length, String replacement) {
        this.highlight(position, length);
        this.busy_ = true;
        this.source_.replaceSelection(replacement);
        this.busy_ = false;
    }

    Element checkableElement(int pos, boolean forward) {
        AbstractDocument doc = (AbstractDocument)this.source_.getDocument();
        boolean min = false;
        int max = doc.getLength();
        Element element = null;
        pos = Math.min(pos, max);
        do {
            try {
                element = ((StyledDocument)((Object)doc)).getCharacterElement(pos);
            }
            catch (Exception e) {
                try {
                    element = doc.getParagraphElement(pos);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            if (element.getStartOffset() >= max) {
                return null;
            }
            if (!this.spellCheckable(element)) continue;
            return element;
        } while (!(forward ? (pos = element.getEndOffset()) >= max : (pos = element.getStartOffset() - 1) <= 0));
        return null;
    }
}

