/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import azcheck.engine.SpellChecker;
import azcheck.engine.SpellException;
import azcheck.engine.Suggestions;
import azcheck.ui.TextSource;
import azcheck.util.CharSequence;
import java.io.IOException;

public class SpellControl
extends SpellChecker {
    TextSource source_;
    CharSequence input_;
    int lastEvent_;
    String failingWord_ = null;
    Suggestions suggestions_;

    SpellControl(String dictPath) throws IOException {
        super(dictPath);
    }

    SpellControl(SpellControl c) {
        super(c);
    }

    public int check(TextSource source) throws SpellException {
        this.source_ = source;
        this.suggestions_ = null;
        while (true) {
            this.input_ = source.getText(this.getCharChecker());
            if (this.input_ == null) {
                System.out.println("input_ == null");
                this.failingWord_ = null;
                return 0;
            }
            if (this.input_.length() == 0) {
                System.out.println("input_.length() == 0");
                this.failingWord_ = null;
                return 0;
            }
            this.setInput(this.input_);
            this.lastEvent_ = this.checkNext();
            if (this.lastEvent_ == 0) {
                source.highlight(this.input_.length(), 0);
                continue;
            }
            this.failingWord_ = this.getWord();
            if (this.lastEvent_ != 1) break;
            this.source_.replace(this.getPosition(), this.failingWord_.length(), this.getReplacement(this.failingWord_));
        }
        source.highlight(this.getPosition(), this.failingWord_.length());
        return this.lastEvent_;
    }

    public String failingWord() {
        return this.failingWord_;
    }

    public Suggestions getSuggestions() throws SpellException {
        if (this.suggestions_ == null) {
            this.suggestions_ = super.getSuggestions();
        }
        return this.suggestions_;
    }

    public void replace(String replacement, boolean always) throws SpellException {
        int MAX_RANK = 2;
        if (this.failingWord_ == null) {
            return;
        }
        int replPos = this.getPosition();
        int replSize = this.failingWord_.length();
        if (replacement.length() == 0) {
            if (this.lastEvent_ != 4) {
                return;
            }
            if (Character.isWhitespace(this.inputChar(replPos - 1))) {
                --replPos;
                ++replSize;
            }
        }
        if (replacement.length() > 0) {
            if (always) {
                this.learnAutoReplacement(this.failingWord_, replacement, "<temporary>");
            } else if (this.suggestions_ != null && !this.suggestions_.contain(replacement, 2)) {
                this.learnSuggestion(this.failingWord_, replacement, "<temporary>");
            }
        }
        this.source_.replace(replPos, replSize, replacement);
    }

    public void add(String word) throws SpellException {
        this.learnWord(word, "<personal>");
    }

    public void ignoreAll(String word) throws SpellException {
        this.learnWord(word, "<temporary>");
    }

    public void stop() {
        try {
            this.savePersonalDictionaries();
        }
        catch (IOException e) {
            System.err.println("OOPS: " + e.getMessage());
        }
    }

    private char inputChar(int pos) {
        return pos < 0 || pos >= this.input_.length() ? (char)'\u0000' : this.input_.charAt(pos);
    }
}

