/*
 * Decompiled with CFR 0.152.
 */
package azcheck.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ThinBorder
extends AbstractBorder {
    private Color dark;
    private Color light;
    private boolean raised;
    private int marginWidth;
    private int marginHeight;

    public ThinBorder(Color color, boolean raised) {
        this(color, raised, -1, -1);
    }

    public ThinBorder(Color color, boolean raised, int marginWidth, int marginHeight) {
        if (marginWidth < 0) {
            marginWidth = 2;
        }
        if (marginHeight < 0) {
            marginHeight = 2;
        }
        this.dark = color.darker();
        this.light = color.brighter();
        this.raised = raised;
        this.marginWidth = marginWidth;
        this.marginHeight = marginHeight;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.raised ? this.dark : this.light);
        g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x + width - 1, y);
        g.setColor(this.raised ? this.light : this.dark);
        g.drawLine(x, y, x + width - 1, y);
        g.drawLine(x, y, x, y + height - 1);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(1 + this.marginHeight, 1 + this.marginWidth, 1 + this.marginHeight, 1 + this.marginWidth);
    }
}

