/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.exolab.castor.types.DateTimeBase;
import org.exolab.castor.types.OperationNotSupportedException;

public class GYear
extends DateTimeBase {
    private static final long serialVersionUID = -8977039151222106864L;
    private static final String YEAR_FORMAT = "yyyy";
    private static final String BAD_GYEAR = "Bad gYear format: ";

    public GYear() {
    }

    public GYear(short century, short year) {
        this.setCentury(century);
        this.setYear(year);
    }

    public GYear(int year) {
        short century = (short)(year / 100);
        this.setCentury(century);
        this.setYear((short)(year %= 100));
    }

    public GYear(short[] values) {
        this.setValues(values);
    }

    public GYear(String gyear) throws ParseException {
        GYear.parseGYearInternal(gyear, this);
    }

    public void setValues(short[] values) {
        if (values.length != 2) {
            throw new IllegalArgumentException("GYear#setValues: not the right number of values");
        }
        this.setCentury(values[0]);
        this.setYear(values[1]);
    }

    public short[] getValues() {
        short[] result = new short[]{this.getCentury(), this.getYear()};
        return result;
    }

    public Date toDate() {
        SimpleDateFormat df = new SimpleDateFormat(YEAR_FORMAT);
        this.setDateFormatTimeZone(df);
        Date date = null;
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isNegative()) {
            result.append('-');
        }
        if (this.getCentury() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getCentury());
        if (this.getYear() / 10 == 0) {
            result.append(0);
        }
        result.append(this.getYear());
        this.appendTimeZoneString(result);
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GYear.parseGYear(str);
    }

    public static GYear parseGYear(String str) throws ParseException {
        return GYear.parseGYearInternal(str, null);
    }

    private static GYear parseGYearInternal(String str, GYear result) throws ParseException {
        int idx;
        char[] chars;
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GYear();
        }
        if ((chars = str.toCharArray())[idx = 0] == '-') {
            result.setNegative();
            ++idx;
        }
        if (!(Character.isDigit(chars[idx]) && Character.isDigit(chars[idx + 1]) && Character.isDigit(chars[idx + 2]) && Character.isDigit(chars[idx + 3]))) {
            throw new ParseException(BAD_GYEAR + str + "\nA gYear must follow the pattern CCYY(Z|((+|-)hh:mm)).", idx);
        }
        short value1 = (short)((chars[idx] - 48) * 10 + (chars[idx + 1] - 48));
        short value2 = (short)((chars[idx + 2] - 48) * 10 + (chars[idx + 3] - 48));
        if (value1 == 0 && value2 == 0) {
            throw new ParseException(BAD_GYEAR + str + "\n'0000' is not allowed as a year.", idx);
        }
        result.setCentury(value1);
        result.setYear(value2);
        GYear.parseTimeZone(str, result, chars, idx += 4, BAD_GYEAR);
        return result;
    }

    public boolean hasMonth() {
        return false;
    }

    public short getMonth() {
        String err = "org.exolab.castor.types.GYear does not have a Month field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMonth(short year) {
        String err = "org.exolab.castor.types.GYear does not have a Month field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasDay() {
        return false;
    }

    public short getDay() {
        String err = "org.exolab.castor.types.GYear does not have a Day field.";
        throw new OperationNotSupportedException(err);
    }

    public void setDay(short month) {
        String err = "org.exolab.castor.types.GYear does not have a Day field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasHour() {
        return false;
    }

    public short getHour() {
        String err = "org.exolab.castor.types.GYear does not have an Hour field.";
        throw new OperationNotSupportedException(err);
    }

    public void setHour(short hour) {
        String err = "org.exolab.castor.types.GYear does not have an Hour field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasMinute() {
        return false;
    }

    public short getMinute() {
        String err = "org.exolab.castor.types.GYear does not have a Minute field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMinute(short minute) {
        String err = "org.exolab.castor.types.GYear does not have a Minute field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasSeconds() {
        return false;
    }

    public short getSeconds() {
        String err = "org.exolab.castor.types.GYear does not have a Seconds field.";
        throw new OperationNotSupportedException(err);
    }

    public void setSecond(short second) {
        String err = "org.exolab.castor.types.GYear does not have a Seconds field.";
        throw new OperationNotSupportedException(err);
    }

    public boolean hasMilli() {
        return false;
    }

    public short getMilli() {
        String err = "org.exolab.castor.types.GYear does not have a Milliseconds field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMilliSecond(short millisecond) {
        String err = "org.exolab.castor.types.GYear does not have a Milliseconds field.";
        throw new OperationNotSupportedException(err);
    }
}

