/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.layout;

import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.layout.JGoAutoLayout;
import com.nwoods.jgo.layout.JGoForceDirectedAutoLayoutLinkData;
import com.nwoods.jgo.layout.JGoForceDirectedAutoLayoutNodeData;
import com.nwoods.jgo.layout.JGoNetwork;
import com.nwoods.jgo.layout.JGoNetworkLink;
import com.nwoods.jgo.layout.JGoNetworkNode;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;

public class JGoForceDirectedAutoLayout
extends JGoAutoLayout {
    private static int \u00ce = 1000;
    private int \u00cf;
    private int \u00d0;

    public JGoForceDirectedAutoLayout() {
        this.\u00cf = JGoForceDirectedAutoLayout.getDefaultMaxIterations();
    }

    public JGoForceDirectedAutoLayout(JGoDocument jGoDocument) {
        super(jGoDocument);
        this.\u00cf = JGoForceDirectedAutoLayout.getDefaultMaxIterations();
    }

    public JGoForceDirectedAutoLayout(JGoSelection jGoSelection) {
        super(jGoSelection);
        this.\u00cf = JGoForceDirectedAutoLayout.getDefaultMaxIterations();
    }

    public JGoForceDirectedAutoLayout(JGoDocument jGoDocument, int n) {
        super(jGoDocument);
        this.\u00cf = n;
    }

    public JGoForceDirectedAutoLayout(JGoDocument jGoDocument, JGoNetwork jGoNetwork, int n) {
        super(jGoDocument, jGoNetwork);
        this.\u00cf = n;
    }

    public void performLayout() {
        Object object;
        if (this.getNetwork() == null) {
            return;
        }
        this.progressUpdate(0.0);
        this.getNetwork().deleteSelfLinks();
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkNode)iterator.next();
            ((JGoNetworkNode)object).nodeData = new JGoForceDirectedAutoLayoutNodeData();
            this.nodeData((JGoNetworkNode)object).charge = this.getElectricalCharge((JGoNetworkNode)object);
            this.nodeData((JGoNetworkNode)object).mass = this.getGravitationalMass((JGoNetworkNode)object);
            this.nodeData((JGoNetworkNode)object).changeX = 0;
            this.nodeData((JGoNetworkNode)object).changeY = 0;
        }
        iterator = this.getNetwork().getLinkIterator();
        while (iterator.hasNext()) {
            object = (JGoNetworkLink)iterator.next();
            ((JGoNetworkLink)object).linkData = new JGoForceDirectedAutoLayoutLinkData();
            this.linkData((JGoNetworkLink)object).stiffness = this.getSpringStiffness((JGoNetworkLink)object);
            this.linkData((JGoNetworkLink)object).length = this.getSpringLength((JGoNetworkLink)object);
        }
        this.\u00d0 = 0;
        while (this.\u00d0 < this.\u00cf) {
            ++this.\u00d0;
            if (!this.updatePositions()) break;
            this.layoutNodesAndLinks(false);
        }
        this.layoutNodesAndLinks(true);
        this.progressUpdate(1.0);
    }

    protected double getNodeDistance(JGoNetworkNode jGoNetworkNode, JGoNetworkNode jGoNetworkNode2) {
        Point point = jGoNetworkNode.getCenter();
        Rectangle rectangle = new Rectangle();
        if (jGoNetworkNode.getJGoObject() != null) {
            int n = jGoNetworkNode.getJGoObject().getWidth() / 2;
            rectangle.x = point.x - n;
            rectangle.width = 2 * n;
            int n2 = jGoNetworkNode.getJGoObject().getHeight() / 2;
            rectangle.y = point.y - n2;
            rectangle.height = 2 * n2;
        } else {
            rectangle.x = point.x;
            rectangle.width = 0;
            rectangle.y = point.y;
            rectangle.height = 0;
        }
        Point point2 = jGoNetworkNode2.getCenter();
        Rectangle rectangle2 = new Rectangle();
        if (jGoNetworkNode2.getJGoObject() != null) {
            int n = jGoNetworkNode2.getJGoObject().getWidth() / 2;
            rectangle2.x = point2.x - n;
            rectangle2.width = 2 * n;
            int n3 = jGoNetworkNode2.getJGoObject().getHeight() / 2;
            rectangle2.y = point2.y - n3;
            rectangle2.height = 2 * n3;
        } else {
            rectangle2.x = point2.x;
            rectangle2.width = 0;
            rectangle2.y = point2.y;
            rectangle2.height = 0;
        }
        if (rectangle.x + rectangle.width < rectangle2.x) {
            if (rectangle.y > rectangle2.y + rectangle2.height) {
                return Math.sqrt(Math.pow(rectangle.x + rectangle.width - rectangle2.x, 2.0) + Math.pow(rectangle.y - (rectangle2.y + rectangle2.height), 2.0));
            }
            if (rectangle.y + rectangle.height < rectangle2.y) {
                return Math.sqrt(Math.pow(rectangle.x + rectangle.width - rectangle2.x, 2.0) + Math.pow(rectangle.y + rectangle.height - rectangle2.y, 2.0));
            }
            return Math.abs(rectangle.x + rectangle.width - rectangle2.x);
        }
        if (rectangle.x > rectangle2.x + rectangle2.width) {
            if (rectangle.y > rectangle2.y + rectangle2.height) {
                return Math.sqrt(Math.pow(rectangle.x - (rectangle2.x + rectangle2.width), 2.0) + Math.pow(rectangle.y - (rectangle2.y + rectangle2.height), 2.0));
            }
            if (rectangle.y + rectangle.height < rectangle2.y) {
                return Math.sqrt(Math.pow(rectangle.x - (rectangle2.x + rectangle2.width), 2.0) + Math.pow(rectangle.y + rectangle.height - rectangle2.y, 2.0));
            }
            return Math.abs(rectangle.x - (rectangle2.x + rectangle2.width));
        }
        if (rectangle.y > rectangle2.y + rectangle2.height) {
            return Math.abs(rectangle.y - (rectangle2.y + rectangle2.height));
        }
        if (rectangle.y + rectangle.height < rectangle2.y) {
            return Math.abs(rectangle.y + rectangle.height - rectangle2.y);
        }
        return 0.1;
    }

    protected double getSpringStiffness(JGoNetworkLink jGoNetworkLink) {
        return 0.05;
    }

    protected double getSpringLength(JGoNetworkLink jGoNetworkLink) {
        return 50.0;
    }

    protected double getElectricalCharge(JGoNetworkNode jGoNetworkNode) {
        return 150.0;
    }

    protected double getElectricalFieldX(Point point) {
        return 0.0;
    }

    protected double getElectricalFieldY(Point point) {
        return 0.0;
    }

    protected double getGravitationalMass(JGoNetworkNode jGoNetworkNode) {
        return 0.0;
    }

    protected double getGravitationalFieldX(Point point) {
        return 0.0;
    }

    protected double getGravitationalFieldY(Point point) {
        return 0.0;
    }

    protected boolean isFixed(JGoNetworkNode jGoNetworkNode) {
        return false;
    }

    protected boolean updatePositions() {
        double d;
        Point point;
        JGoNetworkNode jGoNetworkNode;
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            JGoNetworkNode jGoNetworkNode2 = (JGoNetworkNode)iterator.next();
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).forceX = 0.0;
            this.nodeData((JGoNetworkNode)jGoNetworkNode2).forceY = 0.0;
        }
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        Iterator iterator2 = this.getNetwork().getNodeIterator();
        while (iterator2.hasNext()) {
            object3 = (JGoNetworkNode)iterator2.next();
            object2 = ((JGoNetworkNode)object3).getCenter();
            d3 = this.nodeData((JGoNetworkNode)object3).charge * this.getElectricalFieldX((Point)object2);
            d4 = this.nodeData((JGoNetworkNode)object3).charge * this.getElectricalFieldY((Point)object2);
            this.nodeData((JGoNetworkNode)object3).forceX += d3;
            this.nodeData((JGoNetworkNode)object3).forceY += d4;
            d3 = this.nodeData((JGoNetworkNode)object3).mass * this.getGravitationalFieldX((Point)object2);
            d4 = this.nodeData((JGoNetworkNode)object3).mass * this.getGravitationalFieldY((Point)object2);
            this.nodeData((JGoNetworkNode)object3).forceX += d3;
            this.nodeData((JGoNetworkNode)object3).forceY += d4;
            object = this.getNetwork().getNodeIterator(this.getNetwork().getIndexOfNode(object3) + 1);
            while (object.hasNext()) {
                jGoNetworkNode = (JGoNetworkNode)object.next();
                point = jGoNetworkNode.getCenter();
                d = this.getNodeDistance((JGoNetworkNode)object3, jGoNetworkNode);
                d2 = -1.0 * (this.nodeData((JGoNetworkNode)object3).charge * this.nodeData((JGoNetworkNode)jGoNetworkNode).charge) / (d * d);
                d3 = d2 * ((double)(point.x - ((Point)object2).x) / d);
                d4 = d2 * ((double)(point.y - ((Point)object2).y) / d);
                this.nodeData((JGoNetworkNode)object3).forceX += d3;
                this.nodeData((JGoNetworkNode)object3).forceY += d4;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).forceX -= d3;
                this.nodeData((JGoNetworkNode)jGoNetworkNode).forceY -= d4;
            }
        }
        iterator2 = null;
        object3 = this.getNetwork().getLinkIterator();
        while (object3.hasNext()) {
            object2 = (JGoNetworkLink)object3.next();
            object = ((JGoNetworkLink)object2).getFromNode();
            jGoNetworkNode = ((JGoNetworkLink)object2).getToNode();
            point = ((JGoNetworkNode)object).getCenter();
            Point point2 = jGoNetworkNode.getCenter();
            double d5 = this.getNodeDistance((JGoNetworkNode)object, jGoNetworkNode);
            d2 = this.linkData((JGoNetworkLink)object2).stiffness * (d5 - this.linkData((JGoNetworkLink)object2).length);
            d3 = d2 * ((double)(point2.x - point.x) / d5);
            d4 = d2 * ((double)(point2.y - point.y) / d5);
            this.nodeData((JGoNetworkNode)object).forceX += d3;
            this.nodeData((JGoNetworkNode)object).forceY += d4;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).forceX -= d3;
            this.nodeData((JGoNetworkNode)jGoNetworkNode).forceY -= d4;
        }
        object3 = null;
        iterator = this.getNetwork().getNodeIterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            object2 = (JGoNetworkNode)iterator.next();
            object = ((JGoNetworkNode)object2).getCenter();
            if (this.isFixed((JGoNetworkNode)object2)) continue;
            d = 1.0;
            do {
                n2 = (int)Math.round(this.nodeData((JGoNetworkNode)object2).forceX * d);
                n = (int)Math.round(this.nodeData((JGoNetworkNode)object2).forceY * d);
            } while (n2 == 0 && n == 0 && (d *= 1.25) < 256.0);
            n2 = Math.min(Math.max(n2, -50), 50);
            n = Math.min(Math.max(n, -50), 50);
            ((JGoNetworkNode)object2).setCenter(new Point(((Point)object).x + n2, ((Point)object).y + n));
            this.nodeData((JGoNetworkNode)object2).changeX += n2;
            this.nodeData((JGoNetworkNode)object2).changeY += n;
            if (this.\u00d0 % 10 != 0) continue;
            if (Math.abs(this.nodeData((JGoNetworkNode)object2).changeX) > 1 || Math.abs(this.nodeData((JGoNetworkNode)object2).changeY) > 1) {
                bl = true;
            }
            this.nodeData((JGoNetworkNode)object2).changeX = 0;
            this.nodeData((JGoNetworkNode)object2).changeY = 0;
        }
        if (this.\u00d0 % 10 != 0) {
            bl = true;
        }
        return bl;
    }

    protected void layoutNodesAndLinks(boolean bl) {
        if (this.\u00d0 % 10 == 0 || bl) {
            this.getNetwork().commitNodesAndLinks();
            this.progressUpdate((double)this.\u00d0 / (double)this.\u00cf);
        }
    }

    JGoForceDirectedAutoLayoutNodeData nodeData(JGoNetworkNode jGoNetworkNode) {
        return (JGoForceDirectedAutoLayoutNodeData)jGoNetworkNode.nodeData;
    }

    JGoForceDirectedAutoLayoutLinkData linkData(JGoNetworkLink jGoNetworkLink) {
        return (JGoForceDirectedAutoLayoutLinkData)jGoNetworkLink.linkData;
    }

    public static int getDefaultMaxIterations() {
        return \u00ce;
    }

    public static void setDefaultMaxIterations(int n) {
        \u00ce = n;
    }
}

