/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.webdavaccess;

import com.insightful.webdavaccess.IWebdavStorage;
import com.insightful.webdavaccess.MRUCache;
import com.insightful.webdavaccess.exceptions.WebdavException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalFileSystemStorage
implements IWebdavStorage {
    private static Log log = LogFactory.getLog(LocalFileSystemStorage.class);
    private static final String ROOTPATH_PARAMETER = "rootpath";
    private static final String DEBUG_PARAMETER = "storeDebug";
    private static final int MAX_PROPERTIES_CACHE_SIZE = 5000;
    private static final String CUSTOM_PROPERTIES_STORAGE = ".properties";
    private static final String PROPERTIES_STORAGE_PATH_SEPARATOR = "|";
    private static int BUF_SIZE = 50000;
    private static File root = null;
    private static int debug = -1;
    private String servletName;
    private MRUCache mPropertiesCache;

    public void begin(HttpServletRequest req, Hashtable parameters, String defaultStorageLocation) throws WebdavException {
        if (debug == -1) {
            String debugString = (String)parameters.get(DEBUG_PARAMETER);
            debug = debugString == null ? 0 : Integer.parseInt(debugString);
        }
        if (debug == 1) {
            log.debug((Object)"LocalFileSystemStore.begin()");
        }
        if (root == null) {
            String rootPath = (String)parameters.get(ROOTPATH_PARAMETER);
            if (rootPath != null) {
                try {
                    InitialContext context = new InitialContext();
                    Context environment = (Context)context.lookup("java:comp/env");
                    rootPath = (String)environment.lookup(rootPath);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (rootPath == null && defaultStorageLocation != null) {
                rootPath = defaultStorageLocation;
            }
            if (rootPath == null) {
                throw new WebdavException("missing parameter: rootpath");
            }
            root = new File(rootPath);
            if (!root.exists() && !root.mkdirs()) {
                throw new WebdavException("rootpath: " + root + " does not exist and could not be created");
            }
            this.servletName = req.getServletPath();
        }
        this.mPropertiesCache = new MRUCache(5000);
    }

    public void commit() throws WebdavException {
        if (debug == 1) {
            log.debug((Object)"LocalFileSystemStore.commit() - do nothing");
        }
    }

    public void rollback() throws WebdavException {
        if (debug == 1) {
            log.debug((Object)"LocalFileSystemStore.rollback() - do nothing");
        }
    }

    public boolean objectExists(String uri) throws WebdavException {
        uri = this.normalize(uri);
        File file = new File(root, uri);
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.objectExists(" + uri + ")=" + file.exists()));
        }
        return file.exists();
    }

    public boolean isFolder(String uri) throws WebdavException {
        uri = this.normalize(uri);
        File file = new File(root, uri);
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.isFolder(" + uri + ")=" + file.isDirectory()));
        }
        return file.isDirectory();
    }

    public boolean isResource(String uri) throws WebdavException {
        uri = this.normalize(uri);
        File file = new File(root, uri);
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.isResource(" + uri + ") " + file.isFile()));
        }
        return file.isFile();
    }

    public String getResourceName(String uri) {
        File file = new File(root, uri = this.normalize(uri));
        if (file.isDirectory()) {
            return uri;
        }
        int idx = file.getAbsolutePath().lastIndexOf(File.separatorChar);
        if (idx < 0) {
            return uri;
        }
        String name = file.getAbsolutePath().substring(idx + 1);
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.getResourceName(" + uri + ") " + name));
        }
        return name;
    }

    public void createFolder(String uri) throws WebdavException {
        File file;
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.createFolder(" + uri + ")"));
        }
        if (!(file = new File(root, uri = this.normalize(uri))).mkdir()) {
            throw new WebdavException("cannot create folder: " + uri);
        }
    }

    public void createResource(String uri) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.createResource(" + uri + ")"));
        }
        uri = this.normalize(uri);
        File file = new File(root, uri);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + uri);
            }
        }
        catch (IOException e) {
            throw new WebdavException(e);
        }
    }

    public void copyResource(String src, String dest) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.createResource(" + dest + ")"));
        }
        dest = this.normalize(dest);
        File file = new File(root, dest);
        try {
            if (!file.createNewFile()) {
                throw new WebdavException("cannot create file: " + dest);
            }
        }
        catch (IOException e) {
            throw new WebdavException(e);
        }
        src = this.normalize(src);
        this.setResourceContent(dest, this.getResourceContent(src), null, null);
        this.copyCustomProperties(src, dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceContent(String uri, InputStream is, String contentType, String characterEncoding) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.setResourceContent(" + uri + ")"));
        }
        uri = this.normalize(uri);
        File file = new File(root, uri);
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                int read = -1;
                byte[] copyBuffer = new byte[BUF_SIZE];
                while ((read = is.read(copyBuffer, 0, copyBuffer.length)) != -1) {
                    ((OutputStream)os).write(copyBuffer, 0, read);
                }
            }
            finally {
                try {
                    is.close();
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException e) {
            throw new WebdavException(e);
        }
    }

    public Date getLastModified(String uri) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.getLastModified(" + uri + ")"));
        }
        uri = this.normalize(uri);
        File file = new File(root, uri);
        return new Date(file.lastModified());
    }

    public Date getCreationDate(String uri) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.getCreationDate(" + uri + ")"));
        }
        uri = this.normalize(uri);
        File file = new File(root, uri);
        return new Date(file.lastModified());
    }

    public String[] getChildrenNames(String uri) throws WebdavException {
        File file;
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.getChildrenNames(" + uri + ")"));
        }
        if ((file = new File(root, uri = this.normalize(uri))).isDirectory()) {
            File[] children = file.listFiles();
            ArrayList<String> childList = new ArrayList<String>();
            for (int i = 0; i < children.length; ++i) {
                String name = children[i].getName();
                if (CUSTOM_PROPERTIES_STORAGE.equals(name)) continue;
                childList.add(name);
            }
            String[] childrenNames = new String[childList.size()];
            childrenNames = childList.toArray(childrenNames);
            return childrenNames;
        }
        return null;
    }

    public InputStream getResourceContent(String uri) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.getResourceContent(" + uri + ")"));
        }
        uri = this.normalize(uri);
        File file = new File(root, uri);
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new WebdavException(e);
        }
        return in;
    }

    public long getResourceLength(String uri) throws WebdavException {
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.getResourceLength(" + uri + ")"));
        }
        uri = this.normalize(uri);
        File file = new File(root, uri);
        return file.length();
    }

    public void removeObject(String uri) throws WebdavException {
        uri = this.normalize(uri);
        File file = new File(root, uri);
        boolean success = file.delete();
        this.deleteProperties(uri);
        if (debug == 1) {
            log.debug((Object)("LocalFileSystemStore.removeObject(" + uri + ")=" + success));
        }
        if (!success) {
            throw new WebdavException("cannot delete object: " + uri);
        }
    }

    private String normalize(String uri) {
        if (uri.startsWith(this.servletName)) {
            return uri.substring(this.servletName.length());
        }
        return uri;
    }

    private File getPropertiesFile(String resourceUri) {
        File file = new File(root, resourceUri);
        if ((file = file.getParentFile()) == null) {
            return null;
        }
        return new File(file.getAbsoluteFile() + File.separator + CUSTOM_PROPERTIES_STORAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCustomProperties(Properties newProperties, String resourceUri) {
        if (newProperties == null || newProperties.size() == 0) {
            return;
        }
        File file = this.getPropertiesFile(resourceUri = this.normalize(resourceUri));
        if (file == null) {
            return;
        }
        Properties persisted = new Properties();
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                persisted.loadFromXML(in);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to get properties from cache for " + resourceUri));
                return;
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        Enumeration<Object> en = newProperties.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            persisted.setProperty(resourceUri + PROPERTIES_STORAGE_PATH_SEPARATOR + key, newProperties.getProperty(key));
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            persisted.storeToXML(os, "");
        }
        catch (Exception e) {
            log.warn((Object)("Failed to store properties for " + resourceUri));
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (Exception e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getPropertiesFor(String uri) {
        File file = this.getPropertiesFile(uri = this.normalize(uri));
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream in = null;
        Properties persisted = new Properties();
        try {
            in = new FileInputStream(file);
            persisted.loadFromXML(in);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to get properties from cache for " + uri));
            Properties properties = null;
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
        Enumeration<Object> en = persisted.keys();
        Properties props = new Properties();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith(uri + PROPERTIES_STORAGE_PATH_SEPARATOR)) continue;
            String newKey = key.substring(uri.length() + PROPERTIES_STORAGE_PATH_SEPARATOR.length());
            props.setProperty(newKey, persisted.getProperty(key));
        }
        return props.size() == 0 ? null : props;
    }

    public void setCustomProperties(String resourceUri, Properties newProperties) {
        if (newProperties == null || newProperties.size() == 0) {
            return;
        }
        if ((resourceUri = this.normalize(resourceUri)).endsWith("/.properties")) {
            return;
        }
        Properties props = (Properties)this.mPropertiesCache.get(resourceUri);
        if (props == null && (props = this.getPropertiesFor(resourceUri)) == null) {
            props = new Properties();
        }
        props.putAll((Map<?, ?>)newProperties);
        try {
            this.mPropertiesCache.put(resourceUri, props);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to put properties into cache for " + resourceUri));
        }
        this.saveCustomProperties(props, resourceUri);
    }

    public Properties getCustomProperties(String resourceUri) {
        Properties props = (Properties)this.mPropertiesCache.get(resourceUri = this.normalize(resourceUri));
        if (props != null) {
            return props;
        }
        try {
            props = this.getPropertiesFor(resourceUri);
            if (props == null) {
                return new Properties();
            }
            this.mPropertiesCache.put(resourceUri, props);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to put properties into cache for " + resourceUri));
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperties(String resourceUri) {
        File file;
        Properties props = (Properties)this.mPropertiesCache.get(resourceUri = this.normalize(resourceUri));
        if (props != null) {
            this.mPropertiesCache.remove(resourceUri);
        }
        if ((file = this.getPropertiesFile(resourceUri)) == null || !file.exists()) {
            return;
        }
        FileInputStream in = null;
        Properties persisted = new Properties();
        try {
            in = new FileInputStream(file);
            persisted.loadFromXML(in);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to get properties from cache for " + resourceUri));
            return;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {}
            }
        }
        if (persisted.remove(resourceUri) != null) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(file);
                persisted.storeToXML(os, "");
            }
            catch (Exception e) {
                log.warn((Object)("Failed to store properties for " + resourceUri));
            }
            finally {
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public void copyCustomProperties(String srcUri, String destUri) {
        Properties props = this.getCustomProperties(srcUri);
        this.setCustomProperties(destUri, props);
    }
}

